/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import org.jscience.physics.units.NonSI;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;

public class OptionsPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(IGeomImportSession.AUTO_CORRECT_NORMALS, IGeomImportSession.IMPORT_NORMALS, IGeomImportSession.IMPORT_CREASES, IGeomImportSession.CREASE_ANGLE);
    private final guiCheckBox d_importCreases = new guiCheckBox(Intl.intl("Import creases"));
    private final guiCheckBox d_importNormals = new guiCheckBox(Intl.intl("Import normals"));
    private final ValueField<UnitDouble> d_creaseAngle;
    private final guiCheckBox d_autoCorrectNormals = new guiCheckBox(Intl.intl("Auto-correct inverted polygons"));

    public OptionsPnl() {
        this.d_autoCorrectNormals.setToolTipText("<html>" + Intl.intl("Automatically corrects the winding of polygon vertices. Toggle this<br>checkbox if some objects are too dark."));
        LinkStatus.link((AbstractButton)this.d_importNormals, this.d_autoCorrectNormals);
        this.d_creaseAngle = ValueFields.udFld(DoubleVR.above(0.0, true), NonSI.DEGREE_ANGLE);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Crease Angle:"));
        guiLabel2.setToolTipText(Intl.intl("If no normals are present, this defines the angle between triangles at which a crease appears."));
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.addTitle(Intl.intl("Lighting"));
        gridBagHelper.indent();
        gridBagHelper.addRow(this.d_autoCorrectNormals, 0);
        gridBagHelper.addRow(guiLabel2, this.d_creaseAngle, 0);
        gridBagHelper.finalizeRows();
    }

    @Override
    public void init(IPropertySet iPropertySet) {
        this.d_autoCorrectNormals.setSelected(iPropertySet.get(IGeomImportSession.AUTO_CORRECT_NORMALS));
        this.d_importCreases.setSelected(iPropertySet.get(IGeomImportSession.IMPORT_CREASES));
        this.d_importNormals.setSelected(iPropertySet.get(IGeomImportSession.IMPORT_NORMALS));
        this.d_creaseAngle.setValue(iPropertySet.get(IGeomImportSession.CREASE_ANGLE));
    }

    @Override
    public IPropertySet commit(IPropertySet iPropertySet) {
        iPropertySet.set(IGeomImportSession.IMPORT_CREASES, this.d_importCreases.isSelected());
        iPropertySet.set(IGeomImportSession.IMPORT_NORMALS, this.d_importNormals.isSelected());
        iPropertySet.set(IGeomImportSession.AUTO_CORRECT_NORMALS, this.d_autoCorrectNormals.isSelected());
        iPropertySet.set(IGeomImportSession.CREASE_ANGLE, this.d_creaseAngle.getValue());
        return iPropertySet;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

