/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;

public class MaterialPnl
extends guiPanel
implements IEditor<IPropertySet> {
    private final Set<IPropertySet.Prop<?>> d_props;
    private final guiCheckBox d_replaceIdentMats;
    private final guiCheckBox d_ignoreTransparencyColor;

    public MaterialPnl(Collection<IPropertySet.Prop<?>> collection) {
        this.d_props = new HashSet(collection);
        this.d_replaceIdentMats = new guiCheckBox(Intl.intl("Merge identical materials"));
        this.d_replaceIdentMats.setToolTipText("<html>" + Intl.intl("Some exporters create many copies of a single material. Selecting<br>this option allows materials with duplicate properties to be merged back<br>into one material."));
        this.d_ignoreTransparencyColor = new guiCheckBox(Intl.intl("Ignore transparency color"));
        this.d_ignoreTransparencyColor.setToolTipText("<html>" + Intl.intl("Some exporters only write a transparency factor and not a transparency color.<br>Checking this box ensures that transparency will be read correctly from these<br>files."));
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        if (this.d_props.contains(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS)) {
            gridBagHelper.addRow(this.d_replaceIdentMats, 0);
        }
        if (this.d_props.contains(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR)) {
            gridBagHelper.addFilledRow(this.d_ignoreTransparencyColor);
        }
        gridBagHelper.finalizeRows();
    }

    @Override
    public void init(IPropertySet iPropertySet) {
        this.d_replaceIdentMats.setSelected(iPropertySet.get(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS));
        this.d_ignoreTransparencyColor.setSelected(iPropertySet.get(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR));
    }

    @Override
    public IPropertySet commit(IPropertySet iPropertySet) {
        iPropertySet.set(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS, this.d_replaceIdentMats.isSelected());
        iPropertySet.set(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR, this.d_ignoreTransparencyColor.isSelected());
        return iPropertySet;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

