/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Color;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import thunderheadeng.cad.in.GeomImportHelper;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.StringPool;
import thunderheadeng.util.theUtil;

public class GeomImportSession
implements IGeomImportSession {
    public static final IPropertySet.Prop<Boolean> COMBINE_NODES = new IPropertySet.Prop<Boolean>("GeomImportSession.COMBINE_NODES", false);
    private final IPropertySet d_importProps;
    private final boolean d_combineNodes;
    private final ICallback d_callback;
    private final Converter d_lengthUnitConverter;
    private final double d_lengthScale;
    private final IPointOptimizer d_pointPool;
    private final Map<Integer, Pair<Material, IMaterial>> d_materials;
    private final Map<IMatAttrs, IMaterial> d_uniqueMats;
    private final Deque<Material> d_matlStack;
    private final Deque<NodeBuilder> d_nodes;
    private final List<Object> d_idObjs;

    public GeomImportSession(ICallback iCallback, IPropertySet iPropertySet) {
        double d;
        this.d_importProps = iPropertySet;
        this.d_combineNodes = iPropertySet.get(COMBINE_NODES);
        this.d_callback = iCallback;
        this.d_pointPool = (IPointOptimizer)((Supplier)iPropertySet.get(POINT_OPTIMIZER)).get();
        this.d_lengthUnitConverter = ((Unit)iPropertySet.get(SRC_LENGTH_UNIT)).getConverterTo((Unit)iPropertySet.get(DST_LENGTH_UNIT));
        this.d_materials = new LinkedHashMap<Integer, Pair<Material, IMaterial>>();
        this.d_uniqueMats = new HashMap<IMatAttrs, IMaterial>();
        this.d_matlStack = new ArrayDeque<Material>();
        this.d_idObjs = new ArrayList<Object>();
        this.d_nodes = new ArrayDeque<NodeBuilder>();
        this.d_lengthScale = d = this.d_lengthUnitConverter.convert(1.0);
        ITransform iTransform = TransformUtil.scale(d, d, d);
        this.beginNode("root", new IImportSession.NodeProps(), iTransform);
    }

    public ICallback getCallback() {
        return this.d_callback;
    }

    public IPointOptimizer getPointPool() {
        return this.d_pointPool;
    }

    public Converter getUnitConverter() {
        return this.d_lengthUnitConverter;
    }

    @Override
    public Collection<IMaterial> getMaterials() {
        return theUtil.map(this.d_materials.values(), pair -> (IMaterial)pair.v2);
    }

    public IMaterial getMaterial(int n) {
        Pair<Material, IMaterial> pair = this.d_materials.get(n);
        return pair != null ? (IMaterial)pair.v2 : null;
    }

    protected Material currMaterial() {
        return this.d_matlStack.getLast();
    }

    @Override
    public void beginMaterial(int n, String string, boolean bl) {
        Material material = new Material(n, string, bl);
        this.d_matlStack.addLast(material);
    }

    private static boolean isSimLabMat(Material material) {
        String string = "Material~";
        if (!material.name.startsWith(string)) {
            return false;
        }
        try {
            Integer.parseInt(material.name.substring(string.length()));
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    @Override
    public void endMaterial() {
        Material material = this.d_matlStack.removeLast();
        IMaterial iMaterial = material.finish(this.d_callback, this.d_importProps);
        if (iMaterial != null) {
            IMaterial iMaterial2;
            if (((Boolean)this.d_importProps.get(REPLACE_IDENTICAL_MATERIALS)).booleanValue() && (iMaterial2 = this.d_uniqueMats.putIfAbsent(iMaterial.getAttributes(), iMaterial)) != null) {
                iMaterial = iMaterial2;
            }
            this.d_materials.put(material.id, new Pair<Material, IMaterial>(material, iMaterial));
        }
    }

    @Override
    public void setMatlChnlColor(int n, int n2, int n3, int n4) {
        this.currMaterial().setMatlChnlColor(IImportSession.MatlChannel.values()[n], n2, n3, n4);
    }

    @Override
    public void setMatlChnlMap(int n, double d, int n2, int n3, String string, String string2) {
        this.currMaterial().setMatlChnlMap(IImportSession.MatlChannel.values()[n], d, n2, n3, string, string2);
    }

    @Override
    public void setMatlChnlParams(int n, double ... dArray) {
        this.currMaterial().setMatlChnlParams(IImportSession.MatlChannel.values()[n], dArray);
    }

    @Override
    public void pushModelTransform(double[] dArray) {
        Matrix4d matrix4d = new Matrix4d(dArray);
        ITransform iTransform = GeomConstants.IDENTITY4d.equals(matrix4d) ? TransformUtil.IDENTITY : new MatrixXform(matrix4d);
        this.currBuilder().pushModelTransform(iTransform);
    }

    @Override
    public void popModelTransform() {
        this.currBuilder().popModelTransform();
    }

    @Override
    public void setCurrentColor(int n, int n2, int n3, int n4) {
        this.currGeom().setCurrentColor(ColorPool.get(new Color(n, n2, n3, n4)));
    }

    @Override
    public void setCurrentMatl(int n) {
        this.currGeom().setCurrentMatl(n);
    }

    @Override
    public void polygonOut(double[] dArray, double[] dArray2, double[] dArray3) {
        this.currGeom().polygonOut(dArray, dArray2, dArray3);
    }

    @Override
    public void polylineOut(double[] dArray) {
        this.currGeom().polylineOut(dArray);
    }

    @Override
    public void shellProc(int n, double[] dArray, int[] nArray, double[] dArray2, String[] stringArray, int[] nArray2, int n2, double[] dArray3, int[] nArray3, int n3, boolean[] blArray, int[] nArray4, int[] nArray5) {
        this.currGeom().shellProc(IImportSession.FaceOrient.values()[n], dArray, nArray, dArray2, stringArray, nArray2, IImportSession.MeshElementMapping.values()[n2], dArray3, nArray3, IImportSession.MeshElementMapping.values()[n3], blArray, nArray4, nArray5);
    }

    @Override
    public void meshProc(int n, int n2, int n3, double[] dArray, boolean[] blArray) {
        this.currGeom().meshProc(IImportSession.FaceOrient.values()[n], n2, n3, dArray, blArray);
    }

    @Override
    public boolean circleProc(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        return this.currGeom().circleProc(dArray, d, dArray2, dArray3);
    }

    @Override
    public void metafileProc(double[] dArray, double[] dArray2, double[] dArray3) {
        this.currGeom().metafileProc(dArray, dArray2, dArray3);
    }

    @Override
    public boolean circularArcProc(double[] dArray, double d, double[] dArray2, double[] dArray3, double d2, int n, double[] dArray4) {
        return this.currGeom().circularArcProc(dArray, d, dArray2, dArray3, d2, n, dArray4);
    }

    @Override
    public boolean circularArcProc(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4) {
        return this.currGeom().circularArcProc(dArray, dArray2, dArray3, n, dArray4);
    }

    @Override
    public boolean ellipticalArcProc(double[] dArray, double[] dArray2, double d, double[] dArray3, double d2, double[] dArray4, double d3, double d4, double[] dArray5, int n, double[] dArray6) {
        return this.currGeom().ellipticalArcProc(dArray, dArray2, d, dArray3, d2, dArray4, d3, d4, dArray5, n, dArray6);
    }

    @Override
    public boolean plineProc(double d, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, double d2, double[] dArray4, boolean bl, double[] dArray5, int n, int n2) {
        return this.currGeom().plineProc(d, dArray, dArray2, dArray3, nArray, d2, dArray4, bl, dArray5, n, n2);
    }

    @Override
    public boolean textProc(double[] dArray, double[] dArray2, double[] dArray3, String string, boolean bl, int n, double[] dArray4) {
        return this.currGeom().textProc(dArray, dArray2, dArray3, string, bl, n, dArray4);
    }

    protected int newId(Placeholder placeholder) {
        int n = this.d_idObjs.size();
        this.d_idObjs.add((Object)placeholder);
        return n;
    }

    protected void commitId(int n, Object object) {
        this.d_idObjs.set(n, object);
    }

    @Override
    public Collection<IGeomImportSession.Node> finalizeGeom() {
        assert (!this.d_nodes.isEmpty());
        NodeBuilder nodeBuilder = this.d_nodes.pop();
        IGeomImportSession.Node node = nodeBuilder.toNode();
        if (node.dg == DisplayGeom.EMPTY) {
            if (node.transform.isIdentity()) {
                return node.children;
            }
            ArrayList<IGeomImportSession.Node> arrayList = new ArrayList<IGeomImportSession.Node>(node.children.size());
            for (IGeomImportSession.Node node2 : node.children) {
                IGeomImportSession.Node node3 = new IGeomImportSession.Node(node2.id, node2.name, node.transform.concatenate(node2.transform), node2.props, node2.dg, node2.children);
                arrayList.add(node3);
            }
            return arrayList;
        }
        return Collections.singleton(node);
    }

    @Override
    public long beginNode(String string, IImportSession.NodeProps nodeProps) {
        assert (!this.d_nodes.isEmpty());
        return this.beginNode(string, nodeProps, this.d_nodes.peek().currTransform());
    }

    private long beginNode(String string, IImportSession.NodeProps nodeProps, ITransform iTransform) {
        NodeBuilder nodeBuilder = new NodeBuilder(this.newId(Placeholder.NODE), StringPool.get(string), nodeProps, iTransform);
        this.d_nodes.push(nodeBuilder);
        return nodeBuilder.nodeId;
    }

    @Override
    public void endNode() {
        NodeBuilder nodeBuilder = this.d_nodes.pop();
        IGeomImportSession.Node node = nodeBuilder.toNode();
        if (node.dg != DisplayGeom.EMPTY || !node.children.isEmpty()) {
            this.d_nodes.peek().addChild(node);
        }
        this.commitId(nodeBuilder.nodeId, node);
    }

    protected NodeBuilder currBuilder() {
        return this.d_nodes.peek();
    }

    @Override
    public void insertReference(long l) {
        assert (l < (long)this.d_idObjs.size() && l >= 0L);
        Object object = this.d_idObjs.get((int)l);
        assert (object instanceof IGeomImportSession.Node || object instanceof DisplayGeom);
        if (object instanceof IGeomImportSession.Node) {
            IGeomImportSession.Node node = (IGeomImportSession.Node)object;
            this.currBuilder().addNodeRef(node);
        } else if (object instanceof DisplayGeom) {
            this.currBuilder().addGeomRef(l, (DisplayGeom)object);
        }
    }

    @Override
    public long beginGeom() {
        return this.currBuilder().beginGeom();
    }

    @Override
    public void endGeom() {
        this.currBuilder().endGeom();
    }

    protected GeomImportHelper currGeom() {
        return this.currBuilder().currGeom();
    }

    @Override
    public void endSession() {
    }

    public static abstract class ACallback
    implements ICallback {
        private final List<File> d_libDirs;

        public ACallback(File ... fileArray) {
            this.d_libDirs = new ArrayList<File>(Arrays.asList(fileArray));
            if (fileArray.length > 0) {
                System.out.println("Searching for resources in:");
                for (File file : fileArray) {
                    System.out.println("\t" + file.getAbsolutePath());
                }
            }
        }

        public void addLibDir(File file) {
            this.d_libDirs.add(file);
        }

        @Override
        public File resolvePath(String string) {
            for (File file : this.d_libDirs) {
                File file2 = IOUtil.resolvePath(string, file, null);
                if (file2 == null) continue;
                return file2;
            }
            return null;
        }
    }

    public static interface ICallback {
        public IMaterial createMaterial(Material var1, IMatAttrs var2);

        public File resolvePath(String var1);
    }

    public static class Material {
        public final int id;
        public final String name;
        public final boolean twoSided;
        public Color ambColor;
        public Texture ambTex;
        public Color diffColor;
        public Texture diffTex;
        public Texture normTex;
        public double normStrength;
        public Texture bumpTex;
        public double bumpIndirectBumpScale;
        public Color specColor;
        public Texture specTex;
        public double specGlossFactor;
        public Color reflColor;
        public Texture reflTex;
        public double reflReflectanceScale;
        public double reflReflectivity;
        public Texture refrTex;
        public double refrRefractionIndex;
        public Color transpColor;
        public Texture opacityTex;
        public double transpFactor;
        public double translucenceFactor;
        public double transmittanceScale;
        public Color emissionColor;
        public Texture emissionTex;
        public double luminance;

        public Material(int n, String string, boolean bl) {
            this.id = n;
            this.name = string;
            this.twoSided = bl;
            this.transpColor = Color.WHITE;
            this.transpFactor = 0.0;
        }

        public void setMatlChnlColor(IImportSession.MatlChannel matlChannel, int n, int n2, int n3) {
            Color color = new Color(n, n2, n3);
            switch (matlChannel) {
                case AMBIENT: {
                    this.ambColor = color;
                    break;
                }
                case DIFFUSE: {
                    this.diffColor = color;
                    break;
                }
                case SPECULAR: {
                    this.specColor = color;
                    break;
                }
                case ILLUMINATION: {
                    this.emissionColor = color;
                    break;
                }
                case TRANSPARENCY: {
                    this.transpColor = color;
                    break;
                }
                case REFLECTION: {
                    this.reflColor = color;
                }
            }
        }

        public void setMatlChnlMap(IImportSession.MatlChannel matlChannel, double d, int n, int n2, String string, String string2) {
            Texture texture = Material.toTex(d, n, n2, string, string2);
            switch (matlChannel) {
                case AMBIENT: {
                    this.ambTex = texture;
                    break;
                }
                case DIFFUSE: {
                    this.diffTex = texture;
                    break;
                }
                case BUMP: {
                    this.bumpTex = texture;
                    break;
                }
                case NORMAL: {
                    this.normTex = texture;
                    break;
                }
                case REFLECTION: {
                    this.reflTex = texture;
                    break;
                }
                case REFRACTION: {
                    this.refrTex = texture;
                    break;
                }
                case SPECULAR: {
                    this.specTex = texture;
                    break;
                }
                case TRANSPARENCY: {
                    this.opacityTex = texture;
                    break;
                }
                case ILLUMINATION: {
                    this.emissionTex = texture;
                }
            }
        }

        private static Texture toTex(double d, int n, int n2, String string, String string2) {
            return new Texture(string, Material.toTiling(n), Material.toTiling(n2), d, string2);
        }

        private static Tiling toTiling(int n) {
            switch (n) {
                case 1: {
                    return Tiling.TILE;
                }
                case 2: {
                    return Tiling.CROP;
                }
                case 3: {
                    return Tiling.CLAMP;
                }
                case 4: {
                    return Tiling.MIRROR;
                }
            }
            return Tiling.TILE;
        }

        public void setMatlChnlParams(IImportSession.MatlChannel matlChannel, double ... dArray) {
            switch (matlChannel) {
                case BUMP: {
                    this.bumpIndirectBumpScale = dArray[0];
                    break;
                }
                case NORMAL: {
                    this.normStrength = dArray[0];
                    break;
                }
                case TRANSPARENCY: {
                    this.transpFactor = dArray[0];
                    this.translucenceFactor = dArray[1];
                    this.transmittanceScale = dArray[2];
                    break;
                }
                case REFLECTION: {
                    this.reflReflectanceScale = dArray[0];
                    this.reflReflectivity = dArray[1];
                    break;
                }
                case REFRACTION: {
                    this.refrRefractionIndex = dArray[0];
                    break;
                }
                case SPECULAR: {
                    this.specGlossFactor = dArray[0];
                    break;
                }
                case ILLUMINATION: {
                    this.luminance = dArray[0];
                }
            }
        }

        public IMaterial finish(ICallback iCallback, IPropertySet iPropertySet) {
            IMatAttrs iMatAttrs = this.toNativeMatl(iCallback, iPropertySet);
            if (iMatAttrs == null) {
                return null;
            }
            return iCallback.createMaterial(this, iMatAttrs);
        }

        private IMatAttrs toNativeMatl(ICallback iCallback, IPropertySet iPropertySet) {
            Color color;
            Object object;
            Color color2 = null;
            if (this.diffColor != null) {
                color2 = this.diffColor;
            } else if (this.ambColor != null) {
                color2 = this.ambColor;
            }
            thunderheadeng.scene3d.geom.Texture texture = this.toNativeTex(iCallback, this.diffTex);
            if (color2 == null) {
                color2 = (Color)IMatAttrs.DIFFUSE_COLOR.defVal;
            }
            if (!iPropertySet.get(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR).booleanValue()) {
                object = new float[3];
                float f = (float)this.transpFactor;
                this.transpColor.getColorComponents((float[])object);
                float f2 = object[0] * f;
                float f3 = object[1] * f;
                float f4 = object[2] * f;
                float f5 = f2 * 0.3f + f3 * 0.59f + f4 * 0.11f;
                float f6 = 1.0f - f5;
                color = new Color(1.0f - f2, 1.0f - f3, 1.0f - f4);
            } else {
                float f = 1.0f - (float)this.transpFactor;
                color = new Color(f, f, f);
            }
            object = this.toNativeTex(iCallback, this.specTex);
            thunderheadeng.scene3d.geom.Texture texture2 = this.toNativeTex(iCallback, this.ambTex);
            thunderheadeng.scene3d.geom.Texture texture3 = this.toNativeTex(iCallback, this.bumpTex);
            thunderheadeng.scene3d.geom.Texture texture4 = this.toNativeTex(iCallback, this.normTex);
            thunderheadeng.scene3d.geom.Texture texture5 = this.toNativeTex(iCallback, this.opacityTex);
            thunderheadeng.scene3d.geom.Texture texture6 = this.toNativeTex(iCallback, this.emissionTex);
            thunderheadeng.scene3d.geom.Texture texture7 = this.toNativeTex(iCallback, this.reflTex);
            int n = 0;
            if (!this.twoSided) {
                n |= 2;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Material.addParam(arrayList, MatAttrs.AMBIENT_COLOR, this.ambColor);
            Material.addParam(arrayList, MatAttrs.AMBIENT_TEXTURE, texture2);
            Material.addParam(arrayList, MatAttrs.BUMP, texture3);
            Material.addParam(arrayList, MatAttrs.BUMP_SCALE, this.bumpIndirectBumpScale);
            Material.addParam(arrayList, MatAttrs.DIFFUSE_COLOR, color2);
            Material.addParam(arrayList, MatAttrs.DIFFUSE_TEXTURE, texture);
            Material.addParam(arrayList, MatAttrs.EMISSIVE_COLOR, this.emissionColor);
            Material.addParam(arrayList, MatAttrs.EMISSIVE_TEXTURE, texture6);
            Material.addParam(arrayList, MatAttrs.NORMAL, texture4);
            Material.addParam(arrayList, MatAttrs.OPACITY_COLOR, color);
            Material.addParam(arrayList, MatAttrs.OPACITY_TEXTURE, texture5);
            Material.addParam(arrayList, MatAttrs.REFLECTION_COLOR, this.reflColor);
            Material.addParam(arrayList, MatAttrs.REFLECTION_TEXTURE, texture7);
            Material.addParam(arrayList, MatAttrs.SPECULAR_COLOR, this.specColor);
            Material.addParam(arrayList, MatAttrs.SPECULAR_TEXTURE, object);
            Material.addParam(arrayList, MatAttrs.SHININESS, this.specGlossFactor);
            Material.addParam(arrayList, MatAttrs.OPTIONS, n);
            return new MatAttrs(arrayList);
        }

        private static <T> void addParam(List<Object> list, IPropertySet.Prop<T> prop, T t) {
            if (t == null) {
                return;
            }
            list.add(prop);
            list.add(t);
        }

        private thunderheadeng.scene3d.geom.Texture toNativeTex(ICallback iCallback, Texture texture) {
            return texture == null ? null : texture.toNativeTex(iCallback);
        }

        public static class Texture {
            public final String filename;
            public final Tiling uTiling;
            public final Tiling vTiling;
            public final double blendFactor;
            public final String uvSet;

            public Texture(String string, Tiling tiling, Tiling tiling2, double d, String string2) {
                this.filename = string;
                this.uTiling = tiling;
                this.vTiling = tiling2;
                this.blendFactor = d;
                this.uvSet = string2;
            }

            public thunderheadeng.scene3d.geom.Texture toNativeTex(ICallback iCallback) {
                File file = iCallback.resolvePath(this.filename);
                if (file == null) {
                    System.err.println("Could not resolve image path for " + this.filename);
                    return null;
                }
                IImage iImage = ImageManager.getImage(file.getAbsolutePath());
                if (iImage == null) {
                    System.err.println("Could not get image for " + file.getAbsolutePath());
                    return null;
                }
                switch (this.uTiling) {
                    case CLAMP: {
                        return thunderheadeng.scene3d.geom.Texture.clampedToEdge(iImage, this.uvSet);
                    }
                    case CROP: {
                        return thunderheadeng.scene3d.geom.Texture.clampedToBorder(iImage, Color.BLACK, this.uvSet);
                    }
                }
                return thunderheadeng.scene3d.geom.Texture.repeated(iImage, this.uvSet);
            }
        }

        public static enum Tiling {
            TILE,
            CROP,
            CLAMP,
            MIRROR;

        }
    }

    private class NodeBuilder {
        public final int nodeId;
        public final String name;
        public final IImportSession.NodeProps props;
        private final ITransform d_transform;
        private final List<DisplayGeom> d_finishedGeoms;
        private final List<IGeomImportSession.Node> d_children;
        private final Deque<ITransform> d_xformStack;
        private int d_geomId;
        private GeomImportHelper d_geomBuilder;

        public NodeBuilder(int n, String string, IImportSession.NodeProps nodeProps, ITransform iTransform) {
            this.nodeId = n;
            this.name = string;
            this.props = nodeProps;
            this.d_transform = iTransform;
            this.d_finishedGeoms = new ArrayList<DisplayGeom>();
            this.d_children = new ArrayList<IGeomImportSession.Node>();
            this.d_xformStack = new ArrayDeque<ITransform>();
            this.d_xformStack.push(TransformUtil.IDENTITY);
            this.resetGeom();
        }

        private void resetGeom() {
            assert (this.d_geomBuilder == null);
            Supplier<ITransform> supplier = this::currTransform;
            IntFunction<Pair<Material, IMaterial>> intFunction = n -> {
                Pair pair = (Pair)GeomImportSession.this.d_materials.get(n);
                if (pair == null) {
                    return new Pair<Object, Object>(null, null);
                }
                return pair;
            };
            this.d_geomBuilder = new GeomImportHelper(supplier, GeomImportSession.this.getPointPool(), this.props.solid, intFunction, GeomImportSession.this.d_importProps);
        }

        private DisplayGeom commitGeom() {
            if (this.d_geomBuilder != null) {
                DisplayGeomBuilder.Rep rep = this.d_geomBuilder.finish();
                DisplayGeom displayGeom = rep.toDisplay();
                if (displayGeom != DisplayGeom.EMPTY) {
                    this.d_finishedGeoms.add(displayGeom);
                }
                this.d_geomBuilder = null;
                return displayGeom;
            }
            return DisplayGeom.EMPTY;
        }

        public int beginGeom() {
            this.commitGeom();
            this.d_geomId = GeomImportSession.this.newId(Placeholder.GEOM);
            this.resetGeom();
            return this.d_geomId;
        }

        public void endGeom() {
            assert (this.d_geomBuilder != null);
            DisplayGeom displayGeom = this.commitGeom();
            GeomImportSession.this.commitId(this.d_geomId, displayGeom);
        }

        public GeomImportHelper currGeom() {
            if (this.d_geomBuilder == null) {
                this.resetGeom();
            }
            return this.d_geomBuilder;
        }

        public IGeomImportSession.Node toNode() {
            this.commitGeom();
            DisplayGeom displayGeom = this.finalizeNodeGeom(this.d_finishedGeoms);
            if (GeomImportSession.this.d_combineNodes && displayGeom == DisplayGeom.EMPTY && this.d_children.size() == 1 && this.name.equals(this.d_children.get((int)0).name)) {
                IGeomImportSession.Node node = this.d_children.get(0);
                long l = this.nodeId == -1 ? node.id : (long)this.nodeId;
                return new IGeomImportSession.Node(l, this.name, this.d_transform.concatenate(node.transform), node.props, node.dg, node.children);
            }
            DoubleUnaryOperator doubleUnaryOperator = d -> {
                if (Double.isNaN(d)) {
                    return d;
                }
                return GeomImportSession.this.d_lengthScale * d;
            };
            IImportSession.NodeProps nodeProps = this.props;
            if (!Double.isNaN(this.props.doorWidth) || !Double.isNaN(this.props.doorHeight)) {
                nodeProps = this.props.clone();
                nodeProps.doorWidth = doubleUnaryOperator.applyAsDouble(nodeProps.doorWidth);
                nodeProps.doorHeight = doubleUnaryOperator.applyAsDouble(nodeProps.doorHeight);
            }
            return new IGeomImportSession.Node(this.nodeId, this.name, this.d_transform, nodeProps, displayGeom, this.d_children);
        }

        public void addChild(IGeomImportSession.Node node) {
            this.d_children.add(node);
        }

        public void addNodeRef(IGeomImportSession.Node node) {
            ITransform iTransform = this.currTransform();
            if (!iTransform.isIdentity()) {
                node = GeomImportSession.this.d_combineNodes ? new IGeomImportSession.Node(node.id, node.name, iTransform.concatenate(node.transform), node.props, node.dg, node.children) : new IGeomImportSession.Node(node.id, node.name, iTransform, node.props, DisplayGeom.EMPTY, Collections.singleton(node));
            }
            this.addChild(node);
        }

        public void addGeomRef(long l, DisplayGeom displayGeom) {
            this.commitGeom();
            assert (displayGeom.node.getLocalTransform().isIdentity() && displayGeom.node.getChildren().isEmpty());
            ITransform iTransform = this.currTransform();
            if (!iTransform.isIdentity()) {
                IGeomImportSession.Node node = new IGeomImportSession.Node(l, this.name, iTransform, this.props, displayGeom, Collections.emptyList());
                this.addChild(node);
            } else {
                this.d_finishedGeoms.add(displayGeom);
            }
        }

        public void pushModelTransform(ITransform iTransform) {
            iTransform = this.currTransform().concatenate(iTransform);
            this.d_xformStack.push(iTransform);
        }

        public void popModelTransform() {
            this.d_xformStack.pop();
        }

        public ITransform currTransform() {
            return this.d_xformStack.peek();
        }

        private DisplayGeom finalizeNodeGeom(Collection<DisplayGeom> collection) {
            ArrayList<DisplayGeomBuilder.Rep> arrayList = new ArrayList<DisplayGeomBuilder.Rep>(collection.size());
            for (DisplayGeom displayGeom : collection) {
                assert (displayGeom.node.getLocalTransform().isIdentity() && displayGeom.node.getChildren().isEmpty());
                arrayList.add(new DisplayGeomBuilder.Rep(displayGeom.node.getLocalGeom(), displayGeom.node.getLocalElements(), displayGeom.props));
            }
            return DisplayGeomBuilder.merge(arrayList).toDisplay();
        }
    }

    private static enum Placeholder {
        NODE,
        GEOM;

    }
}

