/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.cad.in.CadImporterUtil;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomImportHelper {
    private static final Point3d[] EMPTY_ARRAY = new Point3d[0];
    private final IPointOptimizer d_pointPool;
    private final Supplier<ITransform> d_transformSrc;
    private final boolean d_solid;
    private final IntFunction<Pair<GeomImportSession.Material, IMaterial>> d_matMap;
    private final boolean d_autoCorrectInvertedNormals;
    private final boolean d_importNormals;
    private final boolean d_importCreases;
    private final double d_creaseAngle;
    private final IPropertySet d_importProps;
    public boolean ignoreText = false;
    private GeomImportSession.Material d_currentImportMat;
    private IPrimProps.Face d_currentFaceProps;
    private IPrimProps.Edge d_currentEdgeProps;
    private IPrimProps.Vertex d_currentVertexProps;
    private IPrimProps.GenericProps d_currentGenericProps;
    private final DisplayGeomBuilder d_faceBuilder;
    private final DisplayGeomBuilder d_nonFaceBuilder;
    private Point3d[] d_lastPolyline;
    private static final Point2d s_emptyUV = new Point2d(0.0, 0.0);

    public GeomImportHelper(Supplier<ITransform> supplier, IPointOptimizer iPointOptimizer, boolean bl, IntFunction<Pair<GeomImportSession.Material, IMaterial>> intFunction, IPropertySet iPropertySet) {
        this.d_pointPool = iPointOptimizer;
        this.d_transformSrc = supplier;
        this.d_solid = bl;
        this.d_matMap = intFunction;
        this.d_importProps = iPropertySet;
        this.d_autoCorrectInvertedNormals = iPropertySet.get(IGeomImportSession.AUTO_CORRECT_NORMALS);
        this.d_importNormals = iPropertySet.get(IGeomImportSession.IMPORT_NORMALS);
        this.d_importCreases = iPropertySet.get(IGeomImportSession.IMPORT_CREASES);
        this.d_creaseAngle = iPropertySet.get(IGeomImportSession.CREASE_ANGLE).get(SI.RADIAN);
        this.d_faceBuilder = new DisplayGeomBuilder();
        this.d_nonFaceBuilder = new DisplayGeomBuilder();
        this.d_lastPolyline = null;
        this.d_currentImportMat = null;
        this.d_currentFaceProps = new IPrimProps.Face(Color.WHITE, null, 0);
        this.d_currentEdgeProps = new IPrimProps.Edge(Color.WHITE, 1.0, IPrimProps.DEF_STIPPLE, 0);
        this.d_currentVertexProps = new IPrimProps.Vertex(Color.WHITE, 1.0);
        this.d_currentGenericProps = new IPrimProps.GenericProps(Color.WHITE, null, 1.0, 255, 1.0, 0);
    }

    public void setCurrentColor(Color color) {
        this.d_currentFaceProps = GeomImportHelper.setColor(this.d_currentFaceProps, color);
        this.d_currentEdgeProps = GeomImportHelper.setColor(this.d_currentEdgeProps, color);
        this.d_currentVertexProps = GeomImportHelper.setColor(this.d_currentVertexProps, color);
        this.d_currentGenericProps = GeomImportHelper.setColor(this.d_currentGenericProps, color);
    }

    public void setCurrentMatl(int n) {
        Pair<GeomImportSession.Material, IMaterial> pair = this.d_matMap.apply(n);
        this.d_currentImportMat = (GeomImportSession.Material)pair.v1;
        this.d_currentFaceProps = GeomImportHelper.setMaterial(this.d_currentFaceProps, (IMaterial)pair.v2);
        this.d_currentGenericProps = GeomImportHelper.setMaterial(this.d_currentGenericProps, (IMaterial)pair.v2);
    }

    private static <T extends IPrimProps> T setColor(T t, Color color) {
        if (!theUtil.equal(t.getColor(), color)) {
            return (T)t.setColor(color);
        }
        return t;
    }

    private static <T extends IPrimProps> T setMaterial(T t, IMaterial iMaterial) {
        if (!theUtil.equal(t.getMaterial(), iMaterial)) {
            return (T)t.setMaterial(iMaterial);
        }
        return t;
    }

    private <T extends Tuple3d> T[] unflatten3d(TransformInfo transformInfo, double[] dArray, Class<T> clazz) {
        Matrix4d matrix4d = transformInfo.getMatrix();
        Tuple3d[] tuple3dArray = (Tuple3d[])Array.newInstance(clazz, dArray.length / 3);
        for (int i = 0; i < dArray.length; i += 3) {
            Tuple3d tuple3d;
            int n = i / 3;
            try {
                tuple3d = (Tuple3d)clazz.newInstance();
            }
            catch (Throwable throwable) {
                assert (false);
                throw new RuntimeException(throwable);
            }
            tuple3d.x = dArray[i];
            tuple3d.y = dArray[i + 1];
            tuple3d.z = dArray[i + 2];
            if (tuple3d instanceof Vector3d) {
                Vector3d vector3d = (Vector3d)tuple3d;
                matrix4d.transform(vector3d);
                Util3D.safeNormalize(vector3d, 0.0);
            } else if (tuple3d instanceof Point3d) {
                matrix4d.transform((Point3d)tuple3d);
            }
            tuple3dArray[n] = tuple3d = this.d_pointPool.getExisting(tuple3d);
        }
        return tuple3dArray;
    }

    private Point2d[] unflatten2d(double[] dArray) {
        return this.unflatten2d(dArray, 0, dArray.length);
    }

    private Point2d[] unflatten2d(double[] dArray, int n, int n2) {
        Point2d[] point2dArray = new Point2d[n2 / 2];
        for (int i = 0; i < n2; i += 2) {
            int n3 = i / 2;
            int n4 = n + i;
            Point2d point2d = new Point2d(dArray[n4], dArray[n4 + 1]);
            point2dArray[n3] = point2d = this.d_pointPool.getExisting(point2d);
        }
        return point2dArray;
    }

    private static boolean isEmpty(IGeom iGeom) {
        return GeomUtil.isEmpty(iGeom);
    }

    protected void addGeom(IGeom iGeom) {
        this.addGeom(iGeom, iPrimProps -> Elements.NONE);
    }

    protected void addGeom(IGeom iGeom, Function<IPrimProps, IPropertySet> function) {
        if (!GeomImportHelper.isEmpty(iGeom)) {
            int n = iGeom.getNumPrims(7);
            int n2 = iGeom.getNumPrims(1);
            if (n2 > 0) {
                assert (n2 == n);
                this.d_faceBuilder.add(iGeom, new UniformProps(this.d_currentFaceProps), function.apply(this.d_currentFaceProps));
            } else {
                assert (n2 == 0);
                IPrimProps.AProps aProps = n == iGeom.getNumPrims(2) ? this.d_currentEdgeProps : (n == iGeom.getNumPrims(4) ? this.d_currentVertexProps : this.d_currentGenericProps);
                this.d_nonFaceBuilder.add(iGeom, new UniformProps(aProps), Elements.NONE);
            }
        }
    }

    private TransformInfo getTransformInfo() {
        return this.d_transformSrc.get().getInfo();
    }

    public void polygonOut(double[] dArray, double[] dArray2, double[] dArray3) {
        Point2d[] point2dArray;
        assert (dArray.length % 3 == 0);
        assert (dArray3.length == 0 || dArray3.length == 3);
        TransformInfo transformInfo = this.getTransformInfo();
        Point3d[] point3dArray = (Point3d[])this.unflatten3d(transformInfo, dArray, Point3d.class);
        Point2d[] point2dArray2 = point2dArray = dArray2 != null ? this.unflatten2d(dArray2) : new Point2d[]{};
        if (transformInfo.hasNegativeScale()) {
            theUtil.reverse(point3dArray);
            theUtil.reverse(point2dArray);
        }
        IPolygon iPolygon = PolyUtil.newPoly(point3dArray);
        Function<IPrimProps, IPropertySet> function = iPrimProps -> {
            IPropertySet iPropertySet = Elements.newElements();
            iPropertySet.setIfNotDefault(Elements.ORIENT, Elements.CCW);
            IMaterial iMaterial = iPrimProps.getMaterial();
            if (iMaterial != null && point2dArray.length > 0) {
                ElementPoly<Point2d> elementPoly = new ElementPoly<Point2d>(point2dArray);
                Set<String> set = iMaterial.getAttributes().getUVSets();
                ListMap<String, ElementPoly<Point2d>> listMap = new ListMap<String, ElementPoly<Point2d>>();
                for (String string : set) {
                    listMap.put(string, elementPoly);
                }
                iPropertySet.setIfNotDefault(Elements.UV, listMap);
            }
            return Elements.finalizeElements(iPropertySet);
        };
        this.addGeom(iPolygon, function);
    }

    public void polylineOut(double[] dArray) {
        assert (6 <= dArray.length);
        assert (dArray.length % 3 == 0);
        Point3d[] point3dArray = (Point3d[])this.unflatten3d(this.getTransformInfo(), dArray, Point3d.class);
        if (this.d_lastPolyline != null && this.d_lastPolyline[this.d_lastPolyline.length - 1].equals(point3dArray[point3dArray.length - 1])) {
            assert (2 <= this.d_lastPolyline.length);
            Point3d[] point3dArray2 = new Point3d[this.d_lastPolyline.length + point3dArray.length];
            System.arraycopy(this.d_lastPolyline, 0, point3dArray2, 0, this.d_lastPolyline.length);
            System.arraycopy(point3dArray, 0, point3dArray2, this.d_lastPolyline.length, point3dArray.length);
            this.d_lastPolyline = point3dArray2;
        } else if (this.d_lastPolyline != null) {
            this.finishPolyline(this.d_lastPolyline);
            this.d_lastPolyline = point3dArray;
        } else {
            this.d_lastPolyline = point3dArray;
        }
    }

    private void finishPolyline(Point3d[] point3dArray) {
        ACurve aCurve = point3dArray.length == 2 ? new LineSeg(point3dArray[0], point3dArray[1]) : new PolyLine(point3dArray);
        this.addGeom(aCurve);
    }

    private static IElementIx getElementIxes(IImportSession.MeshElementMapping meshElementMapping, int[] nArray) {
        switch (meshElementMapping) {
            case ALL_SAME: {
                return (n, n2, n3) -> 0;
            }
            case PER_FACE: {
                if (nArray.length > 0) {
                    return (n, n2, n3) -> nArray[n];
                }
                return (n, n2, n3) -> n;
            }
            case PER_INDEX: {
                if (nArray.length > 0) {
                    return (n, n2, n3) -> nArray[n2];
                }
                return (n, n2, n3) -> n3;
            }
        }
        return null;
    }

    private static List<Point2d> newUVSet(int n) {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(s_emptyUV);
        }
        return arrayList;
    }

    public void shellProc(IImportSession.FaceOrient faceOrient, double[] dArray, int[] nArray, double[] dArray2, String[] stringArray, int[] nArray2, IImportSession.MeshElementMapping meshElementMapping, double[] dArray3, int[] nArray3, IImportSession.MeshElementMapping meshElementMapping2, boolean[] blArray, int[] nArray4, int[] nArray5) {
        Object object;
        boolean bl;
        Object object222;
        Point2d[] point2dArray;
        Object object3;
        Vector3d[] vector3dArray;
        assert (dArray.length % 3 == 0);
        assert (dArray2.length % 2 == 0);
        assert (nArray != null);
        assert (nArray2 != null);
        assert (nArray2.length == 0 || nArray2.length == stringArray.length * nArray.length);
        if (!this.d_importNormals) {
            meshElementMapping = IImportSession.MeshElementMapping.NONE;
        }
        if (!this.d_importCreases) {
            meshElementMapping2 = IImportSession.MeshElementMapping.NONE;
        }
        TransformInfo transformInfo = this.getTransformInfo();
        Point3d[] point3dArray = (Point3d[])this.unflatten3d(transformInfo, dArray, Point3d.class);
        ListMap<Vector3d[], Object> listMap = new ListMap<Vector3d[], Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector3dArray = stringArray[i];
            object3 = Arrays.copyOfRange(nArray2, i * nArray.length, (i + 1) * nArray.length);
            listMap.putIfAbsent(vector3dArray, object3);
        }
        Point2d[] point2dArray2 = point2dArray = dArray2.length > 0 ? this.unflatten2d(dArray2) : null;
        if (point2dArray == null) {
            nArray2 = null;
        }
        vector3dArray = (Vector3d[])this.unflatten3d(transformInfo, dArray3, Vector3d.class);
        object3 = GeomImportHelper.getElementIxes(meshElementMapping, nArray3);
        IElementIx iElementIx = GeomImportHelper.getElementIxes(meshElementMapping2, nArray4);
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Object object222 : listMap.keySet()) {
            linkedHashMap.put((String)object222, new ArrayList());
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        object222 = new IdentityHashMap();
        Function<IMaterial, Set> function = iMaterial -> iMaterial.getAttributes().getUVSets();
        ArrayList<Vector3d> arrayList3 = new ArrayList<Vector3d>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        MeshBuilder meshBuilder = new MeshBuilder(2);
        MeshBuilder meshBuilder2 = new MeshBuilder(3);
        ArrayList<DisplayGeomBuilder.Rep> arrayList5 = new ArrayList<DisplayGeomBuilder.Rep>();
        FacePropSrc facePropSrc = new FacePropSrc(nArray5);
        boolean bl2 = bl = faceOrient == IImportSession.FaceOrient.CCW;
        if (transformInfo.hasNegativeScale()) {
            bl = !bl;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < nArray.length) {
            Object object2;
            int n6 = nArray[n4++];
            assert (arrayList.isEmpty() || n6 < 0);
            int n7 = Math.abs(n6);
            arrayList2.add(arrayList.size());
            int n8 = 0;
            while (n8 < n7) {
                int n9 = n4 + n8;
                arrayList.add(point3dArray[nArray[n9]]);
                if (point2dArray != null) {
                    for (Map.Entry entry : listMap.entrySet()) {
                        object2 = (int[])entry.getValue();
                        ((List)linkedHashMap.get(entry.getKey())).add(point2dArray[object2[n9]]);
                    }
                }
                if (object3 != null) {
                    arrayList3.add(vector3dArray[object3.apply(n3, n9, n5)]);
                }
                if (iElementIx != null) {
                    arrayList4.add(blArray[iElementIx.apply(n3, n9, n5)]);
                }
                ++n8;
                ++n5;
            }
            if (nArray.length > (n4 += n7) && 0 >= nArray[n4]) continue;
            Point3d[] point3dArray2 = theUtil.toArray(arrayList, Point3d.class);
            int[] nArray6 = theUtil.toIntArray(arrayList2);
            IPolygon iPolygon = PolyUtil.newPoly(point3dArray2, nArray6);
            Pair<IPrimProps.Face, GeomImportSession.Material> pair = facePropSrc.next();
            object2 = iPolygon.getNormal(bl);
            if (((Vector3d)object2).lengthSquared() > 0.0) {
                Object object4;
                ListMap listMap2;
                ++n2;
                linkedHashMap2.clear();
                linkedHashMap2.putAll(linkedHashMap);
                if (((IPrimProps.Face)pair.v1).material != null && !linkedHashMap.isEmpty()) {
                    boolean bl3 = false;
                    listMap2 = linkedHashMap.entrySet().iterator().next();
                    Set set = object222.computeIfAbsent(((IPrimProps.Face)pair.v1).material, function);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        bl3 |= linkedHashMap2.putIfAbsent(string, listMap2.getValue()) == null;
                    }
                    if (bl3 && !set.contains(listMap2.getKey())) {
                        linkedHashMap2.remove(listMap2.getKey());
                    }
                    if (set.isEmpty() && this.d_importProps.get(IGeomImportSession.RENAME_ABANDONED_UV_TO) != null) {
                        String string = this.d_importProps.get(IGeomImportSession.RENAME_ABANDONED_UV_TO);
                        linkedHashMap2.remove(listMap2.getKey());
                        linkedHashMap2.put(string, listMap2.getValue());
                    }
                }
                if (this.d_autoCorrectInvertedNormals && !arrayList3.isEmpty() && arrayList3.stream().allMatch(arg_0 -> GeomImportHelper.lambda$shellProc$655((Vector3d)object2, arg_0))) {
                    ++n;
                }
                if (iPolygon instanceof Triangle || iPolygon instanceof Quad) {
                    object4 = iPolygon instanceof Triangle ? meshBuilder : meshBuilder2;
                    ((MeshBuilder)object4).addPrim((IPrimProps)pair.v1, arrayList, linkedHashMap2, arrayList3, arrayList4);
                } else {
                    object4 = Elements.newElements();
                    object4.setIfNotDefault(Elements.NORMAL, this.finalizePolyElems(Elements.NORMAL, arrayList3));
                    object4.setIfNotDefault(Elements.CREASE, this.finalizePolyElems(Elements.CREASE, arrayList4));
                    object4.setIfNotDefault(Elements.ORIENT, Elements.CCW);
                    listMap2 = new ListMap();
                    for (Map.Entry entry : linkedHashMap2.entrySet()) {
                        listMap2.put(entry.getKey(), this.finalizePolyElems(Point2d.class, Elements.NO_UV, (List)entry.getValue()));
                    }
                    object4.setIfNotDefault(Elements.UV, listMap2);
                    object4 = Elements.finalizeElements((IPropertySet)object4);
                    arrayList5.add(new DisplayGeomBuilder.Rep(iPolygon, (IPropertySet)object4, new UniformProps((IPrimProps)pair.v1)));
                }
            }
            arrayList.clear();
            arrayList2.clear();
            for (ListMap listMap2 : linkedHashMap.values()) {
                listMap2.clear();
            }
            arrayList3.clear();
            arrayList4.clear();
            ++n3;
        }
        if (n == n2) {
            bl = !bl;
        }
        DisplayGeomBuilder displayGeomBuilder = new DisplayGeomBuilder();
        for (DisplayGeomBuilder.Rep rep : arrayList5) {
            if (!bl) {
                IPropertySet iPropertySet = Elements.makeMutable(rep.elements);
                iPropertySet.setIfNotDefault(Elements.ORIENT, Elements.CW);
                iPropertySet = Elements.finalizeElements(iPropertySet);
                rep = new DisplayGeomBuilder.Rep(rep.geom, iPropertySet, rep.props);
            }
            displayGeomBuilder.add(rep);
        }
        if (!meshBuilder.isEmpty()) {
            object = meshBuilder.finalizeGeom(bl, this.d_creaseAngle, this.d_autoCorrectInvertedNormals);
            displayGeomBuilder.add((DisplayGeomBuilder.Rep)object);
        }
        if (!meshBuilder2.isEmpty()) {
            object = meshBuilder2.finalizeGeom(bl, this.d_creaseAngle, this.d_autoCorrectInvertedNormals);
            displayGeomBuilder.add((DisplayGeomBuilder.Rep)object);
        }
        object = displayGeomBuilder.finish();
        this.d_faceBuilder.add((DisplayGeomBuilder.Rep)object);
    }

    private <ElemT> IElemSource<ElemT> finalizePolyElems(Elements.ElemProp<ElemT> elemProp, List<ElemT> list) {
        return this.finalizePolyElems(elemProp.type, (IElemSource)elemProp.defVal, list);
    }

    private <ElemT> IElemSource<ElemT> finalizePolyElems(Class<ElemT> clazz, IElemSource<ElemT> iElemSource, List<ElemT> list) {
        if (list.isEmpty()) {
            return iElemSource;
        }
        if (list.size() == 1) {
            return new ElementUniform<ElemT>(list.get(0));
        }
        if (GeomImportHelper.isUniform(list)) {
            return new ElementUniform<ElemT>(list.get(0));
        }
        return new ElementPoly<ElemT>(theUtil.toArray(list, clazz));
    }

    private static <T> boolean isUniform(List<T> list) {
        if (list.isEmpty()) {
            return true;
        }
        T t = list.get(0);
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            if (Objects.equals(t, list.get(i))) continue;
            return false;
        }
        return true;
    }

    public void meshProc(IImportSession.FaceOrient faceOrient, int n, int n2, double[] dArray, boolean[] blArray) {
        int[] nArray = new int[(n - 1) * (n2 - 1) * 5];
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                int n4 = i * n2 + j;
                nArray[n3++] = 4;
                nArray[n3++] = n4;
                nArray[n3++] = n4 + n2;
                nArray[n3++] = n4 + n2 + 1;
                nArray[n3++] = n4 + 1;
            }
        }
        IImportSession.MeshElementMapping meshElementMapping = IImportSession.MeshElementMapping.NONE;
        boolean[] blArray2 = new boolean[]{};
        int[] nArray2 = new int[]{};
        if (blArray.length > 0) {
            blArray2 = new boolean[]{false, true};
            meshElementMapping = IImportSession.MeshElementMapping.PER_INDEX;
            nArray2 = new int[nArray.length];
            n3 = 0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    int n5 = i * (n2 - 1) + j;
                    int n6 = (n2 - 1) * n + j * (n - 1) + i;
                    nArray2[n3++] = 4;
                    nArray2[n3++] = blArray[n6] ? 1 : 0;
                    nArray2[n3++] = blArray[n5 + (n2 - 1)] ? 1 : 0;
                    nArray2[n3++] = blArray[n6 + (n - 1)] ? 1 : 0;
                    nArray2[n3++] = blArray[n5] ? 1 : 0;
                }
            }
        }
        this.shellProc(faceOrient, dArray, nArray, new double[0], new String[0], new int[0], IImportSession.MeshElementMapping.NONE, new double[0], new int[0], meshElementMapping, blArray2, nArray2, new int[0]);
    }

    public boolean circleProc(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        if (!GeomImportHelper.isNullExtrusion(dArray3)) {
            return false;
        }
        Matrix4d matrix4d = this.getLWXform(dArray, null, new Plane3d(dArray2[0], dArray2[1], dArray2[2], 0.0));
        Ellipse2D.Double double_ = ShapeUtil.newCircle(d);
        ShapeGeom shapeGeom = new ShapeGeom((Shape)double_, matrix4d);
        this.addGeom(shapeGeom);
        return true;
    }

    public boolean plineProc(double d, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, double d2, double[] dArray4, boolean bl, double[] dArray5, int n, int n2) {
        Cloneable cloneable;
        int n3;
        if (d2 != 0.0 || dArray.length == 0 || n != 0 || n2 != 0) {
            return false;
        }
        double[] dArray6 = dArray3;
        int n4 = dArray6.length;
        for (n3 = 0; n3 < n4; ++n3) {
            double d3 = dArray6[n3];
            if (d3 == 0.0) continue;
            return false;
        }
        int n5 = dArray.length / 2;
        Point2d[] point2dArray = new Point2d[n5];
        for (n3 = 0; n3 < point2dArray.length; ++n3) {
            int n6 = n3 * 2;
            double d4 = dArray[n6];
            double d5 = dArray[n6 + 1];
            point2dArray[n3] = new Point2d(d4, d5);
        }
        assert (dArray2.length == n5 && (dArray3.length == 0 || dArray3.length / 2 == n5) && nArray.length == n5);
        ShapeUtil.PolyLineBuilder polyLineBuilder = new ShapeUtil.PolyLineBuilder();
        block6: for (int i = 0; i < n5; ++i) {
            Point2d point2d = point2dArray[i];
            if (i == 0) {
                polyLineBuilder.moveTo(point2d);
            }
            cloneable = point2dArray[(i + 1) % n5];
            if (i == n5 - 1 && (!bl || point2d.equals((Tuple2d)cloneable))) break;
            int n7 = nArray[i];
            switch (n7) {
                case 0: {
                    polyLineBuilder.lineTo((Point2d)cloneable);
                    continue block6;
                }
                case 1: {
                    double d6 = dArray2[i];
                    polyLineBuilder.bulgeTo((Point2d)cloneable, d6);
                    continue block6;
                }
            }
        }
        Path2D.Double double_ = polyLineBuilder.getPath();
        Plane3d plane3d = new Plane3d(dArray4[0], dArray4[1], dArray4[2], -d);
        cloneable = this.d_transformSrc.get().toMatrix(true);
        if (dArray5 != null) {
            ((Matrix4d)cloneable).mul(new Matrix4d(dArray5));
        }
        ((Matrix4d)cloneable).mul(CadImporterUtil.getLocalToWorldXform(plane3d));
        this.addGeom(new ShapeGeom((Shape)double_, (Matrix4d)cloneable));
        return true;
    }

    private static boolean isNullExtrusion(double[] dArray) {
        for (double d : dArray) {
            if (d == 0.0) continue;
            return false;
        }
        return true;
    }

    public void metafileProc(double[] dArray, double[] dArray2, double[] dArray3) {
        System.out.printf("Origin: %s%n", Arrays.toString(dArray));
        System.out.printf("U: %s%n", Arrays.toString(dArray2));
        System.out.printf("V: %s%n", Arrays.toString(dArray3));
    }

    private Matrix4d getLWXform(double[] dArray, double[] dArray2, Plane3d plane3d) {
        return this.getLWXform(dArray, dArray2, CadImporterUtil.getLocalToWorldXform(plane3d));
    }

    private Matrix4d getLWXform(double[] dArray, double[] dArray2, Matrix4d matrix4d) {
        Matrix4d matrix4d2 = this.d_transformSrc.get().toMatrix(true);
        if (dArray != null) {
            matrix4d2.mul(Util.translateMat(dArray[0], dArray[1], dArray[2]));
        }
        if (dArray2 != null) {
            matrix4d2.mul(new Matrix4d(dArray2));
        }
        matrix4d2.mul(matrix4d);
        return matrix4d2;
    }

    public boolean circularArcProc(double[] dArray, double d, double[] dArray2, double[] dArray3, double d2, int n, double[] dArray4) {
        if (n != 0 || !GeomImportHelper.isNullExtrusion(dArray4)) {
            return false;
        }
        Plane3d plane3d = new Plane3d(dArray2[0], dArray2[1], dArray2[2], 0.0);
        Matrix4d matrix4d = CadImporterUtil.getLocalToWorldXform(plane3d);
        Matrix4d matrix4d2 = this.getLWXform(dArray, null, matrix4d);
        Vector3d vector3d = Util3D.xform(matrix4d, GeomConstants.VEC3D_XPOS);
        double d3 = Util3D.angle0To2PI(vector3d, new Vector3d(dArray3), plane3d.getNormal());
        double d4 = d3 + d2;
        Arc2D.Double double_ = ShapeUtil.newCircularArc(0.0, 0.0, d, d3, d4, true);
        ShapeGeom shapeGeom = new ShapeGeom((Shape)double_, matrix4d2);
        this.addGeom(shapeGeom);
        return true;
    }

    public boolean circularArcProc(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4) {
        System.out.println("circularArcProc() - simplifying");
        return false;
    }

    public boolean ellipticalArcProc(double[] dArray, double[] dArray2, double d, double[] dArray3, double d2, double[] dArray4, double d3, double d4, double[] dArray5, int n, double[] dArray6) {
        if (n != 0 || !GeomImportHelper.isNullExtrusion(dArray6) || dArray5.length > 0) {
            return false;
        }
        Matrix4d matrix4d = new Matrix4d(dArray2[0], dArray3[0], dArray4[0], 0.0, dArray2[1], dArray3[1], dArray4[1], 0.0, dArray2[2], dArray3[2], dArray4[2], 0.0, 0.0, 0.0, 0.0, 1.0);
        Matrix4d matrix4d2 = this.getLWXform(dArray, null, matrix4d);
        Arc2D.Double double_ = ShapeUtil.newArc(0.0, 0.0, d * 2.0, d2 * 2.0, d3, d4, true);
        ShapeGeom shapeGeom = new ShapeGeom((Shape)double_, matrix4d2);
        this.addGeom(shapeGeom);
        return true;
    }

    public boolean textProc(double[] dArray, double[] dArray2, double[] dArray3, String string, boolean bl, int n, double[] dArray4) {
        if (this.ignoreText) {
            System.out.println("textProc() - ignoring: " + string);
        }
        return this.ignoreText;
    }

    public DisplayGeomBuilder.Rep finish() {
        if (this.d_lastPolyline != null) {
            this.finishPolyline(this.d_lastPolyline);
        }
        DisplayGeomBuilder.Rep rep = this.d_faceBuilder.finish();
        if (this.d_solid && rep != DisplayGeomBuilder.EMPTY_REP) {
            rep = new DisplayGeomBuilder.Rep(new SolidGeom(rep.geom), rep.elements, rep.props);
        }
        DisplayGeomBuilder.Rep rep2 = this.d_nonFaceBuilder.finish();
        DisplayGeomBuilder.Rep rep3 = DisplayGeomBuilder.merge(Arrays.asList(rep, rep2));
        IGeom iGeom = rep3.geom.optimize(this.d_pointPool);
        if (iGeom.getNumPrims(7) == 0) {
            return DisplayGeomBuilder.EMPTY_REP;
        }
        if (iGeom == rep3.geom) {
            return rep3;
        }
        return new DisplayGeomBuilder.Rep(iGeom, rep3.elements, rep3.props);
    }

    private static int countPrims(Collection<? extends IGeom> collection) {
        return new GeomGroup(collection).getNumPrims(7);
    }

    private static /* synthetic */ boolean lambda$shellProc$655(Vector3d vector3d, Vector3d vector3d2) {
        return vector3d2.dot(vector3d) < 0.0;
    }

    private static class MeshBuilder {
        private final byte d_primType;
        private final PropsBuilder d_props = new PropsBuilder();
        private final VertBuilder<Point3d> d_verts = new VertBuilder();
        private final Map<String, VertBuilder<Point2d>> d_uvs = new ListMap<String, VertBuilder<Point2d>>();
        private final VertBuilder<Vector3d> d_normals = new VertBuilder();
        private final VertBuilder<Boolean> d_creases = new VertBuilder();
        private static final Point2d s_uv0 = new Point2d();

        public MeshBuilder(byte by) {
            this.d_primType = by;
        }

        public void addPrim(IPrimProps iPrimProps, List<Point3d> list, Map<String, List<Point2d>> map, List<Vector3d> list2, List<Boolean> list3) {
            int n = this.d_verts.prims.size();
            assert (!list.isEmpty());
            this.d_verts.add(list);
            this.d_normals.add(list2, n, GeomConstants.VEC3D_ZPOS);
            this.d_creases.add(list3, n, Boolean.TRUE);
            for (Map.Entry<String, List<Point2d>> entry : map.entrySet()) {
                VertBuilder vertBuilder = this.d_uvs.computeIfAbsent(entry.getKey(), string -> new VertBuilder());
                vertBuilder.add(entry.getValue(), n, s_uv0);
            }
            this.d_props.add(iPrimProps);
        }

        public void addPrim(IPrimProps iPrimProps, Point3d ... point3dArray) {
            for (Point3d point3d : point3dArray) {
                this.d_verts.add(point3d);
            }
            this.d_props.add(iPrimProps);
        }

        public boolean isEmpty() {
            return this.d_verts.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public DisplayGeomBuilder.Rep finalizeGeom(boolean bl2, double d, boolean bl3) {
            IElemSource<Vector3d> iElemSource;
            IElemSource<Elements.Orient> iElemSource2;
            void var12_15;
            Object object;
            Object object2;
            int n = this.d_verts.prims.size();
            this.d_normals.finish(n, GeomConstants.VEC3D_ZPOS);
            this.d_creases.finish(n, Boolean.TRUE);
            for (Map.Entry<String, VertBuilder<Point2d>> object32 : this.d_uvs.entrySet()) {
                object32.getValue().finish(n, s_uv0);
            }
            Point3d[] point3dArray = theUtil.toArray(this.d_verts.verts.keySet(), Point3d.class);
            int[] nArray = theUtil.toIntArray(this.d_verts.prims);
            Mesh mesh = new Mesh(point3dArray, nArray, this.d_primType);
            Mesh.Fixer fixer = mesh.getFixes();
            mesh = fixer.fix(mesh);
            ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry<String, VertBuilder<Point2d>> entry : this.d_uvs.entrySet()) {
                Mesh mesh2 = mesh;
                object2 = entry.getValue();
                object = this.finishElem(mesh2, new Elements.ElemProp<Point2d>(0, Point2d.class, Elements.NO_UV), ((VertBuilder)object2).verts.keySet(), ((VertBuilder)object2).prims, elementMesh -> fixer.fixVertElements(elementMesh));
                listMap.put(entry.getKey(), (IElemSource<Point2d>)object);
            }
            IElemSource<Vector3d> iElemSource3 = this.finishElem(mesh, Elements.NORMAL, this.d_normals.verts.keySet(), this.d_normals.prims, elementMesh -> fixer.fixVertElements(elementMesh));
            Function<ElementMesh, ElementMesh> function = elementMesh -> elementMesh;
            if (fixer.needsMeshCorrection() && !this.d_creases.isEmpty()) {
                int n2 = this.d_creases.verts.computeIfAbsent(Boolean.FALSE, bl -> this.d_creases.verts.size());
                Function<ElementMesh, ElementMesh> function2 = elementMesh -> fixer.fixEdgeElements(elementMesh, n2 -> n2);
            }
            IElemSource<Boolean> iElemSource4 = this.finishElem(mesh, Elements.CREASE, this.d_creases.verts.keySet(), this.d_creases.prims, (Function)var12_15);
            object2 = this.d_props;
            if (fixer.needsPropFix()) {
                object = new PropsBuilder();
                fixer.fixProps(this.d_props.iterator(), ((PropsBuilder)object)::add);
                object2 = object;
            }
            object = ((PropsBuilder)object2).finalizeProps();
            IElemSource<Elements.Orient> iElemSource5 = iElemSource2 = bl2 ? Elements.CCW : Elements.CW;
            if (iElemSource3 == Elements.NO_NORMAL && d > 0.0) {
                if (bl3) {
                    iElemSource2 = Elements.fixFaceOrients(mesh, iElemSource2, (IPropsSrc)object);
                }
                iElemSource3 = Elements.generateNormals(mesh, iElemSource2, d);
            }
            if (this.d_creases.isEmpty()) {
                iElemSource = iElemSource3;
                if (iElemSource == Elements.NO_NORMAL) {
                    iElemSource = Elements.generateNormals(mesh, iElemSource2, d);
                }
                iElemSource4 = Elements.generateCreasesFromNormals(mesh, (IPropsSrc)object2, iElemSource, iElemSource2);
            }
            iElemSource = Elements.newElements();
            iElemSource.setIfNotDefault(Elements.UV, listMap);
            iElemSource.setIfNotDefault(Elements.NORMAL, iElemSource3);
            iElemSource.setIfNotDefault(Elements.CREASE, iElemSource4);
            iElemSource.setIfNotDefault(Elements.ORIENT, iElemSource2);
            iElemSource = Elements.finalizeElements(iElemSource);
            int n3 = mesh.getNumPrims(7);
            IGeom iGeom = mesh;
            if (n3 == 0) {
                return DisplayGeomBuilder.EMPTY_REP;
            }
            if (n3 == 1) {
                iGeom = mesh.getPrimitive(0);
            }
            return new DisplayGeomBuilder.Rep(iGeom, (IPropertySet)((Object)iElemSource), (IPropsSrc)object);
        }

        private <ElemT> IElemSource<ElemT> finishElem(Mesh mesh, Elements.ElemProp<ElemT> elemProp, Collection<ElemT> collection, List<Integer> list, Function<ElementMesh<ElemT>, ElementMesh<ElemT>> function) {
            if (this.d_verts.prims.size() == list.size()) {
                byte by;
                int[] nArray;
                if (collection.size() == 1) {
                    return new ElementUniform<ElemT>(collection.iterator().next());
                }
                ElemT[] ElemTArray = theUtil.toArray(collection, elemProp.type);
                if (this.d_verts.prims.equals(list)) {
                    nArray = mesh.indices;
                    by = mesh.primtype;
                } else {
                    nArray = theUtil.toIntArray(list);
                    by = this.d_primType;
                }
                ElementMesh elementMesh = new ElementMesh(ElementMesh.Mapping.PER_PRIM_VERTEX, ElemTArray, nArray, Mesh.getNumVertsPerElement(by));
                if (nArray != mesh.indices) {
                    elementMesh = function.apply(elementMesh);
                }
                if (elementMesh.indices.length == elementMesh.elements.length) {
                    elementMesh = new ElementMesh(elementMesh.mapping, elementMesh.elements, elementMesh.vertsPerPrim);
                }
                return elementMesh.optimize(elemProp.type);
            }
            if (!collection.isEmpty()) {
                System.err.println("GeomImportHelper.MeshBuilder missing element coordinates for some faces.");
            }
            return (IElemSource)elemProp.defVal;
        }

        private static class VertBuilder<T> {
            public final Map<T, Integer> verts = new LinkedHashMap<T, Integer>();
            public final List<Integer> prims = new ArrayList<Integer>();

            private VertBuilder() {
            }

            public boolean equals(Object object) {
                return object == this || object instanceof VertBuilder && this.verts.equals(((VertBuilder)object).verts) && this.prims.equals(((VertBuilder)object).prims);
            }

            public void add(T t) {
                this.prims.add(this.indexOf(t));
            }

            public void add(List<T> list) {
                for (T t : list) {
                    this.add(t);
                }
            }

            public void add(List<T> list, int n, T t) {
                if (list.isEmpty()) {
                    return;
                }
                this.matchSize(n, t);
                this.add(list);
            }

            private void matchSize(int n, T t) {
                if (this.prims.size() < n) {
                    int n2 = this.indexOf(t);
                    for (int i = this.prims.size(); i < n; ++i) {
                        this.prims.add(n2);
                    }
                }
            }

            public void finish(int n, T t) {
                if (this.prims.isEmpty()) {
                    return;
                }
                this.matchSize(n, t);
            }

            public boolean isEmpty() {
                return this.prims.isEmpty();
            }

            private Integer indexOf(T t) {
                Integer n = this.verts.get(t);
                if (n == null) {
                    n = this.verts.size();
                    this.verts.put(t, n);
                }
                return n;
            }
        }
    }

    private static interface IElementIx {
        public int apply(int var1, int var2, int var3);
    }

    private class FacePropSrc {
        private final int[] materials;
        private int d_ix;
        private GeomImportSession.Material d_imat;
        private IPrimProps.Face d_currProps;

        public FacePropSrc(int[] nArray) {
            this.materials = nArray;
            this.d_ix = 0;
            this.d_imat = GeomImportHelper.this.d_currentImportMat;
            this.d_currProps = GeomImportHelper.this.d_currentFaceProps;
        }

        public Pair<IPrimProps.Face, GeomImportSession.Material> next() {
            Pair pair;
            switch (this.materials.length) {
                case 0: {
                    return new Pair<IPrimProps.Face, GeomImportSession.Material>(this.d_currProps, this.d_imat);
                }
                case 1: {
                    pair = (Pair)GeomImportHelper.this.d_matMap.apply(this.materials[0]);
                    break;
                }
                default: {
                    int n = this.d_ix++;
                    pair = (Pair)GeomImportHelper.this.d_matMap.apply(this.materials[n]);
                }
            }
            this.d_imat = (GeomImportSession.Material)pair.v1;
            this.d_currProps = (IPrimProps.Face)GeomImportHelper.setMaterial(this.d_currProps, (IMaterial)pair.v2);
            return new Pair<IPrimProps.Face, GeomImportSession.Material>(this.d_currProps, this.d_imat);
        }
    }
}

