/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;

public class ExporterPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final IPropertySet.Prop<CadImporter.Exporter> EXPORTER = new IPropertySet.Prop<CadImporter.Exporter>("ExporterPnl.EXPORTER", CadImporter.Exporter.UNKNOWN);
    public static final IPropertySet.Prop<CadImporter.Exporter> DETECTED_EXPORTER = new IPropertySet.Prop<Object>("ExporterPnl.DETECTED_EXPORTER", null);
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(EXPORTER, DETECTED_EXPORTER);
    private final guiComboBox<CadImporter.Exporter> d_exporterCB;
    private CadImporter.Exporter d_detectedExporter = null;

    public ExporterPnl(IPropertySet iPropertySet) {
        this.d_detectedExporter = iPropertySet.get(DETECTED_EXPORTER);
        this.d_exporterCB = new guiComboBox<CadImporter.Exporter>(CadImporter.Exporter.values());
        this.d_exporterCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                switch ((CadImporter.Exporter)((Object)object)) {
                    case SIMLAB: {
                        string = Intl.intl("SimLab");
                        break;
                    }
                    default: {
                        string = Intl.intl("Unknown");
                    }
                }
                if (object == ExporterPnl.this.d_detectedExporter && ExporterPnl.this.d_detectedExporter != CadImporter.Exporter.UNKNOWN) {
                    string = String.format("%s (detected)", string);
                }
                this.setText(string);
                return this;
            }
        });
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Which software was used to export the FBX file?"));
        guiLabel2.setToolTipText(Intl.intl("This controls which options are selected in the following steps."));
        gridBagHelper.addFilledRow(guiLabel2);
        gridBagHelper.addIdentRow(this.d_exporterCB, 0);
        gridBagHelper.finalizeRows();
    }

    @Override
    public void init(IPropertySet iPropertySet) {
        this.d_exporterCB.setSelectedItem((Object)iPropertySet.get(EXPORTER));
    }

    @Override
    public IPropertySet commit(IPropertySet iPropertySet) {
        CadImporter.Exporter exporter = this.d_exporterCB.getSelectedItem();
        if (exporter != iPropertySet.get(EXPORTER)) {
            ExporterPnl.initExporter(iPropertySet, exporter);
        }
        iPropertySet.setIfNotDefault(EXPORTER, exporter);
        return iPropertySet;
    }

    public static void initExporter(IPropertySet iPropertySet, CadImporter.Exporter exporter) {
        iPropertySet.set(EXPORTER, exporter);
        switch (exporter) {
            case SIMLAB: {
                iPropertySet.setIfNotDefault(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR, true);
                iPropertySet.setIfNotDefault(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS, true);
                break;
            }
            default: {
                iPropertySet.setIfNotDefault(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR, false);
                iPropertySet.setIfNotDefault(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS, false);
            }
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

