/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class CadSplitter {
    private final Map<IGeom, SplitGeom> geomSplitCache = new IdentityHashMap<IGeom, SplitGeom>();
    private final Map<IGeomNode, SplitNodeGeom> gnodeSplitCache = new IdentityHashMap<IGeomNode, SplitNodeGeom>();
    private final Map<IGeomImportSession.Node, Pair<IGeomImportSession.Node, IGeomImportSession.Node>> nodeSplitCache = new IdentityHashMap<IGeomImportSession.Node, Pair<IGeomImportSession.Node, IGeomImportSession.Node>>();

    public List<Pair<IGeomImportSession.Node, IGeomImportSession.Node>> splitGeom(Collection<IGeomImportSession.Node> collection) {
        ArrayList<Pair<IGeomImportSession.Node, IGeomImportSession.Node>> arrayList = new ArrayList<Pair<IGeomImportSession.Node, IGeomImportSession.Node>>(collection.size());
        for (IGeomImportSession.Node node : collection) {
            arrayList.add(this.splitNode(node));
        }
        return arrayList;
    }

    public Pair<IGeomImportSession.Node, IGeomImportSession.Node> splitNode(IGeomImportSession.Node node) {
        Pair<Object, Object> pair;
        Pair<IGeomImportSession.Node, IGeomImportSession.Node> pair2 = this.nodeSplitCache.get(node);
        if (pair2 != null) {
            return pair2;
        }
        int n = CadSplitter.getNumPrims(node, 1);
        int n2 = CadSplitter.getNumPrims(node, 6);
        if (n > 0 && n2 > 0) {
            IGeomImportSession.Node node22;
            Pair<DisplayGeom, DisplayGeom> pair3 = this.splitDisplay(node.dg);
            ArrayList<IGeomImportSession.Node> arrayList = new ArrayList<IGeomImportSession.Node>();
            ArrayList<IGeomImportSession.Node> arrayList2 = new ArrayList<IGeomImportSession.Node>();
            for (IGeomImportSession.Node node22 : node.children) {
                Pair<IGeomImportSession.Node, IGeomImportSession.Node> pair4 = this.splitNode(node22);
                if (pair4.v1 != null) {
                    arrayList.add((IGeomImportSession.Node)pair4.v1);
                }
                if (pair4.v2 == null) continue;
                arrayList2.add((IGeomImportSession.Node)pair4.v2);
            }
            IGeomImportSession.Node node3 = new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, pair3.v1 != null ? (DisplayGeom)pair3.v1 : DisplayGeom.EMPTY, arrayList);
            node22 = new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, pair3.v2 != null ? (DisplayGeom)pair3.v2 : DisplayGeom.EMPTY, arrayList2);
            pair = new Pair<Object, IGeomImportSession.Node>(node3, node22);
        } else {
            pair = n > 0 ? new Pair<IGeomImportSession.Node, Object>(node, null) : new Pair<Object, IGeomImportSession.Node>(null, node);
        }
        this.nodeSplitCache.put(node, pair);
        return pair;
    }

    private static int getNumPrims(IGeomImportSession.Node node, int n) {
        int n2 = node.dg.node.getNumPrims(n);
        for (IGeomImportSession.Node node2 : node.children) {
            n2 += CadSplitter.getNumPrims(node2, n);
        }
        return n2;
    }

    public Pair<DisplayGeom, DisplayGeom> splitDisplay(DisplayGeom displayGeom) {
        SplitNodeGeom splitNodeGeom = this.splitGeomNode(displayGeom.node);
        return splitNodeGeom.split(displayGeom.props);
    }

    /*
     * WARNING - void declaration
     */
    public SplitNodeGeom splitGeomNode(IGeomNode iGeomNode) {
        SplitNodeGeom splitNodeGeom;
        SplitNodeGeom splitNodeGeom2 = this.gnodeSplitCache.get(iGeomNode);
        if (splitNodeGeom2 != null) {
            return splitNodeGeom2;
        }
        int n = iGeomNode.getNumPrims(1);
        int n2 = iGeomNode.getNumPrims(6);
        if (n > 0 && n2 > 0) {
            int i;
            SplitGeom splitGeom = this.splitGeom(iGeomNode.getLocalGeom());
            ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>();
            ArrayList<IGeomNode> arrayList2 = new ArrayList<IGeomNode>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            if (splitGeom.faceOffsets != null) {
                void iGeomNode2;
                int[] nArray = splitGeom.faceOffsets;
                i = nArray.length;
                boolean bl = false;
                while (iGeomNode2 < i) {
                    int splitNodeGeom3 = nArray[iGeomNode2];
                    arrayList3.add(splitNodeGeom3);
                    ++iGeomNode2;
                }
            } else if (splitGeom.faces != null) {
                int n4 = splitGeom.faces.getNumPrims(1);
                for (i = 0; i < n4; ++i) {
                    arrayList3.add(i);
                }
            }
            int n5 = iGeomNode.getLocalGeom().getNumPrims(7);
            for (IGeomNode iGeomNode4 : iGeomNode.getChildren()) {
                SplitNodeGeom splitNodeGeom3 = this.splitGeomNode(iGeomNode4);
                if (splitNodeGeom3.faces != null) {
                    int n3;
                    arrayList.add(splitNodeGeom3.faces);
                    if (splitNodeGeom3.faceOffsets != null) {
                        int[] n8 = splitNodeGeom3.faceOffsets;
                        n3 = n8.length;
                        for (int j = 0; j < n3; ++j) {
                            int n4 = n8[j];
                            arrayList3.add(n4 + n5);
                        }
                    } else {
                        int n6 = splitNodeGeom3.faces.getNumPrims(1);
                        for (n3 = 0; n3 < n6; ++n3) {
                            arrayList3.add(n3 + n5);
                        }
                    }
                }
                if (splitNodeGeom3.nonFaces != null) {
                    arrayList2.add(splitNodeGeom3.nonFaces);
                }
                n5 += iGeomNode4.getNumPrims(7);
            }
            arrayList.trimToSize();
            arrayList2.trimToSize();
            IGeomNode iGeomNode3 = GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), splitGeom.faces != null ? splitGeom.faces : EmptyGeom.INSTANCE, splitGeom.getFaceProps(new ElBuilder(), iGeomNode.getLocalElements()), arrayList);
            IGeomNode iGeomNode2 = GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), splitGeom.nonFaces != null ? splitGeom.nonFaces : EmptyGeom.INSTANCE, splitGeom.getNonFaceProps(new ElBuilder(), iGeomNode.getLocalElements()), arrayList2);
            splitNodeGeom = new SplitNodeGeom(iGeomNode, iGeomNode3, iGeomNode2, theUtil.toIntArray(arrayList3));
        } else {
            splitNodeGeom = n > 0 ? new SplitNodeGeom(iGeomNode, iGeomNode, null, null) : new SplitNodeGeom(iGeomNode, null, iGeomNode, null);
        }
        this.gnodeSplitCache.put(iGeomNode, splitNodeGeom);
        return splitNodeGeom;
    }

    public SplitGeom splitGeom(IGeom iGeom) {
        SplitGeom splitGeom;
        SplitGeom splitGeom2 = this.geomSplitCache.get(iGeom);
        if (splitGeom2 != null) {
            return splitGeom2;
        }
        int n = iGeom.getNumPrims(1);
        int n2 = iGeom.getNumPrims(6);
        if (n > 0 && n2 > 0) {
            if (iGeom instanceof GeomGroup) {
                GeomGroup geomGroup = (GeomGroup)iGeom;
                ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
                ArrayList<IGeom> arrayList2 = new ArrayList<IGeom>();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                int n3 = 0;
                for (IGeom iGeom2 : geomGroup.children) {
                    SplitGeom splitGeom3 = this.splitGeom(iGeom2);
                    if (splitGeom3.faces != null) {
                        int n4;
                        arrayList.add(splitGeom3.faces);
                        if (splitGeom3.faceOffsets != null) {
                            int[] nArray = splitGeom3.faceOffsets;
                            n4 = nArray.length;
                            for (int i = 0; i < n4; ++i) {
                                int n5 = nArray[i];
                                arrayList3.add(n5 + n3);
                            }
                        } else {
                            int n6 = splitGeom3.faces.getNumPrims(1);
                            for (n4 = 0; n4 < n6; ++n4) {
                                arrayList3.add(n4 + n3);
                            }
                        }
                    }
                    if (splitGeom3.nonFaces != null) {
                        arrayList2.add(splitGeom3.nonFaces);
                    }
                    n3 += iGeom2.getNumPrims(7);
                }
                assert (!arrayList.isEmpty() && !arrayList2.isEmpty());
                splitGeom = new SplitGeom(iGeom, GeomUtil.group(arrayList), GeomUtil.group(arrayList2), theUtil.toIntArray(arrayList3));
            } else {
                ArrayList<IPrimitive> arrayList = new ArrayList<IPrimitive>(n);
                ArrayList<IPrimitive> arrayList4 = new ArrayList<IPrimitive>(n2);
                int[] nArray = new int[n];
                List<IPrimitive> list = GeomUtil.explodeToTypes(iGeom, 7);
                for (int i = 0; i < list.size(); ++i) {
                    IPrimitive iPrimitive = list.get(i);
                    if (iPrimitive instanceof IFace) {
                        nArray[arrayList.size()] = i;
                        arrayList.add(iPrimitive);
                        continue;
                    }
                    arrayList4.add(iPrimitive);
                }
                splitGeom = new SplitGeom(iGeom, GeomUtil.group(arrayList), GeomUtil.group(arrayList4), nArray);
            }
        } else {
            splitGeom = n > 0 ? new SplitGeom(iGeom, iGeom, null, null) : new SplitGeom(iGeom, null, iGeom, null);
        }
        this.geomSplitCache.put(iGeom, splitGeom);
        return splitGeom;
    }

    private static <SrcT> SrcT getFaceProps(ItemBuilder<SrcT> itemBuilder, SrcT SrcT, int n, int[] nArray) {
        return CadSplitter.getItems(itemBuilder, SrcT, n, nArray);
    }

    private static <SrcT> SrcT getNonFaceProps(ItemBuilder<SrcT> itemBuilder, SrcT SrcT, int n, int n2, int[] nArray) {
        int[] nArray2 = nArray != null ? CadSplitter.invertOffsets(nArray, n) : null;
        return CadSplitter.getItems(itemBuilder, SrcT, n2, nArray2);
    }

    private static <SrcT> SrcT getItems(ItemBuilder<SrcT> itemBuilder, SrcT SrcT, int n, int[] nArray) {
        if (nArray == null) {
            itemBuilder.add(SrcT, n);
        } else {
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = CadSplitter.getSequentialRange(nArray, n2);
                int n3 = nArray[nArray2[0]];
                int n4 = nArray2[1] - nArray2[0];
                itemBuilder.add(SrcT, n3, n4);
                n2 = nArray2[1];
            }
        }
        return itemBuilder.finalizeItems();
    }

    private static int[] getSequentialRange(int[] nArray, int n) {
        int n2 = nArray[n];
        for (int i = n + 1; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 != n2 + 1) {
                return new int[]{n, i};
            }
            n2 = n3;
        }
        return new int[]{n, nArray.length};
    }

    private static int[] invertOffsets(int[] nArray, int n) {
        int[] nArray2 = new int[n - nArray.length];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            while (n3 < nArray[i]) {
                nArray2[n2++] = n3++;
            }
            ++n3;
        }
        while (n3 < n) {
            nArray2[n2++] = n3++;
        }
        return nArray2;
    }

    private static class ElBuilder
    implements ItemBuilder<IPropertySet> {
        private final ElementsBuilder d_builder = new ElementsBuilder();

        private ElBuilder() {
        }

        @Override
        public void add(IPropertySet iPropertySet, int n) {
            this.d_builder.add(iPropertySet, n);
        }

        @Override
        public void add(IPropertySet iPropertySet, int n, int n2) {
            this.d_builder.addRange(iPropertySet, n, n2);
        }

        @Override
        public IPropertySet finalizeItems() {
            return this.d_builder.finish();
        }
    }

    private static class PropBuilder
    implements ItemBuilder<IPropsSrc> {
        private final PropsBuilder d_builder = new PropsBuilder();

        private PropBuilder() {
        }

        @Override
        public void add(IPropsSrc iPropsSrc, int n) {
            this.d_builder.add(iPropsSrc, n);
        }

        @Override
        public void add(IPropsSrc iPropsSrc, int n, int n2) {
            this.d_builder.add(iPropsSrc.subset(n, n2), n2);
        }

        @Override
        public IPropsSrc finalizeItems() {
            return this.d_builder.finalizeProps();
        }
    }

    public static interface ItemBuilder<SrcT> {
        public void add(SrcT var1, int var2);

        public void add(SrcT var1, int var2, int var3);

        public SrcT finalizeItems();
    }

    public static class SplitGeom {
        public final IGeom original;
        public final IGeom faces;
        public final IGeom nonFaces;
        public final int[] faceOffsets;

        public SplitGeom(IGeom iGeom, IGeom iGeom2, IGeom iGeom3, int[] nArray) {
            this.original = iGeom;
            this.faces = iGeom2;
            this.nonFaces = iGeom3;
            this.faceOffsets = nArray;
        }

        public <SrcT> SrcT getFaceProps(ItemBuilder<SrcT> itemBuilder, SrcT SrcT) {
            return (SrcT)CadSplitter.getFaceProps(itemBuilder, SrcT, this.faces != null ? this.faces.getNumPrims(7) : 0, this.faceOffsets);
        }

        public <SrcT> SrcT getNonFaceProps(ItemBuilder<SrcT> itemBuilder, SrcT SrcT) {
            return (SrcT)CadSplitter.getNonFaceProps(itemBuilder, SrcT, this.original.getNumPrims(7), this.nonFaces != null ? this.nonFaces.getNumPrims(7) : 0, this.faceOffsets);
        }
    }

    public static class SplitNodeGeom {
        public final IGeomNode original;
        public final IGeomNode faces;
        public final IGeomNode nonFaces;
        public final int[] faceOffsets;

        public SplitNodeGeom(IGeomNode iGeomNode, IGeomNode iGeomNode2, IGeomNode iGeomNode3, int[] nArray) {
            this.original = iGeomNode;
            this.faceOffsets = nArray;
            this.faces = iGeomNode2;
            this.nonFaces = iGeomNode3;
        }

        public Pair<DisplayGeom, DisplayGeom> split(IPropsSrc iPropsSrc) {
            if (this.faces != null && this.nonFaces != null) {
                int n = this.faces.getNumPrims(7);
                int n2 = this.nonFaces.getNumPrims(7);
                IPropsSrc iPropsSrc2 = (IPropsSrc)CadSplitter.getFaceProps(new PropBuilder(), iPropsSrc, n, this.faceOffsets);
                IPropsSrc iPropsSrc3 = (IPropsSrc)CadSplitter.getNonFaceProps(new PropBuilder(), iPropsSrc, n + n2, n2, this.faceOffsets);
                return new Pair<DisplayGeom, DisplayGeom>(new DisplayGeom(this.faces, iPropsSrc2), new DisplayGeom(this.nonFaces, iPropsSrc3));
            }
            if (this.faces != null) {
                return new Pair<DisplayGeom, Object>(new DisplayGeom(this.original, iPropsSrc), null);
            }
            return new Pair<Object, DisplayGeom>(null, new DisplayGeom(this.original, iPropsSrc));
        }
    }
}

