/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;

public class CadImporterUtil {
    public static Matrix4d getWorldToLocalXform(Plane3d plane3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        CadImporterUtil.getLocalAxes(plane3d, vector3d, vector3d3, vector3d2);
        double d = vector3d2.x * plane3d.w;
        double d2 = vector3d2.y * plane3d.w;
        double d3 = vector3d2.z * plane3d.w;
        return new Matrix4d(vector3d.x, vector3d.y, vector3d.z, vector3d.x * d + vector3d.y * d2 + vector3d.z * d3, vector3d3.x, vector3d3.y, vector3d3.z, vector3d3.x * d + vector3d3.y * d2 + vector3d3.z * d3, vector3d2.x, vector3d2.y, vector3d2.z, vector3d2.x * d + vector3d2.y * d2 + vector3d2.z * d3, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d plane3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        CadImporterUtil.getLocalAxes(plane3d, vector3d, vector3d3, vector3d2);
        double d = -vector3d2.x * plane3d.w;
        double d2 = -vector3d2.y * plane3d.w;
        double d3 = -vector3d2.z * plane3d.w;
        return new Matrix4d(vector3d.x, vector3d3.x, vector3d2.x, d, vector3d.y, vector3d3.y, vector3d2.y, d2, vector3d.z, vector3d3.z, vector3d2.z, d3, 0.0, 0.0, 0.0, 1.0);
    }

    private static void getLocalAxes(Plane3d plane3d, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        plane3d.getNormal(vector3d3);
        if (Math.abs(vector3d3.x) < 0.015625 && Math.abs(vector3d3.y) < 0.015625) {
            vector3d.cross(GeomConstants.VEC3D_YPOS, vector3d3);
        } else {
            vector3d.cross(GeomConstants.VEC3D_ZPOS, vector3d3);
        }
        vector3d.normalize();
        vector3d2.cross(vector3d3, vector3d);
        vector3d2.normalize();
    }
}

