/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jscience.physics.units.NonSI;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.ExporterPnl;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.cad.in.UnitsPnl;
import thunderheadeng.cad.in.fbx.FbxPropEditor;
import thunderheadeng.cad.in.ifc.IfcPropEditor;
import thunderheadeng.cad.in.teigha.TeighaGeomImportSession;
import thunderheadeng.cad.in.teigha.TeighaPropEditor;
import thunderheadeng.cad.in.teigha.TeighaTriangulationPnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.IEditor;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.BiIntFunction;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.JniTaskProgress;
import thunderheadeng.util.TaskProgress;

public class CadImporter {
    public static final int TYPE_TEIGHA = 0;
    public static final int TYPE_FBX = 1;
    public static final int TYPE_IFC = 2;
    private static volatile WeakReference<Thread> s_currThread = new WeakReference<Object>(null);
    private static final ExecutorService s_executor;
    private long d_peerObj;
    private int d_openedType = -1;
    private String d_openedFn = "";
    private static boolean s_librariesLoaded;

    private native void create();

    private native void destroy();

    private native int jniOpen(String var1, ByteBuffer var2) throws IOException;

    private native int jniGetLengthUnit();

    private native double[] jniGetModelBounds();

    private native void jniImportCad(IImportSession var1, ByteBuffer var2) throws IOException, CancellationException;

    private native int jniSetTriangulationParams(double var1, int var3);

    private native int jniSetIfcParameters(int var1);

    private native int jniDetectExporter();

    public static String[] getSupportedFileFormats() {
        return new String[]{"ifc", Intl.intl("Industry Foundation Classes (BIM)"), "ifcxml", Intl.intl("Industry Foundation Classes (BIM)"), "dxf", Intl.intl("Drawing Exchange Format File"), "dwg", Intl.intl("Drawing (AutoDesk)"), "fbx", Intl.intl("Autodesk FBX"), "dae", Intl.intl("Collada DAE"), "obj", Intl.intl("Alias OBJ")};
    }

    public CadImporter() {
        this.run(() -> this.create());
    }

    public void finalize() throws Throwable {
        this.freeData();
        super.finalize();
    }

    public void freeData() {
        this.run(() -> this.destroy());
    }

    private void run(Runnable runnable) {
        if (Thread.currentThread() == s_currThread.get()) {
            runnable.run();
            return;
        }
        try {
            s_executor.submit(runnable).get();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private <T> T call(T t, Callable<T> callable) {
        try {
            if (Thread.currentThread() == s_currThread.get()) {
                return callable.call();
            }
            return s_executor.submit(callable).get();
        }
        catch (Throwable throwable) {
            return t;
        }
    }

    private void runIO(Callable<?> callable) throws IOException, CancellationException {
        try {
            if (Thread.currentThread() == s_currThread.get()) {
                callable.call();
            } else {
                s_executor.submit(callable).get();
            }
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof IOException) {
                throw (IOException)executionException.getCause();
            }
            if (executionException.getCause() instanceof CancellationException) {
                throw (CancellationException)executionException.getCause();
            }
            throw new IOException(CadImporter.format(executionException.getCause()), executionException.getCause());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    private static String format(Throwable throwable) {
        return throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCad(TaskProgress taskProgress, String string) throws IOException, CancellationException {
        String string2 = new File(string).getName();
        taskProgress.setMessageGenerator((n, n2) -> {
            switch (n) {
                case -1: {
                    return String.format(Intl.intl("Opening %s"), string2);
                }
            }
            return String.format(Intl.intl("Opening %s: %d %%"), string2, (int)((float)n / (float)n2 * 100.0f));
        });
        JniTaskProgress jniTaskProgress = new JniTaskProgress(taskProgress);
        try {
            this.runIO(() -> {
                this.loadLibraries();
                this.d_openedType = this.jniOpen(string, jniTaskProgress.getBuffer());
                this.d_openedFn = string;
                return null;
            });
        }
        finally {
            jniTaskProgress.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibraries() {
        Class<CadImporter> clazz = CadImporter.class;
        synchronized (CadImporter.class) {
            if (s_librariesLoaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.loadLibrary("ifcengine");
            s_librariesLoaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public IGeomImportSession createCompatibleGeomTarget(GeomImportSession.ICallback iCallback, IPropertySet iPropertySet) {
        switch (this.d_openedType) {
            case 0: {
                return new TeighaGeomImportSession(iCallback, iPropertySet);
            }
            case 1: 
            case 2: {
                return new GeomImportSession(iCallback, iPropertySet);
            }
        }
        return null;
    }

    public int getLengthUnit() {
        return this.call(0, () -> this.jniGetLengthUnit());
    }

    public AABox getModelBounds() {
        return this.call(new AABox(), () -> {
            double[] dArray = this.jniGetModelBounds();
            return new AABox(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        });
    }

    public boolean isBoundsSlow() {
        switch (this.d_openedType) {
            case 0: {
                return !FilenameManager.getExtension(this.d_openedFn).equalsIgnoreCase("dxf");
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    public int setTriangulationParams(double d, int n) {
        return this.call(0, () -> this.jniSetTriangulationParams(d, n));
    }

    public int setIfcParameters(IfcPropEditor.IfcGrouping ifcGrouping) {
        return this.call(0, () -> this.jniSetIfcParameters(ifcGrouping.ordinal()));
    }

    public Exporter detectExporter() {
        return this.call(Exporter.UNKNOWN, () -> {
            int n = this.jniDetectExporter();
            return Exporter.values()[n];
        });
    }

    public void initProperties(IPropertySet iPropertySet, boolean bl) {
        if (!bl) {
            return;
        }
        UnitsPnl.initProps(iPropertySet, this.d_openedFn, this);
        if (this.d_openedType == 1) {
            Exporter exporter = this.detectExporter();
            iPropertySet.set(ExporterPnl.DETECTED_EXPORTER, exporter);
            ExporterPnl.initExporter(iPropertySet, exporter);
        }
    }

    public List<Editor> createPropertyEditors(boolean bl, boolean bl2, IPropertySet iPropertySet, IUnitSrc iUnitSrc) {
        if (!bl2) {
            return Collections.emptyList();
        }
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        if (this.d_openedType == 1) {
            arrayList.add(new Editor(Intl.intl("FBX Exporter"), new ExporterPnl(iPropertySet), ExporterPnl.PROPS));
        }
        arrayList.add(new Editor(Intl.intl("Units"), new UnitsPnl(iUnitSrc, bl), UnitsPnl.PROPS));
        switch (this.d_openedType) {
            case 0: {
                arrayList.add(new Editor(Intl.intl("Import Settings"), new TeighaPropEditor(), TeighaPropEditor.PROPS));
                break;
            }
            case 1: {
                arrayList.add(new Editor(Intl.intl("Import Settings"), new FbxPropEditor(), FbxPropEditor.PROPS));
                break;
            }
            case 2: {
                arrayList.add(new Editor(Intl.intl("Import Settings"), new IfcPropEditor(), IfcPropEditor.PROPS));
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return arrayList;
    }

    public void setProperties(IPropertySet iPropertySet) {
        switch (this.d_openedType) {
            case 0: {
                this.setTriangulationParams(iPropertySet.get(TeighaTriangulationPnl.NORMAL_TOLERANCE).get(NonSI.DEGREE_ANGLE), iPropertySet.get(TeighaTriangulationPnl.BETWEEN_KNOTS));
                break;
            }
            case 2: {
                this.setIfcParameters(iPropertySet.get(IfcPropEditor.IFC_GROUPING));
            }
        }
    }

    private BiIntFunction<String> getProgressMsg() {
        switch (this.d_openedType) {
            case 2: {
                return (n, n2) -> {
                    if (n < 0 || n > n2) {
                        return Intl.intl("Importing objects");
                    }
                    return String.format(Intl.intl("Importing objects: %d%%"), (int)((double)n / (double)n2 * 100.0));
                };
            }
        }
        return (n, n2) -> {
            switch (n) {
                case -1: {
                    return Intl.intl("Importing objects");
                }
            }
            return String.format(Intl.intl("Importing object: %1$d / %2$d"), n, n2);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCad(TaskProgress taskProgress, IImportSession ... iImportSessionArray) throws IOException, CancellationException {
        taskProgress.setMessageGenerator(this.getProgressMsg());
        JniTaskProgress jniTaskProgress = new JniTaskProgress(taskProgress);
        try {
            this.runIO(() -> {
                ImportSessionSplitter importSessionSplitter = new ImportSessionSplitter(iImportSessionArray);
                try {
                    this.jniImportCad(importSessionSplitter, jniTaskProgress.getBuffer());
                }
                finally {
                    importSessionSplitter.endSession();
                }
                return null;
            });
        }
        finally {
            jniTaskProgress.finished();
        }
    }

    static {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                System.out.println("Creating new CAD import thread: " + thread);
                s_currThread = new WeakReference<Thread>(thread);
                return thread;
            }
        };
        s_executor = Executors.newSingleThreadExecutor(threadFactory);
        s_librariesLoaded = false;
    }

    private static class ImportSessionSplitter
    implements IImportSession {
        private IImportSession[] d_recipients;

        public ImportSessionSplitter(IImportSession[] iImportSessionArray) {
            this.d_recipients = iImportSessionArray;
            for (int i = 0; i < iImportSessionArray.length / 2; ++i) {
                int n = iImportSessionArray.length - 1 - i;
                IImportSession iImportSession = iImportSessionArray[i];
                iImportSessionArray[i] = iImportSessionArray[n];
                iImportSessionArray[n] = iImportSession;
            }
        }

        @Override
        public void beginMaterial(int n, String string, boolean bl) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.beginMaterial(n, string, bl);
            }
        }

        @Override
        public void endMaterial() {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.endMaterial();
            }
        }

        @Override
        public void setMatlChnlColor(int n, int n2, int n3, int n4) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.setMatlChnlColor(n, n2, n3, n4);
            }
        }

        @Override
        public void setMatlChnlMap(int n, double d, int n2, int n3, String string, String string2) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.setMatlChnlMap(n, d, n2, n3, string, string2);
            }
        }

        @Override
        public void setMatlChnlParams(int n, double ... dArray) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.setMatlChnlParams(n, dArray);
            }
        }

        @Override
        public void pushModelTransform(double[] dArray) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.pushModelTransform(dArray);
            }
        }

        @Override
        public void popModelTransform() {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.popModelTransform();
            }
        }

        @Override
        public long beginGeom() {
            long l = 0L;
            for (IImportSession iImportSession : this.d_recipients) {
                l = iImportSession.beginGeom();
            }
            return l;
        }

        @Override
        public void endGeom() {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.endGeom();
            }
        }

        @Override
        public long beginNode(String string, IImportSession.NodeProps nodeProps) {
            long l = 0L;
            for (IImportSession iImportSession : this.d_recipients) {
                l = iImportSession.beginNode(string, nodeProps);
            }
            return l;
        }

        @Override
        public void endNode() {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.endNode();
            }
        }

        @Override
        public void endSession() {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.endSession();
            }
        }

        @Override
        public void insertReference(long l) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.insertReference(l);
            }
        }

        @Override
        public void setCurrentColor(int n, int n2, int n3, int n4) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.setCurrentColor(n, n2, n3, n4);
            }
        }

        @Override
        public void setCurrentMatl(int n) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.setCurrentMatl(n);
            }
        }

        @Override
        public void polygonOut(double[] dArray, double[] dArray2, double[] dArray3) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.polygonOut(dArray, dArray2, dArray3);
            }
        }

        @Override
        public void polylineOut(double[] dArray) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.polylineOut(dArray);
            }
        }

        @Override
        public void shellProc(int n, double[] dArray, int[] nArray, double[] dArray2, String[] stringArray, int[] nArray2, int n2, double[] dArray3, int[] nArray3, int n3, boolean[] blArray, int[] nArray4, int[] nArray5) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.shellProc(n, dArray, nArray, dArray2, stringArray, nArray2, n2, dArray3, nArray3, n3, blArray, nArray4, nArray5);
            }
        }

        @Override
        public void meshProc(int n, int n2, int n3, double[] dArray, boolean[] blArray) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.meshProc(n, n2, n3, dArray, blArray);
            }
        }

        @Override
        public boolean circleProc(double[] dArray, double d, double[] dArray2, double[] dArray3) {
            boolean bl = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl = iImportSession.circleProc(dArray, d, dArray2, dArray3);
            }
            return bl;
        }

        @Override
        public boolean plineProc(double d, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, double d2, double[] dArray4, boolean bl, double[] dArray5, int n, int n2) {
            boolean bl2 = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl2 = iImportSession.plineProc(d, dArray, dArray2, dArray3, nArray, d2, dArray4, bl, dArray5, n, n2);
            }
            return bl2;
        }

        @Override
        public void metafileProc(double[] dArray, double[] dArray2, double[] dArray3) {
            for (IImportSession iImportSession : this.d_recipients) {
                iImportSession.metafileProc(dArray, dArray2, dArray3);
            }
        }

        @Override
        public boolean circularArcProc(double[] dArray, double d, double[] dArray2, double[] dArray3, double d2, int n, double[] dArray4) {
            boolean bl = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl = iImportSession.circularArcProc(dArray, d, dArray2, dArray3, d2, n, dArray4);
            }
            return bl;
        }

        @Override
        public boolean circularArcProc(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4) {
            boolean bl = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl = iImportSession.circularArcProc(dArray, dArray2, dArray3, n, dArray4);
            }
            return bl;
        }

        @Override
        public boolean ellipticalArcProc(double[] dArray, double[] dArray2, double d, double[] dArray3, double d2, double[] dArray4, double d3, double d4, double[] dArray5, int n, double[] dArray6) {
            boolean bl = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl = iImportSession.ellipticalArcProc(dArray, dArray2, d, dArray3, d2, dArray4, d3, d4, dArray5, n, dArray6);
            }
            return bl;
        }

        @Override
        public boolean textProc(double[] dArray, double[] dArray2, double[] dArray3, String string, boolean bl, int n, double[] dArray4) {
            boolean bl2 = false;
            for (IImportSession iImportSession : this.d_recipients) {
                bl2 = iImportSession.textProc(dArray, dArray2, dArray3, string, bl, n, dArray4);
            }
            return bl2;
        }
    }

    public static class Editor {
        public final String desc;
        public final IEditor<IPropertySet> editor;
        public final List<? extends IPropertySet.Prop<?>> props;

        public Editor(String string, IEditor<IPropertySet> iEditor, List<? extends IPropertySet.Prop<?>> list) {
            this.desc = string;
            this.editor = iEditor;
            this.props = list;
        }
    }

    public static enum Exporter {
        SIMLAB,
        UNKNOWN;

    }
}

