/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.Intl;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.CadSplitter;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CadImportUI {
    public static final IPropertySet.Prop<File> FILE = new IPropertySet.Prop<Object>("SepImportCAD.FILE", null);
    public static final IPropertySet.Prop<IUnitSrc> LENGTH_UNIT_SRC = new IPropertySet.Prop<Object>("SepImportCAD.LENGTH_UNIT_SRC", null);
    public static final IPropertySet.Prop<BiFunction<String, IMatAttrs, IMaterial>> MAT_FACTORY = new IPropertySet.Prop<BiFunction<String, IMatAttrs, IMaterial>>("SepImportCAD.MAT_FACTORY", (string, iMatAttrs) -> null);
    public static final IPropertySet.Prop<UnitDouble> DEF_Z_LOC = new IPropertySet.Prop<UnitDouble>("SepImportCAD.DEF_Z_LOC", new UnitDouble(0.0, SI.METER));
    public static final IPropertySet.Prop<Boolean> INCLUDE_ELEMENT_SUBTRACTIONS = new IPropertySet.Prop<Boolean>("SepImportCAD.INCLUDE_ELEMENT_SUBTRACTIONS", false);
    private static final IPropertySet.Prop<CADImportMgr> MGR = new IPropertySet.Prop<Object>("SepImportCAD.MGR", null);
    private static final IPropertySet.Prop<Boolean> IMPORT_LINES = new IPropertySet.Prop<Boolean>("IMPORT_LINES", false);
    private static final IPropertySet.Prop<Boolean> IMPORT_FACES = new IPropertySet.Prop<Boolean>("IMPORT_FACES", false);
    private static final IPropertySet.Prop<UnitDouble> Z_OFFSET = new IPropertySet.Prop<Object>("Z_OFFSET", null);
    private static final IPropertySet.Prop<Boolean> FLATTEN = new IPropertySet.Prop<Boolean>("FLATTEN", false);
    private static final IPropertySet.Prop<Color> BG_QUADS_COLOR = new IPropertySet.Prop<Object>("BG_QUADS_COLOR", null);
    private static final IPropertySet.Prop<Supplier<Stream<? extends IPropertySet.Prop<?>>>> IMPORTER_PROPS = new IPropertySet.Prop<Supplier<Stream>>("IMPORTER_PROPS", Collections.EMPTY_LIST::stream);

    public static String[] getFileFilters() {
        return CadImporter.getSupportedFileFormats();
    }

    public static AWizardCard<IPropertySet> getFirstWizardCard(IPropertySet iPropertySet) {
        iPropertySet.set(MGR, new CADImportMgr());
        return new OpenCard(iPropertySet);
    }

    public static WizardDlg<IPropertySet> createWizard(Window window, IPropertySet iPropertySet) {
        WizardDlg<IPropertySet> wizardDlg = new WizardDlg<IPropertySet>(window, Intl.intl("Import"), String.format(Intl.intl("Import %s"), iPropertySet.get(FILE).getName()), CadImportUI.getFirstWizardCard(iPropertySet));
        wizardDlg.init(iPropertySet);
        return wizardDlg;
    }

    public static void cleanup(IPropertySet iPropertySet) {
        CADImportMgr cADImportMgr = iPropertySet.get(MGR);
        if (cADImportMgr != null) {
            cADImportMgr.cleanup();
            iPropertySet.setIfNotDefault(MGR, null);
        }
    }

    private static void getBounds(IGeomImportSession.Node node, AABox aABox) {
        AABox aABox2 = GeomUtil.getBoundsTransformer(node.transform.getInfo(), aABox);
        node.dg.node.getBoundingBox(aABox2);
        for (IGeomImportSession.Node node2 : node.children) {
            CadImportUI.getBounds(node2, aABox2);
        }
    }

    public static Collection<IGeomImportSession.Node> finalizeResult(IPropertySet iPropertySet) {
        ArrayList<IGeomImportSession.Node> arrayList = ((Analysis)iPropertySet.get(CadImportUI.MGR).analyze.get()).importedNodes;
        Object object = Predicates.alwaysTrue();
        if (!iPropertySet.get(INCLUDE_ELEMENT_SUBTRACTIONS).booleanValue()) {
            object = Predicates.and(object, node -> !node.props.getBIMType().isDescendentOf(BIMType.FeatureElementSubtraction));
        }
        arrayList = CadImportUI.filter(arrayList, object);
        object = new ArrayList();
        CadSplitter cadSplitter = new CadSplitter();
        for (IGeomImportSession.Node node2 : arrayList) {
            object.add(CadImportUI.split(iPropertySet, cadSplitter, node2));
        }
        arrayList = object;
        if (iPropertySet.get(Z_OFFSET) != null) {
            Serializable serializable;
            object = new AABox();
            for (IGeomImportSession.Node node3 : arrayList) {
                CadImportUI.getBounds(node3, (AABox)object);
            }
            double d = iPropertySet.get(Z_OFFSET).getValue(iPropertySet.get(IGeomImportSession.DST_LENGTH_UNIT));
            Matrix4d matrix4d = new Matrix4d(GeomConstants.IDENTITY4d);
            double d2 = d - ((AABox)object).getMinZ();
            if (!theUtil.eq0(d2, 1.0E-6)) {
                matrix4d.mul(Util.translateMat(0.0, 0.0, d2));
            }
            System.out.println(((AABox)object).getMinZ());
            if (iPropertySet.get(FLATTEN).booleanValue() && !theUtil.eq0(((AABox)object).getHeight(), 1.0E-6)) {
                serializable = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0E-9, ((AABox)object).getMinZ(), 0.0, 0.0, 0.0, 1.0);
                matrix4d.mul((Matrix4d)serializable);
            }
            if (!matrix4d.equals(GeomConstants.IDENTITY4d)) {
                serializable = new MatrixXform(matrix4d);
                ArrayList<IGeomImportSession.Node> arrayList2 = new ArrayList<IGeomImportSession.Node>(arrayList.size());
                for (IGeomImportSession.Node node4 : arrayList) {
                    arrayList2.add(new IGeomImportSession.Node(node4.id, node4.name, serializable.concatenate(node4.transform), node4.props, node4.dg, node4.children));
                }
                arrayList = arrayList2;
            }
        }
        return arrayList;
    }

    public static DisplayGeom createBackgroundQuad(IPropertySet iPropertySet, Supplier<AABox> supplier) {
        if (iPropertySet.get(Z_OFFSET) != null && iPropertySet.get(BG_QUADS_COLOR) != null) {
            AABox aABox = supplier.get();
            double d = iPropertySet.get(Z_OFFSET).getValue(iPropertySet.get(IGeomImportSession.DST_LENGTH_UNIT));
            return CadImportUI.createBackgroundQuad(aABox, d, iPropertySet.get(BG_QUADS_COLOR));
        }
        return null;
    }

    public static DisplayGeom createBackgroundQuad(AABox aABox, double d, Color color) {
        AABox aABox2 = aABox.scale(1.05);
        Quad quad = new Quad(new Point3d(aABox2.getMinX(), aABox2.getMinY(), d), new Point3d(aABox2.getMaxX(), aABox2.getMinY(), d), new Point3d(aABox2.getMaxX(), aABox2.getMaxY(), d), new Point3d(aABox2.getMinX(), aABox2.getMaxY(), d));
        IPrimProps.Face face = new IPrimProps.Face(color, null, 0);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(quad), (IPrimProps)face);
    }

    public static Collection<IGeomImportSession.Node> filter(Collection<IGeomImportSession.Node> collection, Predicate<IGeomImportSession.Node> predicate) {
        if (Predicates.alwaysTrue(predicate)) {
            return collection;
        }
        ArrayList<IGeomImportSession.Node> arrayList = new ArrayList<IGeomImportSession.Node>();
        for (IGeomImportSession.Node node : collection) {
            IGeomImportSession.Node node2 = CadImportUI.filter(node, predicate);
            if (node2 == null) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private static IGeomImportSession.Node filter(IGeomImportSession.Node node, Predicate<IGeomImportSession.Node> predicate) {
        if (!predicate.test(node)) {
            return null;
        }
        ArrayList<IGeomImportSession.Node> arrayList = new ArrayList<IGeomImportSession.Node>();
        for (IGeomImportSession.Node node2 : node.children) {
            IGeomImportSession.Node node3 = CadImportUI.filter(node2, predicate);
            if (node3 == null) continue;
            arrayList.add(node3);
        }
        return new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, node.dg, arrayList);
    }

    private static IGeomImportSession.Node split(IPropertySet iPropertySet, CadSplitter cadSplitter, IGeomImportSession.Node node) {
        ArrayList<IGeomImportSession.Node> arrayList = new ArrayList<IGeomImportSession.Node>();
        if (node.dg != DisplayGeom.EMPTY) {
            IGeomImportSession.Node node2;
            Object object;
            boolean bl;
            Pair<DisplayGeom, DisplayGeom> pair = cadSplitter.splitDisplay(node.dg);
            boolean bl2 = iPropertySet.get(IMPORT_FACES) != false && pair.v1 != null;
            boolean bl3 = bl = iPropertySet.get(IMPORT_LINES) != false && pair.v2 != null;
            if (bl2) {
                object = pair.v2 != null ? String.format(Intl.intl("%s [Faces]"), node.name) : node.name;
                node2 = new IGeomImportSession.Node(node.id, (String)object, TransformUtil.IDENTITY, node.props, (DisplayGeom)pair.v1, Collections.emptyList());
                arrayList.add(node2);
            }
            if (bl) {
                object = pair.v1 != null ? String.format(Intl.intl("%s [Lines]"), node.name) : node.name;
                node2 = new IGeomImportSession.Node(node.id, (String)object, TransformUtil.IDENTITY, node.props, (DisplayGeom)pair.v2, Collections.emptyList());
                arrayList.add(node2);
            }
            if (node.children.isEmpty() && arrayList.size() == 1) {
                object = (IGeomImportSession.Node)arrayList.get(0);
                return new IGeomImportSession.Node(((IGeomImportSession.Node)object).id, ((IGeomImportSession.Node)object).name, node.transform.concatenate(((IGeomImportSession.Node)object).transform), ((IGeomImportSession.Node)object).props, ((IGeomImportSession.Node)object).dg, ((IGeomImportSession.Node)object).children);
            }
        }
        for (IGeomImportSession.Node node3 : node.children) {
            arrayList.add(CadImportUI.split(iPropertySet, cadSplitter, node3));
        }
        return new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, DisplayGeom.EMPTY, arrayList);
    }

    private static Timer startProgressTimer(TaskProgress taskProgress, ProgressPnl progressPnl, Runnable runnable) {
        Timer timer = new Timer(16, actionEvent -> {
            if (!taskProgress.isRunning()) {
                Timer timer = (Timer)actionEvent.getSource();
                timer.stop();
                runnable.run();
            } else {
                boolean bl;
                int[] nArray = taskProgress.getProgress();
                boolean bl2 = bl = nArray == null;
                if (bl != progressPnl.d_progBar.isIndeterminate()) {
                    progressPnl.d_progBar.setIndeterminate(bl);
                }
                if (!bl) {
                    progressPnl.d_progBar.setMaximum(nArray[1]);
                    progressPnl.d_progBar.setValue(nArray[0]);
                }
                progressPnl.d_msg.setText(taskProgress.getMessage());
            }
        });
        timer.start();
        return timer;
    }

    private static class ProgressPnl
    extends guiPanel {
        private final JProgressBar d_progBar = new JProgressBar(0, 100);
        private final guiLabel d_msg = new guiLabel("");

        public ProgressPnl() {
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_msg, 0);
            gridBagHelper.addFilledRow(this.d_progBar);
        }
    }

    private static class Callback<T>
    extends GeomImportSession.ACallback {
        private final WizardDlg<T> d_parent;
        private final IPropertySet d_options;
        private boolean d_cancelled = false;
        private boolean d_skipAllMissing = false;
        private File d_lastAddedDir = null;
        private Set<String> d_skippedPaths = new HashSet<String>();

        public Callback(WizardDlg<T> wizardDlg, IPropertySet iPropertySet) {
            super(iPropertySet.get(FILE).getParentFile(), new File(iPropertySet.get(FILE).getParentFile(), FilenameManager.splitFilename(iPropertySet.get(FILE).getName())[0]));
            this.d_parent = wizardDlg;
            this.d_options = iPropertySet;
            this.d_lastAddedDir = iPropertySet.get(FILE).getParentFile();
        }

        @Override
        public File resolvePath(String string) {
            while (!this.d_cancelled) {
                File file = super.resolvePath(string);
                if (file != null) {
                    return file;
                }
                if (this.d_skipAllMissing || this.d_skippedPaths.contains(string)) {
                    return null;
                }
                String string2 = Intl.intl("Choose another search location.");
                String string3 = Intl.intl("Skip this file.");
                String string4 = Intl.intl("Skip all missing files.");
                Object object = JOptionPane.showInputDialog(this.d_parent, "<html>" + String.format(Intl.intl("The following file was referenced in the import but could not be found:<br>%s<br>What would you like to do?"), string), Intl.intl("Missing File"), 2, null, new Object[]{string2, string3, string4}, string2);
                if (object == string2) {
                    guiFileChooser guiFileChooser2 = new guiFileChooser();
                    guiFileChooser2.setFileSelectionMode(1);
                    guiFileChooser2.setAcceptAllFileFilterUsed(false);
                    guiFileChooser2.setCurrentDirectory(this.d_lastAddedDir);
                    if (guiFileChooser2.showOpenDialog(this.d_parent) != 0) continue;
                    File file2 = guiFileChooser2.getSelectedFile();
                    this.addLibDir(file2);
                    this.d_lastAddedDir = file2.getParentFile();
                    continue;
                }
                if (object == string3) {
                    this.d_skippedPaths.add(string);
                    return null;
                }
                if (object == string4) {
                    this.d_skipAllMissing = true;
                    return null;
                }
                if (!this.d_parent.cancel()) continue;
                this.d_cancelled = true;
                return null;
            }
            return null;
        }

        @Override
        public IMaterial createMaterial(GeomImportSession.Material material, IMatAttrs iMatAttrs) {
            return this.d_options.get(MAT_FACTORY).apply(material.name, iMatAttrs);
        }
    }

    private static class AnalyzeCard
    extends AWizardCard<IPropertySet> {
        private static final String PROGRESS_CARD = "Progress";
        private static final String OPTIONS_CARD = "Options";
        private final CardLayout d_layout;
        private final ProgressPnl d_progPnl = new ProgressPnl();
        private final OptionsPnl d_optsPnl;
        private Timer d_progTimer;

        public AnalyzeCard(IPropertySet iPropertySet) {
            super("");
            this.d_optsPnl = new OptionsPnl(iPropertySet);
            this.d_layout = new CardLayout();
            this.setLayout(this.d_layout);
            this.add((Component)this.d_progPnl, PROGRESS_CARD);
            this.add((Component)this.d_optsPnl, OPTIONS_CARD);
        }

        @Override
        public boolean isActionEnabled(IPropertySet iPropertySet, int n) {
            CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet.get(MGR);
            switch (n) {
                case 0: {
                    return true;
                }
                case 4: {
                    return cADImportMgr.analyze != null && cADImportMgr.analyze.isFinished();
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet iPropertySet2) {
            CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet2.get(MGR);
            cADImportMgr.analyze(iPropertySet2, iPropertySet -> new Callback(this.getWizard(), (IPropertySet)iPropertySet));
            if (cADImportMgr.analyze.isRunning()) {
                this.setSubTitle(Intl.intl("Analyzing File"));
                this.d_layout.show(this, PROGRESS_CARD);
                this.d_progTimer = CadImportUI.startProgressTimer(cADImportMgr.analyze.progress, this.d_progPnl, () -> this.initFrom(iPropertySet2));
                return;
            }
            this.d_progTimer = null;
            try {
                cADImportMgr.analyze.validate();
            }
            catch (CancellationException cancellationException) {
                return;
            }
            catch (Throwable throwable) {
                String string = String.format(Intl.intl("Error reading %s."), iPropertySet2.get(FILE).getAbsolutePath());
                guiUtil.showError(this, Intl.intl("Import Error"), string, throwable);
                return;
            }
            this.setSubTitle(Intl.intl("Import Options"));
            Analysis analysis = (Analysis)cADImportMgr.analyze.get();
            Collection<IGeomImportSession.Node> collection = analysis.importedNodes;
            assert (collection != null);
            analysis.getConvertOptions(iPropertySet2);
            this.d_optsPnl.initFrom(analysis, iPropertySet2);
            this.d_layout.show(this, OPTIONS_CARD);
            this.setModified(true);
        }

        @Override
        public void saveTo(IPropertySet iPropertySet) {
            this.d_optsPnl.saveTo(iPropertySet);
        }

        @Override
        public AWizardCard getNext() {
            return null;
        }

        @Override
        public void cancel() {
            if (this.d_progTimer != null) {
                this.d_progTimer.stop();
                this.d_progTimer = null;
            }
        }

        private static class OptionsPnl
        extends guiPanel {
            private final guiLabel d_typeLbl;
            private final guiCheckBox d_linesCB;
            private final guiCheckBox d_facesCB;
            private final ComponentGroup d_geomTypeGroup;
            private final guiCheckBox d_offsetToZCB;
            private final ValueField<UnitDouble> d_offsetZ;
            private final guiCheckBox d_flattenCB;
            private final guiCheckBox d_makeBoxesCB;
            private final ColorButton d_makeBoxesColor;

            public OptionsPnl(IPropertySet iPropertySet) {
                this.d_typeLbl = new guiLabel(Analysis.Type.FLOORPLAN.name);
                this.d_typeLbl.setFont(this.d_typeLbl.getFont().deriveFont(1));
                guiLabel guiLabel2 = new guiLabel(Intl.intl("Geometry types to import:"));
                this.d_linesCB = new guiCheckBox(Intl.intl("Lines"));
                this.d_facesCB = new guiCheckBox(Intl.intl("Faces"));
                this.d_geomTypeGroup = new ComponentGroup(new Component[]{guiLabel2, this.d_linesCB, this.d_facesCB});
                this.d_offsetToZCB = new guiCheckBox(Intl.intl("Move geometry to Z = "));
                IUnitSrc iUnitSrc = iPropertySet.get(LENGTH_UNIT_SRC) != null ? iPropertySet.get(LENGTH_UNIT_SRC) : new ConstantUnitSrc(SI.MILLI(SI.METER));
                this.d_offsetZ = ValueFields.udFld(iUnitSrc);
                this.d_flattenCB = new guiCheckBox(Intl.intl("Flatten so geometry lies in one plane"));
                this.d_makeBoxesCB = new guiCheckBox(Intl.intl("Add a blank rectangle to obscure lower floors"));
                this.d_makeBoxesColor = new ColorButton();
                guiLabel guiLabel3 = new guiLabel(Intl.intl("Color:"));
                LinkStatus.link2((AbstractButton)this.d_offsetToZCB, this.d_offsetZ, this.d_flattenCB, this.d_makeBoxesCB, this.d_makeBoxesColor, guiLabel3);
                LinkStatus.link2((AbstractButton)this.d_makeBoxesCB, this.d_makeBoxesColor, guiLabel3);
                GridBagHelper gridBagHelper = new GridBagHelper(this, true);
                gridBagHelper.addRow(Intl.intl("Detected Geometry Type:"), this.d_typeLbl);
                gridBagHelper.addRow(guiLabel2, 0);
                gridBagHelper.addIdentRow(this.d_linesCB, 0);
                gridBagHelper.addIdentRow(this.d_facesCB, 0);
                gridBagHelper.addRow(this.d_offsetToZCB, this.d_offsetZ, 0);
                gridBagHelper.indent();
                gridBagHelper.addRow(this.d_flattenCB, 0);
                gridBagHelper.addRow(this.d_makeBoxesCB, 0);
                gridBagHelper.indent();
                guiPanel guiPanel2 = new guiPanel(new FlowLayout(0, gridBagHelper.d_colSpace, 0));
                guiPanel2.add(guiLabel3);
                guiPanel2.add(this.d_makeBoxesColor);
                gridBagHelper.addRow(guiPanel2, 0);
                gridBagHelper.unindent();
                gridBagHelper.unindent();
                gridBagHelper.finalizeRows();
            }

            public void initFrom(Analysis analysis, IPropertySet iPropertySet) {
                this.d_offsetZ.setValue(iPropertySet.get(DEF_Z_LOC));
                this.d_linesCB.setSelected((Boolean)iPropertySet.get(IMPORT_LINES));
                this.d_facesCB.setSelected((Boolean)iPropertySet.get(IMPORT_FACES));
                boolean bl = iPropertySet.get(Z_OFFSET) != null;
                this.d_offsetToZCB.setSelected(bl);
                if (iPropertySet.get(Z_OFFSET) != null) {
                    this.d_offsetZ.setValue(iPropertySet.get(Z_OFFSET));
                }
                this.d_flattenCB.setSelected(bl && (Boolean)iPropertySet.get(FLATTEN) != false);
                this.d_makeBoxesCB.setSelected(bl && iPropertySet.get(BG_QUADS_COLOR) != null);
                Color color = iPropertySet.get(BG_QUADS_COLOR) != null ? (Color)iPropertySet.get(BG_QUADS_COLOR) : Color.BLACK;
                this.d_makeBoxesColor.setColor(color);
                int[] nArray = new int[]{0, 0};
                for (IGeomImportSession.Node node : analysis.importedNodes) {
                    this.countPrims(node, nArray);
                }
                int n = nArray[0];
                int n2 = nArray[1];
                boolean bl2 = false;
                bl2 |= (Boolean)iPropertySet.get(IMPORT_LINES) == false && n2 != 0;
                this.d_geomTypeGroup.setVisible(bl2 |= (Boolean)iPropertySet.get(IMPORT_FACES) == false && n != 0);
                this.d_linesCB.setText(String.format(Intl.intl("Lines (%d detected)"), n2));
                this.d_facesCB.setText(String.format(Intl.intl("Faces (%d detected)"), n));
                this.d_typeLbl.setText(analysis.detectedType.name);
            }

            private void countPrims(IGeomImportSession.Node node, int[] nArray) {
                nArray[0] = nArray[0] + node.dg.node.getNumPrims(1);
                nArray[1] = nArray[1] + node.dg.node.getNumPrims(-2);
                for (IGeomImportSession.Node node2 : node.children) {
                    this.countPrims(node2, nArray);
                }
            }

            public void saveTo(IPropertySet iPropertySet) {
                boolean bl = this.d_offsetToZCB.isSelected();
                iPropertySet.set(Z_OFFSET, bl ? (UnitDouble)this.d_offsetZ.getValue() : null);
                if (bl) {
                    iPropertySet.set(FLATTEN, this.d_flattenCB.isSelected());
                    iPropertySet.set(BG_QUADS_COLOR, this.d_makeBoxesCB.isSelected() ? this.d_makeBoxesColor.getColor() : null);
                }
                iPropertySet.set(IMPORT_FACES, this.d_facesCB.isSelected());
                iPropertySet.set(IMPORT_LINES, this.d_linesCB.isSelected());
            }

            @Override
            public boolean validateData(boolean bl, boolean bl2) {
                if (!super.validateData(bl, bl2)) {
                    return false;
                }
                if (!this.d_linesCB.isSelected() && !this.d_facesCB.isSelected()) {
                    if (bl) {
                        String string = Intl.intl("At least lines or faces must be imported.");
                        guiDialog.showInvalidEntryMessage(this, string);
                    }
                    return false;
                }
                return true;
            }
        }
    }

    private static class OpenCard
    extends AWizardCard<IPropertySet> {
        private final CadImporter d_importer;
        private final ProgressPnl d_progPnl;
        private final IPropertySet d_options;
        private Timer d_progTimer;

        public OpenCard(IPropertySet iPropertySet) {
            super(Intl.intl("Import Settings"));
            this.setSubTitle(Intl.intl("Opening File"));
            this.d_options = iPropertySet;
            this.d_importer = ((CADImportMgr)iPropertySet.get(MGR)).importer;
            this.d_progPnl = new ProgressPnl();
            this.add(this.d_progPnl);
        }

        @Override
        public boolean isActionEnabled(IPropertySet iPropertySet, int n) {
            CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet.get(MGR);
            switch (n) {
                case 0: {
                    return true;
                }
                case 4: {
                    return false;
                }
                case 1: {
                    return cADImportMgr.open != null && !cADImportMgr.open.progress.isRunning();
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet iPropertySet) {
            CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet.get(MGR);
            cADImportMgr.open(iPropertySet);
            if (cADImportMgr.open.progress.isRunning()) {
                this.d_progTimer = CadImportUI.startProgressTimer(cADImportMgr.open.progress, this.d_progPnl, () -> this.initFrom(iPropertySet));
                return;
            }
            this.d_progTimer = null;
            try {
                cADImportMgr.open.validate();
            }
            catch (CancellationException cancellationException) {
                return;
            }
            catch (Throwable throwable) {
                guiUtil.showError(SwingUtilities.getWindowAncestor(this), Intl.intl("File Error"), String.format(Intl.intl("Error opening file: %s"), iPropertySet.get(FILE).getAbsolutePath()), throwable);
                return;
            }
            this.setModified(true);
            WizardDlg wizardDlg = this.getWizard();
            if (wizardDlg != null) {
                wizardDlg.skip();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return OpenCard.getMaxDimension(super.getPreferredSize(), new AnalyzeCard(this.d_options).getPreferredSize());
        }

        @Override
        public void cancel() {
            if (this.d_progTimer != null) {
                this.d_progTimer.stop();
                this.d_progTimer = null;
            }
        }

        private List<CadImporter.Editor> createEditors(IPropertySet iPropertySet) {
            return this.d_importer.createPropertyEditors(true, true, iPropertySet, iPropertySet.get(LENGTH_UNIT_SRC));
        }

        @Override
        public void saveTo(IPropertySet iPropertySet) {
            List<CadImporter.Editor> list = this.createEditors(iPropertySet);
            List list2 = list.stream().flatMap(editor -> editor.props.stream()).collect(Collectors.toList());
            Supplier<Stream> supplier = list2::stream;
            iPropertySet.set(IMPORTER_PROPS, supplier);
            PropertySet propertySet = (PropertySet)((CADImportMgr)iPropertySet.get(MGR)).open.get();
            iPropertySet.merge((IPropertySet)propertySet, supplier.get());
        }

        @Override
        public AWizardCard getNext() {
            List<CadImporter.Editor> list = this.createEditors(this.d_options);
            if (list.isEmpty()) {
                return new AnalyzeCard(this.d_options);
            }
            return new ImporterPropCard(this.d_options, list, 0);
        }
    }

    private static class ImporterPropCard
    extends AWizardCard<IPropertySet> {
        private final List<CadImporter.Editor> d_editors;
        private final int d_ix;
        private final IPropertySet d_options;

        public ImporterPropCard(IPropertySet iPropertySet, List<CadImporter.Editor> list, int n) {
            super(list.get((int)n).desc);
            this.d_options = iPropertySet;
            this.d_editors = list;
            this.d_ix = n;
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addFilledRow(list.get((int)n).editor.getEditorPanel());
            gridBagHelper.finalizeRows();
        }

        @Override
        public boolean isActionEnabled(IPropertySet iPropertySet, int n) {
            switch (n) {
                case 4: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void initFrom(IPropertySet iPropertySet) {
            this.d_editors.get((int)this.d_ix).editor.init(iPropertySet);
        }

        @Override
        public void saveTo(IPropertySet iPropertySet) {
            this.d_editors.get((int)this.d_ix).editor.commit(iPropertySet);
        }

        @Override
        public Dimension getPreferredSize() {
            return ImporterPropCard.getMaxDimension(super.getPreferredSize(), new AnalyzeCard(this.d_options).getPreferredSize());
        }

        @Override
        public AWizardCard getNext() {
            if (this.d_ix < this.d_editors.size() - 1) {
                return new ImporterPropCard(this.d_options, this.d_editors, this.d_ix + 1);
            }
            return new AnalyzeCard(this.d_options);
        }

        @Override
        public void cancel() {
        }
    }

    public static class CADImportMgr {
        public static final List<? extends IPropertySet.Prop<?>> ANALYZE_PROPS = Arrays.asList(CadImportUI.access$200(), CadImportUI.access$100(), CadImportUI.access$400(), CadImportUI.access$300(), CadImportUI.access$500());
        public CadImporter importer = new CadImporter();
        public OpenTask open = null;
        public AnalyzeTask analyze = null;

        public void cleanup() {
            if (this.open != null) {
                this.open.cancel();
                this.open = null;
            }
            if (this.analyze != null) {
                this.analyze.cancel();
                this.analyze = null;
            }
            if (this.importer != null) {
                this.importer.freeData();
                this.importer = null;
            }
        }

        public void open(IPropertySet iPropertySet) {
            if (this.open != null) {
                File file = iPropertySet.get(FILE);
                assert (file != null);
                if (this.open.filename.equalsIgnoreCase(file.getAbsolutePath())) {
                    return;
                }
                this.open.cancel();
                this.open = null;
            }
            assert (this.importer != null);
            this.open = new OpenTask(iPropertySet);
        }

        public void analyze(IPropertySet iPropertySet, Function<IPropertySet, GeomImportSession.ICallback> function) {
            if (this.analyze != null) {
                if (this.analyze.props.compare(iPropertySet, AnalyzeTask.getInputProps(iPropertySet))) {
                    return;
                }
                this.analyze.cancel();
                this.analyze = null;
            }
            assert (this.importer != null);
            this.analyze = new AnalyzeTask(iPropertySet, function);
        }
    }

    private static class ConvertOptions
    implements Cloneable {
        public boolean importLines;
        public boolean importFaces;
        public UnitDouble zOffset;
        public boolean flatten;
        public Color backgroundQuadsColor;

        private ConvertOptions() {
        }

        public ConvertOptions clone() {
            try {
                return (ConvertOptions)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private static class AnalyzeTask
    extends Task<Analysis> {
        private static final List<? extends IPropertySet.Prop<?>> INPUT_PROPS = IGeomImportSession.PROPS;
        public final PropertySet props = new PropertySet();

        public AnalyzeTask(IPropertySet iPropertySet, Function<IPropertySet, GeomImportSession.ICallback> function) {
            super(taskProgress -> {
                try {
                    CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet.get(MGR);
                    IGeomImportSession iGeomImportSession = cADImportMgr.importer.createCompatibleGeomTarget((GeomImportSession.ICallback)function.apply(iPropertySet), iPropertySet);
                    if (iGeomImportSession == null) {
                        throw new IOException(String.format(Intl.intl("Could not create importer for %s"), iPropertySet.get(FILE).getName()));
                    }
                    cADImportMgr.importer.setProperties(iPropertySet);
                    cADImportMgr.importer.importCad((TaskProgress)taskProgress, iGeomImportSession);
                    return new Analysis(iGeomImportSession.finalizeGeom());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            });
            this.props.merge(iPropertySet, AnalyzeTask.getInputProps(iPropertySet));
        }

        public static Stream<? extends IPropertySet.Prop<?>> getInputProps(IPropertySet iPropertySet) {
            return Stream.concat((Stream)((Supplier)iPropertySet.get(IMPORTER_PROPS)).get(), INPUT_PROPS.stream());
        }
    }

    private static class Analysis {
        public final Collection<IGeomImportSession.Node> importedNodes;
        public final Type detectedType;

        public Analysis(Collection<IGeomImportSession.Node> collection) {
            this.importedNodes = collection;
            this.detectedType = Analysis.detectType(collection);
        }

        private static Type detectType(Collection<IGeomImportSession.Node> collection) {
            for (IGeomImportSession.Node node : collection) {
                if (!Analysis.isModel(node)) continue;
                return Type.MODEL;
            }
            return Type.FLOORPLAN;
        }

        private static boolean isModel(IGeomImportSession.Node node) {
            if (Analysis.isModel(node.dg.node)) {
                return true;
            }
            for (IGeomImportSession.Node node2 : node.children) {
                if (!Analysis.isModel(node2)) continue;
                return true;
            }
            return false;
        }

        private static boolean isModel(IGeomNode iGeomNode) {
            AABox aABox = new AABox();
            for (IPrimitive object : GeomUtil.explode(iGeomNode.getLocalGeom(), IPrimitive.class)) {
                aABox.reset();
                object.getBoundingBox(aABox);
                if (!theUtil.gt0(aABox.getHeight(), 0.01)) continue;
                return true;
            }
            for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
                if (!Analysis.isModel(iGeomNode2)) continue;
                return true;
            }
            return false;
        }

        public void getConvertOptions(IPropertySet iPropertySet) {
            switch (this.detectedType) {
                case FLOORPLAN: {
                    iPropertySet.set(IMPORT_FACES, false);
                    iPropertySet.set(IMPORT_LINES, true);
                    iPropertySet.set(Z_OFFSET, iPropertySet.get(DEF_Z_LOC));
                    iPropertySet.set(FLATTEN, true);
                    if (iPropertySet.get(BG_QUADS_COLOR) != null) break;
                    iPropertySet.set(BG_QUADS_COLOR, Color.BLACK);
                    break;
                }
                case MODEL: {
                    iPropertySet.set(IMPORT_LINES, false);
                    iPropertySet.set(IMPORT_FACES, true);
                    iPropertySet.set(Z_OFFSET, null);
                    iPropertySet.set(FLATTEN, false);
                    iPropertySet.set(BG_QUADS_COLOR, null);
                }
            }
        }

        public static enum Type {
            FLOORPLAN(Intl.intl("2D Floorplan")),
            MODEL(Intl.intl("3D Model"));

            public final String name;

            private Type(String string2) {
                this.name = string2;
            }
        }
    }

    private static class OpenTask
    extends Task<PropertySet> {
        public final String filename;

        public OpenTask(IPropertySet iPropertySet) {
            super((TaskProgress taskProgress) -> {
                CADImportMgr cADImportMgr = (CADImportMgr)iPropertySet.get(MGR);
                try {
                    cADImportMgr.importer.openCad((TaskProgress)taskProgress, iPropertySet.get(FILE).getAbsolutePath());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                PropertySet propertySet = new PropertySet();
                cADImportMgr.importer.initProperties(propertySet, true);
                return propertySet;
            });
            this.filename = iPropertySet.get(FILE).getAbsolutePath();
        }
    }

    private static class Task<T> {
        public final TaskProgress progress = new TaskProgress();
        private Throwable d_caughtError;
        private T d_data;
        private boolean d_running = true;

        public Task(Function<TaskProgress, T> function) {
            Runnable runnable = () -> {
                try {
                    Object object = function.apply(this.progress);
                    Task task = this;
                    synchronized (task) {
                        this.d_data = object;
                    }
                }
                catch (RuntimeException runtimeException) {
                    Task task = this;
                    synchronized (task) {
                        this.d_caughtError = runtimeException.getCause();
                    }
                }
                finally {
                    Task task = this;
                    synchronized (task) {
                        this.progress.cancel();
                        this.d_running = false;
                        this.notifyAll();
                    }
                }
            };
            new Thread(runnable).start();
        }

        public synchronized T get() {
            return this.d_data;
        }

        public synchronized void cancel() {
            while (this.d_running) {
                this.progress.cancel();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isFinished() {
            return !this.progress.isRunning() && this.get() != null;
        }

        public boolean isRunning() {
            return this.progress.isRunning();
        }

        public synchronized void validate() throws ExecutionException, CancellationException {
            if (this.d_caughtError instanceof CancellationException) {
                throw new CancellationException();
            }
            if (this.d_caughtError != null) {
                throw new ExecutionException(this.d_caughtError);
            }
        }
    }
}

