/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.animate;

import thunderheadeng.animate.AnimSession;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.util.time.IClock;
import thunderheadeng.util.time.WallClock;

public class TimeAnimator
implements IAnimator {
    private final IAnimSession d_session;
    private final IClock d_clock;
    private final boolean d_loop;
    private double d_lastTime = Double.NaN;

    public TimeAnimator(IAnimSession iAnimSession, boolean bl) {
        this.d_session = iAnimSession;
        this.d_loop = bl;
        this.d_clock = new WallClock();
        this.updateClock(iAnimSession);
    }

    private void updateClock(IAnimSession iAnimSession) {
        double[] dArray = (double[])iAnimSession.get(AnimSession.TIME_RANGE);
        this.d_clock.setRange(dArray[0], dArray[1]);
        switch ((IAnimSession.State)((Object)iAnimSession.get(AnimSession.STATE))) {
            case PAUSED: {
                this.d_clock.pause();
                break;
            }
            case PLAYING: {
                this.d_clock.resume();
            }
        }
        this.d_clock.setScale((Double)iAnimSession.get(AnimSession.TIME_SCALE));
        double d = (Double)iAnimSession.get(AnimSession.TIME);
        if (d != this.d_lastTime) {
            this.d_clock.setTime(d);
        }
    }

    @Override
    public boolean update(IAnimSession iAnimSession) {
        this.updateClock(iAnimSession);
        double d = this.getTime();
        iAnimSession.set(AnimSession.TIME, d);
        this.d_lastTime = d;
        return !this.isClockRunning(iAnimSession);
    }

    private double getTime() {
        IClock iClock = this.d_clock;
        boolean bl = iClock.getScale() < 0.0;
        double d = iClock.getTime();
        double[] dArray = this.d_session.get(IAnimSession.TIME_RANGE);
        if (!bl && d >= dArray[1]) {
            if (this.d_loop) {
                double d2 = dArray[1] - dArray[0];
                double d3 = (d - dArray[0]) / d2;
                d3 -= Math.floor(d3);
                d = dArray[0] + d3 * d2;
            } else {
                d = dArray[1];
            }
            iClock.setTime(d);
        } else if (bl && d < dArray[0]) {
            if (this.d_loop) {
                double d4 = dArray[1] - dArray[0];
                double d5 = (dArray[1] - d) / d4;
                d5 -= Math.floor(d5);
                d = dArray[1] - d5 * d4;
            } else {
                d = dArray[0];
            }
            iClock.setTime(d);
        }
        return d;
    }

    private boolean isClockRunning(IAnimSession iAnimSession) {
        IClock iClock = this.d_clock;
        if (iClock.isPaused()) {
            return false;
        }
        if (this.d_loop) {
            return true;
        }
        double d = iAnimSession.get(IAnimSession.TIME);
        double[] dArray = this.d_session.get(IAnimSession.TIME_RANGE);
        boolean bl = iClock.getScale() < 0.0;
        return !bl && d < dArray[1] || bl && d > dArray[0];
    }
}

