/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.animate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.ISessionListener;
import thunderheadeng.gui.Mediator;
import thunderheadeng.scene3d.FPSTimer;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;

public class AnimSession
extends Mediator
implements IAnimSession {
    public static final Object WAKE_UP = new Object();
    private final List<IAnimator> d_animators;
    private final List<ISessionListener> d_listeners;
    private final PropertySet d_props;
    private final FPSTimer d_fps;
    private AtomicBoolean d_animating;
    private AtomicBoolean d_awake;

    public AnimSession() {
        this.setEvents(new Events());
        this.d_animators = new ArrayList<IAnimator>();
        this.d_listeners = new ArrayList<ISessionListener>();
        this.d_props = new PropertySet();
        this.d_animating = new AtomicBoolean(false);
        this.d_awake = new AtomicBoolean(false);
        this.d_fps = new FPSTimer();
    }

    @Override
    public <T> void set(RWProp<T> rWProp, T t) {
        if (!Objects.equals(t, this.d_props.get(rWProp))) {
            this.d_props.set(rWProp, t);
            this.getEvents().changed(this, rWProp);
        }
    }

    @Override
    public <T> T get(RProp<T> rProp) {
        return this.d_props.get(rProp);
    }

    @Override
    public void addAnimator(IAnimator iAnimator) {
        if (!this.d_animators.contains(iAnimator)) {
            this.d_animators.add(iAnimator);
        }
    }

    @Override
    public void removeAnimator(IAnimator iAnimator) {
        this.d_animators.remove(iAnimator);
    }

    public List<IAnimator> getAnimators() {
        return this.d_animators;
    }

    public void addListener(ISessionListener iSessionListener) {
        if (!this.d_listeners.contains(iSessionListener)) {
            this.d_listeners.add(iSessionListener);
        }
    }

    public void removeListener(ISessionListener iSessionListener) {
        this.d_listeners.remove(iSessionListener);
    }

    public List<ISessionListener> getListeners() {
        return this.d_listeners;
    }

    @Override
    public void wakeUp() {
        if (this.d_awake.get()) {
            return;
        }
        this.getEvents().changed(this, WAKE_UP);
    }

    @Override
    public double getFPS() {
        return this.d_fps.getFPS();
    }

    public boolean isAnimating() {
        return this.d_animating.get();
    }

    public boolean animate() {
        this.d_fps.start();
        this.d_animating.set(true);
        this.d_awake.set(true);
        this.getEvents().pause();
        boolean bl = true;
        for (IAnimator iAnimator : new ArrayList<IAnimator>(this.d_animators)) {
            bl &= iAnimator.update(this);
        }
        this.getEvents().resume();
        this.d_animating.set(false);
        this.d_awake.set(false);
        this.d_fps.stop();
        return bl;
    }

    public void setTimeRange(double d, double d2) {
        this.set(TIME_RANGE, new double[]{d, d2});
    }

    private class Events
    extends thunderheadeng.util.Events {
        private Events() {
        }

        @Override
        protected void fireAndClearEvents() {
            if (AnimSession.this.d_animating.get()) {
                super.fireAndClearEvents();
            } else if (!AnimSession.this.d_listeners.isEmpty() && AnimSession.this.d_awake.compareAndSet(false, true)) {
                for (ISessionListener iSessionListener : AnimSession.this.d_listeners) {
                    iSessionListener.eventPosted(AnimSession.this);
                }
            }
        }
    }
}

