/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.objs.GeneralPoly;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.io.LegacyDictionary;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashSet;
import thunderheadeng.legacy.v1.util.ListSet;
import thunderheadeng.legacy.v1.util.theHashMap;
import thunderheadeng.legacy.v1.util.theHashSet;
import thunderheadeng.legacy.v1.util.theLinkedHashMap;
import thunderheadeng.legacy.v1.util.theLinkedHashSet;
import thunderheadeng.legacy.v10.scene3d.geom.DefMaterial;
import thunderheadeng.legacy.v11.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.legacy.v12.util.AcceptAllFilter;
import thunderheadeng.legacy.v12.util.AcceptNoneFilter;
import thunderheadeng.legacy.v12.util.Filters;
import thunderheadeng.legacy.v13.geometry.objs.AProxyGeom;
import thunderheadeng.legacy.v13.geometry.objs.GeomGroup;
import thunderheadeng.legacy.v13.geometry.objs.ShapeGeom;
import thunderheadeng.legacy.v13.geometry.objs.SolidGeom;
import thunderheadeng.legacy.v13.geometry.objs.TransformedGeom;
import thunderheadeng.legacy.v13.scene3d.geom.IUVPrim;
import thunderheadeng.legacy.v13.scene3d.geom.UVEmpty;
import thunderheadeng.legacy.v13.scene3d.geom.UVFlattened;
import thunderheadeng.legacy.v13.scene3d.geom.UVGroup;
import thunderheadeng.legacy.v13.scene3d.geom.UVMesh;
import thunderheadeng.legacy.v13.scene3d.geom.UVPoly;
import thunderheadeng.legacy.v13.scene3d.geom.UVUniform;
import thunderheadeng.legacy.v16.cad.BIMType;
import thunderheadeng.legacy.v4.geometry.objs.Mesh;
import thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import thunderheadeng.legacy.v7.scene3d.geom.IPrimProps;
import thunderheadeng.legacy.v8.io.StreamSources;
import thunderheadeng.legacy.v9.image.Image;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class TeciIO {
    public static final int VERSION_001 = 1;
    public static final int VERSION_002 = 2;
    public static final int VERSION_003 = 3;
    public static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int VERSION_008 = 8;
    public static final int VERSION_009 = 9;
    public static final int VERSION_010 = 10;
    public static final int VERSION_011 = 11;
    public static final int VERSION_012 = 12;
    public static final int VERSION_013 = 13;
    public static final int VERSION_014 = 14;
    public static final int VERSION_015 = 15;
    public static final int VERSION_016 = 16;
    public static final int VERSION_017 = 17;
    public static final int CURR_VERSION = 17;
    private final int d_version;
    private final LegacyDictionary d_legDictionary;
    private final List<MatAttrs> d_pre16MatAttrs = new ArrayList<MatAttrs>();

    public TeciIO(int n) {
        this.d_version = n;
        this.d_legDictionary = new LegacyDictionary(n);
        this.map(2, "thunderheadeng.util.LinkedIdentityHashMap", LinkedIdentityHashMap.class);
        this.map(2, "thunderheadeng.util.LinkedIdentityHashSet", LinkedIdentityHashSet.class);
        this.map(2, "thunderheadeng.util.ListSet", ListSet.class);
        this.map(2, "thunderheadeng.util.theHashMap", theHashMap.class);
        this.map(2, "thunderheadeng.util.theHashSet", theHashSet.class);
        this.map(2, "thunderheadeng.util.theLinkedHashMap", theLinkedHashMap.class);
        this.map(2, "thunderheadeng.util.theLinkedHashSet", theLinkedHashSet.class);
        this.map(3, "thunderheadeng.scene3d.nativebuffered.Image", Image.class);
        this.map(5, "thunderheadeng.geometry.objs.Mesh", Mesh.class);
        this.map(6, "thunderheadeng.geometry.objs.WallGeom", WallGeom.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$AProps", IPrimProps.AProps.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$GenericProps", IPrimProps.GenericProps.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Face", IPrimProps.Face.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Edge", IPrimProps.Edge.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Vertex", IPrimProps.Vertex.class);
        this.map(9, "thunderheadeng.io.StreamSources$FileSrc", StreamSources.FileSrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$ByteArraySrc", StreamSources.ByteArraySrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$ByteBufferSrc", StreamSources.ByteBufferSrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$DecryptSrc", StreamSources.DecryptSrc.class);
        this.map(10, "thunderheadeng.image.Image", Image.class);
        this.map(11, "thunderheadeng.scene3d.geom.DefMaterial", DefMaterial.class);
        this.map(12, "thunderheadeng.scene3d.nativebuffered.CameraRecord", CameraRecord.class);
        this.map(13, "thunderheadeng.util.Filters$Logic", Filters.Logic.class);
        this.map(13, "thunderheadeng.util.Filters$InvertFilter", Filters.InvertFilter.class);
        this.map(13, "thunderheadeng.util.Filters$CompoundFilter", Filters.CompoundFilter.class);
        this.map(13, "thunderheadeng.util.Filters$MultiCompoundFilter", Filters.MultiCompoundFilter.class);
        this.map(13, "thunderheadeng.util.Filters$CachedFilter", Filters.CachedFilter.class);
        this.map(13, "thunderheadeng.util.AcceptAllFilter", AcceptAllFilter.class);
        this.map(13, "thunderheadeng.util.AcceptNoneFilter", AcceptNoneFilter.class);
        this.map(14, "thunderheadeng.scene3d.geom.IUVPrim", IUVPrim.class);
        this.map(14, "thunderheadeng.scene3d.geom.MatAttrs", thunderheadeng.legacy.v13.scene3d.geom.MatAttrs.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVEmpty", UVEmpty.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVEmpty$1", UVEmpty.UV_OBJ.getClass());
        this.map(14, "thunderheadeng.scene3d.geom.UVFlattened", UVFlattened.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVGroup", UVGroup.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVGroup$Entry", UVGroup.Entry.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVMesh", UVMesh.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVMesh$Prim", UVMesh.Prim.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVPoly", UVPoly.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVUniform", UVUniform.class);
        this.map(14, "thunderheadeng.geometry.objs.AProxyGeom", AProxyGeom.class);
        this.map(14, "thunderheadeng.geometry.objs.GeomGroup", GeomGroup.class);
        this.map(14, "thunderheadeng.geometry.objs.SolidGeom", SolidGeom.class);
        this.map(14, "thunderheadeng.geometry.objs.TransformedGeom", TransformedGeom.class);
        this.map(15, "thunderheadeng.geometry.objs.WallGeom", thunderheadeng.legacy.v14.geometry.objs.WallGeom.class);
        this.map(17, "thunderheadeng.cad.BIMType", BIMType.class);
    }

    private void map(int n, String string, Class clazz) {
        this.d_legDictionary.addLegClass(n, string, clazz);
    }

    public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.equals("thunderheadeng.geometry.objs.ShapeGeom$ShapePrimitive") && objectStreamClass.getSerialVersionUID() == 1106115886445448015L) {
            return ShapeGeom.ShapePrimitive.class;
        }
        if (string.equals("thunderheadeng.geometry.objs.ShapeGeom$ShapeCurve") && objectStreamClass.getSerialVersionUID() == 5421416398197187057L) {
            return ShapeGeom.ShapeCurve.class;
        }
        TriConsumer<String, Long, Long> triConsumer = (string2, l, l2) -> {
            if (string.equals(string2) && objectStreamClass.getSerialVersionUID() == l.longValue()) {
                try {
                    theUtil.assignFinalField(objectStreamClass, ObjectStreamClass.class, "suid", l2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
        triConsumer.accept("thunderheadeng.geometry.objs.ClosedLinearCurve", 8783959934722819851L, 4032153402700153011L);
        return this.d_legDictionary.resolveClass(string);
    }

    public Object resolveObject(Object object) throws IOException {
        if (this.d_version < 4 && object instanceof NGon) {
            return TeciIO.resolvePre4NGon((NGon)object);
        }
        if (this.d_version < 7 && object instanceof Quad) {
            Quad quad = (Quad)object;
            return PolyUtil.newPoly(quad.p1, quad.p2, quad.p3, quad.p4);
        }
        if (this.d_version < 16 && object instanceof MatAttrs) {
            return TeciIO.resolvePre16MatAttrs((MatAttrs)object);
        }
        if (this.d_version < 17 && object instanceof BIMType) {
            return ((BIMType)((Object)object)).convert();
        }
        return object;
    }

    private static IPolygon resolvePre4NGon(NGon nGon) {
        Point3d[] point3dArray = nGon.points;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < point3dArray.length) {
            Point3d point3d;
            Point3d point3d2 = point3dArray[n];
            arrayList.add(n++);
            while (n < point3dArray.length && !point3d2.equals(point3d = point3dArray[n++])) {
            }
        }
        if (arrayList.size() <= 1) {
            return nGon;
        }
        return new GeneralPoly(point3dArray, theUtil.toIntArray(arrayList));
    }

    public static MatAttrs resolvePre16MatAttrs(MatAttrs matAttrs) {
        Color color = matAttrs.get(IMatAttrs.DIFFUSE_COLOR);
        if (color.getAlpha() < 255) {
            int n = color.getAlpha();
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            Color color3 = new Color(n, n, n);
            matAttrs = matAttrs.apply(IMatAttrs.DIFFUSE_COLOR, color2, IMatAttrs.OPACITY_COLOR, color3);
        }
        return matAttrs;
    }
}

