/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.util;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.NamedSorter;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.image.Image;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class Util {
    public static <T> boolean keepIf(Collection<T> collection, Predicate<? super T> predicate) {
        if (predicate == Predicates.alwaysTrue()) {
            return false;
        }
        if (predicate == Predicates.alwaysFalse()) {
            boolean bl = collection.isEmpty();
            collection.clear();
            return !bl;
        }
        boolean bl = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (predicate.test(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static <T> boolean keepIfNullOr(Collection<T> collection, Class<?> clazz) {
        return Util.keepIfNullOr(collection, (? super T object) -> clazz.isInstance(object));
    }

    public static <T> boolean keepIfNullOr(Collection<T> collection, Predicate<? super T> predicate) {
        return Util.keepIf(collection, object -> object == null || predicate.test(object));
    }

    public static boolean keepOnlyNull(Collection<?> collection) {
        return Util.keepIf(collection, object -> object == null);
    }

    public static BGImageXform createDxfImageTransform(Image image, Rectangle2D rectangle2D, Unit unit, UnitDouble unitDouble) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        if (n == 0) {
            n = (int)rectangle2D.getWidth();
        }
        if (n2 == 0) {
            n2 = (int)rectangle2D.getHeight();
        }
        Point2d point2d = new Point2d(-rectangle2D.getMinX() / rectangle2D.getWidth() * (double)n, -rectangle2D.getMinY() / rectangle2D.getHeight() * (double)n2);
        return new BGImageXform(point2d, new Point3d(0.0, 0.0, unitDouble.getValue(SI.METER)), new Point2d(0.0, 0.0), new Point2d(n, 0.0), UnitDouble.convert(rectangle2D.getWidth(), unit, SI.METER), 0.0);
    }

    public static void assignFinalField(Object object, String string, Object object2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = object.getClass().getField(string);
        field.setAccessible(true);
        field.set(object, object2);
        field.setAccessible(false);
    }

    public static <T extends IPyroObject> Collection<? extends T> getAllObjects(PyroMod pyroMod, Class<T> clazz, Predicate<T> predicate, boolean bl) {
        Composite composite = Util.getCategoryRoot(pyroMod, clazz);
        if (composite == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<T> collection = composite.flatten(clazz, predicate);
        return collection;
    }

    public static Composite getCategoryRoot(PyroMod pyroMod, Class<? extends IPyroObject> clazz) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(clazz)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public static String getCatName(IPyroObject iPyroObject) {
        return TVEntryPoints.ep(iPyroObject).getCategoryName();
    }

    public static String getName(IPyroObject iPyroObject) {
        TVEntryPoint<IPyroObject> tVEntryPoint = TVEntryPoints.ep(iPyroObject);
        return tVEntryPoint.getName(iPyroObject);
    }

    public static boolean canDelete(PyroMod pyroMod, Object object) {
        IPyroObject iPyroObject;
        if (object instanceof IPyroObject && (iPyroObject = ((IPyroObject)object).getParent()) != null) {
            return TVEntryPoints.ep(iPyroObject).canDelete(pyroMod, iPyroObject, object);
        }
        return false;
    }

    public static String validateName(PyroMod pyroMod, INamed iNamed, String string) throws Exception {
        if ((string = string.trim()).isEmpty()) {
            throw new Exception(Intl.intl("Empty names are not allowed."));
        }
        if (iNamed.getName().equals(string)) {
            return string;
        }
        TVEntryPoint<INamed> tVEntryPoint = TVEntryPoints.ep(iNamed);
        Object object = tVEntryPoint.getCategoryRoot(pyroMod, iNamed);
        if (object instanceof Composite && Util.isKeyedByName(pyroMod, object, iNamed) && pyroMod.getNames(iNamed).isRegistered(string)) {
            String string2 = String.format(Intl.intl("The name, \"%s,\" is already in use."), string);
            throw new Exception(string2);
        }
        return string;
    }

    public static boolean isKeyedByName(PyroMod pyroMod, Object object) {
        return !pyroMod.getNames(object).getAllowsDuplicates();
    }

    public static boolean isKeyedByName(PyroMod pyroMod, Object object, Object object2) {
        return !pyroMod.getNames(object2).getAllowsDuplicates();
    }

    public static Set<String> getNames(Collection<?> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (INamed iNamed : theUtil.filter(collection, INamed.class)) {
            hashSet.add(iNamed.getName());
        }
        return hashSet;
    }

    public static <T extends IPyroObject> List<T> sort(Composite<? extends T> composite) {
        return Util.sort(composite.flatten());
    }

    public static <T extends IPyroObject> List<T> sort(Collection<? extends T> collection) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList, new NamedSorter());
        return arrayList;
    }

    public static <T> List<T> sort(Collection<? extends T> collection, Comparator<T> comparator) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static <T> int indexOf(Collection<? extends T> collection, T t) {
        int n = 0;
        for (T t2 : collection) {
            if (t2 == t) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean identityMapsEqual(Map<?, ?> map, Map<?, ?> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object var4_4 = null;
            Object var5_5 = null;
            for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
                if (!entry.getKey().equals(entry2.getKey())) continue;
                var4_4 = entry2.getKey();
                var5_5 = entry2.getValue();
                break;
            }
            if (var4_4 == null) {
                return false;
            }
            if (theUtil.equal(entry.getValue(), var5_5)) continue;
            return false;
        }
        return true;
    }

    public static boolean identitySetsEqual(Set<?> set, Set<?> set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        for (Object obj : set) {
            boolean bl = false;
            for (Object obj2 : set2) {
                if (!theUtil.equal(obj, obj2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean isExclusive(Collection<?> collection, Class<?> ... classArray) {
        if (classArray.length == 1) {
            return theUtil.filter(collection, classArray[0]).isExclusive();
        }
        return theUtil.filter(collection, new TypeFilter(classArray)).isExclusive();
    }

    public static boolean containsAny(Collection<?> collection, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> boolean isObjMapEqual(Map<? extends K, ? extends V> map, Map<? extends K, ? extends V> map2) {
        if (map == null && map2 == null) {
            return true;
        }
        if (map == null || map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        BitSet bitSet = new BitSet(map2.size());
        for (K k : map.keySet()) {
            boolean bl = false;
            int n = 0;
            for (K k2 : map2.keySet()) {
                if (bitSet.get(n)) {
                    ++n;
                    continue;
                }
                if (!k.equals(k2)) continue;
                if (theUtil.equal(map.get(k), map2.get(k2))) {
                    bl = true;
                    bitSet.set(n);
                    ++n;
                    break;
                }
                return false;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

