/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.unitsystem;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.jscience.physics.units.Unit;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;

public class UnitSystemTest
extends TestCase {
    public void testSIComplete() {
        this.testUnitSystemComplete(SIUS.getInstance());
    }

    public void testEnglishComplete() {
        this.testUnitSystemComplete(EnglishUS.getInstance());
    }

    private void testUnitSystemComplete(UnitSystem unitSystem) {
        try {
            for (Field field : UnitSystem.class.getFields()) {
                Integer n = (Integer)field.get(null);
                if (n == null) continue;
                Unit unit = unitSystem.getUnit(n);
                UnitSystemTest.assertNotNull((String)("Each UnitSystem must contain a unit for " + n + "."), (Object)unit);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            UnitSystemTest.fail();
        }
    }

    public void testCompatibility() {
        EnglishUS englishUS = EnglishUS.getInstance();
        SIUS sIUS = SIUS.getInstance();
        try {
            for (Field field : UnitSystem.class.getFields()) {
                Integer n = (Integer)field.get(null);
                if (n == null) continue;
                Unit unit = englishUS.getUnit(n);
                Unit unit2 = sIUS.getUnit(n);
                UnitSystemTest.assertTrue((String)String.format("Unit Error (%s): %s is not compatible with %s.", field.getName(), unit, unit2), (boolean)unit.isCompatible(unit2));
                double d = 3.0;
                double d2 = unit2.getConverterTo(unit).convert(d);
                double d3 = unit.getConverterTo(unit.getSystemUnit()).convert(d2);
                double d4 = unit2.getConverterTo(unit2.getSystemUnit()).convert(d);
                UnitSystemTest.assertTrue((Math.abs(d3 - d4) < 1.0E-9 ? 1 : 0) != 0);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            UnitSystemTest.fail();
        }
    }

    public void testCompareTo() {
        EnglishUS englishUS = EnglishUS.getInstance();
        SIUS sIUS = SIUS.getInstance();
        try {
            for (Field field : UnitSystem.class.getFields()) {
                Unit unit;
                Integer n = (Integer)field.get(null);
                if (n == null) continue;
                Unit unit2 = englishUS.getUnit(n);
                Unit unit3 = sIUS.getUnit(n);
                Unit unit4 = unit2.getSystemUnit();
                if (unit4.equals(unit = unit3.getSystemUnit())) continue;
                System.out.println(String.format("%d: %s incompatible with %s", n, unit4.toString(), unit.toString()));
                UnitDouble unitDouble = EnglishUS.newud(0.9, n);
                UnitDouble unitDouble2 = SIUS.newud(0.5, n);
                UnitDouble unitDouble3 = unitDouble.convert(unit4);
                UnitDouble unitDouble4 = unitDouble.convert(unit);
                UnitDouble unitDouble5 = unitDouble2.convert(unit4);
                UnitDouble unitDouble6 = unitDouble2.convert(unit);
                if (Double.compare(unitDouble3.getValueNoUnit(), unitDouble4.getValueNoUnit()) != 0) {
                    System.out.println(String.format("---English Units cannot be consistently converted.---", new Object[0]));
                }
                if (Double.compare(unitDouble5.getValueNoUnit(), unitDouble6.getValueNoUnit()) != 0) {
                    System.out.println(String.format("---SI Units cannot be consistently converted.---", new Object[0]));
                }
                unitDouble.compareTo(unitDouble2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            UnitSystemTest.fail();
        }
    }
}

