/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.unitsystem;

import java.util.HashMap;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;

public class SIUS
extends UnitSystem {
    private static final Map<Integer, Unit> s_unitMap = new HashMap<Integer, Unit>();
    private static final SIUS s_fdsSystem;

    public SIUS() {
        super(Intl.intl("SI"));
    }

    public static SIUS getInstance() {
        return s_fdsSystem;
    }

    @Override
    public Unit getUnit(int n) {
        return s_unitMap.get(n);
    }

    public static Unit unit(int n) {
        return s_unitMap.get(n);
    }

    public static UnitDouble newud(double d, int n) {
        return new UnitDouble(d, SIUS.unit(n));
    }

    static {
        s_unitMap.put(0, SI.METER);
        s_unitMap.put(1, SI.CELSIUS);
        s_unitMap.put(2, SI.SECOND);
        s_unitMap.put(7, SI.PASCAL);
        s_unitMap.put(12, NonSI.BAR);
        s_unitMap.put(29, NonSI.DEGREE_ANGLE);
        s_unitMap.put(3, SI.METER.multiply(SI.SECOND).root(2).label("<html>&#8730(m&#183s)</html>"));
        s_unitMap.put(4, SI.KILOGRAM.divide(SI.METER.pow(3)));
        s_unitMap.put(5, SI.KELVIN.divide(SI.METER));
        s_unitMap.put(6, SI.METER.divide(SI.SECOND.pow(2)));
        s_unitMap.put(8, SI.METER.divide(SI.SECOND));
        s_unitMap.put(9, SI.MILLI(SI.METER));
        s_unitMap.put(10, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        s_unitMap.put(11, SI.KILO(SI.JOULE).divide(SI.KILOGRAM).divide(SI.KELVIN));
        s_unitMap.put(13, SI.METER.pow(-1));
        s_unitMap.put(15, SI.KILO(SI.JOULE).divide(SI.KILO(SI.MOLE)));
        s_unitMap.put(16, SI.METER);
        s_unitMap.put(17, SI.GRAM.divide(SI.MOLE));
        s_unitMap.put(18, Unit.ONE.alternate("kg/kg"));
        s_unitMap.put(27, SI.METER.pow(2).divide(SI.SECOND));
        s_unitMap.put(19, SI.WATT.divide(SI.METER).divide(SI.KELVIN));
        s_unitMap.put(81, SI.WATT.divide(SI.METER.pow(2)).divide(SI.KELVIN));
        s_unitMap.put(20, SI.KILOGRAM.divide(SI.METER.pow(2)).divide(SI.SECOND));
        s_unitMap.put(21, SI.METER.pow(2).divide(SI.KILOGRAM.divide(SI.SECOND)));
        s_unitMap.put(88, SI.KILO(SI.WATT).divide(SI.METER));
        s_unitMap.put(22, SI.KILO(SI.WATT).divide(SI.METER.pow(2)));
        s_unitMap.put(25, SI.KILO(SI.WATT).divide(SI.METER.pow(3)));
        s_unitMap.put(23, SI.KILOGRAM.divide(SI.METER.pow(2)));
        s_unitMap.put(24, SI.METER.pow(3).divide(SI.SECOND));
        s_unitMap.put(26, Unit.ONE.alternate("kg/kg"));
        s_unitMap.put(28, Unit.ONE);
        s_unitMap.put(31, NonSI.PERCENT.divide(SI.METER));
        s_unitMap.put(34, Unit.ONE.divide(SI.METER).label("1/m"));
        s_unitMap.put(30, NonSI.LITER.divide(NonSI.MINUTE));
        s_unitMap.put(32, Unit.ONE.alternate("mol/mol"));
        s_unitMap.put(33, SI.KILO(SI.WATT).divide(SI.METER.pow(2)));
        s_unitMap.put(35, SI.SECOND.pow(-1));
        s_unitMap.put(36, SI.METER.divide(SI.SECOND).pow(2));
        s_unitMap.put(37, SI.KILO(SI.WATT));
        s_unitMap.put(38, SI.KILOGRAM.divide(SI.SECOND));
        s_unitMap.put(39, SI.PASCAL);
        s_unitMap.put(40, SI.MILLI(SI.GRAM).divide(SI.METER.pow(3)));
        s_unitMap.put(41, SI.KILOGRAM.divide(SI.METER).divide(SI.SECOND));
        s_unitMap.put(42, NonSI.ANGSTROM);
        s_unitMap.put(43, SI.KELVIN);
        s_unitMap.put(44, SI.KILOGRAM.divide(SI.METER.pow(2)).divide(SI.SECOND));
        s_unitMap.put(45, SI.KILOGRAM.divide(SI.METER.pow(2)).divide(SI.SECOND));
        s_unitMap.put(46, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        s_unitMap.put(47, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        s_unitMap.put(48, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        s_unitMap.put(50, SI.SECOND.pow(-1).label("1/s"));
        s_unitMap.put(51, SI.METER.pow(-1).label("1/m"));
        s_unitMap.put(52, SI.METER.pow(2).divide(SI.KILOGRAM));
        s_unitMap.put(53, Unit.ONE.divide(SI.SECOND));
        s_unitMap.put(54, SI.KILO(SI.JOULE).divide(SI.KILO(SI.MOLE)));
        s_unitMap.put(55, Unit.ONE.alternate(Intl.intl("Droplets")).divide(SI.METER.pow(3)));
        s_unitMap.put(56, SI.METER.pow(3));
        s_unitMap.put(57, NonSI.PERCENT);
        s_unitMap.put(58, NonSI.LITER.divide(NonSI.MINUTE).divide(NonSI.ATMOSPHERE.root(2)));
        s_unitMap.put(59, NonSI.ATMOSPHERE);
        s_unitMap.put(60, SI.METER.divide(SI.SECOND).root(2).label("<html>&#8730(m/s)</html>"));
        s_unitMap.put(61, SI.MICRO(SI.METER));
        s_unitMap.put(62, SI.KILO(SI.JOULE).divide(SI.METER.pow(3)));
        s_unitMap.put(63, Unit.ONE.divide(SI.METER));
        s_unitMap.put(64, NonSI.PERCENT);
        s_unitMap.put(65, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        s_unitMap.put(66, SI.KILOGRAM.multiply(SI.METER.pow(2)));
        s_unitMap.put(67, SI.NEWTON);
        s_unitMap.put(68, SI.CENTI(SI.METER).pow(2));
        s_unitMap.put(69, SI.NEWTON.divide(SI.METER.divide(SI.SECOND)));
        s_unitMap.put(70, Unit.ONE.alternate("rps"));
        s_unitMap.put(71, Unit.ONE.alternate("pers").divide(SI.METER.pow(2)));
        s_unitMap.put(72, Unit.ONE.alternate("pers").divide(SI.SECOND));
        s_unitMap.put(73, Unit.ONE.divide(SI.SECOND).alternate("<html>m<sup>2</sup>/(sm<sup>2</sup>)</html>"));
        s_unitMap.put(74, SI.KELVIN.divide(NonSI.MINUTE));
        s_unitMap.put(75, SI.KILOGRAM.divide(SI.METER));
        s_unitMap.put(76, SI.KILOGRAM.divide(SI.SECOND));
        s_unitMap.put(77, SI.KILOGRAM);
        s_unitMap.put(78, SI.KILO(SI.JOULE).divide(SI.SECOND));
        s_unitMap.put(79, SI.METER.pow(2));
        s_unitMap.put(80, NonSI.PERCENT);
        s_unitMap.put(82, Unit.ONE.alternate("ppm"));
        s_unitMap.put(83, SI.KILOGRAM.divide(SI.METER.pow(2)));
        s_unitMap.put(84, NonSI.PERCENT);
        s_unitMap.put(85, Unit.ONE);
        s_unitMap.put(86, SI.KILO(SI.JOULE).divide(SI.MOLE));
        s_unitMap.put(87, Unit.ONE.alias("<html>m<sup>3</sup>/m<sup>3</sup></html>"));
        s_unitMap.put(89, SI.WATT.divide(SI.GRAM));
        s_unitMap.put(90, SI.MICRO(SI.METER));
        s_unitMap.put(92, SI.PASCAL.divide(SI.METER));
        s_unitMap.put(93, SI.KELVIN);
        s_fdsSystem = new SIUS();
    }
}

