/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.unitsystem;

import java.util.HashMap;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;

public class EnglishUS
extends UnitSystem {
    private static final Map<Integer, Unit> s_unitMap = new HashMap<Integer, Unit>();
    private static final EnglishUS s_fdsSystem;

    public EnglishUS() {
        super(Intl.intl("English"));
    }

    public static EnglishUS getInstance() {
        return s_fdsSystem;
    }

    @Override
    public Unit getUnit(int n) {
        return s_unitMap.get(n);
    }

    public static Unit unit(int n) {
        return s_unitMap.get(n);
    }

    public static UnitDouble newud(double d, int n) {
        return new UnitDouble(d, EnglishUS.unit(n));
    }

    static {
        s_unitMap.put(3, NonSI.FOOT.multiply(SI.SECOND).root(2));
        s_unitMap.put(0, NonSI.FOOT);
        s_unitMap.put(1, NonSI.FAHRENHEIT);
        s_unitMap.put(2, SI.SECOND);
        s_unitMap.put(4, NonSI.POUND.divide(NonSI.FOOT.pow(3)));
        s_unitMap.put(5, NonSI.RANKINE.divide(NonSI.FOOT));
        s_unitMap.put(6, NonSI.FOOT.divide(SI.SECOND.pow(2)));
        s_unitMap.put(7, NonSI.INCH_OF_MERCURY);
        s_unitMap.put(8, NonSI.FOOT.divide(SI.SECOND));
        s_unitMap.put(9, NonSI.INCH);
        s_unitMap.put(10, NonSI.BTU.divide(NonSI.POUND));
        s_unitMap.put(11, NonSI.BTU.divide(NonSI.POUND).divide(NonSI.RANKINE));
        s_unitMap.put(13, NonSI.FOOT.pow(-1));
        s_unitMap.put(15, NonSI.BTU.divide(SI.MOLE));
        s_unitMap.put(16, NonSI.FOOT);
        s_unitMap.put(17, SI.GRAM.divide(SI.MOLE));
        s_unitMap.put(18, Unit.ONE.alternate("lb/lb"));
        s_unitMap.put(27, NonSI.FOOT.pow(2).divide(SI.SECOND));
        s_unitMap.put(19, NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.FOOT.multiply(NonSI.RANKINE)));
        s_unitMap.put(20, NonSI.POUND.divide(NonSI.FOOT.pow(2)).divide(SI.SECOND));
        s_unitMap.put(21, NonSI.FOOT.pow(2).divide(NonSI.POUND.divide(SI.SECOND)));
        s_unitMap.put(88, NonSI.BTU.divide(SI.SECOND).divide(NonSI.FOOT));
        s_unitMap.put(22, NonSI.BTU.divide(SI.SECOND).divide(NonSI.FOOT.pow(2)));
        s_unitMap.put(25, NonSI.BTU.divide(SI.SECOND).divide(NonSI.FOOT.pow(3)));
        s_unitMap.put(23, NonSI.POUND.divide(NonSI.FOOT.pow(2)));
        s_unitMap.put(24, NonSI.FOOT.pow(3).divide(NonSI.MINUTE));
        s_unitMap.put(26, Unit.ONE.alternate("lb/lb"));
        s_unitMap.put(28, Unit.ONE);
        s_unitMap.put(31, NonSI.PERCENT.divide(NonSI.FOOT));
        s_unitMap.put(34, Unit.ONE.divide(NonSI.FOOT).label("1/ft"));
        s_unitMap.put(30, NonSI.GALLON_LIQUID_US.divide(NonSI.MINUTE));
        s_unitMap.put(32, Unit.ONE.alternate("mol/mol"));
        s_unitMap.put(12, NonSI.BAR);
        s_unitMap.put(29, NonSI.DEGREE_ANGLE);
        s_unitMap.put(33, NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.FOOT.pow(2)));
        s_unitMap.put(35, SI.SECOND.pow(-1));
        s_unitMap.put(36, NonSI.FOOT.divide(SI.SECOND).pow(2));
        s_unitMap.put(37, NonSI.BTU.divide(NonSI.HOUR));
        s_unitMap.put(38, NonSI.POUND.divide(SI.SECOND));
        s_unitMap.put(39, NonSI.BAR);
        s_unitMap.put(40, NonSI.OUNCE.divide(NonSI.FOOT.pow(3)));
        s_unitMap.put(41, NonSI.POUND.divide(NonSI.FOOT).divide(SI.SECOND));
        s_unitMap.put(42, NonSI.ANGSTROM);
        s_unitMap.put(43, SI.KELVIN);
        s_unitMap.put(44, NonSI.POUND.divide(NonSI.FOOT.pow(2)).divide(SI.SECOND));
        s_unitMap.put(45, NonSI.POUND.divide(NonSI.FOOT.pow(2)).divide(SI.SECOND));
        s_unitMap.put(46, NonSI.BTU.divide(NonSI.POUND));
        s_unitMap.put(47, NonSI.BTU.divide(NonSI.POUND));
        s_unitMap.put(48, NonSI.BTU.divide(NonSI.POUND));
        s_unitMap.put(50, SI.SECOND.pow(-1).label("1/s"));
        s_unitMap.put(51, SI.METER.pow(-1).label("1/m"));
        s_unitMap.put(52, NonSI.FOOT.pow(2).divide(NonSI.POUND));
        s_unitMap.put(53, Unit.ONE.divide(SI.SECOND));
        s_unitMap.put(54, NonSI.BTU.divide(SI.KILO(SI.MOLE)));
        s_unitMap.put(55, Unit.ONE.alternate(Intl.intl("Droplets")).divide(NonSI.FOOT.pow(3)));
        s_unitMap.put(56, NonSI.FOOT.pow(3));
        s_unitMap.put(57, NonSI.PERCENT);
        s_unitMap.put(58, NonSI.GALLON_LIQUID_US.divide(NonSI.MINUTE).divide(NonSI.POUND_FORCE.divide(NonSI.INCH.pow(2)).root(2)));
        s_unitMap.put(59, NonSI.ATMOSPHERE);
        s_unitMap.put(60, NonSI.FOOT.divide(SI.SECOND).root(2));
        s_unitMap.put(61, NonSI.INCH);
        s_unitMap.put(62, NonSI.BTU.divide(NonSI.FOOT.pow(3)));
        s_unitMap.put(63, Unit.ONE.divide(NonSI.FOOT));
        s_unitMap.put(64, NonSI.PERCENT);
        s_unitMap.put(65, NonSI.BTU.divide(NonSI.POUND));
        s_unitMap.put(66, NonSI.POUND.multiply(NonSI.FOOT.pow(2)));
        s_unitMap.put(67, NonSI.POUND_FORCE);
        s_unitMap.put(68, NonSI.INCH.pow(2));
        s_unitMap.put(69, NonSI.POUND_FORCE.divide(NonSI.FOOT.divide(SI.SECOND)));
        s_unitMap.put(70, Unit.ONE.alternate("rps"));
        s_unitMap.put(71, Unit.ONE.alternate("pers").divide(NonSI.FOOT.pow(2)));
        s_unitMap.put(72, Unit.ONE.alternate("pers").divide(SI.SECOND));
        s_unitMap.put(73, Unit.ONE.divide(SI.SECOND).alternate("<html>ft<sup>2</sup>/(sft<sup>2</sup>)</html>"));
        s_unitMap.put(74, NonSI.RANKINE.divide(NonSI.MINUTE));
        s_unitMap.put(75, NonSI.POUND.divide(NonSI.FOOT));
        s_unitMap.put(76, NonSI.POUND.divide(SI.SECOND));
        s_unitMap.put(77, NonSI.POUND);
        s_unitMap.put(78, NonSI.BTU.divide(SI.SECOND));
        s_unitMap.put(79, NonSI.FOOT.pow(2));
        s_unitMap.put(80, NonSI.PERCENT);
        s_unitMap.put(82, Unit.ONE.alternate("ppm"));
        s_unitMap.put(83, NonSI.POUND.divide(NonSI.FOOT.pow(2)));
        s_unitMap.put(84, NonSI.PERCENT);
        s_unitMap.put(85, Unit.ONE);
        s_unitMap.put(81, NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.FOOT.pow(2)).divide(NonSI.RANKINE));
        s_unitMap.put(86, NonSI.BTU.divide(SI.MOLE));
        s_unitMap.put(87, Unit.ONE.alias("<html>ft<sup>3</sup>/ft<sup>3</sup></html>"));
        s_unitMap.put(89, NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.POUND));
        s_unitMap.put(90, NonSI.INCH);
        s_unitMap.put(92, NonSI.BAR.divide(NonSI.FOOT));
        s_unitMap.put(93, NonSI.RANKINE);
        s_fdsSystem = new EnglishUS();
    }
}

