/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Font;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.DepUtil;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.Corr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.Door;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.Entr;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.Evho;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.Evss;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.Exit;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.AutoRenameTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Global;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class TVEntryPoints {
    private static final Icon s_mgrIcon = PyroGuiUtil.loadPyroSimIcon("manager8.png");
    private static final Map<Class, TVEntryPoint> s_entryPoints;
    private static final TVEntryPoint s_defEP;
    private static final ResultsNode RESULTS_NODE;

    public static <T> TVEntryPoint<T> ep(Class<T> clazz) {
        TVEntryPoint tVEntryPoint = s_entryPoints.get(clazz);
        if (tVEntryPoint == null) {
            tVEntryPoint = theUtil.findObjectForClass(s_entryPoints, clazz);
            if (tVEntryPoint == null) {
                tVEntryPoint = s_defEP;
            }
            s_entryPoints.put(clazz, tVEntryPoint);
        }
        return tVEntryPoint;
    }

    public static <T> TVEntryPoint<T> ep(T t) {
        if (t == null) {
            return null;
        }
        return TVEntryPoints.ep(t.getClass());
    }

    private static boolean isOwnParent(PyroMod pyroMod, Set<?> set, Composite composite) {
        for (IPyroObject iPyroObject = composite; iPyroObject != null; iPyroObject = iPyroObject.getParent()) {
            if (!set.contains(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    private static boolean allOfType(Collection<?> collection, Class clazz) {
        for (Object obj : collection) {
            if (!(obj instanceof Composite ? !clazz.isAssignableFrom(((Composite)obj).getType()) : !clazz.isInstance(obj))) continue;
            return false;
        }
        return true;
    }

    private static ImageIcon newMgrIcon(Icon icon) {
        return icon == null ? null : new DecoratedIcon(icon, s_mgrIcon, 3);
    }

    static /* synthetic */ ImageIcon access$100(Icon icon) {
        return TVEntryPoints.newMgrIcon(icon);
    }

    static {
        s_defEP = new TVEntryPoint(Intl.intl("Object"));
        s_entryPoints = new HashMap<Class, TVEntryPoint>();
        s_entryPoints.put(PyroMod.class, new RootEP());
        s_entryPoints.put(Composite.class, new CompositeEP(null));
        s_entryPoints.put(MaterialManager.class, new MatlMgrEP());
        s_entryPoints.put(pyrosim.domain.boundcond.mat.Material.class, new MatlEP());
        s_entryPoints.put(ReactionList.class, new ReacMgrEP());
        s_entryPoints.put(Reaction.class, new ReacEP());
        s_entryPoints.put(SurfaceManager.class, new SurfaceMgrEP());
        s_entryPoints.put(Surface.class, new SurfaceEP());
        s_entryPoints.put(MaterialDB.class, new AppearanceDBEP());
        s_entryPoints.put(DeviceManager.class, new DevcMgrEP());
        s_entryPoints.put(IDevice.class, new DevcEP());
        s_entryPoints.put(ControlMgr.class, new CtrlMgrEP());
        s_entryPoints.put(ControlBridge.class, new TVEntryPoint(Intl.intl("Control")));
        s_entryPoints.put(GridList.class, new GridMgrEP());
        s_entryPoints.put(Grid.class, new GridEP());
        s_entryPoints.put(ZoneMgr.class, new ZoneMgrEP());
        s_entryPoints.put(Zone.class, new ZoneEP());
        s_entryPoints.put(ModelComposite.class, new ModelCompositeEP());
        s_entryPoints.put(IModelObj.class, new ModelObjEP());
        s_entryPoints.put(SimParams.class, new SimParamsEP());
        s_entryPoints.put(Plot3d.class, new Plot3dEP());
        s_entryPoints.put(Leak.class, new LeakEP());
        s_entryPoints.put(ExSpecList.class, new ExSpecMgrEP());
        s_entryPoints.put(ExSpec.class, new ExSpecEP());
        s_entryPoints.put(HvacList.class, new CompositeEP(PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png")));
        s_entryPoints.put(IHvacObject.class, new TVEntryPoint(Intl.intl("HVAC Component")));
        s_entryPoints.put(HvacDuctLoss.class, new HvacDuctLossEP());
        s_entryPoints.put(HvacNode.class, new HvacNodeEP());
        s_entryPoints.put(HvacDuct.class, new HvacDuctEP());
        s_entryPoints.put(ParticleList.class, new ParticleListEP());
        s_entryPoints.put(Particle.class, new ParticleEP());
        s_entryPoints.put(HeatLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(HeatLinkModel.class, new TVEntryPoint(Intl.intl("Heat Detector Model")));
        s_entryPoints.put(SmokeLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SmokeLinkModel.class, new TVEntryPoint(Intl.intl("Smoke Detector Model")));
        s_entryPoints.put(SprinklerLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SprinklerLinkModel.class, new TVEntryPoint(Intl.intl("Sprinkler Link Model")));
        s_entryPoints.put(SprayModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SprayModel.class, new TVEntryPoint(Intl.intl("Spray Model")));
        s_entryPoints.put(CorrList.class, new CompositeEP(null));
        s_entryPoints.put(Corr.class, new TVEntryPoint(Intl.intl("Corridor")));
        s_entryPoints.put(DoorList.class, new CompositeEP(null));
        s_entryPoints.put(Door.class, new TVEntryPoint(Intl.intl("Door")));
        s_entryPoints.put(EntrList.class, new CompositeEP(null));
        s_entryPoints.put(Entr.class, new TVEntryPoint(Intl.intl("ENTR")));
        s_entryPoints.put(EvacList.class, new CompositeEP(null));
        s_entryPoints.put(Evac.class, new TVEntryPoint(Intl.intl("EVAC")));
        s_entryPoints.put(EvhoList.class, new CompositeEP(null));
        s_entryPoints.put(Evho.class, new TVEntryPoint(Intl.intl("EVHO")));
        s_entryPoints.put(EvssList.class, new CompositeEP(null));
        s_entryPoints.put(Evss.class, new TVEntryPoint(Intl.intl("EVSS")));
        s_entryPoints.put(ExitList.class, new CompositeEP(null));
        s_entryPoints.put(Exit.class, new TVEntryPoint(Intl.intl("Exit")));
        s_entryPoints.put(PersList.class, new CompositeEP(null));
        s_entryPoints.put(Pers.class, new TVEntryPoint(Intl.intl("PERS")));
        s_entryPoints.put(ResultsNode.class, new ResultsNodeEP());
        s_entryPoints.put(ViewList.class, new ViewListEP());
        s_entryPoints.put(View.class, new ViewEP());
        s_entryPoints.put(ClipPlane.class, new ClipPlaneEP());
        s_entryPoints.put(SectionBox.class, new SectionBoxEP());
        s_entryPoints.put(CameraState.class, new CameraStateEP());
        s_entryPoints.put(StatisticMgr.class, new StatMgrEP());
        s_entryPoints.put(IMeasurementStat.class, new StatisticEP());
        s_entryPoints.put(Boundaries.class, new BoundaryEP());
        s_entryPoints.put(SliceList.class, new SliceMgrEP());
        s_entryPoints.put(PlanarSlice.class, new SliceEP());
        s_entryPoints.put(Slice3dList.class, new Slice3dMgrEP());
        s_entryPoints.put(VolumeSlice.class, new Slice3dEP());
        s_entryPoints.put(IsosurfaceMgr.class, new IsofMgrEP());
        s_entryPoints.put(Isosurface.class, new IsofEP());
        s_entryPoints.put(ProfList.class, new CompositeEP(null));
        s_entryPoints.put(ProfRec.class, new TVEntryPoint(Intl.intl("Material Profile")));
        s_entryPoints.put(FloorManager.class, new CompositeEP(null));
        s_entryPoints.put(Floor.class, new TVEntryPoint(Intl.intl("Floor")));
        RESULTS_NODE = new ResultsNode();
    }

    private static class ResultsNode {
        private ResultsNode() {
        }
    }

    public static class SliceEP
    extends TVEntryPoint<PlanarSlice> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("slices16.png");

        public SliceEP() {
            super(ICON, Intl.intl("Slice"));
        }

        @Override
        public String getName(PlanarSlice planarSlice) {
            if (planarSlice instanceof PlanarSlice) {
                PlanarSlice planarSlice2 = planarSlice;
                String string = "";
                switch (planarSlice2.getPlane()) {
                    case 0: {
                        string = Intl.intl("X");
                        break;
                    }
                    case 1: {
                        string = Intl.intl("Y");
                        break;
                    }
                    case 2: {
                        string = Intl.intl("Z");
                    }
                }
                string = string + " = " + Global.format(planarSlice2.getLocation());
                string = string + ": " + planarSlice2.getQuantity().getDescription();
                return string;
            }
            return super.getName(planarSlice);
        }

        @Override
        public boolean isOccluder(PyroMod pyroMod, PlanarSlice planarSlice) {
            return false;
        }

        @Override
        public boolean isDrawingSnappable(PyroMod pyroMod, PlanarSlice planarSlice) {
            return false;
        }
    }

    public static class Slice3dEP
    extends TVEntryPoint<VolumeSlice> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("slices3d.png");

        public Slice3dEP() {
            super(ICON, Intl.intl("3D Slice"));
        }

        @Override
        public String getName(VolumeSlice volumeSlice) {
            return volumeSlice.toString();
        }

        @Override
        public boolean isOccluder(PyroMod pyroMod, VolumeSlice volumeSlice) {
            return false;
        }

        @Override
        public boolean isDrawingSnappable(PyroMod pyroMod, VolumeSlice volumeSlice) {
            return false;
        }
    }

    public static class Slice3dMgrEP
    extends CompositeEP<Slice3dList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("slices3d.png"));

        public Slice3dMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, Slice3dList slice3dList) {
            if (slice3dList == pyroMod.getSlcf3dList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(pyroMod, slice3dList);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, Slice3dList slice3dList, Object object) {
            for (VolumeSlice volumeSlice : pyroMod.getSlcf3dList().flatten()) {
                if (!volumeSlice.equals(object)) continue;
                return volumeSlice;
            }
            return null;
        }
    }

    public static class SliceMgrEP
    extends CompositeEP<SliceList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("slices16.png"));

        public SliceMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, SliceList sliceList) {
            if (sliceList == pyroMod.getSlcfList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(pyroMod, sliceList);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, SliceList sliceList, Object object) {
            for (PlanarSlice planarSlice : pyroMod.getSlcfList().flatten()) {
                if (!planarSlice.equals(object)) continue;
                return planarSlice;
            }
            return null;
        }
    }

    public static class StatisticEP
    extends TVEntryPoint<IMeasurementStat> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("stat16.png");

        public StatisticEP() {
            super(ICON, Intl.intl("Statistic"));
        }
    }

    public static class StatMgrEP
    extends CompositeEP<StatisticMgr> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("stat16.png"));

        public StatMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, StatisticMgr statisticMgr) {
            if (statisticMgr == pyroMod.getMsrStatMgr()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(pyroMod, statisticMgr);
        }
    }

    public static class ResultsNodeEP
    extends TVEntryPoint<ResultsNode> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("composite16_2.gif");

        public ResultsNodeEP() {
            super(ICON, Intl.intl("Results"));
        }

        @Override
        public boolean isLeaf(PyroMod pyroMod, ResultsNode resultsNode) {
            return false;
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, ResultsNode resultsNode) {
            return true;
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, ResultsNode resultsNode) {
            return pyroMod;
        }

        @Override
        public boolean canRename(PyroMod pyroMod, ResultsNode resultsNode) {
            return false;
        }

        @Override
        public String getName(ResultsNode resultsNode) {
            return Intl.intl("Results");
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod pyroMod, ResultsNode resultsNode) {
            return Arrays.asList(pyroMod.getMsrStatMgr(), pyroMod.getSlcfList(), pyroMod.getSlcf3dList());
        }
    }

    public static class CameraStateEP
    extends TVEntryPoint<CameraState> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("camera16.png");

        public CameraStateEP() {
            super(ICON, Intl.intl("Viewpoint"));
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, CameraState cameraState, Object object) {
            return true;
        }

        @Override
        public String getDisplayName(CameraState cameraState) {
            return Intl.intl("Viewpoint");
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, CameraState cameraState) {
            return null;
        }

        @Override
        public Object getPasteLocation(PyroMod pyroMod, CameraState cameraState) {
            return null;
        }
    }

    public static class SectionBoxEP
    extends TVEntryPoint<SectionBox> {
        public SectionBoxEP() {
            super(Intl.intl("Section Box"));
        }

        @Override
        public boolean canRename(PyroMod pyroMod, SectionBox sectionBox) {
            return false;
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, SectionBox sectionBox, Object object) {
            return true;
        }

        @Override
        public String getDisplayName(SectionBox sectionBox) {
            return Intl.intl("Section Box");
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, SectionBox sectionBox) {
            return null;
        }

        @Override
        public Object getPasteLocation(PyroMod pyroMod, SectionBox sectionBox) {
            return null;
        }
    }

    public static class ClipPlaneEP
    extends TVEntryPoint<ClipPlane> {
        public ClipPlaneEP() {
            super(Intl.intl("Clip Plane"));
        }

        @Override
        public boolean canRename(PyroMod pyroMod, ClipPlane clipPlane) {
            return false;
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, ClipPlane clipPlane, Object object) {
            return false;
        }

        @Override
        public boolean canDrop(PyroMod pyroMod, ClipPlane clipPlane, Set<?> set, Object object) {
            return false;
        }

        @Override
        public String getName(ClipPlane clipPlane) {
            return clipPlane.getPlane().toString(PyroSim.getApp().getUnitSystem().getLengthUnit());
        }
    }

    public static class ViewEP
    extends TVEntryPoint<View> {
        public ViewEP() {
            super(Intl.intl("View"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, View view) {
            boolean bl;
            boolean bl2 = bl = pyroMod.getViews().getActiveView() == view;
            if (bl) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, view);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, View view, Object object) {
            if (object instanceof SectionBox || object instanceof CameraState) {
                return true;
            }
            return super.canDelete(pyroMod, view, object);
        }

        @Override
        public boolean add(View view, Object object) {
            if (object instanceof SectionBox) {
                SectionBox sectionBox = (SectionBox)object;
                if (view.get(View.PROP_SECTION_BOX) == null) {
                    view.set(View.PROP_SECTION_BOX, sectionBox);
                }
                return true;
            }
            if (object instanceof CameraState) {
                if (view.get(View.PROP_CAMERA) == null) {
                    view.set(View.PROP_CAMERA, (CameraState)object);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(View view, Object object) {
            if (object instanceof SectionBox) {
                view.remove(View.PROP_SECTION_BOX);
                return true;
            }
            if (object instanceof CameraState) {
                view.remove(View.PROP_CAMERA);
            }
            return false;
        }

        @Override
        public boolean isDroppable(PyroMod pyroMod, View view) {
            return view.get(View.PROP_SECTION_BOX) == null || view.get(View.PROP_CAMERA) == null;
        }

        @Override
        public boolean canDrop(PyroMod pyroMod, View view, Set<?> set, Object object) {
            if (theUtil.filter(set, new TypeFilter(SectionBox.class, CameraState.class)).isExclusive() && (theUtil.filter(set, SectionBox.class).size() == 1 || theUtil.filter(set, CameraState.class).size() == 1)) {
                for (Object obj : set) {
                    if (this.canPaste(pyroMod, view, obj)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public Task drop(PyroMod pyroMod, View view, int n, Collection<?> collection) {
            return new ReorderObjectsTask((IPyroObject)view, n, theUtil.filter(collection, IPyroObject.class));
        }

        @Override
        public boolean canPaste(PyroMod pyroMod, View view, Object object) {
            return object instanceof SectionBox && view.get(View.PROP_SECTION_BOX) == null || object instanceof CameraState && view.get(View.PROP_CAMERA) == null;
        }

        @Override
        public Task paste(PyroMod pyroMod, View view, Object object, Object object2, TVEntryPoint.ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
            return new AddTask<IPyroObject>((IPyroObject)view, (Collection<IPyroObject>)Arrays.asList((IPyroObject)object));
        }

        @Override
        public boolean isContainer(PyroMod pyroMod, View view, Object object) {
            if (object instanceof SectionBox || object instanceof CameraState) {
                return true;
            }
            return super.isContainer(pyroMod, view, object);
        }
    }

    public static class ViewListEP
    extends CompositeEP<ViewList> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("cameras16.png");

        public ViewListEP() {
            super(ICON);
        }

        @Override
        public boolean canDrop(PyroMod pyroMod, ViewList viewList, Set<?> set, Object object) {
            if (!super.canDrop(pyroMod, viewList, set, object)) {
                return false;
            }
            for (Object obj : set) {
                if (this.canPaste(pyroMod, viewList, obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, ViewList viewList) {
            if (viewList != pyroMod.getViews()) {
                View view = pyroMod.getViews().getActiveView();
                for (IPyroObject iPyroObject = view.getParent(); iPyroObject != null; iPyroObject = iPyroObject.getParent()) {
                    if (iPyroObject != viewList) continue;
                    return s_bold;
                }
            }
            return super.getBaseFont(pyroMod, viewList);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, ViewList viewList, Object object) {
            if (object instanceof View) {
                View view = (View)object;
                return pyroMod.getViews().getActiveView() != view;
            }
            return super.canDelete(pyroMod, viewList, object);
        }
    }

    public static class ModelCompositeEP
    extends CompositeEP<ModelComposite> {
        public ModelCompositeEP() {
            super(PyroGuiUtil.loadPyroSimIcon("composite16_2.gif"));
        }
    }

    public static class ModelObjEP
    extends TVEntryPoint<IModelObj> {
        public static final ImageIcon VENT_ICON = PyroGuiUtil.loadPyroSimIcon("vent16.gif");
        public static final ImageIcon SLAB_ICON = PyroGuiUtil.loadPyroSimIcon("triangle.png");
        public static final ImageIcon WALL_ICON = PyroGuiUtil.loadPyroSimIcon("block16_2.gif");
        public static final ImageIcon INIT_REGION_ICON = PyroGuiUtil.loadPyroSimIcon("init16.png");
        public static final ImageIcon PART_CLOUD_ICON = PyroGuiUtil.loadPyroSimIcon("partCloud16.gif");
        public static final ImageIcon SINGLE_PART_ICON = PyroGuiUtil.loadPyroSimIcon("single_part16.gif");
        public static final ImageIcon ABLOCK_ICON = PyroGuiUtil.loadPyroSimIcon("cube16.png");
        public static final ImageIcon AHOLE_ICON = PyroGuiUtil.loadPyroSimIcon("hole16.gif");
        public static final ImageIcon HOLE_ICON = PyroGuiUtil.loadPyroSimIcon("wall_hole16.png");
        public static final ImageIcon GEOMGROUP_ICON = PyroGuiUtil.loadPyroSimIcon("geomgroup16.png");

        public ModelObjEP() {
            super(Intl.intl("Geometric Object"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Icon[] getIcons(PyroMod pyroMod, IModelObj iModelObj) {
            ImageIcon imageIcon;
            IGeomNode iGeomNode = iModelObj.getGeom();
            if (iGeomNode.getChildren().isEmpty()) {
                IGeom iGeom = iGeomNode.getLocalGeom();
                while (iGeom instanceof IProxyGeom) {
                    iGeom = ((IProxyGeom)iGeom).getBase();
                }
                if (iGeom instanceof AABoxGeom && iModelObj instanceof IObstruction) {
                    imageIcon = ABLOCK_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iGeom instanceof AABoxGeom && iModelObj instanceof IHole) {
                    imageIcon = AHOLE_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iGeom instanceof WallGeom && iModelObj instanceof IObstruction) {
                    imageIcon = WALL_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iGeom instanceof WallGeom && iModelObj instanceof IHole) {
                    imageIcon = HOLE_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iGeom instanceof ExtrudedPoly) {
                    imageIcon = SLAB_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iGeom instanceof GeomGroup) {
                    imageIcon = GEOMGROUP_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iModelObj instanceof InitRegion) {
                    imageIcon = INIT_REGION_ICON;
                    return new Icon[]{imageIcon, null};
                } else if (iModelObj instanceof PartCloud) {
                    PartCloud partCloud = (PartCloud)iModelObj;
                    imageIcon = partCloud.getGeom().getLocalGeom() instanceof Point ? SINGLE_PART_ICON : PART_CLOUD_ICON;
                    return new Icon[]{imageIcon, null};
                } else {
                    if (!(iModelObj instanceof Vent)) return super.getIcons(pyroMod, iModelObj);
                    imageIcon = VENT_ICON;
                }
                return new Icon[]{imageIcon, null};
            } else {
                imageIcon = GEOMGROUP_ICON;
            }
            return new Icon[]{imageIcon, null};
        }

        @Override
        public boolean mayBeReferenced(PyroMod pyroMod, IModelObj iModelObj) {
            return iModelObj instanceof Vent;
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, IModelObj iModelObj) {
            return pyroMod.getObstructions();
        }
    }

    public static class CompositeEP<T extends Composite>
    extends TVEntryPoint<T> {
        public CompositeEP(ImageIcon imageIcon) {
            super(imageIcon, Intl.intl("Group"));
        }

        @Override
        public boolean isVisible(PyroMod pyroMod, T t) {
            if (((Composite)t).getMembers().isEmpty()) {
                return true;
            }
            for (IPyroObject iPyroObject : ((Composite)t).getMembers()) {
                if (!TVEntryPoints.ep(iPyroObject).isVisible(pyroMod, iPyroObject)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isContainer(PyroMod pyroMod, T t, Object object) {
            return object instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, T t, Object object) {
            return true;
        }

        @Override
        public boolean add(T t, Object object) {
            return ((Composite)t).add((IPyroObject)object);
        }

        @Override
        public boolean addAll(T t, Collection<?> collection) {
            return ((Composite)t).addAll(collection);
        }

        @Override
        public boolean remove(T t, Object object) {
            return ((Composite)t).remove((IPyroObject)object);
        }

        @Override
        public boolean removeAll(T t, Collection<?> collection) {
            return ((Composite)t).removeAll(collection);
        }

        @Override
        public void reorder(T t, Collection<?> collection) {
            ((Composite)t).reorder(collection);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, T t, Object object) {
            if (Util.isKeyedByName(pyroMod, object)) {
                String string = Util.getName((IPyroObject)object);
                if (!pyroMod.getNames().getNames(object).isRegistered(string)) {
                    return null;
                }
                return ((Composite)t).get(string);
            }
            return null;
        }

        @Override
        public boolean canPaste(PyroMod pyroMod, T t, Object object) {
            return object instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object);
        }

        @Override
        public Task paste(PyroMod pyroMod, T t, Object object, Object object2, TVEntryPoint.ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
            assert (object instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object));
            assert (object2 == null || object2 instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object2));
            if (object2 == null) {
                return new AddTask(t, new IPyroObject[]{(IPyroObject)object});
            }
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            if (conflictResolution == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING) {
                for (Dependency dependency : depSnapshot.getDependents((IPyroObject)object2)) {
                    compositeTask.addTask(DepUtil.getReplacementTask(depSnapshot, dependency.source, (IPyroObject)object2, (IPyroObject)object));
                }
                compositeTask.addTask(Tasks.delete((IPyroObject)object2));
            } else {
                Object object3 = TVEntryPoints.ep(object).getCategoryRoot(pyroMod, object);
                assert (object3 instanceof Composite);
                if (object instanceof INamed) {
                    compositeTask.addTask(new AutoRenameTask(pyroMod, new INamed[]{(INamed)object}));
                }
            }
            compositeTask.addTask(new AddTask(t, new IPyroObject[]{(IPyroObject)object}));
            return compositeTask;
        }

        @Override
        public boolean isDroppable(PyroMod pyroMod, T t) {
            return true;
        }

        @Override
        public boolean canDrop(PyroMod pyroMod, T t, Set<?> set, Object object) {
            if (!(object instanceof Composite)) {
                return false;
            }
            IPyroObject iPyroObject = Hierarchy.getCategoryRoot((Composite)object);
            if (iPyroObject == null) {
                return false;
            }
            return Hierarchy.isDescendent(iPyroObject, t) && !TVEntryPoints.isOwnParent(pyroMod, set, t);
        }

        @Override
        public Task drop(PyroMod pyroMod, T t, int n, Collection<?> collection) {
            return new ReorderObjectsTask((IPyroObject)t, n, (Collection<? extends IPyroObject>)theUtil.filter(collection, IPyroObject.class));
        }
    }

    public static class ZoneEP
    extends TVEntryPoint<Zone> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZoneEP() {
            super(ICON, Intl.intl("Zone"));
        }

        @Override
        public boolean canRename(PyroMod pyroMod, Zone zone) {
            return !zone.isOuter();
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Zone zone) {
            return zone.isOuter() ? s_bold : super.getBaseFont(pyroMod, zone);
        }
    }

    public static class ZoneMgrEP
    extends CompositeEP<ZoneMgr> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("zones16.png"));

        public ZoneMgrEP() {
            super(ICON);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, ZoneMgr zoneMgr, Object object) {
            return object instanceof Zone && !((Zone)object).isOuter();
        }
    }

    public static class GridEP
    extends TVEntryPoint<Grid> {
        private static ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif");
        private static ImageIcon ICON_EVAC = PyroGuiUtil.loadPyroSimIcon("3dgrid_evac16.gif");

        public GridEP() {
            super(Intl.intl("Mesh"));
        }

        @Override
        public Icon[] getIcons(PyroMod pyroMod, Grid grid) {
            ImageIcon imageIcon = grid.getEvacuation() ? ICON_EVAC : ICON;
            return new Icon[]{imageIcon, null};
        }

        @Override
        public String getDisplayName(Grid grid) {
            long l = grid.getXDivisions().length;
            long l2 = grid.getYDivisions().length;
            long l3 = grid.getZDivisions().length;
            long l4 = l * l2 * l3;
            String string = NumberFormat.getNumberInstance(Locale.getDefault()).format(l4);
            return grid.getName() + " (" + string + ")";
        }
    }

    public static class GridMgrEP
    extends CompositeEP<GridList> {
        public static final ImageIcon ICON_GRID = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"));

        public GridMgrEP() {
            super(ICON_GRID);
        }

        @Override
        public String getDisplayName(GridList gridList) {
            Collection collection = gridList.flatten();
            long l = 0L;
            for (Grid grid : collection) {
                long l2 = grid.getXDivisions().length;
                long l3 = grid.getYDivisions().length;
                long l4 = grid.getZDivisions().length;
                l += l2 * l3 * l4;
            }
            String string = NumberFormat.getNumberInstance(Locale.getDefault()).format(l);
            return gridList.getName() + " (" + (String)string + ")";
        }
    }

    public static class CtrlMgrEP
    extends CompositeEP<ControlMgr> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public CtrlMgrEP() {
            super(ICON);
        }
    }

    public static class ParticleListEP
    extends CompositeEP<ParticleList> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("particles16.gif"));

        public ParticleListEP() {
            super(ICON);
        }
    }

    public static class ParticleEP
    extends TVEntryPoint<Particle> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("particles16.gif");

        public ParticleEP() {
            super(ICON, Intl.intl("Particle"));
        }
    }

    public static class ExSpecEP
    extends TVEntryPoint<ExSpec> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("molecule16.png");

        public ExSpecEP() {
            super(ICON, Intl.intl("Species"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, ExSpec exSpec) {
            if (exSpec.isBackgroundSpec()) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, exSpec);
        }

        @Override
        public String getDisplayName(ExSpec exSpec) {
            String string = super.getDisplayName(exSpec);
            if (exSpec.isBackgroundSpec()) {
                string = String.format(Intl.intl("%s (Background)"), string);
            }
            return string;
        }
    }

    public static class ExSpecMgrEP
    extends CompositeEP<ExSpecList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("molecule16.png"));

        public ExSpecMgrEP() {
            super(ICON);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, ExSpecList exSpecList, Object object) {
            if (object instanceof ExSpec) {
                ExSpec exSpec = (ExSpec)object;
                if (exSpec.getType() == 4) {
                    List<Reaction> list = pyroMod.getReactions().getActiveReactions();
                    if (list.isEmpty()) {
                        return true;
                    }
                    if (list.iterator().next().getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
                        return false;
                    }
                }
                return true;
            }
            return super.canDelete(pyroMod, exSpecList, object);
        }
    }

    public static class DevcEP
    extends TVEntryPoint<IDevice> {
        public DevcEP() {
            super(Intl.intl("Device"));
        }

        @Override
        public Icon[] getIcons(PyroMod pyroMod, IDevice iDevice) {
            return iDevice.getIcons();
        }
    }

    public static class DevcMgrEP
    extends CompositeEP<DeviceManager> {
        public static final ImageIcon ICON_DEVICE = PyroGuiUtil.loadPyroSimIcon("sprk3.gif");

        public DevcMgrEP() {
            super(ICON_DEVICE);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, DeviceManager deviceManager, Object object) {
            if (Clock.isClock((IPyroObject)object)) {
                return Clock.INSTANCE;
            }
            return super.getConflict(pyroMod, deviceManager, object);
        }
    }

    public static class AppearanceEP
    extends TVEntryPoint<Material> {
        public AppearanceEP() {
            super(Intl.intl("Appearance"));
        }

        @Override
        public Icon[] getIcons(PyroMod pyroMod, Material material) {
            int n = 3;
            return PyroGuiUtil.getIcons(material, -1, 16, n, guiUtil.ImageFilter.NORMAL, guiUtil.ImageFilter.DISABLED);
        }
    }

    public static class AppearanceDBEP
    extends CompositeEP<MaterialDB> {
        public AppearanceDBEP() {
            super((ImageIcon)null);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, MaterialDB materialDB, Object object) {
            if (!(object instanceof Material)) {
                return null;
            }
            for (Material material : materialDB.flatten()) {
                if (!material.pseudoEquals((Material)object)) continue;
                return material;
            }
            return null;
        }

        @Override
        public boolean isEquivalent(PyroMod pyroMod, MaterialDB materialDB, Object object, Object object2) {
            assert (((Material)object).pseudoEquals((Material)object2));
            return true;
        }
    }

    public static class SurfaceEP
    extends TVEntryPoint<Surface> {
        public static final ImageIcon DEF_ICON = PyroGuiUtil.loadPyroSimIcon("surf2a.gif");

        public SurfaceEP() {
            super(Intl.intl("Surface"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Surface surface) {
            if (surface == pyroMod.getSimParams().getMisc().getSurfDefault()) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, surface);
        }

        @Override
        public boolean canRename(PyroMod pyroMod, Surface surface) {
            return !surface.isPredefined();
        }

        @Override
        public Icon[] getIcons(PyroMod pyroMod, Surface surface) {
            return surface.getIcons(DEF_ICON.getIconWidth(), DEF_ICON.getIconHeight());
        }
    }

    public static class SurfaceMgrEP
    extends CompositeEP<SurfaceManager> {
        public static final ImageIcon ICON_SURFDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf2a.gif"));

        public SurfaceMgrEP() {
            super(ICON_SURFDB);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, SurfaceManager surfaceManager, Object object) {
            return !(object instanceof Surface) || !((Surface)object).isPredefined();
        }
    }

    public static class HvacDuctEP
    extends TVEntryPoint<HvacDuct> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_duct16.png");

        public HvacDuctEP() {
            super(ICON, Intl.intl("HVAC Duct"));
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, HvacNode hvacNode) {
            return pyroMod.getObstructions();
        }
    }

    public static class HvacNodeEP
    extends TVEntryPoint<HvacNode> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_node16.png");

        public HvacNodeEP() {
            super(ICON, Intl.intl("HVAC Node"));
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, HvacNode hvacNode) {
            return pyroMod.getObstructions();
        }
    }

    public static class HvacDuctLossEP
    extends TVEntryPoint<HvacDuctLoss> {
        public HvacDuctLossEP() {
            super(Intl.intl("HVAC Duct Loss"));
        }

        @Override
        public String getName(HvacDuctLoss hvacDuctLoss) {
            return String.format(Intl.intl("Duct Loss: Node=%s: %s -> %s (%s : %s)"), hvacDuctLoss.node.getName(), hvacDuctLoss.duct1.getName(), hvacDuctLoss.duct2.getName(), Global.format(hvacDuctLoss.fwdLoss), Global.format(hvacDuctLoss.revLoss));
        }
    }

    public static class LeakEP
    extends TVEntryPoint<Leak> {
        public LeakEP() {
            super(Intl.intl("Zone Leak"));
        }

        @Override
        public String getName(Leak leak) {
            return String.format(Intl.intl("Leak: %s -> %s (%s)"), leak.zone1.getName(), leak.zone2.getName(), Global.format(leak.area));
        }
    }

    public static class IsofEP
    extends TVEntryPoint<Isosurface> {
        public IsofEP() {
            super(Intl.intl("Isosurface"));
        }

        @Override
        public String getName(Isosurface isosurface) {
            return isosurface.getQuantity().getDescription();
        }
    }

    public static class IsofMgrEP
    extends CompositeEP<IsosurfaceMgr> {
        public IsofMgrEP() {
            super((ImageIcon)null);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, IsosurfaceMgr isosurfaceMgr, Object object) {
            for (Isosurface isosurface : pyroMod.getIsofList().flatten()) {
                if (!isosurface.equals(object)) continue;
                return isosurface;
            }
            return null;
        }
    }

    public static class MatlEP
    extends TVEntryPoint<pyrosim.domain.boundcond.mat.Material> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("surf.png");

        public MatlEP() {
            super(ICON, Intl.intl("Material"));
        }
    }

    public static class MatlMgrEP
    extends CompositeEP<MaterialManager> {
        public static final ImageIcon ICON_MATLDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf.png"));

        public MatlMgrEP() {
            super(ICON_MATLDB);
        }
    }

    public static class Plot3dEP
    extends TVEntryPoint<Plot3d> {
        public Plot3dEP() {
            super(Intl.intl("Plot3d Output"));
        }

        @Override
        public String getName(Plot3d plot3d) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, Plot3d plot3d) {
            return pyroMod.getPlot3d() == plot3d;
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, Plot3d plot3d) {
            return pyroMod;
        }

        public Task paste(final PyroMod pyroMod, Composite<? extends IPyroObject> composite, final Plot3d plot3d, final Plot3d plot3d2, TVEntryPoint.ConflictResolution conflictResolution) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    pyroMod.setPL3DRecord(plot3d);
                }

                @Override
                public void undo() {
                    pyroMod.setPL3DRecord(plot3d2);
                }
            };
        }
    }

    public static class SimParamsEP
    extends TVEntryPoint<SimParams> {
        public SimParamsEP() {
            super(Intl.intl("Simulation Parameters"));
        }

        @Override
        public String getName(SimParams simParams) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, SimParams simParams) {
            return pyroMod.getSimParams() == simParams;
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, SimParams simParams) {
            return pyroMod;
        }

        public Task paste(final PyroMod pyroMod, Composite<? extends IPyroObject> composite, final SimParams simParams, final SimParams simParams2, TVEntryPoint.ConflictResolution conflictResolution) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    pyroMod.setSimParams(simParams);
                }

                @Override
                public void undo() {
                    pyroMod.setSimParams(simParams2);
                }
            };
        }
    }

    public static class BoundaryEP
    extends TVEntryPoint<Boundaries> {
        public BoundaryEP() {
            super(Intl.intl("Boundary Quantities"));
        }

        @Override
        public String getName(Boundaries boundaries) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, Boundaries boundaries) {
            return pyroMod.getBoundaryOutput() == boundaries;
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, Boundaries boundaries) {
            return pyroMod;
        }

        @Override
        public boolean canMerge(PyroMod pyroMod, Boundaries boundaries) {
            return true;
        }

        @Override
        public Boundaries mergeToRoot(PyroMod pyroMod, Boundaries boundaries) {
            return Boundaries.mergeBoundaries(boundaries, pyroMod.getBoundaryOutput());
        }

        public Task paste(final PyroMod pyroMod, Composite<? extends IPyroObject> composite, final Boundaries boundaries, final Boundaries boundaries2, TVEntryPoint.ConflictResolution conflictResolution) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    pyroMod.setBoundaries(boundaries);
                }

                @Override
                public void undo() {
                    pyroMod.setBoundaries(boundaries2);
                }
            };
        }
    }

    public static class ReacEP
    extends TVEntryPoint<Reaction> {
        private static ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("reaction16.gif");

        public ReacEP() {
            super(ICON, Intl.intl("Reaction"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Reaction reaction) {
            if (reaction.isActive()) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, reaction);
        }

        @Override
        public String getDisplayName(Reaction reaction) {
            String string = super.getDisplayName(reaction);
            if (reaction.isActive()) {
                string = String.format(Intl.intl("%s (Active)"), string);
            }
            return string;
        }
    }

    public static class ReacMgrEP
    extends CompositeEP<ReactionList> {
        public static final ImageIcon ICON_REACT = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));

        public ReacMgrEP() {
            super(ICON_REACT);
        }
    }

    public static class RootEP
    extends TVEntryPoint<PyroMod> {
        public RootEP() {
            super(Intl.intl("PyroSim Model"));
        }

        @Override
        public String getName(PyroMod pyroMod) {
            return "";
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, PyroMod pyroMod2) {
            return pyroMod2 == pyroMod;
        }

        @Override
        public boolean isLeaf(PyroMod pyroMod, PyroMod pyroMod2) {
            return false;
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod pyroMod, PyroMod pyroMod2) {
            return Arrays.asList(pyroMod2.getViews(), pyroMod2.getGridManager(), pyroMod2.getZoneMgr(), pyroMod2.getExSpecList(), pyroMod2.getReactions(), pyroMod2.getPartList(), pyroMod2.getMaterialMgr(), pyroMod2.getSurfaceMgr(), pyroMod2.getDevices(), pyroMod2.getControls(), RESULTS_NODE, pyroMod2.getHvacList(), pyroMod2.getObstructions());
        }

        @Override
        public boolean isContainer(PyroMod pyroMod, PyroMod pyroMod2, Object object) {
            if (!(object instanceof IPyroObject)) {
                return false;
            }
            for (IPyroObject iPyroObject : pyroMod2.getMembers()) {
                if (!iPyroObject.getClass().isInstance(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getConflict(PyroMod pyroMod, PyroMod pyroMod2, Object object) {
            if (object instanceof Plot3d) {
                return pyroMod.getPlot3d();
            }
            if (object instanceof SimParams) {
                return pyroMod.getSimParams();
            }
            if (object instanceof Boundaries) {
                return pyroMod.getBoundaryOutput();
            }
            return null;
        }

        @Override
        public Task paste(final PyroMod pyroMod, PyroMod pyroMod2, Object object, Object object2, TVEntryPoint.ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
            assert (conflictResolution == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING);
            if (object instanceof Plot3d) {
                return new AReplaceRefTask<Plot3d>(object2, object){

                    @Override
                    protected void set(Plot3d plot3d) {
                        pyroMod.setPL3DRecord(plot3d);
                    }
                };
            }
            if (object instanceof SimParams) {
                return new AReplaceRefTask<SimParams>(object2, object){

                    @Override
                    protected void set(SimParams simParams) {
                        pyroMod.setSimParams(simParams);
                    }
                };
            }
            if (object instanceof Boundaries) {
                return new AReplaceRefTask<Boundaries>(object2, object){

                    @Override
                    protected void set(Boundaries boundaries) {
                        pyroMod.setBoundaries(boundaries);
                    }
                };
            }
            return super.paste(pyroMod, pyroMod2, object, object2, conflictResolution, depSnapshot);
        }
    }
}

