/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class TVEntryPoint<T> {
    protected static final Font s_plain = new Font("Sans Serif", 0, 11);
    protected static final Font s_bold = new Font("Sans Serif", 1, 11);
    protected static final Font s_italic = new Font("Sans Serif", 2, 11);
    protected static final Font s_italicBold = s_italic.deriveFont(1);
    private static final Map<Class, Boolean> s_refedTypesToUpdate = new HashMap<Class, Boolean>();
    private final ImageIcon d_icon;
    private final String d_categoryName;

    public static void registerReferencedUpdateTypes(Class<? extends IPyroObject> ... classArray) {
        for (Class<? extends IPyroObject> clazz : classArray) {
            s_refedTypesToUpdate.put(clazz, Boolean.TRUE);
        }
    }

    protected static boolean getDependentsNeedUpdate(Class clazz) {
        Boolean bl = s_refedTypesToUpdate.get(clazz);
        if (bl == null) {
            bl = theUtil.findObjectForClass(s_refedTypesToUpdate, clazz);
            if (bl == null) {
                bl = false;
            }
            s_refedTypesToUpdate.put(clazz, bl);
        }
        return bl;
    }

    public TVEntryPoint(String string) {
        this(null, string);
    }

    public TVEntryPoint(ImageIcon imageIcon, String string) {
        this.d_icon = imageIcon;
        this.d_categoryName = string;
    }

    public String getCategoryName() {
        return this.d_categoryName;
    }

    public String getName(T t) {
        if (t instanceof INamed) {
            return ((INamed)t).getName();
        }
        return t.toString();
    }

    public String getDisplayName(T t) {
        return this.getName(t);
    }

    public String getTooltip(T t) {
        return "";
    }

    public void setName(PyroMod pyroMod, T t, String string) {
        if (t instanceof INamed) {
            try {
                string = Util.validateName(pyroMod, (INamed)t, string);
                SetNameTask setNameTask = new SetNameTask((INamed)t, string);
                pyroMod.getTaskManager().exec(setNameTask, Intl.intl("Rename"));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), exception.getLocalizedMessage(), Intl.intl("Invalid Name"), 0);
            }
        }
    }

    public boolean objectInModel(PyroMod pyroMod, T t) {
        if (!(t instanceof IPyroObject)) {
            return false;
        }
        return ((IPyroObject)t).getDomain() == pyroMod;
    }

    public Object getTreeviewParent(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getParent();
        }
        return null;
    }

    public boolean canRename(PyroMod pyroMod, T t) {
        return t instanceof INamed;
    }

    public Icon[] getIcons(PyroMod pyroMod, T t) {
        return new Icon[]{this.d_icon, null};
    }

    public Font getBaseFont(PyroMod pyroMod, T t) {
        return s_plain;
    }

    public Font getFont(PyroMod pyroMod, T t) {
        Font font = this.getBaseFont(pyroMod, t);
        if (!this.isEnabled(pyroMod, t)) {
            HashMap hashMap = new HashMap(font.getAttributes());
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            font = font.deriveFont(hashMap);
        }
        return font;
    }

    public boolean isVisible(PyroMod pyroMod, T t) {
        if (t instanceof IPyroGeomSrc) {
            return ((IPyroGeomSrc)t).isVisible();
        }
        return true;
    }

    public boolean isEnabled(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).isEnabled();
        }
        return true;
    }

    public boolean isLeaf(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getMembers().isEmpty();
        }
        return false;
    }

    public Object getPasteLocation(PyroMod pyroMod, T t) {
        return this.getCategoryRoot(pyroMod, t);
    }

    public boolean canPaste(PyroMod pyroMod, T t, Object object) {
        return false;
    }

    public boolean canMerge(PyroMod pyroMod, T t) {
        return false;
    }

    public T mergeToRoot(PyroMod pyroMod, T t) {
        return null;
    }

    public boolean isOccluder(PyroMod pyroMod, T t) {
        return true;
    }

    public boolean isDrawingSnappable(PyroMod pyroMod, T t) {
        return true;
    }

    public boolean showInTree(PyroMod pyroMod, T t) {
        T t2 = t;
        Object object = this.getTreeviewParent(pyroMod, t);
        if (object != null) {
            TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
            if (object == pyroMod) {
                return tVEntryPoint.getTreeviewChildren(pyroMod, object).contains(t2);
            }
            return tVEntryPoint.showInTree(pyroMod, object);
        }
        return false;
    }

    public boolean mayBeReferenced(PyroMod pyroMod, T t) {
        return true;
    }

    public boolean getDependentsMayNeedUpdate(PyroMod pyroMod, T t) {
        return t == null ? false : TVEntryPoint.getDependentsNeedUpdate(t.getClass());
    }

    public Object getCategoryRoot(PyroMod pyroMod, T t) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!TVEntryPoints.ep(iPyroObject).isContainer(pyroMod, iPyroObject, t)) continue;
            return iPyroObject;
        }
        return null;
    }

    public Collection<?> getTreeviewChildren(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getMembers();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isContainer(PyroMod pyroMod, T t, Object object) {
        return false;
    }

    public boolean canDelete(PyroMod pyroMod, T t, Object object) {
        return false;
    }

    public boolean preserveIndexOnDelete(PyroMod pyroMod, T t, Object object) {
        return true;
    }

    public boolean add(T t, Object object) {
        return false;
    }

    public boolean addAll(T t, Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            bl &= this.add(t, obj);
        }
        return bl;
    }

    public boolean remove(T t, Object object) {
        return false;
    }

    public boolean removeAll(T t, Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            bl &= this.remove(t, obj);
        }
        return bl;
    }

    public void reorder(T t, Collection<?> collection) {
    }

    public Object getConflict(PyroMod pyroMod, T t, Object object) {
        return null;
    }

    public boolean isEquivalent(PyroMod pyroMod, T t, Object object, Object object2) {
        return object.equals(object2);
    }

    public Task paste(PyroMod pyroMod, T t, Object object, Object object2, ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
        return EmptyTask.INSTANCE;
    }

    public boolean isDroppable(PyroMod pyroMod, T t) {
        return false;
    }

    public boolean canDrop(PyroMod pyroMod, T t, Set<?> set, Object object) {
        return false;
    }

    public Task drop(PyroMod pyroMod, T t, int n, Collection<?> collection) {
        return EmptyTask.INSTANCE;
    }

    public static enum ConflictResolution {
        OVERWRITE_EXISTING,
        RENAME_NEW;

    }
}

