/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSimSelectionModel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.treeview.PyroTreeCellEditor;
import pyrosim.treeview.PyroTreeCellRenderer;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.PyroTreeSelectionHandler;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.AbstractDnDTree;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ContextMenuListener;
import thunderheadeng.gui.ContextMenuModel;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class PyroTreeView
extends AbstractDnDTree
implements ContextMenuModel,
IEventObserver {
    private static final long serialVersionUID = 7688413797899563539L;
    private final PyroMod d_mediator;
    private final PyroTreeModel d_model = (PyroTreeModel)this.getModel();
    private final PyroTreeSelectionHandler d_selectionHandler;
    private final FriendlyExpansionHack d_expansionHack;
    private final SelectionScroller d_selScroll;
    private AutoExpandAction d_autoExpandAction;
    private CollapseAllAction d_collapseAllAction;
    private ExpandAllAction d_expandAllAction;

    public PyroTreeView(PyroMod pyroMod) {
        super(new PyroTreeModel(pyroMod));
        this.d_mediator = pyroMod;
        this.setExpandsSelectedPaths(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        this.setLargeModel(true);
        this.setSelectNodeOnCollapse(false);
        this.setCellRenderer(new PyroTreeCellRenderer(this, this.d_mediator));
        this.setToggleClickCount(0);
        this.setEditable(true);
        this.setCellEditor(new PyroTreeCellEditor(this.d_mediator, this, (PyroTreeCellRenderer)this.getCellRenderer()));
        this.d_selectionHandler = new PyroTreeSelectionHandler(this.d_mediator, this.getSelectionModel(), (PyroTreeModel)this.getModel());
        this.d_expansionHack = new FriendlyExpansionHack(this, this.d_mediator);
        this.d_selScroll = new SelectionScroller(this, this.d_model);
        this.addMouseListener(new MouseEditListener());
        this.addMouseListener(new SelectionRemovalListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "EditNode");
        this.getActionMap().put("EditNode", Actions.getEditNodeAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(113, 0), "Rename");
        this.getActionMap().put("Rename", new guiAction(""){
            private static final long serialVersionUID = -5343334185151088404L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = PyroTreeView.this.getRenameAction();
                if (action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        });
        this.addMouseListener(new ContextMenuListener(this));
        this.expandRootNodes();
        this.getInputMap().put((KeyStroke)Actions.getCopyAction().getValue("AcceleratorKey"), "none");
        this.getInputMap().put((KeyStroke)Actions.getPasteAction().getValue("AcceleratorKey"), "none");
        this.getInputMap().put((KeyStroke)Actions.getCutAction().getValue("AcceleratorKey"), "none");
        ToolTipManager.sharedInstance().registerComponent(this);
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return null;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            this.clearSelection();
            return null;
        }
        if (!this.isPathSelected(treePath)) {
            this.setSelectionPath(treePath);
        }
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            linkedIdentityHashSet.add(treePathArray[i].getLastPathComponent());
        }
        return Actions.getContextMenu(linkedIdentityHashSet);
    }

    private void expandRootNodes() {
        Object object = this.getModel().getRoot();
        for (int i = this.getModel().getChildCount(object) - 1; i >= 0; --i) {
            this.expandRow(i);
        }
    }

    @Override
    public void update(Events events) {
        if (this.d_selectionHandler.lock()) {
            this.d_selectionHandler.unlock();
            this.d_selectionHandler.preUpdate(events);
            this.d_selectionHandler.lock();
            this.d_model.update(events);
            this.d_expansionHack.update(events);
            this.d_selectionHandler.unlock();
            this.d_selectionHandler.update(events);
        }
    }

    public Action getRenameAction() {
        if (this.getSelectionCount() == 1) {
            return this.getRenameAction(this.getSelectionPath());
        }
        return null;
    }

    public Action getRenameAction(TreePath treePath) {
        TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(treePath.getLastPathComponent());
        if (tVEntryPoint.canRename(this.d_mediator, treePath.getLastPathComponent())) {
            return new BeginRenameAction(treePath);
        }
        return null;
    }

    private boolean objectsParentIsSelected(Object object) {
        object = ((PyroTreeModel)this.getModel()).parentForObject(object);
        if (object != null) {
            return this.d_mediator.getSelectionModel().isSelected(object);
        }
        return false;
    }

    public JToggleButton getAutoExpandButton() {
        if (this.d_autoExpandAction == null) {
            this.d_autoExpandAction = new AutoExpandAction(this);
        }
        return PyroGuiUtil.createToolbarToggleButton(this.d_autoExpandAction);
    }

    public JButton getCollapseAllButton() {
        if (this.d_collapseAllAction == null) {
            this.d_collapseAllAction = new CollapseAllAction();
        }
        return PyroGuiUtil.createToolbarButton(this.d_collapseAllAction);
    }

    public JButton getExpandAllButton() {
        if (this.d_expandAllAction == null) {
            this.d_expandAllAction = new ExpandAllAction();
        }
        return PyroGuiUtil.createToolbarButton(this.d_expandAllAction);
    }

    public int getMaxExpandedLevel() {
        int n = 0;
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(this.d_model.pathForObject(this.d_mediator));
        while (enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            int n2 = treePath.getPathCount();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void collapseAll(Object object) {
        this.collapseAll(object, 2);
    }

    public void collapseAll(Object object, int n) {
        TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
        Collection<?> collection = tVEntryPoint.getTreeviewChildren(this.d_mediator, object);
        if (!collection.isEmpty()) {
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                Object obj = object2.next();
                this.collapseAll(obj, n);
            }
            if (object != this.d_mediator && (object2 = this.d_model.pathForObject(object)) != null && ((TreePath)object2).getPathCount() >= n) {
                this.collapsePath((TreePath)object2);
            }
        }
    }

    public void expandAll(Object object) {
        this.expandAll(object, Integer.MAX_VALUE);
    }

    public void expandAll(Object object, int n) {
        TreePath treePath;
        TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
        if (tVEntryPoint == null) {
            return;
        }
        Collection<?> collection = tVEntryPoint.getTreeviewChildren(this.d_mediator, object);
        if (!collection.isEmpty() && (treePath = this.d_model.pathForObject(object)) != null && treePath.getPathCount() <= n) {
            this.expandPath(treePath);
            for (Object obj : collection) {
                this.expandAll(obj, n);
            }
        }
    }

    private static class AutoExpandAction
    extends BooleanAction {
        private static final long serialVersionUID = -4692230488579176836L;
        private PyroTreeView d_tv;
        public static final Icon ICON = PyroGuiUtil.loadTeciIcon("Refresh16.gif");

        public AutoExpandAction(PyroTreeView pyroTreeView) {
            super(Intl.intl("Auto Expand Selection"), true, ICON);
            this.d_tv = pyroTreeView;
            this.d_tv.d_expansionHack.setEnableSelectionTracking(true);
            this.d_tv.d_selScroll.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.d_tv.d_expansionHack.isEnabledSelectionTracking();
            this.d_tv.d_expansionHack.setEnableSelectionTracking(bl);
            this.d_tv.d_selScroll.setEnabled(bl);
            if (bl) {
                PyroMod pyroMod = this.d_tv.d_mediator;
                PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
                Set<?> set = pyroSimSelectionModel.getSelection();
                for (Object obj : set) {
                    TreePath treePath = this.d_tv.d_model.pathForObject(obj);
                    if (treePath == null) continue;
                    this.d_tv.scrollPathToVisible(treePath);
                }
            }
        }
    }

    private class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1711911466070010077L;

        public ExpandAllAction() {
            super(Intl.intl("Expand"), ((BasicTreeUI)PyroTreeView.this.getUI()).getCollapsedIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroTreeView.this.expandAll(PyroTreeView.this.d_mediator, this.getMaxExpand());
        }

        private int getMaxExpand() {
            int n = PyroTreeView.this.getMaxExpandedLevel();
            return n < 2 ? 2 : Integer.MAX_VALUE;
        }
    }

    private class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8659650226613495788L;

        public CollapseAllAction() {
            super(Intl.intl("Collapse"), ((BasicTreeUI)PyroTreeView.this.getUI()).getExpandedIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroTreeView.this.collapseAll(PyroTreeView.this.d_mediator, this.getMinCollapse());
        }

        private int getMinCollapse() {
            int n = PyroTreeView.this.getMaxExpandedLevel();
            return n > 2 ? 3 : 2;
        }
    }

    private class DescendentComp
    implements Comparator<TreePath> {
        private final boolean d_forward;

        public DescendentComp() {
            this(true);
        }

        public DescendentComp(boolean bl) {
            this.d_forward = bl;
        }

        @Override
        public int compare(TreePath treePath, TreePath treePath2) {
            int n;
            if (treePath.equals(treePath2)) {
                return 0;
            }
            int n2 = n = this.d_forward ? 1 : -1;
            if (treePath2.isDescendant(treePath)) {
                return n;
            }
            if (treePath.isDescendant(treePath2)) {
                return -n;
            }
            return 0;
        }
    }

    private class BeginRenameAction
    extends guiAction {
        private static final long serialVersionUID = 1435889790484787750L;
        private TreePath d_tp;

        private BeginRenameAction(TreePath treePath) {
            super(Intl.intl("Rename"));
            this.d_tp = treePath;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroTreeView.this.startEditingAtPath(this.d_tp);
        }
    }

    private class MouseEditListener
    extends MouseAdapter {
        private MouseEditListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = PyroTreeView.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && PyroTreeView.this.getSelectionModel().isPathSelected(treePath) && PyroTreeView.this.getPathBounds(treePath).contains(mouseEvent.getPoint()) && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.paramString());
                guiAction guiAction2 = Actions.getDefaultAction(PyroTreeView.this.d_mediator);
                if (guiAction2 != null) {
                    guiAction2.actionPerformed(actionEvent);
                }
            }
        }
    }

    private class SelectionRemovalListener
    extends MouseAdapter {
        private SelectionRemovalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Pair<TreePath, Boolean> pair = PyroTreeView.this.getExtendedPathForLocationEx(mouseEvent.getX(), mouseEvent.getY());
            if (pair == null) {
                PyroTreeView.this.d_mediator.getSelectionModel().clearSelection();
            } else if (!(((Boolean)pair.v2).booleanValue() || mouseEvent.getButton() != 1 || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                PyroTreeView.this.d_mediator.pauseUpdates();
                PyroTreeView.this.d_mediator.getSelectionModel().clearSelection();
                PyroTreeView.this.d_mediator.getSelectionModel().select(((TreePath)pair.v1).getLastPathComponent());
                PyroTreeView.this.d_mediator.resumeUpdates();
            }
        }
    }

    private static class SelectionScroller
    implements TreeSelectionListener {
        private final JTree d_tree;
        private final IDnDTreeModel d_model;
        private boolean d_enabled;

        public SelectionScroller(JTree jTree, IDnDTreeModel iDnDTreeModel) {
            this.d_tree = jTree;
            this.d_model = iDnDTreeModel;
            this.d_tree.addTreeSelectionListener(this);
            this.d_enabled = false;
        }

        public void setEnabled(boolean bl) {
            this.d_enabled = bl;
        }

        public boolean isEnabled() {
            return this.d_enabled;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.d_enabled && treeSelectionEvent.isAddedPath() && !this.d_model.isDragging()) {
                this.d_tree.scrollPathToVisible(treeSelectionEvent.getNewLeadSelectionPath());
            }
        }
    }

    private class FriendlyExpansionHack {
        private final PyroTreeView d_ptv;
        private boolean d_enableAutoExpand;

        public FriendlyExpansionHack(PyroTreeView pyroTreeView2, PyroMod pyroMod) {
            this.d_ptv = pyroTreeView2;
            this.d_enableAutoExpand = false;
        }

        public void setEnableSelectionTracking(boolean bl) {
            this.d_enableAutoExpand = bl;
        }

        public boolean isEnabledSelectionTracking() {
            return this.d_enableAutoExpand;
        }

        public void update(Events events) {
            PyroTreeModel pyroTreeModel = (PyroTreeModel)this.d_ptv.getModel();
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                TreePath treePath = pyroTreeModel.pathForObject(pyroTreeModel.getRoot());
                pyroTreeModel.fireTreeStructureChanged(new TreeModelEvent((Object)this, treePath));
                PyroTreeView.this.expandRootNodes();
                return;
            }
            if (this.d_enableAutoExpand) {
                Object object;
                LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
                Set<Object> set = events.getEvents(Object.class, PyroMod.class).getAddedObjs();
                for (EventChannel<Object> eventChannel : events.getAffectedChannels(Object.class, PyroMod.class)) {
                    object = TVEntryPoints.ep(eventChannel.getObjectType());
                    if (object == null) continue;
                    for (Object object2 : eventChannel.getAddedObjs()) {
                        Iterator<Object> iterator = ((TVEntryPoint)object).getTreeviewParent(PyroTreeView.this.d_mediator, object2);
                        if (iterator == null || set.contains(iterator)) continue;
                        linkedIdentityHashSet.add(iterator);
                    }
                    PyroSimSelectionModel pyroSimSelectionModel = PyroTreeView.this.d_mediator.getSelectionModel();
                    Set<Object> set22 = eventChannel.getChangedObjs(PyroMod.EVT_SEL);
                    for (Object object3 : set22) {
                        Object object4;
                        if (!pyroSimSelectionModel.isSelected(object3) || pyroSimSelectionModel.isSelected(object4 = ((TVEntryPoint)object).getTreeviewParent(PyroTreeView.this.d_mediator, object3))) continue;
                        linkedIdentityHashSet.add(object4);
                    }
                }
                for (EventChannel<Object> eventChannel : linkedIdentityHashSet) {
                    object = PyroTreeView.this.d_model.pathForObject(eventChannel);
                    if (object == null) continue;
                    PyroTreeView.this.expandPath((TreePath)object);
                }
            }
        }
    }
}

