/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;

public class PyroTreeSelectionHandler
implements TreeSelectionListener {
    private final PyroMod d_pyMod;
    private final TreeSelectionModel d_tsm;
    private final PyroTreeModel d_ptm;
    private final Semaphore d_sema;

    public PyroTreeSelectionHandler(PyroMod pyroMod, TreeSelectionModel treeSelectionModel, PyroTreeModel pyroTreeModel) {
        this.d_pyMod = pyroMod;
        this.d_tsm = treeSelectionModel;
        this.d_ptm = pyroTreeModel;
        this.d_sema = new Semaphore(1);
        treeSelectionModel.addTreeSelectionListener(this);
    }

    public boolean lock() {
        return this.d_sema.tryAcquire();
    }

    public void unlock() {
        this.d_sema.release();
    }

    private boolean containsSelEvents(Events events) {
        for (EventChannel<Object> eventChannel : events.getAffectedChannels(Object.class, new Class[0])) {
            if (!eventChannel.hasAddedObjs() && !eventChannel.hasRemovedObjs() && !eventChannel.containsChange(PyroMod.EVT_SEL) && !eventChannel.containsChange(PyroMod.EVT_MODEL_CHANGED)) continue;
            return true;
        }
        return false;
    }

    public void preUpdate(Events events) {
        if (!this.containsSelEvents(events) || !this.lock()) {
            return;
        }
        this.d_tsm.clearSelection();
        this.unlock();
    }

    public void update(Events events) {
        if (!this.containsSelEvents(events) || !this.lock()) {
            return;
        }
        Set<?> set = this.d_pyMod.getSelectionModel().getSelection();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(set.size());
        for (Object obj : set) {
            TreePath treePath = this.d_ptm.pathForObject(obj);
            if (treePath == null) continue;
            arrayList.add(treePath);
        }
        this.d_tsm.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
        this.unlock();
    }

    private boolean objectInModel(Object object) {
        TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
        if (tVEntryPoint == null) {
            return false;
        }
        return tVEntryPoint.objectInModel(this.d_pyMod, object);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object;
        int n;
        if (this.d_ptm.isDragging()) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        if (treePathArray.length == 0) {
            this.unlock();
            return;
        }
        if (!this.objectInModel(treePathArray[0].getLastPathComponent())) {
            this.d_tsm.clearSelection();
            this.unlock();
            return;
        }
        this.d_pyMod.pauseUpdates();
        for (n = 0; n < treePathArray.length; ++n) {
            assert (treePathArray[n] != null);
            object = treePathArray[n].getLastPathComponent();
            if (treeSelectionEvent.isAddedPath(n)) continue;
            if (object instanceof IPyroObject) {
                if (this.objectsParentIsSelected((IPyroObject)object)) continue;
                this.d_pyMod.getSelectionModel().deselect(object);
                continue;
            }
            this.d_pyMod.getSelectionModel().deselect(object);
        }
        for (n = 0; n < treePathArray.length; ++n) {
            assert (treePathArray[n] != null);
            object = treePathArray[n].getLastPathComponent();
            if (!treeSelectionEvent.isAddedPath(n)) continue;
            this.d_pyMod.getSelectionModel().select(object);
        }
        this.d_pyMod.resumeUpdates();
        this.unlock();
    }

    private boolean objectsParentIsSelected(IPyroObject iPyroObject) {
        IPyroObject iPyroObject2 = iPyroObject.getParent();
        if (iPyroObject2 == null) {
            return false;
        }
        return this.d_pyMod.getSelectionModel().isSelected(iPyroObject2);
    }
}

