/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class PyroTreeModel
implements IDnDTreeModel {
    private final PyroMod d_mediator;
    private final List<TreeModelListener> d_listeners;
    private boolean d_dragging;
    private Map<Object, SortCache> d_caches;

    public PyroTreeModel(PyroMod pyroMod) {
        this.d_mediator = pyroMod;
        this.d_listeners = new ArrayList<TreeModelListener>();
        this.d_dragging = false;
        this.d_caches = new IdentityHashMap<Object, SortCache>();
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.d_listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.d_listeners.remove(treeModelListener);
    }

    public <T> TVEntryPoint<T> ep(T t) {
        return TVEntryPoints.ep(t);
    }

    @Override
    public Object getRoot() {
        return this.d_mediator;
    }

    private void invalidateCaches() {
        this.d_caches.clear();
    }

    private void invalidateChildCaches(Collection<?> collection) {
        this.d_caches.keySet().removeAll(collection);
    }

    private SortCache getSortCache(Object object) {
        TVEntryPoint<Object> tVEntryPoint;
        SortCache sortCache = this.d_caches.get(object);
        if (sortCache == null && (tVEntryPoint = this.ep(object)) != null) {
            sortCache = new SortCache(tVEntryPoint.getTreeviewChildren(this.d_mediator, object));
            this.d_caches.put(object, sortCache);
        }
        return sortCache;
    }

    @Override
    public boolean isLeaf(Object object) {
        TVEntryPoint<Object> tVEntryPoint = this.ep(object);
        if (tVEntryPoint == null) {
            return true;
        }
        return tVEntryPoint.isLeaf(this.d_mediator, object);
    }

    @Override
    public int getChildCount(Object object) {
        SortCache sortCache = this.getSortCache(object);
        if (sortCache == null) {
            return 0;
        }
        return sortCache.size();
    }

    @Override
    public Object getChild(Object object, int n) {
        SortCache sortCache = this.getSortCache(object);
        assert (sortCache != null);
        return sortCache.get(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        SortCache sortCache = this.getSortCache(object);
        assert (sortCache != null);
        return sortCache.indexOf(object2);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        String string = ((String)object).trim();
        if (string.isEmpty()) {
            return;
        }
        TVEntryPoint<Object> tVEntryPoint = this.ep(object2);
        if (tVEntryPoint != null && tVEntryPoint.canRename(this.d_mediator, object2)) {
            tVEntryPoint.setName(this.d_mediator, object2, string);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.d_listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.d_listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.d_listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.d_listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    public TreePath pathForObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object == this.getRoot()) {
            return new TreePath(object);
        }
        TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
        if (!tVEntryPoint.showInTree(this.d_mediator, object)) {
            return null;
        }
        Object object2 = object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (object2 != null) {
            arrayList.add(object2);
            object2 = this.parentForObject(object2);
        }
        if (arrayList.isEmpty() || arrayList.get(arrayList.size() - 1) != this.getRoot()) {
            System.err.println("returning null tree path for: " + object.getClass().getName());
            return null;
        }
        Object[] objectArray = new Object[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            objectArray[arrayList.size() - i - 1] = arrayList.get(i);
        }
        return new TreePath(objectArray);
    }

    public Object parentForObject(Object object) {
        TVEntryPoint<Object> tVEntryPoint = this.ep(object);
        return tVEntryPoint.getTreeviewParent(this.d_mediator, object);
    }

    public void update(Events events) {
        Serializable serializable;
        if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) {
            this.invalidateCaches();
        } else {
            this.invalidateChildCaches(events.getEvents(IPyroObject.class, new Class[0]).getChangedObjs(PyroMod.EVT_CHILDREN_ADDED, PyroMod.EVT_CHILDREN_REMOVED, PyroMod.EVT_CHILDREN_CHANGED));
        }
        Set<Object> set = new LinkedIdentityHashSet();
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        Set<Object> set2 = new LinkedIdentityHashSet();
        boolean bl = false;
        IEventRecord<IPyroObject> iEventRecord = events.getEvents(IPyroObject.class, new Class[0]);
        set.addAll(iEventRecord.getChangedObjs(PyroMod.EVT_CHILDREN_CHANGED, PyroMod.EVT_CHILDREN_REMOVED));
        set2.addAll(iEventRecord.getAddedObjs());
        set2.addAll(iEventRecord.getChangedObjs(PyroMod.EVT_PARENT_CHANGED));
        linkedIdentityHashSet.addAll(iEventRecord.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_PARENT_CHANGED));
        bl |= !events.getAffectedChannels(SimParams.Misc.class, new Class[0]).isEmpty();
        set2 = this.pruneToHighestParents(set2);
        for (TreeModelEvent object2 : this.toEvents(set2, SortMethod.ASCENDING)) {
            this.fireTreeNodesInserted(object2);
        }
        set = this.pruneToHighestParents(set);
        for (Object object : set) {
            serializable = this.pathForObject(object);
            if (serializable == null) continue;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, (TreePath)serializable));
        }
        List<TreeModelEvent> list = this.toEvents(linkedIdentityHashSet, SortMethod.NONE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            serializable = (TreeModelEvent)iterator.next();
            this.fireTreeNodesChanged((TreeModelEvent)serializable);
        }
        if (bl) {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.pathForObject(this.d_mediator.getSurfaceMgr())));
        }
    }

    private Set<Object> pruneToHighestParents(Set<?> set) {
        LinkedIdentityHashSet<Object> linkedIdentityHashSet = new LinkedIdentityHashSet<Object>(set.size());
        for (Object obj : set) {
            if (this.containsParent(set, obj)) continue;
            linkedIdentityHashSet.add(obj);
        }
        return linkedIdentityHashSet;
    }

    private boolean containsParent(Set<?> set, Object object) {
        TVEntryPoint<Object> tVEntryPoint;
        while (object != null && (tVEntryPoint = this.ep(object)) != null) {
            Object object2 = tVEntryPoint.getTreeviewParent(this.d_mediator, object);
            if (object2 != null && set.contains(object2)) {
                return true;
            }
            object = object2;
        }
        return false;
    }

    private <E> List<TreeModelEvent> toEvents(Collection<E> collection, final SortMethod sortMethod) {
        Predicate<Object> predicate = new Predicate<Object>(){

            @Override
            public boolean test(Object object) {
                return TVEntryPoints.ep(object).showInTree(PyroTreeModel.this.d_mediator, object);
            }
        };
        Map<Object, List<E>> map = this.getParentChildMap(collection);
        ArrayList<TreeModelEvent> arrayList = new ArrayList<TreeModelEvent>(map.size());
        for (Map.Entry<Object, List<E>> entry : map.entrySet()) {
            Object object;
            final Object object2 = entry.getKey();
            List<E> list = entry.getValue();
            TreePath treePath = this.pathForObject(object2);
            if (treePath == null) continue;
            Object[] objectArray = theUtil.filter(list, predicate).toArray();
            if (sortMethod != SortMethod.NONE) {
                object = new Comparator<Object>(){

                    @Override
                    public int compare(Object object, Object object22) {
                        return sortMethod == SortMethod.ASCENDING ? PyroTreeModel.this.getIndexOfChild(object2, object) - PyroTreeModel.this.getIndexOfChild(object2, object22) : PyroTreeModel.this.getIndexOfChild(object2, object22) - PyroTreeModel.this.getIndexOfChild(object2, object);
                    }
                };
                Arrays.sort(objectArray, object);
            }
            object = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object[i] = this.getIndexOfChild(object2, objectArray[i]);
            }
            arrayList.add(new TreeModelEvent((Object)this, treePath, (int[])object, objectArray));
        }
        return arrayList;
    }

    private <E> Map<Object, List<E>> getParentChildMap(Collection<E> collection) {
        LinkedIdentityHashMap<Object, List<E>> linkedIdentityHashMap = new LinkedIdentityHashMap<Object, List<E>>();
        for (E e : collection) {
            Object object = this.parentForObject(e);
            if (object == null) continue;
            ArrayList<E> arrayList = (ArrayList<E>)linkedIdentityHashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<E>();
                linkedIdentityHashMap.put(object, arrayList);
            }
            arrayList.add(e);
        }
        return linkedIdentityHashMap;
    }

    @Override
    public IDnDTreeModel.IDragPacket preparePacket(List<? extends TreePath> list) {
        return new DragPacket(list);
    }

    @Override
    public boolean canDrop(IDnDTreeModel.IDragPacket iDragPacket, Object object) {
        if (object == null) {
            return false;
        }
        DragPacket dragPacket = (DragPacket)iDragPacket;
        TVEntryPoint<Object> tVEntryPoint = this.ep(object);
        return tVEntryPoint.canDrop(this.d_mediator, object, dragPacket.objs, dragPacket.commonParent);
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket iDragPacket, Object object, int n) {
        DragPacket dragPacket = (DragPacket)iDragPacket;
        TVEntryPoint<Object> tVEntryPoint = this.ep(object);
        Task task = tVEntryPoint.drop(this.d_mediator, object, n, dragPacket.objs);
        this.d_mediator.getTaskManager().exec(task, Intl.intl("Reorder Objects"));
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket iDragPacket, Object object) {
        this.drop(iDragPacket, object, 0);
    }

    @Override
    public void setDragging(boolean bl) {
        this.d_dragging = bl;
    }

    @Override
    public boolean isDragging() {
        return this.d_dragging;
    }

    @Override
    public boolean isLeafDroppable(Object object) {
        return TVEntryPoints.ep(object).isDroppable(this.d_mediator, object);
    }

    public static class DragPacket
    extends IDnDTreeModel.DefaultDragPacket {
        public final Set<Object> objs;
        public final IPyroObject commonParent;

        public DragPacket(List<? extends TreePath> list) {
            super(list);
            this.objs = new LinkedIdentityHashSet<Object>(list.size());
            for (TreePath treePath : list) {
                this.objs.add(treePath.getLastPathComponent());
            }
            this.commonParent = Hierarchy.getCommonParent(theUtil.filter(this.objs, IPyroObject.class));
        }
    }

    private static enum SortMethod {
        NONE,
        ASCENDING,
        DESCENDING;

    }
}

