/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import pyrosim.PyroMod;
import pyrosim.treeview.PyroTreeCellRenderer;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.PyroTreeView;
import pyrosim.treeview.TVEntryPoint;

public class PyroTreeCellEditor
extends DefaultTreeCellEditor
implements TreeCellEditor {
    private final PyroMod d_mediator;
    private Object d_curVal;

    public PyroTreeCellEditor(PyroMod pyroMod, PyroTreeView pyroTreeView, PyroTreeCellRenderer pyroTreeCellRenderer) {
        super(pyroTreeView, pyroTreeCellRenderer);
        this.d_mediator = pyroMod;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        TVEntryPoint<Object> tVEntryPoint = ((PyroTreeModel)jTree.getModel()).ep(object);
        if (tVEntryPoint == null) {
            return null;
        }
        String string = tVEntryPoint.getName(object);
        Component component = super.getTreeCellEditorComponent(jTree, string, bl, bl2, bl3, n);
        Icon[] iconArray = tVEntryPoint.getIcons(this.d_mediator, object);
        this.editingIcon = !component.isEnabled() && iconArray[1] != null ? iconArray[1] : iconArray[0];
        return component;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        PyroTreeView pyroTreeView = (PyroTreeView)this.tree;
        if (pyroTreeView.getSelectionCount() != 1) {
            return false;
        }
        Object object = pyroTreeView.getSelectionPath().getLastPathComponent();
        TVEntryPoint<Object> tVEntryPoint = ((PyroTreeModel)pyroTreeView.getModel()).ep(object);
        return super.isCellEditable(eventObject) && tVEntryPoint != null && tVEntryPoint.canRename(this.d_mediator, object);
    }

    private Object objectFor(EventObject eventObject) {
        MouseEvent mouseEvent;
        TreePath treePath;
        if (eventObject instanceof MouseEvent && (treePath = this.tree.getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }
}

