/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.io.IOUtil;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSParser;

public class UnsupportedParamTest {
    public UnsupportedParamTest(File file) throws IOException, FDSParseException, URISyntaxException {
        Object object;
        Object object2;
        Serializable serializable2;
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = (Integer)hashMap.get(string);
                int n2 = (Integer)hashMap.get(string2);
                return -Double.compare(n, n2);
            }
        };
        PrintWriter printWriter = new PrintWriter(new File("D:\\Docs\\validation_log.txt"));
        ArrayList arrayList = (ArrayList)this.getAllFiles(file);
        FDSFileFilter fDSFileFilter = new FDSFileFilter();
        for (Serializable serializable2 : arrayList) {
            if (!fDSFileFilter.accept((File)serializable2)) continue;
            printWriter.printf("%nParsing %s%n", ((File)serializable2).getName());
            object2 = null;
            try {
                object2 = this.readFDS5File(((File)serializable2).getAbsolutePath());
            }
            catch (Throwable throwable) {
                printWriter.printf("   Error parsing file.%n   %s%n   %s%n", throwable.getClass().getSimpleName(), throwable.getMessage());
                continue;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                FDSParseWarning fDSParseWarning = (FDSParseWarning)object.next();
                printWriter.printf("   Warning: %s   Line: %s   Action Taken: %s   Record Text: %s%n", fDSParseWarning.getWarningInfo(0), fDSParseWarning.getWarningInfo(2), fDSParseWarning.getWarningInfo(1), fDSParseWarning.getWarningInfo(3));
                String string = fDSParseWarning.getWarningInfo(0).toString();
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, 1);
                    continue;
                }
                hashMap.put(string, (Integer)hashMap.get(string) + 1);
            }
        }
        printWriter.close();
        PrintWriter printWriter2 = new PrintWriter(new File("C:\\Users\\albrecht\\Documents\\fds-smv-read-only\\mapped_verification_log.txt"));
        serializable2 = new ArrayList(hashMap.keySet());
        Collections.sort(serializable2, comparator);
        object2 = serializable2.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            printWriter2.printf("%d\t    %s%n", hashMap.get(object), object);
        }
        printWriter2.close();
    }

    public List getAllFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : IOUtil.listFiles(file)) {
            if (file2.isDirectory()) {
                ArrayList arrayList2 = (ArrayList)this.getAllFiles(file2);
                arrayList.addAll(arrayList2);
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    public Collection<FDSParseWarning> readFDS5File(String string) throws IOException, FDSParseException {
        PyroMod pyroMod = new PyroMod(true);
        FDSParser fDSParser = FDS.newParser(6);
        FDSParseResult fDSParseResult = fDSParser.parseFile(string, pyroMod);
        return fDSParseResult.warningReport.getWarnings();
    }

    public static void main(String[] stringArray) {
        try {
            new UnsupportedParamTest(new File("D:\\Docs\\FDS Repo\\Validation"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }

    static {
        new PyroSim(false);
    }

    public class FDSFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith("fds");
        }
    }
}

