/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.io.FilenameManager;

public class TestRoundTrip
extends TestCase {
    public TestRoundTrip(String string) {
        super(string);
    }

    protected void tearDown() {
    }

    public void test_blockFds() throws Throwable {
        this.compareRoundTripImportFds(((Object)((Object)this)).getClass().getResource("testfiles/block.fds"));
    }

    public void test_burnerFds() throws Throwable {
        this.compareRoundTripImportFds(((Object)((Object)this)).getClass().getResource("testfiles/burner.fds"));
    }

    public void test_jetFanFds() throws Throwable {
        this.compareRoundTripImportFds(((Object)((Object)this)).getClass().getResource("testfiles/JetFan.fds"));
    }

    public void test_smokeFds() throws Throwable {
        this.compareRoundTripImportFds(((Object)((Object)this)).getClass().getResource("testfiles/smoke.fds"));
    }

    public void test_switchgearFds() throws Throwable {
        this.compareRoundTripImportFds(((Object)((Object)this)).getClass().getResource("testfiles/switchgear.fds"));
    }

    private void compareRoundTripImportFds(URL uRL) throws Throwable {
        File file = new File(uRL.toURI());
        PyroMod pyroMod = this.readFDS5File(file.getAbsolutePath());
        Serialized serialized = (Serialized)pyroMod.getLockObj();
        String[] stringArray = FilenameManager.splitFilename(file.getName());
        File file2 = File.createTempFile(stringArray[0], null);
        file2.deleteOnExit();
        FDSRenderer fDSRenderer = FDS.newRenderer(pyroMod, PyroSim.getApp().getFDSRenderProps());
        fDSRenderer.renderFile(file2);
        pyroMod = this.readFDS5File(file2.getAbsolutePath());
        Serialized serialized2 = (Serialized)pyroMod.getLockObj();
        boolean bl = this.isSerialziedEqual(serialized2, serialized);
        TestRoundTrip.assertTrue((boolean)bl);
    }

    public PyroMod readFDS5File(String string) throws IOException, FDSParseException {
        PyroMod pyroMod = new PyroMod(true);
        FDSParser fDSParser = FDS.newParser(6);
        FDSParseResult fDSParseResult = fDSParser.parseFile(string, pyroMod);
        fDSParseResult.warningReport.showWarnings(true);
        return pyroMod;
    }

    public boolean isSerialziedEqual(Serialized serialized, Serialized serialized2) throws IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray = Serialized.class.getFields();
        int n = 0;
        for (Field field : fieldArray) {
            Object object = field.get(serialized);
            Object object2 = field.get(serialized2);
            if (!(object instanceof Composite)) continue;
            object2.getClass().getName();
            boolean bl = this.isCompositeEqual((Composite)object2, (Composite)object);
            System.out.printf("newSer.%s.equals(oldSer.%s): %s%n", field.getName(), field.getName(), bl);
            if (bl) continue;
            ++n;
            this.isCompositeEqual((Composite)object2, (Composite)object, true);
        }
        return n == 0;
    }

    public boolean isCompositeEqual(Composite<IPyroObject> composite, Composite<IPyroObject> composite2) {
        return this.isCompositeEqual(composite, composite2, false);
    }

    public boolean isCompositeEqual(Composite<IPyroObject> composite, Composite<IPyroObject> composite2, boolean bl) {
        int n = 0;
        Collection<IPyroObject> collection = composite.flatten();
        Collection<IPyroObject> collection2 = composite2.flatten();
        boolean bl2 = false;
        if (collection.size() != collection2.size()) {
            if (bl) {
                System.err.printf("     %s: Composite objects do not have the same number of elements.%n", composite.getType().getSimpleName());
            }
            return false;
        }
        Iterator<IPyroObject> iterator = collection.iterator();
        Iterator<IPyroObject> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            IPyroObject iPyroObject = iterator.next();
            IPyroObject iPyroObject2 = iterator2.next();
            boolean bl3 = false;
            if (DeepEquals.deepEquals(iPyroObject, iPyroObject2, bl)) {
                ++n;
                bl3 = true;
            }
            if (!bl) continue;
            String string = iPyroObject.getClass().getSimpleName();
            String string2 = iPyroObject instanceof NamedPyroObject ? ((NamedPyroObject)iPyroObject).getName() : iPyroObject.toString();
            String[] stringArray = string2.split("[\\W]");
            string2 = stringArray[stringArray.length - 1];
            if (bl3) continue;
            System.out.printf("     %s.equals(%s): %s%n", string, string, bl3);
            System.out.println("          Name: " + string2);
        }
        if (n == collection.size()) {
            bl2 = true;
        }
        return bl2;
    }

    static {
        new PyroSim(false);
    }

    public static class DeepEquals {
        private static ArrayDeque d_checked;

        public static boolean deepEquals(Object object, Object object2, boolean bl) {
            if (object == object2) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            if (object.getClass() != object2.getClass()) {
                return false;
            }
            d_checked = new ArrayDeque();
            if (DeepEquals.checkDeclaredEquals(object.getClass())) {
                return object.equals(object2);
            }
            return DeepEquals.checkFields(object, object2, bl);
        }

        private static void showNullMessage(String string, String string2, Object object) {
            System.err.printf("     Null Object: %s     Class: %s     Comparing Value: %s%n", string, string2, object);
        }

        private static boolean checkFields(Object object, Object object2, boolean bl) {
            if (object == object2) {
                return true;
            }
            if (object == null) {
                if (bl) {
                    DeepEquals.showNullMessage(object2.toString(), object2.getClass().getSimpleName(), object2);
                }
                return false;
            }
            if (object2 == null) {
                if (bl) {
                    DeepEquals.showNullMessage(object.toString(), object.getClass().getSimpleName(), object);
                }
                return false;
            }
            Class<?> clazz = object.getClass();
            int n = 0;
            int n2 = 0;
            while (clazz != null) {
                int n3 = clazz.getDeclaredFields().length;
                int n4 = 0;
                if (d_checked.contains(clazz)) break;
                d_checked.add(clazz);
                for (Field field : clazz.getDeclaredFields()) {
                    if (!DeepEquals.checkSingleField(clazz, field, object, object2, bl)) continue;
                    ++n4;
                }
                if (n4 == n3) {
                    ++n2;
                }
                clazz = clazz.getEnclosingClass() != null ? clazz.getEnclosingClass() : clazz.getSuperclass();
                ++n;
            }
            return n2 == n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean checkSingleField(Class clazz, Field field, Object object, Object object2, boolean bl) {
            boolean bl2 = field.isAccessible();
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (field.get(object) == field.get(object2)) {
                    boolean bl4 = true;
                    return bl4;
                }
                if (field.getType().isPrimitive()) {
                    Class<?> clazz2 = field.getType();
                    if (clazz2 == Boolean.TYPE) {
                        Boolean bl5 = field.getBoolean(object);
                        boolean bl6 = bl5.equals(field.get(object2));
                        return bl6;
                    }
                    if (clazz2 == Character.TYPE) {
                        Character c = Character.valueOf(field.getChar(object));
                        boolean bl7 = c.equals(field.get(object2));
                        return bl7;
                    }
                    if (clazz2 == Byte.TYPE) {
                        Byte by = field.getByte(object);
                        boolean bl8 = by.equals(field.get(object2));
                        return bl8;
                    }
                    if (clazz2 == Short.TYPE) {
                        Short s = field.getShort(object2);
                        boolean bl9 = s.equals(field.get(object2));
                        return bl9;
                    }
                    if (clazz2 == Integer.TYPE) {
                        Integer n = field.getInt(object);
                        boolean bl10 = n.equals(field.get(object2));
                        return bl10;
                    }
                    if (clazz2 == Long.TYPE) {
                        Long l = field.getLong(object);
                        boolean bl11 = l.equals(field.get(object2));
                        return bl11;
                    }
                    if (clazz2 == Float.TYPE) {
                        Float f = Float.valueOf(field.getFloat(object));
                        boolean bl12 = f.equals(field.get(object2));
                        return bl12;
                    }
                    if (clazz2 == Double.TYPE) {
                        Double d = field.getDouble(object);
                        boolean bl13 = d.equals(field.get(object2));
                        return bl13;
                    }
                } else if (DeepEquals.checkDeclaredEquals(field.getType())) {
                    if (field.get(object).equals(field.get(object2))) {
                        boolean bl14 = true;
                        return bl14;
                    }
                    if (bl) {
                        System.err.println("    The equals method didn't work for: " + field.getType());
                        System.err.printf("        object1: %s  object2: %s%n", field.get(object), field.get(object2));
                    }
                } else if (DeepEquals.checkFields(field.get(object), field.get(object2), bl)) {
                    boolean bl15 = true;
                    return bl15;
                }
            }
            catch (Throwable throwable) {
                System.err.printf("          Exception:  %s:%s%n", throwable.getClass().getName(), throwable.getMessage());
                System.err.printf("             Class: %s  Field: %s%n", clazz.getName(), field.getName());
            }
            finally {
                field.setAccessible(bl2);
            }
            return false;
        }

        private static boolean checkDeclaredEquals(Class clazz) {
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz == SimParams.class) {
                return false;
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals("equals")) continue;
                return true;
            }
            return false;
        }

        public static int hashCode(Object object) {
            return object.hashCode();
        }
    }
}

