/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import pyrosim.OpenModel;
import pyrosim.PyroMod;
import pyrosim.io.IOUtil;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.mv.ModelView;
import thunderheadeng.io.CopyFile;

public class LoaderWriterInputGen {
    private static Logger LOG;
    private static Throwable LAST_ERROR;

    private static void log(String string) {
        LOG.log(string);
    }

    private static void deltree(File file, boolean bl) {
        if (!file.exists()) {
            return;
        }
        for (File file2 : IOUtil.listFiles(file)) {
            if (file2.isDirectory()) {
                LoaderWriterInputGen.deltree(file2, false);
            }
            file2.delete();
        }
        if (bl) {
            file.delete();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("\\\\halo\\thunderhead\\Projects\\PyroSim\\Legacy PSM Files - PyroSim 2012 compatible");
        File file2 = new File("\\\\halo\\thunderhead\\Projects\\PyroSim\\Legacy PSM Files - PyroSim 2012 compatible\\test-output");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        LoaderWriterInputGen.deltree(file2, false);
        LOG = new Logger(new File(file2, "load.txt"));
        LoaderWriterInputGen.proc(file2, file);
        LOG.close();
    }

    public static void proc(File file, File file2) throws IOException {
        LOG.log("Processing folder: " + file2.getName());
        long l = System.currentTimeMillis();
        for (File file3 : IOUtil.listFiles(file2)) {
            if (file3.equals(file)) continue;
            if (file3.isDirectory()) {
                LoaderWriterInputGen.proc(new File(file, file3.getName()), file3);
                continue;
            }
            if (!file3.getPath().toUpperCase().endsWith("PSM")) continue;
            LoaderWriterInputGen.procFile(file, file3);
        }
        String string = String.format("%1.1f", (double)(System.currentTimeMillis() - l) / 1000.0);
        LOG.log(file2.getName() + " processed in " + (String)string + " seconds");
    }

    private static String getError(int n) {
        String string = "Unknown Error: " + n;
        if (n == 0) {
            string = "";
        }
        if (n == 2) {
            string = "Error 2: TOO OLD";
        }
        if (n == 3) {
            string = "Error 3: TOO NEW";
        }
        if (n == 4) {
            string = "Error 4: FAILED";
        }
        if (n != 0 && LAST_ERROR != null) {
            string = String.format("%s - %s (%s)", string, LAST_ERROR.getClass().getName(), LAST_ERROR.getMessage());
            LAST_ERROR.printStackTrace();
            LAST_ERROR = null;
        }
        return string;
    }

    public static void procFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            LoaderWriterInputGen.log("creating folder: " + file.getName());
            file.mkdirs();
        }
        File file3 = new File(file, file2.getName());
        LoaderWriterInputGen.log(String.format(" -> \"%s\"", file3.getName()));
        CopyFile.copy(file2, file3);
        PyroMod pyroMod = new PyroMod();
        int n = OpenModel.openModel(pyroMod, file2, false, new OpenModelCbStub());
        if (n != 0) {
            LoaderWriterInputGen.log("!!!!!!!!!!!!!!!!!");
            LoaderWriterInputGen.log("!!! " + LoaderWriterInputGen.getError(n));
            LoaderWriterInputGen.log("!!!!!!!!!!!!!!!!!");
            return;
        }
        LoaderWriterInputGen.log("    model opened!");
        assert (n == 0);
        File file4 = new File(file, file2.getName() + ".fds6");
        FDSRenderer fDSRenderer = FDS.newRenderer(pyroMod, new FDSRenderProps());
        try {
            fDSRenderer.renderFile(file4);
            LoaderWriterInputGen.log("    render complete!");
        }
        catch (Throwable throwable) {
            String string = String.format("Error writing FDS file - %s (%s)", throwable.getClass().getName(), throwable.getMessage());
            LoaderWriterInputGen.log("!!!!!!!!!!!!!!!!!");
            LoaderWriterInputGen.log("!!! " + string);
            LoaderWriterInputGen.log("!!!!!!!!!!!!!!!!!");
            return;
        }
    }

    private static class OpenModelCbStub
    implements OpenModel.Callbacks {
        private OpenModelCbStub() {
        }

        @Override
        public void setError(Throwable throwable) {
            LAST_ERROR = throwable;
        }

        @Override
        public boolean doBackup() {
            return true;
        }

        @Override
        public void setSnapToSpacing(double d) {
        }

        @Override
        public void setShowBgImagesSelected(boolean bl) {
        }

        @Override
        public void setActiveSnapper(int n) {
        }

        @Override
        public void setModelViewFilters(ModelView.ModelViewFilterProps modelViewFilterProps) {
        }

        @Override
        public boolean confirmOpenUnsupported(int n) {
            return true;
        }
    }

    private static class Logger {
        private PrintStream d_out;
        private SimpleDateFormat d_fmtDateTime;
        private SimpleDateFormat d_fmtTime;

        public Logger(File file) throws Exception {
            this.d_out = new PrintStream(file);
            this.d_fmtDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.d_fmtTime = new SimpleDateFormat("HH:mm:ss");
            this.d_out.printf("Hi! I'm a log. We will have fun together. - Logger at %s%n", this.d_fmtDateTime.format(new Date()));
        }

        public void log(String string) {
            this.d_out.printf("[%s] %s%n", this.d_fmtTime.format(new Date()), string);
        }

        public void close() {
            this.d_out.close();
        }
    }
}

