/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.recordview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSPrintRenderer;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.SyntaxMap;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.theUtil;

public class RecordView
extends guiPanel
implements IEventObserver,
ColorChangedListener {
    private static final long serialVersionUID = 5094944977612462311L;
    private static final String s_selStyle = "sel";
    private PyroMod d_mediator;
    private JTextPane d_unproc;
    private TextPane d_proc;
    private TextPaneWithLineNumbers d_lineNos;
    private JScrollPane d_procScroller;
    private JScrollPane d_unprocScroller;
    private JSplitPane d_splitter;
    private boolean d_modified;
    private boolean d_dirty;
    private boolean d_selDirty;
    private boolean d_renderingRecords = false;
    private Map<IPyroObject, ObjDisp> d_displays;
    private ArrayList<ObjDisp> d_displayList;
    private ArrayList<ObjDisp> d_selDisplays;
    Style d_keyWordStyle;
    Style d_specCharStyle;
    Style d_referenceStyle;
    Style d_valueStyle;
    Style d_commentStyle;
    private final guiAction FontBiggerAction = new FontBiggerAction();
    private final guiAction FontSmallerAction = new FontSmallerAction();

    public RecordView(PyroMod pyroMod) {
        guiAction[] guiActionArray;
        this.d_mediator = pyroMod;
        this.d_displays = Collections.EMPTY_MAP;
        this.d_displayList = new ArrayList(0);
        this.d_selDisplays = this.d_displayList;
        this.d_dirty = true;
        this.d_selDirty = true;
        this.d_mediator.getEvents().addObserver(this);
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.setLayout(new BorderLayout());
        guiPanel2.add((Component)new JLabel(Intl.intl("Model Records (Read-Only)") + ":"), "North");
        this.d_proc = new TextPane(this.createStyledDocument(), new SyntaxMap());
        this.d_proc.setEditable(false);
        this.d_proc.addCaretListener(caretEvent -> {
            if (this.d_renderingRecords) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.updateModelSel());
        });
        this.d_proc.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    RecordView.this.clearSelection();
                }
            }
        });
        this.d_lineNos = new TextPaneWithLineNumbers(this.d_proc);
        this.d_procScroller = new JScrollPane(this.d_lineNos);
        this.d_procScroller.getViewport().setBackground(this.d_proc.getBackground());
        this.d_procScroller.addMouseWheelListener(mouseWheelEvent -> {
            if (mouseWheelEvent.isControlDown()) {
                this.setTextSize(this.d_proc.getFont().getSize() - mouseWheelEvent.getWheelRotation());
            }
        });
        guiPanel2.add((Component)this.d_procScroller, "Center");
        guiPanel guiPanel3 = new guiPanel();
        guiPanel3.setLayout(new BorderLayout());
        guiPanel3.add((Component)new JLabel(Intl.intl("Additional Records:")), "North");
        this.d_unproc = new UnprocessedPane();
        this.d_unproc.setFont(this.d_proc.getFont());
        this.d_unproc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.recsModified();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.recsModified();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.recsModified();
            }

            private void recsModified() {
                RecordView.this.d_modified = true;
            }
        });
        this.d_unproc.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (RecordView.this.d_modified && !focusEvent.isTemporary()) {
                    RecordView.this.applyChanges();
                    RecordView.this.d_modified = false;
                }
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        Consumer<UnprocAction> consumer = unprocAction -> {
            JMenuItem jMenuItem = new JMenuItem(this.d_unproc.getActionMap().get(((UnprocAction)unprocAction).lookupStr));
            jMenuItem.setText(((UnprocAction)unprocAction).displayStr);
            jPopupMenu.add(jMenuItem);
        };
        consumer.accept(UnprocAction.CUT);
        consumer.accept(UnprocAction.COPY);
        consumer.accept(UnprocAction.PASTE);
        jPopupMenu.addSeparator();
        consumer.accept(UnprocAction.SELECTALL);
        this.d_unproc.setComponentPopupMenu(jPopupMenu);
        this.d_unprocScroller = new JScrollPane(this.d_unproc);
        guiPanel3.add((Component)this.d_unprocScroller, "Center");
        this.d_splitter = new JSplitPane(0, true, guiPanel2, guiPanel3);
        this.setLayout(new BorderLayout());
        this.d_splitter.setResizeWeight(0.75);
        this.updateFontSizes(null);
        guiToolBar guiToolBar2 = new guiToolBar();
        guiToolBar2.setFloatable(false);
        guiToolBar2.add(new FontBiggerAction());
        guiToolBar2.add(new FontSmallerAction());
        Utils.noToolBarFocus(guiToolBar2);
        this.add((Component)guiToolBar2, "North");
        this.add((Component)this.d_splitter, "Center");
        for (guiAction guiAction2 : guiActionArray = new guiAction[]{Actions.getDeleteAction(), Actions.getPasteAction(), Actions.getCutAction(), Actions.getCopyAction()}) {
            for (KeyStroke keyStroke : guiAction2.getAccelerators()) {
                this.d_proc.getInputMap().put(keyStroke, "none");
            }
        }
    }

    public TextPane getModelRecords() {
        return this.d_proc;
    }

    @Override
    public void colorChanged(ColorChangedEvent colorChangedEvent) {
        this.updateColors();
        this.d_proc.updateSyntax();
    }

    private void updateFontSizes(Font font) {
        Object object;
        float f = 12.0f;
        PyroSim pyroSim = PyroSim.getApp();
        if (pyroSim != null) {
            f = PyroPrefs.getFloat(PyroPrefs.RECORD_VIEW_FONTSIZE);
        }
        if (font == null) {
            Font[] fontArray;
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font2 : fontArray = ((GraphicsEnvironment)object).getAllFonts()) {
                if (!font2.getFamily().equals("Consolas")) continue;
                font = font2.deriveFont(0, 12.0f);
                break;
            }
            if (font == null) {
                font = new Font("monospaced", 0, 12);
            }
        }
        object = font.deriveFont(f);
        this.d_proc.setFont((Font)object);
        this.d_unproc.setFont((Font)object);
        this.d_lineNos.setFont((Font)object);
    }

    private StyledDocument createStyledDocument() {
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        this.d_keyWordStyle = defaultStyledDocument.addStyle("SYMBOL_KEYWORD", null);
        this.d_specCharStyle = defaultStyledDocument.addStyle("SYMBOL_SPECIAL", null);
        this.d_referenceStyle = defaultStyledDocument.addStyle("SYMBOL_REFERENCE", null);
        this.d_valueStyle = defaultStyledDocument.addStyle("SYMBOL_VALUE", null);
        this.d_commentStyle = defaultStyledDocument.addStyle("SYMBOL_COMMENT", null);
        defaultStyledDocument.addStyle("SYMBOL_EMPTY", null);
        this.updateStyles();
        return defaultStyledDocument;
    }

    private void updateStyles() {
        ColorScheme colorScheme = PyroSim.getApp().getColorScheme();
        StyleConstants.setForeground(this.d_keyWordStyle, colorScheme.getColor(PyroSimColors.FDS_KEYWORD_COLOR));
        StyleConstants.setBold(this.d_keyWordStyle, true);
        StyleConstants.setForeground(this.d_specCharStyle, colorScheme.getColor(PyroSimColors.FDS_SPECIAL_COLOR));
        StyleConstants.setBold(this.d_specCharStyle, true);
        StyleConstants.setForeground(this.d_referenceStyle, colorScheme.getColor(PyroSimColors.FDS_REFERENCE_COLOR));
        StyleConstants.setBold(this.d_referenceStyle, true);
        StyleConstants.setForeground(this.d_valueStyle, colorScheme.getColor(PyroSimColors.FDS_VALUE_COLOR));
        StyleConstants.setForeground(this.d_commentStyle, colorScheme.getColor(PyroSimColors.FDS_COMMENT_COLOR));
        StyleConstants.setItalic(this.d_commentStyle, true);
    }

    private void updateColors() {
        this.updateStyles();
        if (this.d_proc != null) {
            this.d_proc.updateColors();
        }
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void applyChanges() {
        if (!this.d_dirty) {
            this.d_mediator.setUnprocessedRecords(this.d_unproc.getText());
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.updateText(true);
        this.updateTextSel();
        super.paint(graphics);
    }

    @Override
    public void update(Events events) {
        if (this.d_renderingRecords) {
            return;
        }
        this.d_renderingRecords = true;
        boolean bl = false;
        boolean bl2 = false;
        IEventRecord<PyroMod> iEventRecord = events.getEvents(PyroMod.class, new Class[0]);
        bl |= iEventRecord.containsChange(PyroMod.EVT_MODEL_CHANGED) || iEventRecord.containsChange(PyroMod.EVT_UNPROC_RECS_CHANGED) || iEventRecord.containsChange(PyroMod.EVT_FDS_EVAC_CHANGED) || iEventRecord.containsChange(PyroMod.EVT_RAST_PROPS) || iEventRecord.containsChange(PyroMod.EVT_PREFS_CHANGED) || iEventRecord.containsChange(PyroMod.EVT_FILENAME_CHANGED);
        IEventRecord<Object> iEventRecord2 = events.getEvents(Object.class, PyroMod.class);
        bl2 |= iEventRecord2.isModified();
        if ((bl |= iEventRecord2.isModified() && (!iEventRecord2.areChangesOnly() || !iEventRecord2.areChangesExclusiveTo(PyroMod.EVT_SEL))) && iEventRecord.containsChange(PyroMod.EVT_PREFS_CHANGED)) {
            this.updateFontSizes(this.d_proc.getFont());
        }
        this.d_dirty |= bl;
        this.d_selDirty |= bl | bl2;
        if (this.d_dirty) {
            this.clearCache();
        }
        this.repaint();
        this.d_renderingRecords = false;
    }

    private void clearCache() {
        boolean bl = this.d_displayList.size() > 0 || this.d_proc.getDocument().getLength() > 0;
        this.d_displayList = new ArrayList(0);
        this.d_selDisplays = this.d_displayList;
        this.d_displays = Collections.EMPTY_MAP;
        this.d_proc.setDocument(this.createStyledDocument());
        if (bl) {
            SwingUtilities.invokeLater(() -> System.gc());
        }
    }

    private void updateText(boolean bl) {
        if (this.d_renderingRecords) {
            return;
        }
        if (!this.d_dirty) {
            return;
        }
        this.d_renderingRecords = true;
        this.d_displayList = new ArrayList();
        this.d_displays = new IdentityHashMap<IPyroObject, ObjDisp>();
        int n = this.d_procScroller.getVerticalScrollBar().getValue();
        FDS6Renderer fDS6Renderer = (FDS6Renderer)FDS.newRenderer(this.d_mediator, PyroSim.getApp().getFDSRenderProps());
        SyntaxMap syntaxMap = this.d_proc.getSyntaxMap();
        syntaxMap.clearSyntax();
        StyledDocument styledDocument = this.createStyledDocument();
        Renderer renderer = new Renderer(fDS6Renderer.getProps(), styledDocument, syntaxMap);
        String string = PyroSim.getApp().getFilename();
        if (string == null) {
            string = "untitled.fds";
        } else if (!string.endsWith(".fds")) {
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                n2 = string.length();
            }
            string = string.substring(0, n2) + ".fds";
        }
        FDSRenderer.Filenames filenames = new FDSRenderer.Filenames(new File(string));
        Collection<IPyroObject> collection = fDS6Renderer.collectPyroObjects();
        FDSRenderer.Prep prep = fDS6Renderer.prepareObjs(collection, PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM), this.d_mediator.getUnprocessedRecords());
        try {
            fDS6Renderer.renderFileForVersion(filenames, prep.objs, prep.deps, renderer, Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.d_displayList.trimToSize();
        this.d_proc.setDocument(styledDocument);
        SwingUtilities.invokeLater(() -> this.d_procScroller.getVerticalScrollBar().setValue(n));
        if (bl) {
            this.d_unproc.setText(this.d_mediator.getUnprocessedRecords());
        }
        this.d_dirty = false;
        this.d_renderingRecords = false;
    }

    private static Style getSelectionStyle(JTextPane jTextPane) {
        Style style = jTextPane.getStyle(s_selStyle);
        if (style == null) {
            style = jTextPane.addStyle(s_selStyle, null);
            StyleConstants.setBackground(style, PyroSim.getApp().getColorScheme().getColor(PyroSimColors.FDS_SEL_COLOR));
            StyleConstants.setForeground(style, PyroSim.getApp().getColorScheme().getColor(PyroSimColors.FDS_SEL_TEXT_COLOR));
        }
        return style;
    }

    public void clearSelection() {
        if (this.d_selDisplays.size() > this.d_displayList.size() * 3 / 4) {
            this.d_proc.updateSyntax();
        } else {
            for (ObjDisp objDisp : this.d_selDisplays) {
                this.d_proc.updateSyntax(objDisp.i1, objDisp.i2);
            }
        }
    }

    public void select(int n, int n2) {
        Style style = RecordView.getSelectionStyle(this.d_proc);
        this.select(style, n, n2);
    }

    private void select(Style style, int n, int n2) {
        this.d_proc.setCaretPosition(n);
        this.d_proc.moveCaretPosition(n2);
        this.d_proc.setCharacterAttributes(style, true);
    }

    private void updateTextSel() {
        if (this.d_renderingRecords) {
            return;
        }
        if (!this.d_selDirty) {
            return;
        }
        this.d_renderingRecords = true;
        Collection<IPyroObject> collection = this.d_mediator.getSelectionModel().flatten(IPyroObject.class);
        Style style = RecordView.getSelectionStyle(this.d_proc);
        int n = this.d_proc.getCaretPosition();
        this.clearSelection();
        this.d_selDisplays = new ArrayList();
        for (IPyroObject iPyroObject : collection) {
            ObjDisp objDisp = this.d_displays.get(iPyroObject);
            if (objDisp == null) continue;
            this.select(style, objDisp.i1, objDisp.i2);
            this.d_selDisplays.add(objDisp);
        }
        this.d_selDisplays.trimToSize();
        if (this.d_selDisplays.size() > 0) {
            ObjDisp objDisp = this.d_selDisplays.get(0);
            this.d_proc.setCaretPosition(objDisp.i1);
            this.d_proc.moveCaretPosition(objDisp.i2);
        } else {
            this.d_proc.setCaretPosition(n);
            this.d_proc.moveCaretPosition(n);
        }
        this.d_selDirty = false;
        this.d_renderingRecords = false;
    }

    private void updateModelSel() {
        if (this.d_renderingRecords) {
            return;
        }
        this.d_renderingRecords = true;
        this.d_mediator.pauseUpdates();
        this.d_mediator.getSelectionModel().clearSelection();
        int n = this.d_proc.getSelectionStart();
        int n2 = this.d_proc.getSelectionEnd();
        if (n2 >= n && !this.d_displayList.isEmpty()) {
            int n3 = this.getDisplayIndex(n);
            int n4 = this.getDisplayIndex(n2);
            for (int i = n3; i <= n4; ++i) {
                ObjDisp objDisp = this.d_displayList.get(i);
                if (n > objDisp.i2 || n2 < objDisp.i1) continue;
                this.d_mediator.getSelectionModel().select(objDisp.obj);
            }
        }
        if (n == n2) {
            this.d_renderingRecords = false;
            this.d_mediator.resumeUpdates();
        } else {
            this.d_mediator.resumeUpdates();
            this.d_renderingRecords = false;
        }
    }

    private int getDisplayIndex(int n) {
        ObjDisp objDisp = new ObjDisp(null, n, n, null);
        int n2 = theUtil.binarySearch(this.d_displayList, objDisp, new Comparator<ObjDisp>(){

            @Override
            public int compare(ObjDisp objDisp, ObjDisp objDisp2) {
                return objDisp.i1 - objDisp2.i1;
            }
        });
        if (n2 < 0) {
            n2 = -1 - n2;
        }
        if (n2 > 0) {
            --n2;
        }
        return n2;
    }

    private ObjDisp getDisplay(int n) {
        int n2 = this.getDisplayIndex(n);
        if (n2 < 0 || n2 >= this.d_displayList.size()) {
            return null;
        }
        ObjDisp objDisp = this.d_displayList.get(n2);
        return n >= objDisp.i1 && n <= objDisp.i2 ? objDisp : null;
    }

    private void setTextSize(float f) {
        if ((double)f < 1.0) {
            f = 1.0f;
        }
        if ((double)f > 36.0) {
            f = 36.0f;
        }
        try {
            PyroPrefs.set(PyroPrefs.RECORD_VIEW_FONTSIZE, Float.valueOf(f), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateFontSizes(this.d_proc.getFont());
    }

    private static class UnprocessedPane
    extends JTextPane {
        private static final long serialVersionUID = 1L;

        public UnprocessedPane() {
            this.createMouseListener();
        }

        public UnprocessedPane(StyledDocument styledDocument) {
            super(styledDocument);
            this.createMouseListener();
        }

        private void createMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.requestFocusInWindow();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.requestFocusInWindow();
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.requestFocusInWindow();
                }
            });
        }
    }

    private class FontSmallerAction
    extends guiAction {
        private static final long serialVersionUID = 661777269162981666L;

        public FontSmallerAction() {
            super(Intl.intl("Font Size Decrease"), PyroGuiUtil.loadPyroSimIcon("font-smaller.png", 16));
            this.putValue("ShortDescription", Intl.intl("Font Size Decrease"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RecordView.this.setTextSize(RecordView.this.d_proc.getFont().getSize() - 1);
        }
    }

    private class FontBiggerAction
    extends guiAction {
        private static final long serialVersionUID = 2157730166712308476L;

        public FontBiggerAction() {
            super(Intl.intl("Font Size Increase"), PyroGuiUtil.loadPyroSimIcon("font-bigger.png", 16));
            this.putValue("ShortDescription", Intl.intl("Font Size Increase"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RecordView.this.setTextSize(RecordView.this.d_proc.getFont().getSize() + 1);
        }
    }

    private static class ObjDisp {
        public final IPyroObject obj;
        public int i1;
        public int i2;
        public final FDSRenderRecord rec;

        public ObjDisp(IPyroObject iPyroObject, int n, int n2, FDSRenderRecord fDSRenderRecord) {
            this.obj = iPyroObject;
            this.i1 = n;
            this.i2 = n2;
            this.rec = fDSRenderRecord;
        }

        public void append(int n, int n2) {
            this.i2 = n2;
        }
    }

    private static class DocWriter
    extends Writer {
        private final StyledDocument d_doc;
        private final StringBuilder d_buffer;

        public DocWriter(StyledDocument styledDocument) {
            this.d_doc = styledDocument;
            this.d_buffer = new StringBuilder();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        public int size() {
            return this.d_doc.getLength() + this.d_buffer.length();
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.write(new String(cArray, n, n2));
        }

        @Override
        public void write(String string) throws IOException {
            int n = 0;
            int n2 = string.indexOf(10);
            while (n2 >= 0 && n2 < string.length()) {
                block3: {
                    this.d_buffer.append(string, n, n2);
                    try {
                        this.d_doc.insertString(this.d_doc.getLength(), this.d_buffer.toString(), null);
                    }
                    catch (BadLocationException badLocationException) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
                this.d_buffer.setLength(0);
                n = n2;
                n2 = string.indexOf(10, n2 + 1);
            }
            this.d_buffer.append(string, n, string.length());
        }
    }

    private class Renderer
    extends FDSPrintRenderer {
        private final StyledDocument d_doc;
        private IPyroObject d_prev;
        private final SyntaxMap d_sMap;
        private int d_syntaxCounter;

        public Renderer(FDSRenderProps fDSRenderProps, StyledDocument styledDocument, SyntaxMap syntaxMap) {
            super(new PrintWriter(new DocWriter(styledDocument)), fDSRenderProps);
            this.d_prev = null;
            this.d_doc = styledDocument;
            this.d_sMap = syntaxMap;
            this.d_syntaxCounter = 0;
        }

        private int size() {
            return this.d_doc.getLength();
        }

        @Override
        public void render(FDSRenderRecord fDSRenderRecord, IPyroObject iPyroObject) {
            int n = this.size();
            SyntaxMap syntaxMap = this.renderWithSyntax(fDSRenderRecord, iPyroObject);
            int n2 = this.size();
            this.d_sMap.put(n, "SYMBOL_EMPTY");
            if (iPyroObject != null && iPyroObject.getDomain() != null) {
                ObjDisp objDisp;
                if (n2 > n) {
                    --n2;
                }
                if ((objDisp = (ObjDisp)RecordView.this.d_displays.get(iPyroObject)) == null) {
                    objDisp = new ObjDisp(iPyroObject, n, n2, fDSRenderRecord);
                    RecordView.this.d_displays.put(iPyroObject, objDisp);
                    RecordView.this.d_displayList.add(objDisp);
                } else if (iPyroObject == this.d_prev) {
                    objDisp.append(n, n2);
                }
            }
            this.d_prev = iPyroObject;
            boolean bl = true;
            int n3 = 4000;
            PyroSim pyroSim = PyroSim.getApp();
            if (pyroSim != null) {
                bl = PyroPrefs.getBoolean(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE);
                n3 = PyroPrefs.getInt(PyroPrefs.SYNTAX_HIGHLIGHT_OBSTHOLELIMIT);
            }
            boolean bl2 = false;
            if (fDSRenderRecord.getType().equals("OBST") || fDSRenderRecord.getType().equals("HOLE")) {
                ++this.d_syntaxCounter;
                boolean bl3 = bl2 = n3 < this.d_syntaxCounter;
            }
            if (bl && !bl2 && syntaxMap != null) {
                int n4;
                Iterator<Map.Entry<Integer, String>> iterator = syntaxMap.getMap().entrySet().iterator();
                int n5 = n4 = this.d_sMap.getCurrIx();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, String> entry = iterator.next();
                    this.d_doc.setCharacterAttributes(n5, entry.getKey() + n4 - n5, RecordView.this.d_proc.getStyle(entry.getValue()), true);
                    n5 = n4 + entry.getKey();
                }
                this.d_sMap.mergeSyntaxToRoot(syntaxMap);
            }
        }

        public SyntaxMap renderWithSyntax(FDSRenderRecord fDSRenderRecord, IPyroObject iPyroObject) {
            return fDSRenderRecord.renderRecord(this.d_writer, this.props(), this.d_fieldRenderer);
        }
    }

    private class TextPane
    extends JTextPane {
        private static final long serialVersionUID = 4686426398407311194L;
        private SyntaxMap d_sMap;

        public TextPane(StyledDocument styledDocument, SyntaxMap syntaxMap) {
            super(styledDocument);
            this.d_sMap = null;
            this.d_sMap = syntaxMap;
            this.updateColors();
        }

        public void setSyntaxHighlighting(SyntaxMap syntaxMap) {
            this.d_sMap = syntaxMap;
        }

        public SyntaxMap getSyntaxMap() {
            return this.d_sMap;
        }

        public void updateColors() {
            ColorScheme colorScheme = PyroSim.getApp().getColorScheme();
            this.setSelectionColor(colorScheme.getColor(PyroSimColors.FDS_SEL_COLOR));
            this.setSelectedTextColor(colorScheme.getColor(PyroSimColors.FDS_SEL_TEXT_COLOR));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHints(renderingHints);
            super.paintComponent(graphics);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                if (mouseEvent.getID() != 501) {
                    return;
                }
                int n = this.viewToModel(mouseEvent.getPoint());
                ObjDisp objDisp = RecordView.this.getDisplay(n);
                if (objDisp == null || !RecordView.this.d_mediator.getSelectionModel().isSelected(objDisp.obj)) {
                    RecordView.this.d_proc.setCaretPosition(n);
                }
                SwingUtilities.invokeLater(() -> {
                    JPopupMenu jPopupMenu = Actions.getContextMenu(RecordView.this.d_mediator.getSelectionModel().getSelection());
                    if (jPopupMenu != null) {
                        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                });
                return;
            }
            super.processMouseEvent(mouseEvent);
        }

        public void clearSyntax() {
            this.d_sMap.clearSyntax();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public void updateSyntax() {
            this.updateSyntax(this.d_sMap.getMap(), 0);
        }

        public void updateSyntax(int n, int n2) {
            Map map = this.d_sMap.getMap().entrySet().stream().filter(entry -> (Integer)entry.getKey() >= n && (Integer)entry.getKey() <= n2).sorted((entry, entry2) -> Integer.compare((Integer)entry.getKey(), (Integer)entry2.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (string, string2) -> string, LinkedHashMap::new));
            this.updateSyntax(map, n);
        }

        public void updateSyntax(Map<Integer, String> map, int n) {
            StyledDocument styledDocument = RecordView.this.d_proc.getStyledDocument();
            int n2 = n;
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                styledDocument.setCharacterAttributes(n2, entry.getKey() - n2, styledDocument.getStyle(entry.getValue()), true);
                n2 = entry.getKey();
            }
        }
    }

    private static class TextPaneWithLineNumbers
    extends guiPanel
    implements Scrollable {
        private static final long serialVersionUID = 4399351684684845435L;
        private static Color COLOR_FG = new Color(127, 127, 127);
        private static Color COLOR_BG = new Color(237, 237, 237);
        private TextPane d_textPane;
        private JComponent d_rowHeader;

        public TextPaneWithLineNumbers(TextPane textPane) {
            this.d_textPane = textPane;
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_textPane, "Center");
            this.d_rowHeader = new JComponent(){
                private static final long serialVersionUID = -1527734596283354023L;

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    Rectangle rectangle = this.getBounds();
                    Rectangle rectangle2 = graphics.getClipBounds();
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n = rectangle.width - 4;
                    int n2 = 8;
                    int n3 = fontMetrics.getHeight();
                    graphics.setColor(COLOR_FG);
                    int n4 = Math.min(n3, rectangle2.y / n3);
                    int n5 = (rectangle2.y + rectangle2.height) / n3 + 1;
                    for (int i = n4; i <= n5; ++i) {
                        String string = Integer.toString(i);
                        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                        n2 = Math.max(n2, 4 + (int)rectangle2D.getWidth() + 4);
                        int n6 = n - (int)rectangle2D.getWidth();
                        int n7 = i * n3 - 1;
                        graphics.drawString(string, n6, n7);
                    }
                    if (this.getPreferredSize().width < n2) {
                        d_rowHeader.setPreferredSize(new Dimension(n2, 1));
                        d_rowHeader.revalidate();
                    }
                }
            };
            this.d_rowHeader.setFont(this.d_textPane.getFont());
            this.setBackground(COLOR_BG);
            this.setOpaque(true);
            this.d_rowHeader.setPreferredSize(new Dimension(40, 1));
            this.add((Component)this.d_rowHeader, "West");
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.d_rowHeader != null) {
                this.d_rowHeader.setFont(font);
            }
            if (this.d_textPane != null) {
                this.d_textPane.setFont(font);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.d_textPane.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.d_textPane.getFontMetrics(this.d_textPane.getFont()).getHeight();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.d_textPane.getFontMetrics(this.d_textPane.getFont()).getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.d_textPane.getScrollableTracksViewportWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.d_textPane.getScrollableTracksViewportHeight();
        }
    }

    private static enum UnprocAction {
        CUT(Intl.intl("Cut"), "cut-to-clipboard"),
        COPY(Intl.intl("Copy"), "copy-to-clipboard"),
        PASTE(Intl.intl("Paste"), "paste-from-clipboard"),
        SELECTALL(Intl.intl("Select All"), "select-all");

        private final String displayStr;
        private final String lookupStr;

        private UnprocAction(String string2, String string3) {
            this.displayStr = string2;
            this.lookupStr = string3;
        }

        public String display() {
            return this.displayStr;
        }

        public String lookup() {
            return this.lookupStr;
        }
    }
}

