/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools.popupmenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.constraint.ConstantConstraintGen;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SnapConstraintMenuBuilder
implements IPopupMenuBuilder {
    public final List<Pair<Object, IConstraintGen>> d_constraints;

    public SnapConstraintMenuBuilder(Pair<Object, IConstraintGen> ... pairArray) {
        this.d_constraints = Arrays.asList(pairArray);
    }

    public SnapConstraintMenuBuilder(Collection<Pair<Object, IConstraintGen>> collection) {
        this.d_constraints = new ArrayList<Pair<Object, IConstraintGen>>(collection);
    }

    public SnapConstraintMenuBuilder(Object ... objectArray) {
        this.d_constraints = new ArrayList<Pair<Object, IConstraintGen>>(objectArray.length / 2);
        int n = 0;
        while (n < objectArray.length) {
            Object object = null;
            IConstraintGen iConstraintGen = null;
            for (int i = 0; i < 2 && i + n < objectArray.length; ++i) {
                Object object2 = objectArray[n + i];
                if (object2 instanceof IConstraintGen) {
                    iConstraintGen = (IConstraintGen)object2;
                    continue;
                }
                if (object2 instanceof ISnapConstraint) {
                    iConstraintGen = new ConstantConstraintGen((ISnapConstraint)object2);
                    continue;
                }
                object = object2;
            }
            if (object == null || iConstraintGen == null) continue;
            this.d_constraints.add(new Pair<Object, Object>(object, iConstraintGen));
        }
    }

    @Override
    public void buildMenu(IPyroTool iPyroTool, MenuBuilder menuBuilder) {
        ArrayList<ConstraintAction> arrayList = new ArrayList<ConstraintAction>(this.d_constraints.size());
        for (Pair<Object, IConstraintGen> pair : this.d_constraints) {
            arrayList.add(new ConstraintAction(iPyroTool, pair.v1.toString(), (IConstraintGen)pair.v2));
        }
        menuBuilder.addMutuallyExclusive(arrayList);
    }

    public boolean toggleCurrentConstraint(IPyroTool iPyroTool) {
        IConstraintGen iConstraintGen = iPyroTool.getConstraintGen();
        for (int i = 0; i < this.d_constraints.size(); ++i) {
            if (!iConstraintGen.equals(this.d_constraints.get((int)i).v2)) continue;
            iConstraintGen = (IConstraintGen)this.d_constraints.get((int)((i + 1) % this.d_constraints.size())).v2;
            iPyroTool.setConstraintGen(iConstraintGen);
            iPyroTool.repaintSurface();
            return true;
        }
        return false;
    }

    protected static class ConstraintAction
    extends BooleanAction {
        private static final long serialVersionUID = -7014485830040692107L;
        private final IPyroTool d_tool;
        private final IConstraintGen d_constraint;

        public ConstraintAction(IPyroTool iPyroTool, String string, IConstraintGen iConstraintGen) {
            super(string, theUtil.equal(iPyroTool.getConstraintGen(), iConstraintGen));
            this.d_tool = iPyroTool;
            this.d_constraint = iConstraintGen;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_tool.setConstraintGen(this.d_constraint);
                this.d_tool.repaintSurface();
            }
        }
    }
}

