/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.ModelView;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.MouseHistory;

public class TranslateTool
extends ATransformTool
implements ValueEditor.IListener {
    public TranslateTool(ModelView modelView, TransformMgr transformMgr, ModelScene modelScene, DrawProps drawProps) {
        super(modelView, transformMgr, modelScene, drawProps);
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        super.initValueEditor(valueEditor);
        ValueEditorUtil.configure(valueEditor, "LOCATION", "OFFSET");
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        List<Point3d> list = this.getClickHistory().getAllPoints();
        Point3d point3d = list.size() >= 1 ? list.get(0) : null;
        Point3d point3d2 = list.size() >= 2 ? point.p : null;
        this.update(point3d, point3d2);
        if (mouseHistory.committedSize() >= 2) {
            this.finishIfValid();
        }
    }

    public void finishIfValid() {
        if (this.getXformMgr().isTransformValid()) {
            super.finish();
        }
    }

    private void update(Point3d point3d, Point3d point3d2) {
        IPrimProps.GenericProps genericProps = new IPrimProps.GenericProps(Color.RED, null, 3.0, IPrimProps.DEF_STIPPLE, 10.0, 0);
        ArrayList<APrimitive> arrayList = new ArrayList<APrimitive>();
        if (point3d2 != null) {
            arrayList.add(new LineSeg(point3d, point3d2));
        }
        if (point3d != null) {
            arrayList.add(new Point(point3d));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(arrayList)), new UniformProps(genericProps));
        if (point3d2 != null) {
            Vector3d vector3d = Util3D.vector(point3d, point3d2);
            ITransform iTransform = TransformUtil.translate(vector3d.x, vector3d.y, vector3d.z);
            this.getXformMgr().modify(iTransform);
        } else {
            this.getXformMgr().modify(TransformUtil.IDENTITY);
        }
        this.repaintSurface();
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }
}

