/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JMenu;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.gui.MenuBuilder;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.mv.gui.ColorUtil;
import pyrosim.mv.tools.DrawProps;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ToolUtil {
    public static void addSurfSubmenu(PyroMod pyroMod, DrawProps drawProps, Predicate<Surface> predicate, MenuBuilder menuBuilder) {
        IFilteredCollection<Surface> iFilteredCollection = theUtil.filter(pyroMod.getSurfaceMgr().flatten(), predicate);
        List<Surface> list = Util.sort(iFilteredCollection);
        ArrayList<SurfaceAction> arrayList = new ArrayList<SurfaceAction>();
        for (Surface surface : list) {
            arrayList.add(new SurfaceAction(pyroMod, drawProps, surface));
        }
        JMenu jMenu = new JMenu(Intl.intl("Surface"));
        PyroGuiUtil.addMEMenuItems(jMenu, arrayList);
        menuBuilder.add(jMenu);
    }

    public static void addColorSubmenu(PyroMod pyroMod, DrawProps drawProps, MenuBuilder menuBuilder) {
        JMenu jMenu = new JMenu(Intl.intl("Color"));
        ArrayList<ColorAction> arrayList = new ArrayList<ColorAction>();
        arrayList.add(new ColorAction(drawProps, null));
        Color color = drawProps.get(DrawProps.COLOR);
        if (color != null) {
            arrayList.add(new ColorAction(drawProps, color));
        }
        ArrayList<Color> arrayList2 = new ArrayList<Color>(ColorHistory.get());
        arrayList2.remove(color);
        int n = Math.min(arrayList2.size(), 5);
        for (int i = arrayList2.size() - 1; i >= arrayList2.size() - n; --i) {
            arrayList.add(new ColorAction(drawProps, (Color)arrayList2.get(i)));
        }
        PyroGuiUtil.addMEMenuItems(jMenu, arrayList);
        jMenu.addSeparator();
        jMenu.add(new ChooseColorAction(drawProps));
        menuBuilder.add(jMenu);
    }

    public static <T extends Enum<T>> T nextVal(T t) {
        Enum[] enumArray = (Enum[])t.getDeclaringClass().getEnumConstants();
        return (T)enumArray[(t.ordinal() + 1) % enumArray.length];
    }

    public static class ChooseColorAction
    extends guiAction {
        private static final long serialVersionUID = 2128157030543995315L;
        private final DrawProps d_props;

        public ChooseColorAction(DrawProps drawProps) {
            super(Intl.intl("Choose..."));
            this.d_props = drawProps;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleColorChooser simpleColorChooser = new SimpleColorChooser((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("Choose Color"), 0);
            Color color = this.d_props.get(DrawProps.COLOR);
            if (color != null) {
                simpleColorChooser.setColor(color);
            }
            if (simpleColorChooser.doModal() == 1) {
                this.d_props.set(DrawProps.COLOR, simpleColorChooser.getColor());
                this.d_props.fireStateChanged();
            }
        }
    }

    public static class ColorAction
    extends BooleanAction {
        private static final long serialVersionUID = 6873831908343298640L;
        private final DrawProps d_props;
        private final Color d_color;

        public ColorAction(DrawProps drawProps, Color color) {
            super(ColorUtil.format(color), theUtil.equal(drawProps.get(DrawProps.COLOR), color), color != null ? new ColorIcon(color, 16, 16, 3) : null);
            this.d_props = drawProps;
            this.d_color = color;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_props.set(DrawProps.COLOR, this.d_color);
                this.d_props.fireStateChanged();
            }
        }
    }

    public static class SurfaceAction
    extends BooleanAction {
        private static final long serialVersionUID = 686439224217139673L;
        private final DrawProps d_props;
        private final Surface d_surf;

        public SurfaceAction(PyroMod pyroMod, DrawProps drawProps, Surface surface) {
            super(surface.getName(), drawProps.get(DrawProps.SURFACE) == surface, TVEntryPoints.ep(surface).getIcons(pyroMod, surface)[0]);
            this.setDisabledIcon(TVEntryPoints.ep(surface).getIcons(pyroMod, surface)[1]);
            this.d_surf = surface;
            this.d_props = drawProps;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_props.set(DrawProps.SURFACE, this.d_surf);
                this.d_props.fireStateChanged();
            }
        }
    }
}

