/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.gui.SurfaceHover;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.FaceCache;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.SurfaceUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;

public class SurfacePickerTool
extends APyroTool {
    public static final Cursor CURSOR = guiUtil.createCursor("EyeDropper32", "pyrosim/icons/eye_dropper32.gif", 3, 29);
    private final DrawProps[] d_setProps;
    private Pair<ISurfObj, Integer> d_selection;
    private final FaceCache d_faceCache;
    private SurfaceHover d_popup;

    public SurfacePickerTool(PyroMod pyroMod, IToolController iToolController, DrawProps drawProps, DrawProps ... drawPropsArray) {
        super(iToolController, drawProps, new ToolFunc());
        this.d_setProps = drawPropsArray;
        this.d_faceCache = new FaceCache(pyroMod);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                SurfaceUtil.chooseNextSurfaceSpecs(SurfacePickerTool.this.getProps());
                SurfacePickerTool.this.updatePopup();
            }
        });
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        menuBuilder.addMutuallyExclusive(new PickPropAction(true, false), new PickPropAction(false, true), new PickPropAction(true, true));
        super.addContextMenuActions(menuBuilder);
    }

    private boolean getPickPropState(boolean bl, boolean bl2) {
        return this.getProps().get(DrawProps.SPECIFY_SURFACE) == bl && this.getProps().get(DrawProps.SPECIFY_COLOR) == bl2;
    }

    private static String getPickPropDesc(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return Intl.intl("Pick Surface + Color");
        }
        if (bl) {
            return Intl.intl("Pick Surface only");
        }
        return Intl.intl("Pick Color only");
    }

    protected SurfaceHover getPopup() {
        if (this.d_popup == null) {
            this.d_popup = new SurfaceHover(this.getModelView().getRenderComp());
        }
        return this.d_popup;
    }

    @Override
    protected String getStatusMessage() {
        Surface surface = this.getSelectedSurf();
        return surface == null ? "" : String.format(Intl.intl("Surface: %s"), surface.getName());
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(ISurfObj.class, GeomType.FACE));
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        return null;
    }

    protected void updatePickFace() {
        Pair<ISurfObj, Integer> pair = null;
        Collection<IsectInfo> collection = this.getP1().snaps;
        if (!collection.isEmpty()) {
            IsectInfo isectInfo = collection.iterator().next();
            assert (isectInfo.obj instanceof ISurfObj);
            ISurfObj iSurfObj = (ISurfObj)isectInfo.obj;
            IFace[] iFaceArray = this.d_faceCache.getFaces((ISurfObj)iSurfObj).faces;
            for (int i = 0; i < iFaceArray.length; ++i) {
                IFace iFace = iFaceArray[i];
                Point3d point3d = iFace.project(isectInfo.isectPoint);
                if (!point3d.epsilonEquals(isectInfo.isectPoint, 1.0E-6) || !iFace.classify((Point3d)point3d, (double)1.0E-6).positive) continue;
                pair = new Pair<ISurfObj, Integer>(iSurfObj, i);
                break;
            }
        }
        this.d_selection = pair;
        this.repaintSurface();
    }

    protected void updatePopup() {
        if (this.d_selection == null) {
            this.getPopup().setVisible(false);
            return;
        }
        boolean bl = this.getProps().get(DrawProps.SPECIFY_SURFACE);
        boolean bl2 = this.getProps().get(DrawProps.SPECIFY_COLOR);
        Surface surface = this.getSelectedSurf();
        Color color = this.getSelectedColor();
        this.getPopup().update(Intl.intl("Pick"), bl, surface, bl2, color);
    }

    @Override
    public void finish() {
        this.reset();
        super.finish();
    }

    @Override
    public void cancel() {
        this.reset();
        super.cancel();
    }

    @Override
    public void reset() {
        this.getPopup().setVisible(false);
        this.d_selection = null;
        this.d_faceCache.clear();
    }

    @Override
    public void activate() {
        super.activate();
        this.getPopup().attach();
    }

    @Override
    public void deactivate() {
        this.getPopup().detach();
        super.deactivate();
    }

    protected Surface getSelectedSurf() {
        if (this.d_selection == null) {
            return null;
        }
        Surface[] surfaceArray = ((ISurfObj)this.d_selection.v1).getSurfaces();
        return surfaceArray.length == 1 ? surfaceArray[0] : surfaceArray[(Integer)this.d_selection.v2];
    }

    protected Color getSelectedColor() {
        if (this.d_selection == null) {
            return null;
        }
        Color[] colorArray = ((ISurfObj)this.d_selection.v1).getColors();
        return colorArray.length == 1 ? colorArray[0] : colorArray[(Integer)this.d_selection.v2];
    }

    protected static class ToolFunc
    extends APyroTool.ToolFunc<SurfacePickerTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseMoved(SurfacePickerTool surfacePickerTool, MouseEvent mouseEvent) {
            super.mouseMoved(surfacePickerTool, mouseEvent);
            surfacePickerTool.updatePickFace();
            surfacePickerTool.updatePopup();
        }

        @Override
        public void mouseDragged(SurfacePickerTool surfacePickerTool, MouseEvent mouseEvent) {
            super.mouseDragged(surfacePickerTool, mouseEvent);
            surfacePickerTool.updatePickFace();
            surfacePickerTool.updatePopup();
        }

        @Override
        public void mouseReleased(SurfacePickerTool surfacePickerTool, MouseEvent mouseEvent) {
            super.mouseReleased(surfacePickerTool, mouseEvent);
            surfacePickerTool.updatePickFace();
            if (mouseEvent.getButton() == 1 && surfacePickerTool.d_selection != null) {
                Serializable serializable;
                if (surfacePickerTool.getProps().get(DrawProps.SPECIFY_SURFACE).booleanValue()) {
                    serializable = surfacePickerTool.getSelectedSurf();
                    for (DrawProps drawProps : surfacePickerTool.d_setProps) {
                        drawProps.set(DrawProps.SURFACE, serializable);
                    }
                }
                if (surfacePickerTool.getProps().get(DrawProps.SPECIFY_COLOR).booleanValue()) {
                    serializable = surfacePickerTool.getSelectedColor();
                    for (DrawProps drawProps : surfacePickerTool.d_setProps) {
                        drawProps.set(DrawProps.COLOR, serializable);
                    }
                    if (serializable != null) {
                        ColorHistory.add((Color)serializable);
                    }
                }
                surfacePickerTool.finish();
            }
        }
    }

    protected class PickPropAction
    extends BooleanAction {
        private static final long serialVersionUID = 3002203575155581285L;
        private final boolean d_surface;
        private final boolean d_color;

        public PickPropAction(boolean bl, boolean bl2) {
            super(SurfacePickerTool.getPickPropDesc(bl, bl2), SurfacePickerTool.this.getPickPropState(bl, bl2));
            this.d_surface = bl;
            this.d_color = bl2;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                SurfacePickerTool.this.getProps().set(DrawProps.SPECIFY_SURFACE, this.d_surface);
                SurfacePickerTool.this.getProps().set(DrawProps.SPECIFY_COLOR, this.d_color);
                SurfacePickerTool.this.updatePopup();
            }
        }
    }
}

