/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.gui.SurfaceHover;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.FaceCache;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.SurfaceUtil;
import pyrosim.mv.tools.ToolUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SurfacePainterTool
extends APyroTool {
    public static final Cursor CURSOR = guiUtil.createCursor("PaintBucket32", "pyrosim/icons/paint_bucket32.png", 3, 27);
    private static final int PAINT_WHOLE_OBJ_KEY = 16;
    private final PyroMod d_domain;
    private final DisplayManager d_mgr;
    private final GenericGeomSrc d_displayObj;
    private final FaceCache d_faceCache;
    private Selection d_selection;
    private final Map<ISurfObj, IGeomNode> d_surfPaintedObjs;
    private final Map<ISurfObj, ISurfObj> d_objClones;
    private final Set<FacePainter> d_facePainters;
    private SurfaceHover d_hover;

    public SurfacePainterTool(PyroMod pyroMod, ModelView modelView, DisplayManager displayManager, DrawProps drawProps) {
        super((IToolController)modelView, drawProps, new ToolFunc());
        this.d_domain = pyroMod;
        this.d_mgr = displayManager;
        this.d_faceCache = new FaceCache(pyroMod);
        this.d_displayObj = new GenericGeomSrc("", GeomNodeUtil.EMPTY_NODE, DisplayGeom.EMPTY.props);
        this.d_surfPaintedObjs = new IdentityHashMap<ISurfObj, IGeomNode>();
        this.d_facePainters = new LinkedHashSet<FacePainter>();
        this.d_objClones = new LinkedIdentityHashMap<ISurfObj, ISurfObj>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                SurfaceUtil.chooseNextSurfaceSpecs(SurfacePainterTool.this.getProps());
                SurfacePainterTool.this.updatePickFace();
            }
        });
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
    }

    protected SurfaceHover getHoverWindow() {
        if (this.d_hover == null) {
            this.d_hover = new SurfaceHover(this.getAttachedComponent());
        }
        return this.d_hover;
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        super.activate();
        this.d_mgr.add(this.d_displayObj);
        this.resumeRepaint(true);
        this.getHoverWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getHoverWindow().detach();
        this.pauseRepaint();
        this.d_mgr.remove(this.d_displayObj);
        super.deactivate();
        this.resumeRepaint(true);
    }

    public static Predicate<Surface> getSurfFilter() {
        Predicate<Surface> predicate = Obstruction.getSurfaceFilter().or(Vent.getSurfaceFilter());
        Predicate<Surface> predicate2 = new Predicate<Surface>(){

            @Override
            public boolean test(Surface surface) {
                return surface.isEnabled();
            }
        };
        return predicate.and(predicate2);
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(ISurfObj.class, GeomType.FACE));
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        return null;
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        menuBuilder.addMutuallyExclusive(new PickPropAction(true, false), new PickPropAction(false, true), new PickPropAction(true, true));
        menuBuilder.addSeparator();
        if (this.getProps().get(DrawProps.SPECIFY_SURFACE).booleanValue()) {
            ToolUtil.addSurfSubmenu(this.d_domain, this.getProps(), SurfacePainterTool.getSurfFilter(), menuBuilder);
        }
        if (this.getProps().get(DrawProps.SPECIFY_COLOR).booleanValue()) {
            ToolUtil.addColorSubmenu(this.d_domain, this.getProps(), menuBuilder);
        }
        super.addContextMenuActions(menuBuilder);
    }

    private boolean getPickPropState(boolean bl, boolean bl2) {
        return this.getProps().get(DrawProps.SPECIFY_SURFACE) == bl && this.getProps().get(DrawProps.SPECIFY_COLOR) == bl2;
    }

    private static String getPickPropDesc(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return Intl.intl("Paint Surface + Color");
        }
        if (bl) {
            return Intl.intl("Paint Surface only");
        }
        return Intl.intl("Paint Color only");
    }

    protected void setSurface(Surface surface) {
        this.getProps().set(DrawProps.SURFACE, surface);
        this.updatePickFace();
    }

    protected void setColor(Color color) {
        this.getProps().set(DrawProps.COLOR, color);
        if (color != null) {
            ColorHistory.add(color);
        }
        this.updatePickFace();
    }

    protected boolean getWholeObjMode() {
        return this.getPressedKeys().contains(16);
    }

    @Override
    protected String getStatusMessage() {
        return this.getWholeObjMode() ? "" : Intl.intl("Hold SHIFT to paint whole object");
    }

    /*
     * WARNING - void declaration
     */
    protected void updatePickFace() {
        Object object;
        Serializable serializable;
        Iterator iterator;
        Collection<IDisplayable> collection;
        Selection selection = null;
        boolean bl = this.getWholeObjMode();
        DrawProps drawProps = this.getProps();
        boolean bl2 = drawProps.get(DrawProps.SPECIFY_COLOR);
        Color color = drawProps.get(DrawProps.COLOR);
        boolean bl3 = drawProps.get(DrawProps.SPECIFY_SURFACE);
        Surface surface = drawProps.get(DrawProps.SURFACE);
        Collection<IsectInfo> collection2 = this.getP1().snaps;
        if ((bl2 || bl3) && !collection2.isEmpty()) {
            collection = collection2.iterator().next();
            assert (((IsectInfo)((Object)collection)).obj instanceof ISurfObj);
            iterator = (ISurfObj)((IsectInfo)((Object)collection)).obj;
            if (!bl3 || iterator.getSurfFilter().test(surface)) {
                FaceCache.Faces object22 = this.d_faceCache.getFaces((ISurfObj)((Object)iterator));
                for (int i = 0; i < object22.faces.length; ++i) {
                    serializable = object22.faces[i];
                    object = serializable.project(((IsectInfo)((Object)collection)).isectPoint);
                    if (!((Tuple3d)object).epsilonEquals(((IsectInfo)((Object)collection)).isectPoint, 1.0E-6) || !serializable.classify((Point3d)object, (double)1.0E-6).positive) continue;
                    selection = new Selection((ISurfObj)((Object)iterator), i, bl);
                    break;
                }
            }
        }
        if (!theUtil.equal(this.d_selection, selection)) {
            this.d_selection = selection;
            if (selection != null) {
                void var11_14;
                collection = this.d_selection.obj.getGeom();
                iterator = FDSUtil.getUsableTexMapperPrim((IGeomNode)((Object)collection), selection.obj.getTextureOrigin());
                if (selection.wholeObj) {
                    IGeomNode iGeomNode = collection.initUVElements((IElemSource<Point2d>)((Object)iterator));
                } else {
                    FaceCache.Faces faces = this.d_faceCache.getFaces(this.d_selection.obj);
                    serializable = faces.faces[this.d_selection.faceIx];
                    object = Elements.getPrimElements(faces.elems, this.d_selection.faceIx);
                    IGeomNode iGeomNode = GeomNodeUtil.newNode((IGeom)serializable, (IPropertySet)object).initUVElements((IElemSource<Point2d>)((Object)iterator));
                }
                this.d_displayObj.setGeom((IGeomNode)var11_14);
                Color color2 = bl2 ? color : null;
                serializable = bl3 ? surface : this.getSurface(selection.obj, selection.faceIx);
                object = FDSUtil.newObstFaceProps(color2, (Surface)serializable, 0);
                this.d_displayObj.setDisplayProps(new UniformProps((IPrimProps)object));
            } else {
                this.clearDisplay();
            }
            collection = this.d_mgr.getDisplayObjs(this.d_displayObj);
            if (!collection.isEmpty()) {
                this.d_mgr.updateDisplays(this.d_displayObj);
                for (GeomDisplay geomDisplay : theUtil.filter(collection, GeomDisplay.class)) {
                    geomDisplay.setSelected(true);
                }
            }
            this.repaintSurface();
        }
        collection = bl ? Intl.intl("Paint Whole Object") : Intl.intl("Paint Face");
        this.getHoverWindow().update((String)((Object)collection), bl3, surface, bl2, color);
    }

    protected Color getColor(ISurfObj iSurfObj, int n) {
        Color[] colorArray = iSurfObj.getColors();
        return colorArray.length == 1 ? colorArray[0] : colorArray[n];
    }

    protected Surface getSurface(ISurfObj iSurfObj, int n) {
        Surface[] surfaceArray = iSurfObj.getSurfaces();
        return surfaceArray.length == 1 ? surfaceArray[0] : surfaceArray[n];
    }

    protected void paintCurrentFace() {
        int[] nArray;
        if (this.d_selection == null) {
            return;
        }
        DrawProps drawProps = this.getProps();
        boolean bl = drawProps.get(DrawProps.SPECIFY_SURFACE);
        Surface surface = drawProps.get(DrawProps.SURFACE);
        boolean bl2 = drawProps.get(DrawProps.SPECIFY_COLOR);
        Color color = drawProps.get(DrawProps.COLOR);
        if (!this.d_selection.wholeObj) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.d_selection.faceIx;
            nArray = nArray2;
            nArray2[1] = this.d_selection.faceIx + 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = this.d_selection.obj.getNumFaces();
        }
        int[] nArray4 = nArray;
        ISurfObj iSurfObj3 = this.d_objClones.computeIfAbsent(this.d_selection.obj, iSurfObj -> {
            ISurfObj iSurfObj2 = (ISurfObj)iSurfObj.clone();
            this.d_mgr.remove(iSurfObj);
            this.d_mgr.add(iSurfObj2);
            return iSurfObj2;
        });
        if (bl) {
            this.d_surfPaintedObjs.computeIfAbsent(this.d_selection.obj, iSurfObj2 -> FacePainter.decompressSurf(iSurfObj2, iSurfObj3, this.d_faceCache));
        }
        if (bl2) {
            FacePainter.decompressColor(iSurfObj3);
        }
        boolean bl3 = false;
        for (int i = nArray4[0]; i < nArray4[1]; ++i) {
            FacePainter facePainter = new FacePainter(this.d_selection.obj, iSurfObj3, i, bl, surface, bl2, color);
            if (facePainter.isNull() || this.d_facePainters.contains(facePainter)) continue;
            facePainter.apply();
            this.d_facePainters.add(facePainter);
            bl3 = true;
        }
        if (bl3) {
            this.d_mgr.updateDisplays(iSurfObj3);
            this.repaintSurface();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyPressed(keyEvent);
        if (keyEvent.getKeyCode() == 16) {
            this.updatePickFace();
        }
        this.resumeRepaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyReleased(keyEvent);
        if (keyEvent.getKeyCode() == 16) {
            this.updatePickFace();
        }
        this.resumeRepaint();
    }

    private Collection<PaintRecord> compressPaintedObjs() {
        LinkedIdentityHashMap<ISurfObj, ObjPainted> linkedIdentityHashMap = new LinkedIdentityHashMap<ISurfObj, ObjPainted>();
        for (FacePainter object : this.d_facePainters) {
            ObjPainted objPainted = linkedIdentityHashMap.computeIfAbsent(object.obst, iSurfObj -> new ObjPainted());
            objPainted.surf |= object.paintSurf;
            objPainted.color |= object.paintColor;
            objPainted.mfaces.add(object.ix);
        }
        ArrayList arrayList = new ArrayList(linkedIdentityHashMap.size());
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            ISurfObj iSurfObj2 = (ISurfObj)entry.getKey();
            ObjPainted objPainted = (ObjPainted)entry.getValue();
            if (!objPainted.surf && !objPainted.color) continue;
            ISurfObj iSurfObj3 = this.d_objClones.get(iSurfObj2);
            assert (iSurfObj3 != null);
            PaintRecord paintRecord = new PaintRecord(iSurfObj2);
            arrayList.add(paintRecord);
            if (objPainted.surf) {
                FacePainter.compressSurf(iSurfObj3, this.d_surfPaintedObjs.get(iSurfObj2), objPainted.mfaces);
                paintRecord.geom = iSurfObj3.getGeom();
                paintRecord.surfs = iSurfObj3.getSurfaces();
            }
            if (!objPainted.color) continue;
            FacePainter.compressColor(iSurfObj3);
            paintRecord.colors = iSurfObj3.getColors();
        }
        return arrayList;
    }

    @Override
    public void finish() {
        this.pauseRepaint();
        if (!this.d_facePainters.isEmpty()) {
            Collection<PaintRecord> collection = this.compressPaintedObjs();
            PaintTask paintTask = new PaintTask(collection);
            this.d_domain.getTaskManager().exec((Task)paintTask, Intl.intl("Paint Faces"), 1);
        }
        this.reset();
        super.finish();
        this.resumeRepaint();
    }

    @Override
    public void cancel() {
        this.pauseRepaint();
        this.reset();
        super.cancel();
        this.resumeRepaint();
    }

    @Override
    public void reset() {
        this.clearDisplay();
        this.d_mgr.updateDisplays(this.d_displayObj);
        this.d_mgr.removeDisplays((Collection<? extends Object>)this.d_objClones.values());
        this.d_mgr.addDisplays((Collection<? extends Object>)this.d_objClones.keySet());
        this.repaintSurface();
        this.d_objClones.clear();
        this.d_faceCache.clear();
        this.d_facePainters.clear();
        this.d_surfPaintedObjs.clear();
        this.d_selection = null;
    }

    protected void clearDisplay() {
        this.d_displayObj.setGeom(GeomNodeUtil.EMPTY_NODE);
        this.d_displayObj.setDisplayProps(DisplayGeom.EMPTY.props);
    }

    protected static class ToolFunc
    extends APyroTool.ToolFunc<SurfacePainterTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseMoved(SurfacePainterTool surfacePainterTool, MouseEvent mouseEvent) {
            super.mouseMoved(surfacePainterTool, mouseEvent);
            surfacePainterTool.updatePickFace();
        }

        @Override
        public void mousePressed(SurfacePainterTool surfacePainterTool, MouseEvent mouseEvent) {
            super.mousePressed(surfacePainterTool, mouseEvent);
            surfacePainterTool.updatePickFace();
            if (surfacePainterTool.isDragging(1)) {
                surfacePainterTool.paintCurrentFace();
            }
        }

        @Override
        public void mouseDragged(SurfacePainterTool surfacePainterTool, MouseEvent mouseEvent) {
            super.mouseDragged(surfacePainterTool, mouseEvent);
            surfacePainterTool.updatePickFace();
            if (surfacePainterTool.isDragging(1)) {
                surfacePainterTool.paintCurrentFace();
            }
        }

        @Override
        public void mouseReleased(SurfacePainterTool surfacePainterTool, MouseEvent mouseEvent) {
            super.mouseReleased(surfacePainterTool, mouseEvent);
            surfacePainterTool.updatePickFace();
            if (mouseEvent.getButton() == 1) {
                surfacePainterTool.paintCurrentFace();
                if (surfacePainterTool.d_facePainters.size() > 0) {
                    surfacePainterTool.finish();
                }
            }
        }
    }

    private static class Selection {
        public final ISurfObj obj;
        public final int faceIx;
        public final boolean wholeObj;

        public Selection(ISurfObj iSurfObj, int n, boolean bl) {
            this.obj = iSurfObj;
            this.faceIx = n;
            this.wholeObj = bl;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Selection && ((Selection)object).obj == object && ((Selection)object).faceIx == this.faceIx && ((Selection)object).wholeObj == this.wholeObj;
        }
    }

    private static class ObjPainted {
        public boolean surf = false;
        public boolean color = false;
        public Set<Integer> mfaces = new HashSet<Integer>();

        private ObjPainted() {
        }
    }

    public static class PaintTask
    extends AUndoableTask {
        private final PaintRecord[] records;

        public PaintTask(Collection<PaintRecord> collection) {
            this.records = theUtil.toArray(collection, PaintRecord.class);
        }

        protected PyroMod getDomain() {
            if (this.records.length == 0) {
                return null;
            }
            return (PyroMod)this.records[0].obj.getDomain();
        }

        @Override
        public void run() {
            PyroMod pyroMod = this.getDomain();
            if (pyroMod != null) {
                pyroMod.pauseUpdates();
            }
            for (int i = 0; i < this.records.length; ++i) {
                PaintRecord paintRecord = this.records[i];
                PaintRecord paintRecord2 = new PaintRecord(paintRecord.obj, paintRecord.colors != null ? paintRecord.obj.getColors() : null, paintRecord.surfs != null ? paintRecord.obj.getSurfaces() : null, paintRecord.geom != null ? paintRecord.obj.getGeom() : null);
                if (paintRecord.colors != null) {
                    paintRecord.obj.setColors(paintRecord.colors);
                }
                if (paintRecord.surfs != null) {
                    paintRecord.obj.setSurfaces(paintRecord.surfs);
                }
                if (paintRecord.geom != null) {
                    paintRecord.obj.setGeom(paintRecord.geom);
                }
                this.records[i] = paintRecord2;
            }
            if (pyroMod != null) {
                pyroMod.resumeUpdates();
            }
        }

        @Override
        public void undo() {
            this.run();
        }
    }

    private static class PaintRecord {
        public final ISurfObj obj;
        public Color[] colors;
        public Surface[] surfs;
        public IGeomNode geom;

        public PaintRecord(ISurfObj iSurfObj) {
            this(iSurfObj, null, null, null);
        }

        public PaintRecord(ISurfObj iSurfObj, Color[] colorArray, Surface[] surfaceArray, IGeomNode iGeomNode) {
            this.obj = iSurfObj;
            this.colors = colorArray;
            this.surfs = surfaceArray;
            this.geom = iGeomNode;
        }
    }

    public static class FacePainter {
        public final ISurfObj obst;
        public final ISurfObj clone;
        public final int ix;
        public final boolean paintSurf;
        public final Surface newSurf;
        public final boolean paintColor;
        public final Color newColor;

        public FacePainter(ISurfObj iSurfObj, ISurfObj iSurfObj2, int n, boolean bl, Surface surface, boolean bl2, Color color) {
            this.obst = iSurfObj;
            this.clone = iSurfObj2;
            this.ix = n;
            this.paintSurf = bl;
            this.newSurf = surface;
            this.paintColor = bl2;
            this.newColor = color;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof FacePainter && ((FacePainter)object).obst == this.obst && ((FacePainter)object).ix == this.ix;
        }

        public int hashCode() {
            return -1842044929 + this.ix + System.identityHashCode(this.obst);
        }

        public void apply() {
            if (this.paintSurf) {
                int n = this.clone.getNumFaces();
                IGeomNode iGeomNode = this.clone.getGeom();
                Surface[] surfaceArray = this.clone.getSurfaces();
                Surface surface = surfaceArray[this.ix];
                if (surface != this.newSurf) {
                    surfaceArray[this.ix] = this.newSurf;
                    this.clone.setSurfaces(surfaceArray);
                    assert (this.clone.getGeom().getChildren().isEmpty());
                    IElemSource<Point2d> iElemSource = FDSUtil.getDefaultTexMapper();
                    Map<String, IElemSource<Point2d>> map = iGeomNode.getLocalElements().get(Elements.UV);
                    for (Map.Entry<String, IElemSource<Point2d>> entry : map.entrySet()) {
                        IElemSource<Point2d>[] iElemSourceArray = Elements.decompress(entry.getValue(), 0, n, false).getArray();
                        iElemSourceArray[this.ix] = iElemSource;
                    }
                }
            }
            if (this.paintColor) {
                Color[] colorArray = this.clone.getColors();
                colorArray[this.ix] = this.newColor;
                this.clone.setColors(colorArray);
            }
        }

        public boolean isNull() {
            Serializable serializable;
            Serializable[] serializableArray;
            if (this.paintSurf) {
                serializableArray = this.clone.getSurfaces();
                Serializable serializable2 = serializable = serializableArray.length == 1 ? serializableArray[0] : serializableArray[this.ix];
                if (serializable != this.newSurf) {
                    return false;
                }
            }
            if (this.paintColor) {
                serializableArray = this.clone.getColors();
                Serializable serializable3 = serializable = serializableArray.length == 1 ? serializableArray[0] : serializableArray[this.ix];
                if (!theUtil.equal(serializable, this.newColor)) {
                    return false;
                }
            }
            return true;
        }

        public static IGeomNode decompressSurf(ISurfObj iSurfObj, ISurfObj iSurfObj2, FaceCache faceCache) {
            IGeomNode iGeomNode;
            Object object;
            int n = iSurfObj2.getNumFaces();
            Surface[] surfaceArray = iSurfObj2.getSurfaces();
            surfaceArray = GeomUtil.matchPrimCount(surfaceArray, Surface.class, true, n);
            iSurfObj2.setSurfaces(surfaceArray);
            IGeomNode iGeomNode2 = iSurfObj2.getGeom();
            if (faceCache != null) {
                object = faceCache.getFaces(iSurfObj);
                iGeomNode = GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(((FaceCache.Faces)object).faces), ((FaceCache.Faces)object).elems);
            } else {
                iGeomNode = iGeomNode2.flatten();
            }
            object = Elements.copyOf(iGeomNode.getLocalElements());
            Map<String, IElemSource<Point2d>> map = object.get(Elements.UV);
            ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>(map);
            int n2 = iGeomNode.getLocalGeom().getNumPrims(7);
            for (Map.Entry<String, IElemSource<Point2d>> entry : map.entrySet()) {
                listMap.put(entry.getKey(), Elements.decompress(entry.getValue(), 0, n2, true));
            }
            object.set(Elements.UV, listMap);
            iGeomNode = iGeomNode.applyLocalElements((IPropertySet)object);
            iSurfObj2.setGeom(iGeomNode);
            return iGeomNode2;
        }

        public static void compressSurf(ISurfObj iSurfObj, IGeomNode iGeomNode, Set<Integer> set) {
            iSurfObj.setSurfaces(GeomUtil.optimize(iSurfObj.getSurfaces()));
            IGeomNode iGeomNode2 = iGeomNode;
            assert (iSurfObj.getGeom().getChildren().isEmpty());
            Map<String, IElemSource<Point2d>> map = iSurfObj.getGeom().getLocalElements().get(Elements.UV);
            for (Map.Entry<String, IElemSource<Point2d>> entry : map.entrySet()) {
                ElementFlattened elementFlattened = (ElementFlattened)entry.getValue();
                iGeomNode2 = iGeomNode2.applyUVElements(entry.getKey(), (n, iElemSource) -> set.contains(n) ? elementFlattened.getArray()[n] : iElemSource);
            }
            iSurfObj.setGeom(iGeomNode2);
        }

        public static void decompressColor(ISurfObj iSurfObj) {
            Color[] colorArray = GeomUtil.matchPrimCount(iSurfObj.getColors(), Color.class, true, iSurfObj.getNumFaces());
            iSurfObj.setColors(colorArray);
        }

        public static void compressColor(ISurfObj iSurfObj) {
            iSurfObj.setColors(GeomUtil.optimize(iSurfObj.getColors()));
        }
    }

    protected class PickPropAction
    extends BooleanAction {
        private static final long serialVersionUID = 4257523322539688474L;
        private final boolean d_surface;
        private final boolean d_color;

        public PickPropAction(boolean bl, boolean bl2) {
            super(SurfacePainterTool.getPickPropDesc(bl, bl2), SurfacePainterTool.this.getPickPropState(bl, bl2));
            this.d_surface = bl;
            this.d_color = bl2;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                SurfacePainterTool.this.getProps().set(DrawProps.SPECIFY_SURFACE, this.d_surface);
                SurfacePainterTool.this.getProps().set(DrawProps.SPECIFY_COLOR, this.d_color);
                SurfacePainterTool.this.updatePickFace();
            }
        }
    }
}

