/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.format.DoubleListFormat;
import thunderheadeng.gui.format.UDListFormat;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class RotateTool
extends ATransformTool
implements ValueEditor.IListener {
    private RotInfo d_rotation = null;

    public RotateTool(ModelView modelView, TransformMgr transformMgr, ModelScene modelScene, DrawProps drawProps) {
        super(modelView, transformMgr, modelScene, drawProps);
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        valueEditor.addChoice(Value.BASE.name(), new ValueEditor.Choice(Intl.intl("Rotate Center (x,y,z)"), new guiFormattedFld<Object>(new UDListFormat(UnitSystem.getSource(0), 3, 3), null)));
        valueEditor.addChoice(Value.REF_VECTOR.name(), new ValueEditor.Choice(Intl.intl("Reference Direction (x,y,z)"), new guiFormattedFld<Object>(new DoubleListFormat(3, 3), null)));
        valueEditor.addChoice(Value.ANGLE.name(), new ValueEditor.Choice(Intl.intl("Angle"), new guiFormattedFld<Object>(new UnitDoubleFormat(new ConstantUnitSrc(NonSI.DEGREE_ANGLE)), null)));
    }

    @Override
    public void activate() {
        super.activate();
        this.reset();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        if (this.getRotation().baseCommitted) {
            return this.getRotation().base;
        }
        return null;
    }

    protected RotInfo getRotation() {
        if (this.d_rotation == null) {
            this.d_rotation = new RotInfo();
        }
        return this.d_rotation;
    }

    @Override
    public void reset() {
        this.d_rotation = null;
        super.reset();
    }

    @Override
    public void valueEditorChanged(ValueEditor valueEditor, boolean bl) {
        RotInfo rotInfo = this.getRotation();
        Value value = Value.valueOf(valueEditor.getCurrentValueType());
        switch (value) {
            case BASE: {
                UnitDouble[] unitDoubleArray = (UnitDouble[])valueEditor.getValue();
                if (unitDoubleArray.length < 3) break;
                Point3d point3d = new UnitPoint3D(unitDoubleArray).getPoint3dValue(Geometry.LU);
                try {
                    point3d = this.constrain(this.getSnapConstraint(), point3d);
                    this.setBase(rotInfo, point3d, bl);
                }
                catch (CursorTool.ConstraintException constraintException) {}
                break;
            }
            case REF_VECTOR: {
                Point3d point3d;
                double[] dArray = (double[])valueEditor.getValue();
                if (dArray.length < 3) break;
                Vector3d vector3d = new Vector3d(dArray);
                Plane3d plane3d = this.getWorkingPlane();
                Point3d point3d2 = plane3d.projectOntoPlane(new Point3d(0.0, 0.0, 0.0));
                vector3d = Util3D.vector(point3d2, point3d = plane3d.projectOntoPlane(new Point3d(vector3d.x, vector3d.y, vector3d.z)));
                double d = vector3d.length();
                if (!theUtil.eq0(d, 1.0E-6)) {
                    vector3d.scale(1.0 / d);
                    this.setV1(rotInfo, vector3d, bl);
                    break;
                }
                this.setV1(rotInfo, null, false);
                break;
            }
            case ANGLE: {
                UnitDouble unitDouble = (UnitDouble)valueEditor.getValue();
                this.setAngle(rotInfo, unitDouble.getValue(Geometry.AU), bl);
                break;
            }
        }
        this.updateEditorState(false);
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        RotInfo rotInfo = this.getRotation();
        if (!rotInfo.baseCommitted) {
            this.setBase(rotInfo, this.getBase(rotInfo, point), point.committed);
        } else if (!rotInfo.v1Committed) {
            this.setV1(rotInfo, this.getV1(rotInfo, point), point.committed);
        } else if (!rotInfo.angleCommitted) {
            this.setAngle(rotInfo, this.getAngle(rotInfo, point), point.committed);
        }
    }

    private Point3d getBase(RotInfo rotInfo, MouseHistory.Point point) {
        return point.p;
    }

    private Vector3d getV1(RotInfo rotInfo, MouseHistory.Point point) {
        if (point.p.equals(rotInfo.base)) {
            return null;
        }
        return Util3D.vectorN(rotInfo.base, point.p);
    }

    private double getAngle(RotInfo rotInfo, MouseHistory.Point point) {
        Vector3d vector3d = Util3D.vector(rotInfo.base, point.p);
        double d = vector3d.length();
        if (!theUtil.eq0(d, 1.0E-6)) {
            Vector3d vector3d2 = this.getWorkingPlane().getNormal();
            vector3d.scale(1.0 / d);
            double d2 = Util3D.angle(rotInfo.v1, vector3d, vector3d2);
            IDOF iDOF = this.getXformMgr().getDOF();
            if (iDOF == IDOF.NONE) {
                return Double.NaN;
            }
            double d3 = RotateTool.snapAngle(d2, iDOF);
            if (d3 != d2) {
                d2 = d3;
                Matrix4d matrix4d = Util.rotMat(vector3d2.x, vector3d2.y, vector3d2.z, d2);
                vector3d = new Vector3d(rotInfo.v1);
                matrix4d.transform(vector3d);
            }
            if (theUtil.eq(d2, Math.PI, 1.0E-9)) {
                d2 = Math.PI;
            }
            return d2;
        }
        return Double.NaN;
    }

    private static double snapAngle(double d, IDOF iDOF) {
        if (!GeomUtil.isAligned(iDOF)) {
            return d;
        }
        double d2 = d / 1.5707963267948966;
        d2 = Math.round(d2);
        return d2 * Math.PI * 0.5;
    }

    private void setBase(RotInfo rotInfo, Point3d point3d, boolean bl) {
        rotInfo.base = point3d;
        rotInfo.baseCommitted = bl && point3d != null;
        this.update(rotInfo);
    }

    private void setV1(RotInfo rotInfo, Vector3d vector3d, boolean bl) {
        rotInfo.v1 = vector3d;
        rotInfo.v1Committed = bl && vector3d != null;
        this.update(rotInfo);
    }

    private void setAngle(RotInfo rotInfo, double d, boolean bl) {
        rotInfo.angle = d;
        rotInfo.angleCommitted = bl && !Double.isNaN(d);
        this.update(rotInfo);
    }

    @Override
    protected void updateEditorState(boolean bl) {
        RotInfo rotInfo = this.getRotation();
        if (!rotInfo.baseCommitted) {
            this.getValueEditor().setValueType(Value.BASE.name());
            if (bl && rotInfo.base != null) {
                UnitPoint3D unitPoint3D = new UnitPoint3D(rotInfo.base, Geometry.LU);
                UnitDouble[] unitDoubleArray = new UnitDouble[]{unitPoint3D.xu(), unitPoint3D.yu(), unitPoint3D.zu()};
                this.getValueEditor().setValue(unitDoubleArray);
            }
        } else if (!rotInfo.v1Committed) {
            this.getValueEditor().setValueType(Value.REF_VECTOR.name());
            if (bl && rotInfo.v1 != null) {
                double[] dArray = new double[]{rotInfo.v1.x, rotInfo.v1.y, rotInfo.v1.z};
                this.getValueEditor().setValue(dArray);
            }
        } else if (!rotInfo.angleCommitted) {
            this.getValueEditor().setValueType(Value.ANGLE.name());
            if (bl && !Double.isNaN(rotInfo.angle)) {
                this.getValueEditor().setValue(new UnitDouble(rotInfo.angle, Geometry.AU));
            }
        }
    }

    private void update(RotInfo rotInfo) {
        ITransform iTransform;
        Object object;
        Plane3d plane3d = this.getWorkingPlane();
        Vector3d vector3d = plane3d != null ? plane3d.getNormal() : null;
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
        PropsBuilder propsBuilder = new PropsBuilder();
        if (!Double.isNaN(rotInfo.angle)) {
            assert (vector3d != null);
            object = this.getView();
            double d = ((View)object).screenToWorld(25.0, rotInfo.base);
            Vector3d vector3d2 = rotInfo.v1;
            Vector3d vector3d3 = vector3d;
            Vector3d vector3d4 = Util3D.cross(vector3d3, vector3d2);
            Matrix4d matrix4d = Util.translateMat(rotInfo.base.x, rotInfo.base.y, rotInfo.base.z);
            Matrix4d matrix4d2 = new Matrix4d(vector3d2.x, vector3d4.x, vector3d3.x, 0.0, vector3d2.y, vector3d4.y, vector3d3.y, 0.0, vector3d2.z, vector3d4.z, vector3d3.z, 0.0, 0.0, 0.0, 0.0, 1.0);
            matrix4d.mul(matrix4d2);
            Arc2D.Double double_ = ShapeUtil.newCircularArc(0.0, 0.0, d, 0.0, rotInfo.angle, rotInfo.angle >= 0.0);
            ShapeGeom shapeGeom = new ShapeGeom((Shape)double_, matrix4d);
            arrayList.add(shapeGeom);
            propsBuilder.add(new IPrimProps.Edge(Color.BLUE, 2.0, IPrimProps.DEF_STIPPLE, 0));
            Point3d point3d = rotInfo.base;
            Vector3d vector3d5 = new Vector3d(rotInfo.v1);
            Matrix4d matrix4d3 = Util.rotMat(vector3d.x, vector3d.y, vector3d.z, rotInfo.angle);
            matrix4d3.transform(vector3d5);
            Point3d point3d2 = this.projectToFrustum(rotInfo.base, vector3d5);
            arrayList.add(new LineSeg(point3d, point3d2));
            propsBuilder.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
        }
        if (rotInfo.v1 != null) {
            object = rotInfo.base;
            Point3d point3d = this.projectToFrustum(rotInfo.base, rotInfo.v1);
            arrayList.add(new LineSeg((Point3d)object, point3d));
            propsBuilder.add(new IPrimProps.Edge(Color.RED, 3.0, IPrimProps.DEF_STIPPLE, 0));
        }
        if (rotInfo.base != null) {
            arrayList.add(new Point(rotInfo.base));
            propsBuilder.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(arrayList)), propsBuilder.finalizeProps());
        object = TransformUtil.IDENTITY;
        if (!Double.isNaN(rotInfo.angle) && (iTransform = TransformUtil.rotate(vector3d.x, vector3d.y, vector3d.z, rotInfo.angle)).getInfo().isAccepted(this.getXformMgr().getDOF())) {
            ITransform iTransform2 = TransformUtil.translate(rotInfo.base.x, rotInfo.base.y, rotInfo.base.z);
            iTransform2 = iTransform2.concatenate(iTransform);
            iTransform2 = iTransform2.concatenate(TransformUtil.translate(-rotInfo.base.x, -rotInfo.base.y, -rotInfo.base.z));
            object = iTransform2;
        }
        this.getXformMgr().modify((ITransform)object);
        if (rotInfo.angleCommitted) {
            this.finish();
        }
        this.repaintSurface();
    }

    @Override
    protected Plane3d getWorkingPlane() {
        RotInfo rotInfo = this.getRotation();
        if (this.getView().getCamera() instanceof PerspectiveCamera && rotInfo.baseCommitted) {
            return new Plane3d(new Vector3d(0.0, 0.0, 1.0), rotInfo.base);
        }
        return super.getWorkingPlane();
    }

    private static class RotInfo {
        public Point3d base = null;
        public boolean baseCommitted = false;
        public Vector3d v1 = null;
        public boolean v1Committed = false;
        public double angle = Double.NaN;
        public boolean angleCommitted = false;

        private RotInfo() {
        }
    }

    private static enum Value {
        BASE,
        REF_VECTOR,
        ANGLE;

    }
}

