/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.function.Function;
import javax.vecmath.Point2d;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.MouseSelectionLogic;
import pyrosim.mv.snappers.ModelGridSnapper;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.theUtil;

public class Pyro3DSelector
implements ISelectionLogic {
    private final MouseSelectionLogic d_selLogic;

    public Pyro3DSelector(MouseSelectionLogic mouseSelectionLogic) {
        this.d_selLogic = mouseSelectionLogic;
    }

    public IIsectFilter getSelectionFilter(CursorTool cursorTool) {
        if (this.gridSelEnabled(cursorTool)) {
            return new DefaultFilter(IPyroObject.class, ModelGridSnapper.class);
        }
        return new DefaultFilter(IPyroObject.class);
    }

    private boolean gridSelEnabled(CursorTool cursorTool) {
        return cursorTool.isKeyPressed(71);
    }

    @Override
    public void selectSingle(CursorTool cursorTool, MouseEvent mouseEvent, Point2d point2d, GeomPicker geomPicker) {
        Collection<IsectInfo> collection = ISelectionLogic.find(cursorTool, geomPicker, point2d, this.getSelectionFilter(cursorTool));
        this.d_selLogic.handleSelectionSingle(mouseEvent, cursorTool.getPressedKeys(), Pyro3DSelector.transformGrids(Pyro3DSelector.transformIsects(collection)));
    }

    @Override
    public void selectMultiple(CursorTool cursorTool, MouseEvent mouseEvent, Point2d point2d, Point2d point2d2, GeomPicker geomPicker) {
        Collection<Object> collection = ISelectionLogic.find(cursorTool, geomPicker, point2d, point2d2, this.getSelectionFilter(cursorTool));
        this.d_selLogic.handleSelectionMultiple(mouseEvent, cursorTool.getPressedKeys(), Pyro3DSelector.transformGrids(collection));
    }

    private static Collection<Object> transformGrids(Collection<Object> collection) {
        Function<Object, Object> function = new Function<Object, Object>(){

            @Override
            public Object apply(Object object) {
                if (object instanceof ModelGridSnapper) {
                    return ((ModelGridSnapper)object).getGrid();
                }
                return object;
            }
        };
        return theUtil.map(collection, function);
    }

    private static Collection<Object> transformIsects(Collection<IsectInfo> collection) {
        return theUtil.map(collection, new Function<IsectInfo, Object>(){

            @Override
            public Object apply(IsectInfo isectInfo) {
                return isectInfo.obj;
            }
        });
    }
}

