/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.ModelView;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.MouseHistory;

public class MirrorTool
extends ATransformTool {
    public MirrorTool(ModelView modelView, TransformMgr transformMgr, ModelScene modelScene, DrawProps drawProps) {
        super(modelView, transformMgr, modelScene, drawProps);
    }

    protected ITransform getXform(Point3d point3d, Point3d point3d2) {
        Plane3d plane3d = this.getWorkingPlane();
        Vector3d vector3d = plane3d.getNormal();
        Vector3d vector3d2 = Util3D.vector(point3d, point3d2);
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        vector3d3.normalize();
        Plane3d plane3d2 = new Plane3d(vector3d3, point3d);
        return TransformUtil.mirror(plane3d2);
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        Object object;
        Serializable serializable;
        List<Point3d> list = mouseHistory.getAllPoints();
        ArrayList<APrimitive> arrayList = new ArrayList<APrimitive>();
        PropsBuilder propsBuilder = new PropsBuilder();
        if (list.size() > 1) {
            serializable = Util3D.vector(list.get(0), list.get(1));
            object = this.projectToFrustum(list.get(0), (Vector3d)serializable);
            ((Tuple3d)serializable).negate();
            Point3d point3d = this.projectToFrustum(list.get(0), (Vector3d)serializable);
            arrayList.add(new LineSeg((Point3d)object, point3d));
            propsBuilder.add(new IPrimProps.Edge(Color.RED, 3.0, IPrimProps.DEF_STIPPLE, 0));
            arrayList.add(new Point(list.get(1)));
            propsBuilder.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        if (list.size() > 0) {
            arrayList.add(new Point(list.get(0)));
            propsBuilder.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(arrayList)), propsBuilder.finalizeProps());
        serializable = TransformUtil.IDENTITY;
        if (list.size() > 1 && ((TransformInfo)(object = this.getXform(list.get(0), list.get(1)).getInfo())).isAccepted(this.getXformMgr().getDOF())) {
            serializable = ((TransformInfo)object).xform;
        }
        this.getXformMgr().modify((ITransform)serializable);
        if (mouseHistory.committedSize() == 2) {
            this.finish();
        }
        this.repaintSurface();
    }
}

