/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.util.theUtil;

public class MeshAutoAxisChooser
implements DrawPlaneGeomTool.IAutoAxisChooser {
    private final PyroMod d_domain;
    private final boolean d_selGridsOnly;

    public MeshAutoAxisChooser(PyroMod pyroMod, boolean bl) {
        this.d_domain = pyroMod;
        this.d_selGridsOnly = bl;
    }

    @Override
    public Geometry.Axis chooseAxis(DrawPlaneGeomTool drawPlaneGeomTool, Point3d point3d) {
        List<Geometry.Axis> list = drawPlaneGeomTool.getAllowableAxes();
        if (list.size() == 1) {
            return list.get(0);
        }
        CursorTool.Ray ray = drawPlaneGeomTool.getPickRay(point3d);
        Point3d point3d3 = drawPlaneGeomTool.getView().worldToScreen(ray.begin);
        RayPointProx[] rayPointProxArray = new RayPointProx[]{null};
        Geometry.Axis[] axisArray = new Geometry.Axis[]{null};
        BiConsumer<Point3d, LineSeg> biConsumer = (point3d2, lineSeg) -> {
            double d = Inter3D.nearestTOnLine(ray.begin, ray.dir, point3d2);
            if (theUtil.lt0(d, 1.0E-9)) {
                return;
            }
            Point3d point3d3 = drawPlaneGeomTool.getView().worldToScreen((Point3d)point3d2);
            double d2 = new Point2d(point3d3.x, point3d3.y).distance(new Point2d(point3d.x, point3d.y));
            RayPointProx rayPointProx = new RayPointProx(d, d2);
            if (rayPointProxArray[0] == null || rayPointProx.compareTo(rayPointProxArray[0]) < 0) {
                Vector3d vector3d = lineSeg.getTangent(0.0, ICurve.Orient.POSITIVE, true);
                Geometry.Axis axis = Geometry.Axis.values()[Util3D.getClosestAxis(vector3d)];
                if (list.contains((Object)axis)) {
                    axisArray[0] = axis;
                    rayPointProxArray[0] = rayPointProx;
                }
            }
        };
        Collection<Object> collection = this.d_selGridsOnly ? this.d_domain.getSelectionModel().flatten(Grid.class) : this.d_domain.getGridManager().flatten();
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        for (Grid grid : collection) {
            AABoxGeom aABoxGeom = new AABoxGeom(grid.getBounds());
            for (IPolygon iPolygon : GeomUtil.explode(Collections.singleton(aABoxGeom), IPolygon.class)) {
                arrayList.clear();
                iPolygon.getBoundary(arrayList);
                for (ICurve iCurve : arrayList) {
                    Mesh mesh = iCurve.getSegments(0.0);
                    if (mesh.indices.length == 0) continue;
                    Point3d point3d5 = mesh.vertices[mesh.indices[mesh.indices.length - 1]];
                    for (int i = 0; i < mesh.indices.length; ++i) {
                        Point3d point3d6 = mesh.vertices[mesh.indices[i]];
                        vector3d.sub(point3d6, point3d5);
                        if (Inter3D.lineLineSegProximity(null, point3d4, ray.begin, ray.dir, point3d5, point3d6, vector3d)) {
                            biConsumer.accept(point3d4, new LineSeg(point3d5, point3d6));
                        }
                        point3d5 = point3d6;
                    }
                }
            }
        }
        return axisArray[0];
    }
}

