/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;

public class MeasureTool
extends ADrawTool {
    private MeasureWindow d_popupWindow;

    public MeasureTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S1D);
        this.setSnapInfo(SnapMode.ANY, null);
        this.getClickHistory().setDuplicatesAllowed(true);
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    protected MeasureWindow getPopupWindow() {
        if (this.d_popupWindow == null) {
            this.d_popupWindow = new MeasureWindow();
        }
        return this.d_popupWindow;
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return IGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
    }

    @Override
    public void activate() {
        super.activate();
        this.getPopupWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getPopupWindow().detach();
        super.deactivate();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        this.getPopupWindow().update(mouseHistory);
        if (point.committed && point.dragged && mouseHistory.committedSize() == 2) {
            int n;
            double d = this.getLastSegDist(this.getClickHistory().getCommittedPoints());
            if (d > 0.0 && (n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.getAttachedComponent()), Intl.intl("Would you like to copy the distance to the clipboard?"), Intl.intl("Copy to Clipboard?"), 0)) == 0) {
                this.copyToClipboard(d);
            }
            this.finish();
        } else {
            this.updateDisplay();
            this.repaintSurface();
        }
    }

    protected void updateDisplay() {
        ArrayList<LineSeg> arrayList = new ArrayList<LineSeg>();
        PropsBuilder propsBuilder = new PropsBuilder();
        IPrimProps.Edge edge = new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0);
        List<Point3d> list = this.getClickHistory().getAllPoints();
        for (int i = 0; i < list.size() - 1; ++i) {
            Point3d point3d = list.get(i);
            Point3d point3d2 = list.get(i + 1);
            arrayList.add(new LineSeg(point3d, point3d2));
            propsBuilder.add(edge);
        }
        this.fireUpdate(0, GeomNodeUtil.newNode(GeomUtil.group(arrayList)), propsBuilder.finalizeProps());
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        super.addContextMenuActions(menuBuilder);
        List<Point3d> list = this.getClickHistory().getAllPoints();
        double d = this.getLastSegDist(list);
        double d2 = this.getTotalDist(list);
        if (d2 > 0.0) {
            String string = d2 > d ? Intl.intl("Copy total distance to clipboard") : Intl.intl("Copy distance to clipboard");
            CopyAction copyAction = new CopyAction(string, d2);
            menuBuilder.add(copyAction);
        }
        menuBuilder.addSeparator();
    }

    private void copyToClipboard(double d) {
        try {
            Unit[] unitArray = this.getModelView().getLengthUnits();
            double d2 = UnitDouble.convert(d, unitArray[0], unitArray[1]);
            String string = Double.toString(d2) + " " + unitArray[1].toString();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
        catch (Exception exception) {
            System.err.println("[23498f] Could not copy to clipboard");
            exception.printStackTrace();
        }
    }

    public double getLastSegDist(List<Point3d> list) {
        if (list.size() < 2) {
            return 0.0;
        }
        Point3d point3d = list.get(list.size() - 1);
        Point3d point3d2 = list.get(list.size() - 2);
        return point3d2.distance(point3d);
    }

    public double getTotalDist(List<Point3d> list) {
        double d = 0.0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Point3d point3d = list.get(i);
            Point3d point3d2 = list.get(i + 1);
            d += point3d.distance(point3d2);
        }
        return d;
    }

    private class CopyAction
    extends guiAction {
        private static final long serialVersionUID = 6997068062523459877L;
        private final double d_dist;

        public CopyAction(String string, double d) {
            super(string);
            this.d_dist = d;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MeasureTool.this.copyToClipboard(this.d_dist);
            MeasureTool.this.finish();
        }
    }

    private class MeasureWindow
    extends HoverWindow {
        private static final long serialVersionUID = 5006700539880599966L;

        public MeasureWindow() {
            super(MeasureTool.this.getAttachedComponent());
        }

        public void update(MouseHistory mouseHistory) {
            String string2;
            double d;
            List<Point3d> list = mouseHistory.getAllPoints();
            if (list.isEmpty()) {
                this.setVisible(false);
                return;
            }
            this.getContentPane().removeAll();
            ArrayList<String> arrayList = new ArrayList<String>();
            Point3d point3d = list.get(list.size() - 1);
            arrayList.add(String.format(Intl.intl("<b>Location:</b> %s"), MeasureTool.this.toString(point3d)));
            if (list.size() > 1) {
                d = MeasureTool.this.getLastSegDist(list);
                string2 = list.size() > 2 ? String.format(Intl.intl("<b>Current Segment Distance:</b> %s"), MeasureTool.this.toString(d)) : String.format(Intl.intl("<b>Distance:</b> %s"), MeasureTool.this.toString(d));
                arrayList.add(string2);
            }
            if (list.size() > 2) {
                d = MeasureTool.this.getTotalDist(list);
                string2 = String.format(Intl.intl("<b>Total Distance:</b> %s"), MeasureTool.this.toString(d));
                arrayList.add(string2);
            }
            GridBagHelper gridBagHelper = new GridBagHelper(this.getContentPane());
            gridBagHelper.d_rowSpace = 1;
            for (String string2 : arrayList) {
                string2 = "<html>" + string2 + "</html>";
                gridBagHelper.addRow(string2, 0);
            }
            gridBagHelper.finalizeRows();
            this.pack();
            this.setVisible(true);
            this.repaint();
        }
    }
}

