/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import java.util.Map;
import pyrosim.PyroMod;
import pyrosim.domain.geom.ISurfObj;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;

public class FaceCache
implements IEventObserver {
    public static final int MAX_CACHE_SIZE = 20;
    private final Map<ISurfObj, Faces> d_faceCache = new LinkedIdentityHashMap<ISurfObj, Faces>();

    public FaceCache(PyroMod pyroMod) {
        pyroMod.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        IEventRecord<ISurfObj> iEventRecord = events.getEvents(ISurfObj.class, new Class[0]);
        this.d_faceCache.keySet().removeAll(iEventRecord.getRemovedObjs());
        this.d_faceCache.keySet().removeAll(iEventRecord.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED));
    }

    public Faces getFaces(ISurfObj iSurfObj) {
        Faces faces = this.d_faceCache.get(iSurfObj);
        if (faces == null) {
            IGeomNode iGeomNode = iSurfObj.getGeom().flatten();
            List<IFace> list = GeomUtil.explode(iGeomNode.getLocalGeom(), IFace.class);
            faces = new Faces(list.toArray(new IFace[list.size()]), iGeomNode.getLocalElements());
            if (this.d_faceCache.size() == 20) {
                this.d_faceCache.remove(this.d_faceCache.keySet().iterator().next());
            }
            this.d_faceCache.put(iSurfObj, faces);
        } else {
            this.d_faceCache.remove(iSurfObj);
            this.d_faceCache.put(iSurfObj, faces);
        }
        return faces;
    }

    public void clear() {
        this.d_faceCache.clear();
    }

    public static class Faces {
        public final IFace[] faces;
        public final IPropertySet elems;

        public Faces(IFace[] iFaceArray, IPropertySet iPropertySet) {
            this.faces = iFaceArray;
            this.elems = iPropertySet;
        }
    }
}

