/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawWallGeomTool
extends ADrawTool
implements MouseHistory.IListener {
    private WallGeom d_wall;
    private WallGeom.Alignment d_alignment = WallGeom.Alignment.LEFT;

    public DrawWallGeomTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                DrawWallGeomTool.this.incrementAlignment();
            }
        });
    }

    public Class getGeomType() {
        return WallGeom.class;
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        this.update();
        if (point.committed && point.dragged && mouseHistory.getHistory().size() == 2 && this.d_wall != null) {
            this.finish();
            return;
        }
        if (point.committed) {
            this.finishIfClosed();
        }
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        if (this.getClickHistory().committedSize() >= 2) {
            menuBuilder.add(new FinishAction());
        }
        if (this.getClickHistory().committedSize() >= 3) {
            menuBuilder.add(new CloseAction());
        }
        menuBuilder.addSeparator();
        menuBuilder.addMutuallyExclusive(new AlignmentAction(Intl.intl("Align wall to left"), WallGeom.Alignment.LEFT), new AlignmentAction(Intl.intl("Align wall to right"), WallGeom.Alignment.RIGHT), new AlignmentAction(Intl.intl("Align wall to center"), WallGeom.Alignment.CENTER));
        super.addContextMenuActions(menuBuilder);
    }

    private void finishIfClosed() {
        Deque<MouseHistory.Point> deque = this.getClickHistory().getHistory();
        if (deque.size() >= 3 && deque.peekFirst().equals(deque.peekLast())) {
            this.finish();
        }
    }

    @Override
    public void finish() {
        this.getClickHistory().finalizePoints();
        this.update();
        this.fireFinish(this.d_wall != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_wall = null;
        super.reset();
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyPressed(keyEvent);
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.finish();
            }
        }
        this.resumeRepaint(true);
    }

    protected void incrementAlignment() {
        WallGeom.Alignment alignment;
        switch (this.d_alignment) {
            case LEFT: {
                alignment = WallGeom.Alignment.RIGHT;
                break;
            }
            case RIGHT: {
                alignment = WallGeom.Alignment.CENTER;
                break;
            }
            default: {
                alignment = WallGeom.Alignment.LEFT;
            }
        }
        this.setAlignment(alignment);
    }

    protected void setAlignment(WallGeom.Alignment alignment) {
        this.d_alignment = alignment;
        this.update();
    }

    private void update() {
        if (this.d_wall != null) {
            this.fireRemove(0);
            this.d_wall = null;
        }
        if (this.getClickHistory().size() >= 2) {
            WallGeom wallGeom;
            this.d_wall = wallGeom = this.newWall(this.getClickHistory().getAllPoints());
            this.fireUpdate(0, GeomNodeUtil.newNode(wallGeom), null);
        }
        this.updateStatusMessage();
        this.repaintSurface();
    }

    private WallGeom newWall(Collection<Point3d> collection) {
        DrawProps drawProps = this.getProps();
        Iterator<Point3d> iterator = collection.iterator();
        ACurve aCurve = collection.size() == 2 ? new LineSeg(iterator.next(), iterator.next()) : new PolyLine(collection.toArray(new Point3d[collection.size()]));
        WallGeom wallGeom = new WallGeom(aCurve, this.d_alignment, Math.abs(drawProps.get(DrawProps.THICKNESS).getValue(Geometry.LU)), drawProps.get(DrawProps.HEIGHT).getValue(Geometry.LU));
        return wallGeom;
    }

    protected class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -7182806987253734853L;

        public FinishAction() {
            super(Intl.intl("&Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawWallGeomTool.this.finish();
        }
    }

    protected class AlignmentAction
    extends BooleanAction {
        private static final long serialVersionUID = 1071723952695168321L;
        private final WallGeom.Alignment d_alignment;

        public AlignmentAction(String string, WallGeom.Alignment alignment) {
            super(string, alignment == DrawWallGeomTool.this.d_alignment);
            this.d_alignment = alignment;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawWallGeomTool.this.setAlignment(this.d_alignment);
            }
        }
    }

    protected class CloseAction
    extends guiAction {
        private static final long serialVersionUID = -1783748032522181284L;

        public CloseAction() {
            super(Intl.intl("&Close"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawWallGeomTool.this.getClickHistory().addPoint(DrawWallGeomTool.this.getClickHistory().getHistory().getFirst().snap, true);
        }
    }
}

