/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.ActionsMesh;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.ToolMeta;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class DrawToolBridge
implements ADrawTool.Listener,
ToolManager.ToolChangeListener {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final DisplayManager d_dispMgr;
    private final ToolManager d_toolMgr;
    private final Map<Integer, IPyroGeomSrc> d_geomMap;

    public DrawToolBridge(PyroMod pyroMod, ModelView modelView, DisplayManager displayManager, ToolManager toolManager) {
        this.d_domain = pyroMod;
        this.d_mv = modelView;
        this.d_dispMgr = displayManager;
        this.d_toolMgr = toolManager;
        this.d_geomMap = new HashMap<Integer, IPyroGeomSrc>();
        Tool tool = toolManager.getCurrentTool();
        if (tool instanceof ADrawTool) {
            ((ADrawTool)tool).addListener(this);
        }
        toolManager.addToolChangeListener(this);
    }

    @Override
    public void toolWillChanged(Tool tool, Tool tool2) {
        if (tool instanceof ADrawTool) {
            this.d_dispMgr.remove(this.d_geomMap.values());
            this.d_geomMap.clear();
            ((ADrawTool)tool).removeListener(this);
        }
        if (tool2 instanceof ADrawTool) {
            ((ADrawTool)tool2).addListener(this);
        }
    }

    @Override
    public void updateProps() {
        Tool tool = this.d_toolMgr.getCurrentTool();
        if (!(tool instanceof ADrawTool)) {
            return;
        }
        DrawProps drawProps = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
        ToolMeta toolMeta = this.getMeta();
        if (toolMeta == null || toolMeta.objCreateType == null) {
            return;
        }
        for (Map.Entry<Integer, IPyroGeomSrc> entry : this.d_geomMap.entrySet()) {
            IPyroGeomSrc iPyroGeomSrc;
            IPyroGeomSrc iPyroGeomSrc2 = entry.getValue();
            if (iPyroGeomSrc2 instanceof GenericGeomSrc || (iPyroGeomSrc = drawProps.updateObject(iPyroGeomSrc2, toolMeta.objCreateType)) == iPyroGeomSrc2) continue;
            entry.setValue(iPyroGeomSrc);
            this.d_dispMgr.remove(iPyroGeomSrc2);
            this.d_dispMgr.add(iPyroGeomSrc);
        }
    }

    @Override
    public void updateGeom(int n, IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        IPyroGeomSrc iPyroGeomSrc = this.d_geomMap.get(n);
        if (iPyroGeomSrc != null && (!(iPyroGeomSrc instanceof GenericGeomSrc) && iPropsSrc != null || iPyroGeomSrc instanceof GenericGeomSrc && iPropsSrc == null)) {
            this.remove(n);
            iPyroGeomSrc = null;
        }
        if (iPyroGeomSrc == null) {
            iPyroGeomSrc = this.newGeomSrc(iGeomNode, iPropsSrc);
            if (iPyroGeomSrc == null) {
                return;
            }
            this.d_geomMap.put(n, iPyroGeomSrc);
            this.d_dispMgr.add(iPyroGeomSrc);
        } else {
            this.updateGeomSrc(iPyroGeomSrc, iGeomNode, iPropsSrc);
            this.d_dispMgr.updateDisplays(iPyroGeomSrc);
        }
    }

    private IPyroGeomSrc newGeomSrc(IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        if (iPropsSrc != null) {
            GenericGeomSrc genericGeomSrc = new GenericGeomSrc("", iGeomNode, iPropsSrc);
            return genericGeomSrc;
        }
        ToolMeta toolMeta = this.getMeta();
        if (toolMeta == null || toolMeta.objCreateType == null) {
            return null;
        }
        DrawProps drawProps = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
        return drawProps.newObject(toolMeta.objCreateType, iGeomNode);
    }

    private void updateGeomSrc(IPyroGeomSrc iPyroGeomSrc, IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        if (iPyroGeomSrc instanceof GenericGeomSrc && iPropsSrc != null) {
            iPyroGeomSrc.setGeom(iGeomNode.bakeIfRecommended());
            ((GenericGeomSrc)iPyroGeomSrc).setDisplayProps(iPropsSrc);
        } else {
            ToolMeta toolMeta = this.getMeta();
            if (toolMeta == null || toolMeta.objCreateType == null) {
                return;
            }
            DrawProps drawProps = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
            iGeomNode = drawProps.finalizeGeom(iPyroGeomSrc, toolMeta.objCreateType, iGeomNode);
            if (iGeomNode != null) {
                iPyroGeomSrc.setGeom(iGeomNode.bakeIfRecommended());
            }
        }
    }

    @Override
    public void remove(int n) {
        IPyroGeomSrc iPyroGeomSrc = this.d_geomMap.remove(n);
        if (iPyroGeomSrc != null) {
            this.d_dispMgr.remove(iPyroGeomSrc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finish(boolean bl) {
        if (!this.d_geomMap.isEmpty() && bl) {
            void var5_11;
            Object object;
            List<IPyroGeomSrc> list;
            if (this.getMeta().objCreateType == DrawProps.ObjType.MESH_SPLIT) {
                this.finishMeshSplit();
                return;
            }
            ArrayList<IPyroGeomSrc> arrayList = new ArrayList<IPyroGeomSrc>(this.d_geomMap.size());
            LinkedIdentityHashMap<Composite, ArrayList<IPyroGeomSrc>> linkedIdentityHashMap = new LinkedIdentityHashMap<Composite, ArrayList<IPyroGeomSrc>>();
            for (IPyroGeomSrc iPyroGeomSrc : this.d_geomMap.values()) {
                void var6_12;
                IPyroGeomSrc object32 = (IPyroGeomSrc)iPyroGeomSrc.clone();
                if (object32 instanceof PlanarSlice && !this.d_domain.getSlcfList().isUnique((PlanarSlice)object32)) {
                    return;
                }
                if (object32 instanceof VolumeSlice && !this.d_domain.getSlcf3dList().isUnique((VolumeSlice)object32)) {
                    return;
                }
                arrayList.add(object32);
                Object object2 = TVEntryPoints.ep(object32).getCategoryRoot(this.d_domain, object32);
                if (object2 instanceof ModelComposite) {
                    ModelComposite modelComposite = this.d_mv.getNewObstructionGroup();
                }
                if (!(var6_12 instanceof Composite)) continue;
                list = (List)linkedIdentityHashMap.get((Composite)var6_12);
                if (list == null) {
                    list = new ArrayList<IPyroGeomSrc>();
                    linkedIdentityHashMap.put((Composite)var6_12, (ArrayList<IPyroGeomSrc>)list);
                }
                list.add(object32);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
                Composite composite;
                list = (List)entry.getValue();
                object = null;
                if (list.size() == 1) {
                    object = (IPyroObject)list.get(0);
                } else if (list.size() > 1) {
                    composite = ((Composite)entry.getKey()).newGroup(Util.getName((IPyroObject)list.get(0)));
                    composite.addAll((Collection<IPyroObject>)list);
                    object = composite;
                }
                assert (object != null);
                composite = (Composite)entry.getKey();
                if (Util.isKeyedByName(this.d_domain, object)) {
                    arrayList2.add(new AddAutoRenameTask(composite, new IPyroObject[]{object}));
                    continue;
                }
                arrayList2.add(new AddTask((IPyroObject)entry.getKey(), new IPyroObject[]{object}));
            }
            Object var5_8 = null;
            if (arrayList2.size() == 1) {
                Task task = (Task)arrayList2.get(0);
            } else {
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_domain);
                list = arrayList2.iterator();
                while (list.hasNext()) {
                    object = (Task)list.next();
                    compositeTask.addTask((Task)object);
                }
                CompositeTask<PyroMod> compositeTask2 = compositeTask;
            }
            SelectTask selectTask = new SelectTask(this.d_domain, arrayList);
            selectTask.addTask((Task)var5_11);
            this.d_domain.getTaskManager().exec((Task)selectTask, Intl.intl("Add Object"), 1);
        }
    }

    private ToolMeta getMeta() {
        Tool tool = this.d_toolMgr.getCurrentTool();
        Object object = this.d_toolMgr.getProps((Tool)tool).meta;
        return object instanceof ToolMeta ? (ToolMeta)object : null;
    }

    private void finishMeshSplit() {
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        DrawPlaneGeomTool drawPlaneGeomTool = (DrawPlaneGeomTool)this.d_toolMgr.getCurrentTool();
        List<Plane3d> list = drawPlaneGeomTool.getPlanes();
        ArrayList<Grid> arrayList = new ArrayList<Grid>(pyroMod.getSelectionModel().flatten(Grid.class));
        Task task = ActionsMesh.SplitMeshAction.taskSplit(arrayList, list, pyroMod.getDependencies(arrayList));
        if (task != null) {
            pyroMod.getTaskManager().exec(task, Intl.intl("Split Meshes"), 1);
        }
    }
}

