/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawRoomTool
extends ADrawTool {
    private WallGeom d_wall = null;
    private WallGeom.Alignment d_alignment = WallGeom.Alignment.LEFT;

    public DrawRoomTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                DrawRoomTool.this.incrementAlignment();
                DrawRoomTool.this.repaintSurface();
            }
        });
    }

    public Class getGeomType() {
        return WallGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        ValueEditorUtil.configureLocation(valueEditor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(valueEditor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        menuBuilder.addMutuallyExclusive(new AlignmentAction(Intl.intl("Align wall to left"), WallGeom.Alignment.LEFT), new AlignmentAction(Intl.intl("Align wall to right"), WallGeom.Alignment.RIGHT), new AlignmentAction(Intl.intl("Align wall to center"), WallGeom.Alignment.CENTER));
        super.addContextMenuActions(menuBuilder);
    }

    protected void incrementAlignment() {
        WallGeom.Alignment alignment;
        switch (this.d_alignment) {
            case LEFT: {
                alignment = WallGeom.Alignment.RIGHT;
                break;
            }
            case RIGHT: {
                alignment = WallGeom.Alignment.CENTER;
                break;
            }
            default: {
                alignment = WallGeom.Alignment.LEFT;
            }
        }
        this.setAlignment(alignment);
    }

    protected void setAlignment(WallGeom.Alignment alignment) {
        this.d_alignment = alignment;
        this.updateRoom();
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        this.updateRoom();
        if (mouseHistory.committedSize() >= 2) {
            this.finish();
        }
        this.repaintSurface();
    }

    private void updateRoom() {
        List<Point3d> list = this.getClickHistory().getAllPoints();
        WallGeom wallGeom = this.d_wall = list.size() < 2 ? null : this.constructGeom(list.get(0), list.get(1));
        if (this.d_wall != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_wall), null);
        } else {
            this.fireRemove(0);
        }
    }

    private WallGeom constructGeom(Point3d point3d, Point3d point3d2) {
        if (point3d.x == point3d2.x || point3d.y == point3d2.y) {
            return null;
        }
        DrawProps drawProps = this.getProps();
        double d = point3d.z;
        Point3d[] point3dArray = new Point3d[]{new Point3d(point3d.x, point3d.y, d), new Point3d(point3d2.x, point3d.y, d), new Point3d(point3d2.x, point3d2.y, d), new Point3d(point3d.x, point3d2.y, d), new Point3d(point3d.x, point3d.y, d)};
        ICurve iCurve = DrawRoomTool.newCurve(point3dArray);
        return new WallGeom(iCurve, this.d_alignment, Math.abs(drawProps.get(DrawProps.THICKNESS).getValue(Geometry.LU)), drawProps.get(DrawProps.HEIGHT).getValue(Geometry.LU));
    }

    private static ICurve newCurve(Point3d ... point3dArray) {
        return (point3dArray = Util3D.deleteDupPoints(0.0, false, point3dArray)).length == 2 ? new LineSeg(point3dArray[0], point3dArray[1]) : new PolyLine(point3dArray);
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_wall != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_wall = null;
        super.reset();
    }

    protected class AlignmentAction
    extends BooleanAction {
        private static final long serialVersionUID = 2354631256275798741L;
        private final WallGeom.Alignment d_alignment;

        public AlignmentAction(String string, WallGeom.Alignment alignment) {
            super(string, alignment == DrawRoomTool.this.d_alignment);
            this.d_alignment = alignment;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawRoomTool.this.setAlignment(this.d_alignment);
            }
        }
    }
}

