/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.Grid;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ActionsMesh;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class DrawProps {
    public static final Prop<GeomSpace> GEOM_SPACE = new Prop("GEOM_SPACE");
    public static final Prop<UnitDouble> THICKNESS = new Prop("THICKNESS");
    public static final Prop<UnitDouble> LOCATION = new Prop("LOCATION");
    public static final Prop<UnitDouble> HEIGHT = new Prop("HEIGHT");
    public static final Prop<Surface> SURFACE = new Prop("SURFACE");
    public static final Prop<Color> COLOR = new Prop("COLOR");
    public static final Prop<Boolean> THICKEN = new Prop("THICKEN");
    public static final Prop<Boolean> PERMIT_HOLES = new Prop("PERMIT_HOLES");
    public static final Prop<Particle> PARTICLES = new Prop("PARTICLES");
    public static final Prop<PartCloud.IDropletCount> DROP_COUNT = new Prop("DROP_COUNT");
    public static final Prop<Pair<PartCloud.IInsertion, ControlBridge>> INSERTION = new Prop("INSERTION");
    public static final Prop<InitRegion> INIT = new Prop("INIT");
    public static final Prop<IDevice> DEVC = new Prop("DEVC");
    public static final Prop<Map<ObjType, String>> NAME = new Prop("NAME");
    public static final Prop<Boolean> SPECIFY_COLOR = new Prop("SPECIFY_COLOR");
    public static final Prop<Boolean> SPECIFY_SURFACE = new Prop("SPECIFY_SURFACE");
    public static final Prop<Geometry.Axis> AXIS = new Prop("AXIS");
    public static final Prop<Boolean> SLICE_VECTOR = new Prop("SLICE_VECTOR");
    public static final Prop<IQuantity> SLICE_QUANTITY = new Prop("SLICE_QUANTITY");
    public static final Prop<Boolean> SLICE_CENTERED = new Prop("SLICE_CENTERED");
    public static final Prop<MeshCellType> CELL_TYPE = new Prop("CELL_TYPE");
    public static final Prop<int[]> CELL_COUNT = new Prop("CELL_COUNT");
    public static final Prop<UnitDouble[]> CELL_SIZE = new Prop("CELL_SIZE");
    public final PyroMod d_mediator;
    private final Map<String, Object> d_values;
    private final Collection<ChangeListener> d_listeners;

    public DrawProps(PyroMod pyroMod) {
        this.d_mediator = pyroMod;
        this.d_values = new HashMap<String, Object>();
        this.d_listeners = new ArrayDeque<ChangeListener>();
        this.reset();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.d_listeners.add(changeListener);
    }

    public void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.d_listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void update(Events events) {
        Set<IPyroObject> set;
        IEventRecord<Particle> iEventRecord;
        if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) {
            this.reset();
            return;
        }
        IEventRecord<Surface> iEventRecord2 = events.getEvents(Surface.class, new Class[0]);
        if (iEventRecord2.getRemovedObjs().contains(this.get(SURFACE))) {
            this.set(SURFACE, this.d_mediator.getDefaultSurface());
        }
        if ((iEventRecord = events.getEvents(Particle.class, new Class[0])).getRemovedObjs().contains(this.get(PARTICLES))) {
            set = this.d_mediator.getPartList().flatten().isEmpty() ? null : (Particle)this.d_mediator.getPartList().flatten().iterator().next();
            this.set(PARTICLES, set);
        }
        if (iEventRecord.hasAddedObjs() && this.get(PARTICLES) == null) {
            this.set(PARTICLES, this.d_mediator.getPartList().flatten().iterator().next());
        }
        if (!(set = events.getEvents(IPyroObject.class, new Class[0]).getRemovedObjs()).isEmpty()) {
            if (!this.validateDeletedReferences((IPyroObject)this.get(INIT), set)) {
                this.set(INIT, new InitRegion());
            }
            if (!this.validateDeletedReferences((IPyroObject)this.get(DEVC), set)) {
                this.set(DEVC, DrawProps.getDefaultDevc());
            }
            if (set.contains(this.get(DrawProps.INSERTION).v2)) {
                this.set(INSERTION, new Pair(this.get(DrawProps.INSERTION).v1, null));
            }
        }
    }

    private <T extends IPyroObject> boolean validateDeletedReferences(T t, Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = new DepSnapshot();
        depSnapshot.takeSnapshot(t);
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        LinkedIdentityHashSet<IPyroObject> linkedIdentityHashSet2 = new LinkedIdentityHashSet<IPyroObject>(collection);
        while (!linkedIdentityHashSet2.isEmpty()) {
            linkedIdentityHashSet.addAll(linkedIdentityHashSet2);
            LinkedIdentityHashSet linkedIdentityHashSet3 = new LinkedIdentityHashSet();
            for (IPyroObject iPyroObject : linkedIdentityHashSet2) {
                Set<Dependency> set = depSnapshot.getDependents(iPyroObject);
                for (Dependency dependency : set) {
                    if (dependency.link == DLink.REQUIRED) {
                        return false;
                    }
                    if (dependency.link == DLink.STRONG && dependency.source instanceof IPyroObject && !linkedIdentityHashSet.contains((IPyroObject)((Object)dependency.source))) {
                        if (dependency.source == t) {
                            return false;
                        }
                        linkedIdentityHashSet3.add((IPyroObject)((Object)dependency.source));
                        continue;
                    }
                    dependency.source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            linkedIdentityHashSet2 = linkedIdentityHashSet3;
        }
        return true;
    }

    public void reset() {
        this.set(GEOM_SPACE, GeomSpace.S3D);
        this.set(LOCATION, new UnitDouble(0.0, SI.METER));
        this.set(HEIGHT, new UnitDouble(1.0, SI.METER));
        this.set(THICKNESS, new UnitDouble(0.2, SI.METER));
        this.set(SURFACE, this.d_mediator.getDefaultSurface());
        this.set(COLOR, null);
        this.set(THICKEN, false);
        this.set(PERMIT_HOLES, true);
        PartCloud partCloud = new PartCloud();
        this.set(INSERTION, new Pair<PartCloud.IInsertion, Object>(partCloud.getInsertion(), null));
        this.set(DROP_COUNT, partCloud.getInitDrops());
        Particle particle = !this.d_mediator.getPartList().flatten().isEmpty() ? (Particle)this.d_mediator.getPartList().flatten().iterator().next() : null;
        this.set(PARTICLES, particle);
        this.set(INIT, new InitRegion());
        this.set(DEVC, DrawProps.getDefaultDevc());
        this.set(CELL_TYPE, MeshCellType.FIXED_SIZE);
        UnitDouble unitDouble = new UnitDouble(0.25, SI.METER);
        this.set(CELL_SIZE, new UnitDouble[]{unitDouble, unitDouble, unitDouble});
        this.set(CELL_COUNT, new int[]{10, 10, 10});
        this.set(NAME, new HashMap());
        for (ObjType objType : ObjType.values()) {
            this.set(new Prop(DrawProps.getNameKey(objType)), objType.defName);
        }
        this.set(SPECIFY_COLOR, false);
        this.set(SPECIFY_SURFACE, true);
        this.set(AXIS, null);
        this.set(SLICE_QUANTITY, Quantity.TEMPERATURE.create());
        this.set(SLICE_VECTOR, false);
        this.set(SLICE_CENTERED, false);
    }

    private static IDevice getDefaultDevc() {
        return new GasPointMeasurer(Intl.intl("Device"), Quantity.TEMPERATURE.create(), new FreePointLoc());
    }

    public <T> void set(Prop<T> prop, T t) {
        this.d_values.put(prop.key, t);
    }

    public <T> T get(Prop<T> prop) {
        return (T)this.d_values.get(prop.key);
    }

    public static String getNameKey(ObjType objType) {
        return objType.name() + "_NAME";
    }

    public Predicate<Surface> getSurfFilter(ObjType objType, Class<? extends IGeom> clazz) {
        switch (objType) {
            case OBSTRUCTION: {
                return Obstruction.getSurfaceFilter();
            }
            case VENT: {
                return Vent.getSurfaceFilter();
            }
        }
        return Filters.rejectAll();
    }

    public String getThicknessDesc(ObjType objType, Class<? extends IGeom> clazz) {
        if (AABoxGeom.class.isAssignableFrom(clazz)) {
            return Intl.intl("Size");
        }
        if (WallGeom.class.isAssignableFrom(clazz)) {
            return Intl.intl("Wall Thickness");
        }
        return Intl.intl("Thickness");
    }

    public Set<Prop<?>> getObjPropTypes(ObjType objType) {
        switch (objType) {
            case HOLE: {
                return Sets.fromArrayHS(NAME, SPECIFY_COLOR);
            }
            case OBSTRUCTION: {
                return Sets.fromArrayHS(NAME, SURFACE, COLOR, THICKEN, PERMIT_HOLES);
            }
            case VENT: {
                return Sets.fromArrayHS(NAME, SURFACE, COLOR);
            }
            case PART_CLOUD: {
                return Sets.fromArrayHS(NAME, PARTICLES, INSERTION, DROP_COUNT);
            }
            case INIT_REGION: {
                return Sets.fromArrayHS(NAME, INIT);
            }
            case POINT_DEVC: {
                return Sets.fromArrayHS(NAME, DEVC);
            }
            case MESH: {
                return Sets.fromArrayHS(NAME, SPECIFY_COLOR, CELL_TYPE, CELL_COUNT, CELL_SIZE);
            }
            case ZONE: {
                return Sets.fromArrayHS(NAME);
            }
            case MESH_SPLIT: {
                return Sets.fromArrayHS(AXIS);
            }
            case SLICE: {
                return Sets.fromArrayHS(NAME, SLICE_VECTOR, SLICE_CENTERED, SLICE_QUANTITY, AXIS);
            }
            case SLICE3D: {
                return Sets.fromArrayHS(NAME, SLICE_VECTOR, SLICE_CENTERED, SLICE_QUANTITY);
            }
        }
        return Collections.EMPTY_SET;
    }

    public Set<Prop<?>> getGeomPropTypes(Class<? extends IGeom> clazz) {
        if (AABoxGeom.class.isAssignableFrom(clazz) || WallGeom.class.isAssignableFrom(clazz)) {
            return Sets.fromArrayHS(THICKNESS, LOCATION, HEIGHT);
        }
        if (IPolygon.class.isAssignableFrom(clazz)) {
            return Sets.fromArrayHS(LOCATION);
        }
        if (ExtrudedPoly.class.isAssignableFrom(clazz)) {
            return Sets.fromArrayHS(THICKNESS, LOCATION);
        }
        if (Point.class.isAssignableFrom(clazz)) {
            return Sets.fromArrayHS(LOCATION);
        }
        if (PlanarSurface.class.isAssignableFrom(clazz)) {
            return Sets.fromArrayHS(AXIS);
        }
        return Collections.EMPTY_SET;
    }

    public Set<Prop<?>> getPropTypes(ObjType objType, Class<? extends IGeom> clazz) {
        HashSet hashSet = new HashSet(this.getObjPropTypes(objType));
        hashSet.addAll(this.getGeomPropTypes(clazz));
        return hashSet;
    }

    public IPyroGeomSrc newObject(ObjType objType, IGeomNode iGeomNode) {
        IPyroGeomSrc iPyroGeomSrc = objType == ObjType.POINT_DEVC ? (IPyroGeomSrc)this.get(DEVC) : null;
        iGeomNode = this.finalizeGeom(iPyroGeomSrc, objType, iGeomNode);
        if (iGeomNode == null) {
            return null;
        }
        String string = DrawProps.getNameKey(objType);
        String string2 = (String)this.get(new Prop(string));
        IPyroGeomSrc iPyroGeomSrc2 = null;
        switch (objType) {
            case OBSTRUCTION: {
                iPyroGeomSrc2 = new Obstruction(string2, iGeomNode, new Surface[]{this.get(SURFACE)});
                break;
            }
            case HOLE: {
                iPyroGeomSrc2 = new Hole(string2, iGeomNode);
                break;
            }
            case VENT: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof AARectangle);
                iPyroGeomSrc2 = new Vent(string2, this.get(SURFACE), (AARectangle)iGeom);
                break;
            }
            case INIT_REGION: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof AABoxGeom);
                iPyroGeomSrc2 = new InitRegion(string2, (AABoxGeom)iGeom);
                break;
            }
            case PART_CLOUD: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof AABoxGeom || iGeom instanceof Point);
                iPyroGeomSrc2 = new PartCloud(string2, this.get(PARTICLES), iGeom);
                break;
            }
            case POINT_DEVC: {
                IDevice iDevice = this.get(DEVC);
                if (iDevice == null) break;
                iPyroGeomSrc2 = (IDevice)iDevice.clone();
                break;
            }
            case MESH: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof Grid.GridGeom);
                iPyroGeomSrc2 = new Grid(string2, (Grid.GridGeom)iGeom);
                break;
            }
            case SLICE: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof PlanarSurface);
                iPyroGeomSrc2 = new PlanarSlice((PlanarSurface)iGeom, (IQuantity)Quantity.TEMPERATURE.create(), false, false);
                break;
            }
            case SLICE3D: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof AABoxGeom);
                IQuantity iQuantity = this.get(SLICE_QUANTITY);
                string2 = this.d_mediator.getNames().getNames(VolumeSlice.class).generateValidName(iQuantity.getDescription());
                iPyroGeomSrc2 = new VolumeSlice(string2, iGeom, iQuantity, false, false);
                break;
            }
            case MESH_SPLIT: {
                iPyroGeomSrc2 = new GenericGeomSrc(string2, iGeomNode, DisplayGeom.EMPTY.props);
                break;
            }
            case ZONE: {
                IGeom iGeom = iGeomNode.flatten().getLocalGeom();
                assert (iGeom instanceof AABoxGeom);
                iPyroGeomSrc2 = new Zone(string2, new UnitAABox(((AABoxGeom)iGeom).getBoundingBox(new AABox()), Geometry.LU));
                break;
            }
            case HVAC_NODE: {
                assert (iGeomNode.flatten().getLocalGeom() instanceof Point);
                HvacNode hvacNode = new HvacNode(string2);
                hvacNode.setGeom(iGeomNode);
                iPyroGeomSrc2 = hvacNode;
                break;
            }
            case HVAC_DUCT: {
                assert (iGeomNode.flatten().getLocalGeom() instanceof HvacDuct.DuctGeom);
                HvacDuct hvacDuct = new HvacDuct(string2);
                hvacDuct.setGeom(iGeomNode);
                iPyroGeomSrc2 = hvacDuct;
                break;
            }
        }
        if (iPyroGeomSrc2 != null) {
            iPyroGeomSrc2 = this.updateObject(iPyroGeomSrc2, objType);
        }
        return iPyroGeomSrc2;
    }

    public IPyroGeomSrc updateObject(IPyroGeomSrc iPyroGeomSrc, ObjType objType) {
        if (iPyroGeomSrc == null) {
            return null;
        }
        String string = DrawProps.getNameKey(objType);
        String string2 = (String)this.get(new Prop(string));
        if (iPyroGeomSrc instanceof INamed) {
            ((INamed)((Object)iPyroGeomSrc)).setName(string2);
        }
        if (iPyroGeomSrc instanceof ISurfObj) {
            ((ISurfObj)iPyroGeomSrc).setSurfaces(new Surface[]{this.get(SURFACE)});
        }
        if (iPyroGeomSrc instanceof FDSObject) {
            ((FDSObject)iPyroGeomSrc).setColors(this.get(COLOR));
        }
        switch (objType) {
            case OBSTRUCTION: {
                Obstruction obstruction = (Obstruction)iPyroGeomSrc;
                obstruction.setOptions(1, this.get(THICKEN));
                obstruction.setOptions(4, this.get(PERMIT_HOLES));
                break;
            }
            case INIT_REGION: {
                InitRegion initRegion = (InitRegion)iPyroGeomSrc;
                InitRegion initRegion2 = this.get(INIT);
                initRegion.setDensity(initRegion2.getDensity());
                initRegion.setExtraSpecies(new LinkedIdentityHashMap<ExSpec, UnitDouble>(initRegion2.getExtraSpecies()), initRegion2.getExtraSpeciesType());
                initRegion.setTemperature(initRegion2.getTemperature());
                break;
            }
            case PART_CLOUD: {
                PartCloud partCloud = (PartCloud)iPyroGeomSrc;
                partCloud.setParticle(this.get(PARTICLES));
                Pair<PartCloud.IInsertion, ControlBridge> pair = this.get(INSERTION);
                partCloud.setInsertion((PartCloud.IInsertion)pair.v1);
                if (pair.v2 == null) {
                    partCloud.getInputPin().disconnectAll();
                } else {
                    partCloud.getInputPin().connect(((ControlBridge)pair.v2).getOutputPins().get(0));
                }
                partCloud.setInitDrops(this.get(DROP_COUNT));
                break;
            }
            case MESH: {
                Grid grid = (Grid)iPyroGeomSrc;
                grid.setColor(this.get(COLOR));
                break;
            }
            case POINT_DEVC: {
                IDevice iDevice = this.get(DEVC);
                if (iDevice == null) break;
                IDevice iDevice2 = (IDevice)iDevice.clone();
                iDevice2.setName(string2);
                iPyroGeomSrc = iDevice2;
                break;
            }
            case SLICE: {
                PlanarSlice planarSlice = (PlanarSlice)iPyroGeomSrc;
                planarSlice.setQuantity(this.get(SLICE_QUANTITY));
                planarSlice.setIncludeFlowVector(this.get(SLICE_VECTOR));
                planarSlice.setCellCentered(this.get(SLICE_CENTERED));
                break;
            }
            case SLICE3D: {
                VolumeSlice volumeSlice = (VolumeSlice)iPyroGeomSrc;
                IQuantity iQuantity = this.get(SLICE_QUANTITY);
                volumeSlice.setName(this.d_mediator.getNames().getNames(VolumeSlice.class).generateValidName(iQuantity.getDescription()));
                volumeSlice.setQuantity(iQuantity);
                volumeSlice.setIncludeFlowVector(this.get(SLICE_VECTOR));
                volumeSlice.setCellCentered(this.get(SLICE_CENTERED));
                break;
            }
            case MESH_SPLIT: {
                GenericGeomSrc genericGeomSrc = (GenericGeomSrc)iPyroGeomSrc;
                IGeomNode iGeomNode = genericGeomSrc.getGeom();
                IPrimProps.Face face = new IPrimProps.Face(new Color(255, 255, 255, 128), null, 0);
                IPrimProps.Edge edge = new IPrimProps.Edge(new Color(255, 255, 255, 255), 3.0, IPrimProps.DEF_STIPPLE, 0);
                PropsBuilder propsBuilder = new PropsBuilder();
                for (IPrimitive iPrimitive : GeomUtil.explodeToTypes(iGeomNode.flatten().getLocalGeom(), 7)) {
                    if (iPrimitive instanceof IFace) {
                        propsBuilder.add(face);
                        continue;
                    }
                    propsBuilder.add(edge);
                }
                genericGeomSrc.setDisplayProps(propsBuilder.finalizeProps());
                break;
            }
        }
        return iPyroGeomSrc;
    }

    public IGeomNode finalizeGeom(IPyroGeomSrc iPyroGeomSrc, ObjType objType, IGeomNode iGeomNode) {
        IGeom iGeom = iGeomNode.getLocalGeom();
        switch (objType) {
            case POINT_DEVC: {
                assert (iGeom instanceof Point);
                IManipulatable iManipulatable = (Point)iGeom;
                if (iPyroGeomSrc instanceof IFreePointDevice) {
                    IFreePointDevice iFreePointDevice = (IFreePointDevice)iPyroGeomSrc;
                    FreePointLoc freePointLoc = iFreePointDevice.getLocation();
                    return GeomNodeUtil.newNode(new FreePointGeom(freePointLoc.setGeom((IGeom)((Object)iManipulatable))));
                }
                if (iPyroGeomSrc instanceof IAttachedPointDevice) {
                    IAttachedPointDevice iAttachedPointDevice = (IAttachedPointDevice)iPyroGeomSrc;
                    AttachedPointLoc attachedPointLoc = iAttachedPointDevice.getAttachedLocation();
                    return GeomNodeUtil.newNode(new AttachedPointGeom(attachedPointLoc.setLoc(iManipulatable.loc)));
                }
            }
            case MESH: {
                IManipulatable iManipulatable;
                assert (iGeom instanceof AABoxGeom);
                try {
                    Object object;
                    int[] nArray;
                    iManipulatable = (AABoxGeom)iGeom;
                    if (((AABoxGeom)iManipulatable).min.x == ((AABoxGeom)iManipulatable).max.x || ((AABoxGeom)iManipulatable).min.y == ((AABoxGeom)iManipulatable).max.y || ((AABoxGeom)iManipulatable).min.z == ((AABoxGeom)iManipulatable).max.z) {
                        return null;
                    }
                    UnitPoint3D unitPoint3D = new UnitPoint3D(((AABoxGeom)iManipulatable).min, Geometry.LU);
                    UnitPoint3D unitPoint3D2 = new UnitPoint3D(((AABoxGeom)iManipulatable).max, Geometry.LU);
                    if (this.get(CELL_TYPE) == MeshCellType.FIXED_COUNT) {
                        nArray = this.get(CELL_COUNT);
                    } else {
                        object = this.get(CELL_SIZE);
                        nArray = new int[]{DrawProps.countDivs(object[0], ((AABoxGeom)iManipulatable).min.x, ((AABoxGeom)iManipulatable).max.x), DrawProps.countDivs(object[1], ((AABoxGeom)iManipulatable).min.y, ((AABoxGeom)iManipulatable).max.y), DrawProps.countDivs(object[2], ((AABoxGeom)iManipulatable).min.z, ((AABoxGeom)iManipulatable).max.z)};
                        unitPoint3D2 = new UnitPoint3D(unitPoint3D.xu().add(object[0].scale(nArray[0])), unitPoint3D.yu().add(object[1].scale(nArray[1])), unitPoint3D.zu().add(object[2].scale(nArray[2])));
                    }
                    if (nArray[0] <= 0 || nArray[1] <= 0 || nArray[2] <= 0) {
                        return null;
                    }
                    object = new Grid.GridGeom(unitPoint3D, unitPoint3D2, Grid.makeUniformDivisions(nArray[0], unitPoint3D.xu(), unitPoint3D2.xu()), Grid.makeUniformDivisions(nArray[1], unitPoint3D.yu(), unitPoint3D2.yu()), Grid.makeUniformDivisions(nArray[2], unitPoint3D.zu(), unitPoint3D2.zu()));
                    return GeomNodeUtil.newNode((IGeom)object);
                }
                catch (Throwable throwable) {
                    System.out.println(throwable.getMessage());
                    return null;
                }
            }
            case MESH_SPLIT: {
                List<IGeom> list = iGeom instanceof GeomGroup ? ((GeomGroup)iGeom).children : Arrays.asList(iGeom);
                ArrayList<IPrimitive> arrayList = new ArrayList<IPrimitive>();
                for (Grid grid : PyroSim.getApp().getMediator().getSelectionModel().flatten(Grid.class)) {
                    AABox aABox = grid.getBounds();
                    UnitDouble[][] unitDoubleArrayArray = new UnitDouble[][]{null, null, null};
                    for (PlanarSurface planarSurface : theUtil.filter(list, PlanarSurface.class)) {
                        UnitDouble unitDouble;
                        int n;
                        int n2 = Util3D.getClosestAxis(planarSurface.plane.getNormal());
                        if (unitDoubleArrayArray[n2] == null) {
                            unitDoubleArrayArray[n2] = grid.getLinePositions(n2);
                        }
                        if ((n = ActionsMesh.SplitMeshAction.getSplitIndex(unitDoubleArrayArray[n2], unitDouble = new UnitDouble(-planarSurface.plane.w, Geometry.LU))) <= 0 || n >= unitDoubleArrayArray[n2].length - 1) continue;
                        double[] dArray = new double[]{aABox.getMinX(), aABox.getMinY(), aABox.getMinZ()};
                        double[] dArray2 = new double[]{aABox.getMaxX(), aABox.getMaxY(), aABox.getMaxZ()};
                        dArray[n2] = dArray2[n2] = unitDoubleArrayArray[n2][n].getValue(Geometry.LU);
                        AARectangle aARectangle = AARectangle.construct(new Point3d(dArray), new Point3d(dArray2), false);
                        assert (aARectangle != null);
                        arrayList.add(aARectangle);
                        ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
                        aARectangle.getBoundary(arrayList2);
                        arrayList.addAll(arrayList2);
                    }
                }
                return GeomNodeUtil.newNode(GeomUtil.group(arrayList));
            }
        }
        return iGeomNode;
    }

    private static int countDivs(UnitDouble unitDouble, double d, double d2) {
        double d3 = unitDouble.getValue(Geometry.LU);
        double d4 = d2 - d;
        return Math.max(1, (int)Math.round(d4 / d3));
    }

    public static class Prop<DataT> {
        public final String key;

        public Prop(String string) {
            this.key = string;
        }
    }

    public static enum GeomSpace {
        S0D,
        S1D,
        S2D,
        S3D;

    }

    public static enum MeshCellType {
        FIXED_SIZE,
        FIXED_COUNT;

    }

    public static enum ObjType {
        OBSTRUCTION(Intl.intl("Obstruction")),
        HOLE(Intl.intl("Hole")),
        VENT(Intl.intl("Vent")),
        PART_CLOUD(Intl.intl("Particle Cloud")),
        INIT_REGION(Intl.intl("Init Region")),
        POINT_DEVC(Intl.intl("Device")),
        MESH(Intl.intl("MESH")),
        SLICE(Intl.intl("Slice")),
        SLICE3D(Intl.intl("3D Slice")),
        MESH_SPLIT(""),
        ZONE(Intl.intl("Zone")),
        HVAC_NODE(Intl.intl("Node")),
        HVAC_DUCT(Intl.intl("Duct"));

        public final String defName;

        private ObjType(String string2) {
            this.defName = string2;
        }
    }
}

