/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class DrawPlaneGeomTool
extends ADrawTool {
    private static final String LOCATION = "LOCATION";
    private final Deque<PlaneLoc> d_planeLocs;
    private final boolean d_multiplePlanes;
    private final boolean d_axisAligned;
    private final IAutoAxisChooser d_autoAxisChooser;
    private PlaneHover d_planeHover;

    public DrawPlaneGeomTool(IToolController iToolController, DrawProps drawProps, boolean bl, boolean bl2) {
        this(iToolController, drawProps, bl, bl2, null);
    }

    public DrawPlaneGeomTool(IToolController iToolController, DrawProps drawProps, boolean bl, boolean bl2, IAutoAxisChooser iAutoAxisChooser) {
        super(iToolController, drawProps, new ToolFunc(), DrawProps.GeomSpace.S2D);
        this.d_autoAxisChooser = iAutoAxisChooser;
        this.d_multiplePlanes = bl;
        this.d_axisAligned = bl2;
        this.d_planeLocs = new ArrayDeque<PlaneLoc>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                DrawPlaneGeomTool.this.setAxis(DrawPlaneGeomTool.this.getNextAxis());
                DrawPlaneGeomTool.this.repaintSurface();
            }
        });
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return PlanarSurface.class;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
    }

    protected PlaneHover getHoverWindow() {
        if (this.d_planeHover == null) {
            this.d_planeHover = new PlaneHover(this.getAttachedComponent());
        }
        return this.d_planeHover;
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        super.addContextMenuActions(menuBuilder);
        if (this.d_multiplePlanes) {
            menuBuilder.add(new FinishAction());
            menuBuilder.addSeparator();
        }
        ArrayList<PlaneAction> arrayList = new ArrayList<PlaneAction>();
        for (Geometry.Axis axis : this.getAllowableAxes()) {
            arrayList.add(new PlaneAction(axis));
        }
        menuBuilder.addMutuallyExclusive(arrayList);
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void activate() {
        super.activate();
        List<Geometry.Axis> list = this.getAllowableAxes();
        if (!list.contains((Object)this.getAxis())) {
            this.setAxis(list.get(0));
        }
        this.getHoverWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getHoverWindow().detach();
        super.deactivate();
    }

    @Override
    public void reset() {
        this.d_planeLocs.clear();
        this.updateGeom();
        super.reset();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    private void updateAll() {
        this.updateStatusMessage();
        this.updateHoverWindow();
        this.updateGeom();
    }

    protected void setAxis(Geometry.Axis axis) {
        if (this.getProps().get(DrawProps.AXIS) == axis) {
            return;
        }
        this.getProps().set(DrawProps.AXIS, axis);
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.peekLast().committed) {
            PlaneLoc planeLoc = this.d_planeLocs.removeLast();
            this.d_planeLocs.addLast(new PlaneLoc(this.chooseAxis(planeLoc.p), planeLoc.p, planeLoc.committed));
        }
        this.updateAll();
    }

    protected Geometry.Axis getAxis() {
        return this.getProps().get(DrawProps.AXIS);
    }

    protected void updateHoverWindow() {
        if (this.d_planeLocs.isEmpty()) {
            this.getHoverWindow().setVisible(false);
            return;
        }
        PlaneLoc planeLoc = this.d_planeLocs.peekLast();
        this.getHoverWindow().setPlane(planeLoc.axis, planeLoc.axis.getVal(planeLoc.p));
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        List<Point3d> list;
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.peekLast().committed) {
            this.d_planeLocs.removeLast();
        }
        this.pauseRepaint();
        if (!point.committed && point.dragged && (list = mouseHistory.getAllPoints()).size() >= 2) {
            Point3d point3d = list.get(list.size() - 2);
            Point3d point3d2 = list.get(list.size() - 1);
            double[] dArray = new double[]{Math.abs(point3d.x - point3d2.x), Math.abs(point3d.y - point3d2.y), Math.abs(point3d.z - point3d2.z)};
            int n = 0;
            double d = dArray[0];
            for (int i = 1; i < 3; ++i) {
                if (!(dArray[i] < d)) continue;
                d = dArray[i];
                n = i;
            }
            Geometry.Axis axis = Geometry.Axis.values()[n];
            if (this.getAxis() != null) {
                this.setAxis(axis);
            }
            if (!this.d_planeLocs.isEmpty()) {
                PlaneLoc planeLoc = this.d_planeLocs.removeLast();
                this.d_planeLocs.addLast(new PlaneLoc(axis, planeLoc.p, true));
            }
        }
        if (!point.dragged) {
            this.d_planeLocs.add(new PlaneLoc(this.chooseAxis(point.p), point.p, point.committed));
        }
        this.updateAll();
        this.resumeRepaint();
    }

    protected Geometry.Axis chooseAxis(Point3d point3d) {
        Geometry.Axis axis;
        Geometry.Axis axis2 = this.getAxis();
        if (axis2 != null) {
            return axis2;
        }
        if (this.d_autoAxisChooser != null && (axis = this.d_autoAxisChooser.chooseAxis(this, point3d)) != null) {
            return axis;
        }
        System.out.println("Could not determine auto axis");
        return Geometry.Axis.X;
    }

    protected Geometry.Axis getNextAxis() {
        List<Geometry.Axis> list = this.getAllowableAxes();
        int n = list.indexOf((Object)this.getAxis());
        n = n < 0 ? 0 : (n + 1) % list.size();
        return list.get(n);
    }

    public List<Geometry.Axis> getAllowableAxes() {
        Cloneable cloneable;
        EnumSet<Geometry.Axis> enumSet = EnumSet.allOf(Geometry.Axis.class);
        if (this.getView().getCamera() instanceof OrthoCamera) {
            cloneable = Util3D.normalize(this.getView().getCamera().getViewVector());
            int n = Util3D.getClosestAxis(cloneable);
            enumSet.remove((Object)Geometry.Axis.values()[n]);
        }
        cloneable = new ArrayList();
        if (this.d_autoAxisChooser != null) {
            cloneable.add(null);
        }
        cloneable.addAll(enumSet);
        return cloneable;
    }

    @Override
    public void finish() {
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.getLast().committed) {
            this.d_planeLocs.removeLast();
        }
        this.updateGeom();
        this.fireFinish(!this.d_planeLocs.isEmpty());
        super.finish();
    }

    protected void updateGeom() {
        if (this.d_planeLocs.isEmpty()) {
            this.fireRemove(0);
        } else {
            List<Plane3d> list = this.getPlanes();
            ArrayList<PlanarSurface> arrayList = new ArrayList<PlanarSurface>(list.size());
            for (Plane3d plane3d : list) {
                arrayList.add(new PlanarSurface(plane3d));
            }
            IGeom iGeom = GeomUtil.group(arrayList);
            this.fireUpdate(0, GeomNodeUtil.newNode(iGeom), null);
        }
    }

    public List<Plane3d> getPlanes() {
        ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>(this.d_planeLocs.size());
        for (PlaneLoc planeLoc : this.d_planeLocs) {
            UnitDouble unitDouble = planeLoc.axis.getVal(planeLoc.p);
            Vector3d vector3d = planeLoc.axis.toVec();
            Plane3d plane3d = new Plane3d(vector3d.x, vector3d.y, vector3d.z, -unitDouble.getValue(Geometry.LU));
            arrayList.add(plane3d);
        }
        return arrayList;
    }

    @Override
    protected String getStatusMessage() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.d_multiplePlanes) {
            arrayList.add(Intl.intl("Multi-click to set locations. Right-click to finish."));
        }
        arrayList.add(Intl.intl("Click-drag to change orientation"));
        Geometry.Axis axis = this.getNextAxis();
        if (axis != null) {
            arrayList.add(String.format(Intl.intl("Press CTRL to specify <i>%s axis</i>"), axis.toString()));
        } else {
            arrayList.add(Intl.intl("Press CTRL to choose axis automatically"));
        }
        String string = "<html>";
        for (String string2 : arrayList) {
            string2 = "&lt;" + string2 + "&gt;";
            string = string + string2;
        }
        string = string + "</html>";
        return string;
    }

    private static String getActionName(Geometry.Axis axis) {
        if (axis != null) {
            return String.format(Intl.intl("Set axis to %s"), axis.toString());
        }
        return Intl.intl("Choose axis automatically");
    }

    protected static class ToolFunc
    extends APyroTool.ToolFunc<DrawPlaneGeomTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseReleased(DrawPlaneGeomTool drawPlaneGeomTool, MouseEvent mouseEvent) {
            super.mouseReleased(drawPlaneGeomTool, mouseEvent);
            if (!drawPlaneGeomTool.d_multiplePlanes && !drawPlaneGeomTool.d_planeLocs.isEmpty() && ((PlaneLoc)((DrawPlaneGeomTool)drawPlaneGeomTool).d_planeLocs.peekLast()).committed) {
                drawPlaneGeomTool.finish();
            }
        }
    }

    public static interface IAutoAxisChooser {
        public Geometry.Axis chooseAxis(DrawPlaneGeomTool var1, Point3d var2);
    }

    private static class PlaneLoc {
        public final Geometry.Axis axis;
        public final Point3d p;
        public final boolean committed;

        public PlaneLoc(Geometry.Axis axis, Point3d point3d, boolean bl) {
            this.axis = axis;
            this.p = point3d;
            this.committed = bl;
        }
    }

    private static class PlaneHover
    extends HoverWindow {
        private static final long serialVersionUID = 3419918394404288603L;
        private Geometry.Axis d_axis;
        private UnitDouble d_val;

        public PlaneHover(Component component) {
            super(component);
        }

        public void setPlane(Geometry.Axis axis, UnitDouble unitDouble) {
            this.d_axis = axis;
            this.d_val = unitDouble;
            this.update();
        }

        public void update() {
            if (this.d_axis == null || this.d_val == null) {
                this.setVisible(false);
                return;
            }
            Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
            String string = String.format("%s = %s", this.d_axis.toString(), Global.format(this.d_val.getValue(unit), unit));
            this.getContentPane().removeAll();
            GridBagHelper gridBagHelper = new GridBagHelper(this.getContentPane());
            gridBagHelper.addFilledRow(string);
            gridBagHelper.finalizeRows();
            this.pack();
            this.setVisible(true);
            this.repaint();
        }
    }

    public class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -1349713789023524525L;

        public FinishAction() {
            super(Intl.intl("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawPlaneGeomTool.this.finish();
        }
    }

    public class PlaneAction
    extends BooleanAction {
        private static final long serialVersionUID = 446317840765443593L;
        private final Geometry.Axis axis;

        public PlaneAction(Geometry.Axis axis) {
            super(DrawPlaneGeomTool.getActionName(axis), axis == DrawPlaneGeomTool.this.getAxis());
            this.axis = axis;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawPlaneGeomTool.this.setAxis(this.axis);
            }
        }
    }
}

