/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.gui.NamedObjFormat;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawHvacDuctTool
extends ADrawTool {
    private static final String VALTYPE_NODE1 = "NODE1";
    private static final String VALTYPE_NODE2 = "NODE2";
    private HvacDuct.DuctGeom d_geom;

    public DrawHvacDuctTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S1D);
        final Predicate<HvacNode> predicate = HvacDuct.getNodeFilter();
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(new Class[]{HvacNode.class}){

            @Override
            public boolean acceptPickObject(Object object) {
                if (!(object instanceof HvacNode)) {
                    return false;
                }
                HvacNode hvacNode = (HvacNode)object;
                MouseHistory.Point point = DrawHvacDuctTool.this.getClickHistory().getLastCommittedPoint();
                HvacNode hvacNode2 = DrawHvacDuctTool.getNode(point);
                return hvacNode2 != hvacNode && predicate.test(hvacNode);
            }
        });
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        NamedObjFormat<HvacNode> namedObjFormat = new NamedObjFormat<HvacNode>(PyroSim.getApp().getMediator(), PyroSim.getApp().getMediator().getObstructions(), HvacNode.class);
        valueEditor.addChoice(VALTYPE_NODE1, new ValueEditor.Choice(Intl.intl("Node A"), new guiFormattedFld<Object>(namedObjFormat, null)));
        valueEditor.addChoice(VALTYPE_NODE2, new ValueEditor.Choice(Intl.intl("Node B"), new guiFormattedFld<Object>(namedObjFormat, null)));
    }

    @Override
    public void valueEditorChanged(ValueEditor valueEditor, boolean bl) {
        HvacNode hvacNode = (HvacNode)valueEditor.getValue();
        if (hvacNode != null) {
            CursorTool.SnapInfo snapInfo;
            Point3d point3d = hvacNode.getLocation();
            Point3d point3d2 = this.getView() != null ? this.getView().worldToScreen(point3d) : new Point3d();
            Point2d point2d = new Point2d(point3d2.x, point3d2.y);
            IsectInfo isectInfo = new IsectInfo(GeomType.VERTEX, hvacNode, point3d, () -> new Point(point3d), IPrimProps.DEF, new RayPointProx(point3d2.z, 0.0));
            CursorTool.SnapInfo snapInfo2 = new CursorTool.SnapInfo(System.currentTimeMillis(), point2d, point3d, Arrays.asList(isectInfo), point3d);
            this.getClickHistory().addPoint(snapInfo2, bl);
            if (bl && (snapInfo = this.getP1()) != null) {
                this.getClickHistory().addPoint(snapInfo, false);
            }
        }
        this.updateEditorState(false);
    }

    @Override
    protected void updateEditorState(boolean bl) {
        ValueEditor valueEditor = this.getValueEditor();
        String string = this.getNodes(true).isEmpty() ? VALTYPE_NODE1 : VALTYPE_NODE2;
        valueEditor.setValueType(string);
        if (bl) {
            MouseHistory mouseHistory = this.getClickHistory();
            HvacNode hvacNode = null;
            if (!mouseHistory.getHistory().isEmpty()) {
                MouseHistory.Point point = this.getClickHistory().getHistory().getLast();
                hvacNode = DrawHvacDuctTool.getNode(point);
            }
            valueEditor.setValue(hvacNode);
        }
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return HvacDuct.DuctGeom.class;
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_geom != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_geom = null;
        super.reset();
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        List<HvacNode> list = this.getNodes(false);
        if (list.size() >= 2) {
            this.d_geom = new HvacDuct.DuctGeom(list.get(0), list.get(1));
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_geom), null);
            if (point.committed) {
                this.finish();
            }
        } else if (list.size() == 1) {
            ArrayList<APrimitive> arrayList = new ArrayList<APrimitive>(2);
            PropsBuilder propsBuilder = new PropsBuilder();
            arrayList.add(new Point(list.get(0).getLocation()));
            propsBuilder.add(new IPrimProps.Vertex(Color.GREEN, 10.0));
            arrayList.add(new LineSeg(list.get(0).getLocation(), point.p));
            propsBuilder.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
            this.fireUpdate(0, GeomNodeUtil.newNode(GeomUtil.group(arrayList)), propsBuilder.finalizeProps());
        } else if (list.isEmpty()) {
            this.fireUpdate(0, DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props);
        }
        this.repaintSurface();
    }

    protected List<HvacNode> getNodes(boolean bl) {
        ArrayList<HvacNode> arrayList = new ArrayList<HvacNode>();
        for (MouseHistory.Point point : this.getClickHistory().getHistory()) {
            HvacNode hvacNode;
            if (bl && !point.committed || (hvacNode = DrawHvacDuctTool.getNode(point)) == null) continue;
            arrayList.add(hvacNode);
        }
        return arrayList;
    }

    private static HvacNode getNode(MouseHistory.Point point) {
        if (point != null && point.snap != null) {
            for (IsectInfo isectInfo : point.snap.snaps) {
                if (!(isectInfo.obj instanceof HvacNode)) continue;
                return (HvacNode)isectInfo.obj;
            }
        }
        return null;
    }
}

