/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.DrawAABoxGeomTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;

public class DrawGridGeomTool
extends DrawAABoxGeomTool {
    public DrawGridGeomTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps);
    }

    @Override
    protected CursorTool.SnapInfo snapPoint(CursorTool.SnapInfo snapInfo) {
        if (this.getProps().get(DrawProps.CELL_TYPE) == DrawProps.MeshCellType.FIXED_SIZE && this.getClickHistory().committedSize() == 1) {
            MouseHistory.Point point = this.getClickHistory().getHistory().getFirst();
            UnitDouble[] unitDoubleArray = this.getProps().get(DrawProps.CELL_SIZE);
            double[] dArray = new double[]{unitDoubleArray[0].getValue(Geometry.LU), unitDoubleArray[1].getValue(Geometry.LU), unitDoubleArray[2].getValue(Geometry.LU)};
            Point3d point3d = snapInfo.constrained.getLast();
            double d = Math.round((point3d.x - point.p.x) / dArray[0]);
            double d2 = Math.round((point3d.y - point.p.y) / dArray[1]);
            double d3 = Math.round((point3d.z - point.p.z) / dArray[2]);
            Point3d point3d2 = new Point3d(point.p.x + dArray[0] * d, point.p.y + dArray[1] * d2, point.p.z + dArray[2] * d3);
            Point2d point2d = this.toScreen(point3d2);
            return new CursorTool.SnapInfo(snapInfo.timestamp, point2d, point3d2, (Collection<IsectInfo>)Collections.EMPTY_LIST, point3d2);
        }
        return snapInfo;
    }
}

