/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.util.Rectifier;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public class DrawGridCellTool
extends ADrawTool {
    private static final int TEMP_BLOCK_ID = -1;
    private final PyroSim d_pySim = (PyroSim)Application.getApp();
    private final PyroMod d_pyMod = this.d_pySim.getMediator();
    private AABoxGeom d_block;
    private IPolygon d_gridCell;
    private final Set<Point3d> d_coordsUsed = new HashSet<Point3d>();
    private final List<AABoxGeom> d_blocksToAdd;
    private boolean d_blockVis = false;
    private Orient d_orient = Orient.TOWARD_CAMERA;

    public DrawGridCellTool(ModelView modelView, DrawProps drawProps) {
        super(modelView, drawProps, new Func(), DrawProps.GeomSpace.S3D);
        this.d_blocksToAdd = new ArrayList<AABoxGeom>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                DrawGridCellTool.this.setOrient(DrawGridCellTool.this.d_orient.next());
            }
        });
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        if (this.getView().getCamera() instanceof OrthoCamera) {
            return new Pair<SnapMode, Object>(SnapMode.NONE, null);
        }
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(GeomType.FACE));
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    public Class getGeomType() {
        return AABoxGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        menuBuilder.addMutuallyExclusive(new FlipExtrusion(Orient.AWAYFROM_CAMERA), new FlipExtrusion(Orient.TOWARD_CAMERA));
        super.addContextMenuActions(menuBuilder);
    }

    private void showBlock() {
        if (!this.d_blockVis) {
            this.fireUpdate(-1, GeomNodeUtil.newNode(this.d_block), null);
            this.d_blockVis = true;
        }
    }

    private void hideBlock() {
        if (this.d_blockVis) {
            this.fireRemove(-1);
            this.d_blockVis = false;
        }
    }

    private void updateBlock() {
        Pair<AABox, IPolygon> pair = this.getBlockCoordsGeom();
        if (pair != null) {
            AABox aABox = (AABox)pair.v1;
            this.d_block = new AABoxGeom(aABox.getMin(), aABox.getMax(), 0);
            this.d_gridCell = (IPolygon)pair.v2;
            this.fireUpdate(-1, GeomNodeUtil.newNode(this.d_block), null);
        }
    }

    @Override
    public void activate() {
        this.d_block = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), 0);
        this.d_gridCell = null;
        super.activate();
    }

    private Pair<AABox, IPolygon> getBlockCoordsGeom() {
        Vector3d vector3d;
        IPolygon iPolygon;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Unit unit = Geometry.LU;
        DrawProps drawProps = this.getProps();
        double d = drawProps.get(DrawProps.LOCATION).getValue(unit);
        double d2 = drawProps.get(DrawProps.HEIGHT).getValue(unit);
        double d3 = drawProps.get(DrawProps.THICKNESS).getValue(unit) * 0.5;
        CursorTool.Ray ray = this.getPickRay();
        if (this.getView().getCamera() instanceof OrthoCamera) {
            Vector3d vector3d2;
            AABox aABox;
            Serializable serializable3;
            Serializable serializable4;
            IPolygon iPolygon2 = null;
            IsectInfo isectInfo = this.pickGridCell(ray.begin, ray.dir);
            if (isectInfo != null) {
                assert (isectInfo.getPrim != null);
                serializable4 = isectInfo.getPrim.get();
                assert (serializable4 instanceof IPolygon);
                serializable3 = (IPolygon)serializable4;
                aABox = serializable3.getBoundingBox(new AABox());
                vector3d2 = serializable3.getNormal(true);
                iPolygon2 = serializable3;
            } else {
                vector3d2 = new Vector3d(this.getView().getCamera().getViewVector());
                vector3d2.normalize();
                serializable4 = new Plane3d(vector3d2.x, vector3d2.y, vector3d2.z, 0.0);
                serializable3 = Inter3D.linePlaneIntersection(ray.begin, ray.dir, (Plane3d)serializable4, 1.0E-6);
                if (serializable3 == null) {
                    return null;
                }
                aABox = new AABox(((Point3d)serializable3).x - d3, ((Point3d)serializable3).y - d3, ((Point3d)serializable3).z - d3, ((Point3d)serializable3).x + d3, ((Point3d)serializable3).y + d3, ((Point3d)serializable3).z + d3);
            }
            serializable4 = aABox.getMin();
            serializable3 = aABox.getMax();
            int n = Util.getClosestAxis(vector3d2);
            DrawGridCellTool.convertPointFromDepth((Point3d)serializable4, d, n);
            DrawGridCellTool.convertPointFromDepth((Point3d)serializable3, d + d2, n);
            Rectifier.rectify((Point3d)serializable4, (Point3d)serializable3);
            return new Pair<AABox, IPolygon>(new AABox((Point3d)serializable4, (Point3d)serializable3), iPolygon2);
        }
        IsectInfo isectInfo = null;
        Collection<IsectInfo> collection = this.getP1().snaps;
        if (!collection.isEmpty()) {
            isectInfo = collection.iterator().next();
        }
        Point3d point3d = this.getP1().referenceSnap;
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, -1.0);
        if (isectInfo != null && isectInfo.getPrim != null && (object = isectInfo.getPrim.get()) instanceof IPolygon) {
            serializable2 = ((IPolygon)object).getNormal(true);
            int n = Util3D.getClosestAxis(serializable2);
            switch (n) {
                case 0: {
                    vector3d3 = new Vector3d(1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    vector3d3 = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    vector3d3 = new Vector3d(0.0, 0.0, 1.0);
                }
            }
        }
        object = this.pickGridCell(point3d, vector3d3);
        serializable2 = null;
        if (object != null && ((IsectInfo)object).getPrim != null) {
            serializable = ((IsectInfo)object).getPrim.get();
            assert (serializable instanceof IPolygon);
            iPolygon = (IPolygon)serializable;
            serializable2 = iPolygon;
            vector3d = Util3D.vector(((IsectInfo)object).isectPoint, point3d);
            ITransform iTransform = TransformUtil.translate(vector3d.x, vector3d.y, vector3d.z);
            iPolygon = iPolygon.transform(iTransform.getInfo(), 0);
        } else {
            serializable = point3d;
            iPolygon = Math.abs(vector3d3.x) == 1.0 ? new AARectangle(0, serializable.x, serializable.y - d3, serializable.z - d3, serializable.y + d3, serializable.z + d3, false) : (Math.abs(vector3d3.y) == 1.0 ? new AARectangle(1, serializable.y, serializable.x - d3, serializable.z - d3, serializable.x + d3, serializable.z + d3, false) : new AARectangle(2, serializable.z, serializable.x - d3, serializable.y - d3, serializable.x + d3, serializable.y + d3, false));
        }
        serializable = iPolygon.getNormal(true);
        vector3d = Util3D.normalize((Vector3d)serializable);
        double d4 = vector3d.dot(ray.dir);
        if (d4 > 0.0 && this.d_orient == Orient.TOWARD_CAMERA || d4 < 0.0 && this.d_orient == Orient.AWAYFROM_CAMERA) {
            vector3d.negate();
        }
        vector3d.scale(d2);
        ExtrudedPoly extrudedPoly = new ExtrudedPoly(iPolygon, vector3d);
        return new Pair<AABox, Vector3d>(extrudedPoly.getBoundingBox(new AABox()), (Vector3d)serializable2);
    }

    protected static void convertPointFromDepth(Point3d point3d, double d, int n) {
        switch (n) {
            case 0: {
                point3d.set(d, point3d.y, point3d.z);
                break;
            }
            case 1: {
                point3d.set(point3d.x, d, point3d.z);
                break;
            }
            case 2: {
                point3d.set(point3d.x, point3d.y, d);
            }
        }
    }

    protected void setOrient(Orient orient) {
        this.d_orient = orient;
        this.updateBlock();
        this.repaintSurface();
    }

    protected IsectInfo pickGridCell(final Point3d point3d, final Vector3d vector3d) {
        IGridSnapper iGridSnapper = ((ModelView)this.getModelView()).getCurrentSnapperObj();
        if (iGridSnapper == null) {
            return null;
        }
        Point3d point3d2 = this.getView().worldToScreen(point3d);
        point3d2.z = 1.0;
        Point3d point3d3 = this.getView().screenToWorld(point3d2);
        final ArrayList arrayList = new ArrayList();
        final TaskProgress taskProgress = new TaskProgress();
        IIsectCollector iIsectCollector = new IIsectCollector(){

            @Override
            public void addFace(Object object, Point3d point3d2, Supplier<IFace> supplier, Supplier<Vector3d> supplier2, IPrimProps iPrimProps) {
                double d = Util3D.tOnLine(point3d, vector3d, point3d2);
                arrayList.add(new IsectInfo(GeomType.FACE, object, point3d2, supplier, iPrimProps, new RayPointProx(d, 0.0)));
            }

            @Override
            public void addNonFace(Object object, Point3d point3d2, GeomType geomType) {
                assert (false);
            }

            @Override
            public void addInfinite(Object object, Point3d point3d2, GeomType geomType, IPrimitive iPrimitive) {
                assert (false);
            }

            @Override
            public TaskProgress getProgress() {
                return taskProgress;
            }
        };
        iGridSnapper.pickCells(iIsectCollector, point3d, vector3d, new LineSegRTreeTest(point3d, point3d3));
        if (arrayList.isEmpty()) {
            return null;
        }
        Collections.sort(arrayList, new Comparator<IsectInfo>(){

            @Override
            public int compare(IsectInfo isectInfo, IsectInfo isectInfo2) {
                return isectInfo.prox.compareTo(isectInfo2.prox);
            }
        });
        return (IsectInfo)arrayList.iterator().next();
    }

    private void addBlock() {
        AABox aABox = this.d_gridCell != null ? this.d_gridCell.getBoundingBox(new AABox()) : this.d_block.getBoundingBox(new AABox());
        Point3d point3d = aABox.getMin();
        if (this.d_coordsUsed.contains(point3d)) {
            return;
        }
        this.d_coordsUsed.add(point3d);
        AABoxGeom aABoxGeom = this.d_block;
        this.fireUpdate(this.d_blocksToAdd.size(), GeomNodeUtil.newNode(aABoxGeom), null);
        this.d_blocksToAdd.add(aABoxGeom);
    }

    @Override
    protected String getStatusMessage() {
        Pair<AABox, IPolygon> pair = this.getBlockCoordsGeom();
        return pair == null ? "" : String.format(Intl.intl("Grid cell: %1$s -> %2$s [%3$s x %4$s x %5$s]"), this.toString(((AABox)pair.v1).getMin()), this.toString(((AABox)pair.v1).getMax()), this.toString(((AABox)pair.v1).getWidth()), this.toString(((AABox)pair.v1).getDepth()), this.toString(((AABox)pair.v1).getHeight()));
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
    }

    protected static class Func
    extends APyroTool.ToolFunc<DrawGridCellTool> {
        protected Func() {
        }

        @Override
        public void mouseEntered(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mouseEntered(drawGridCellTool, mouseEvent);
            drawGridCellTool.showBlock();
            drawGridCellTool.updateBlock();
            drawGridCellTool.repaintSurface();
        }

        @Override
        public void mouseExited(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mouseExited(drawGridCellTool, mouseEvent);
            drawGridCellTool.hideBlock();
            drawGridCellTool.repaintSurface();
        }

        @Override
        public void mouseMoved(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mouseMoved(drawGridCellTool, mouseEvent);
            drawGridCellTool.updateBlock();
            drawGridCellTool.repaintSurface();
        }

        @Override
        public void mousePressed(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mousePressed(drawGridCellTool, mouseEvent);
            if (mouseEvent.getButton() != 1) {
                return;
            }
            drawGridCellTool.setConsumeEvents(true);
            drawGridCellTool.addBlock();
            drawGridCellTool.repaintSurface();
        }

        @Override
        public void mouseReleased(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mouseReleased(drawGridCellTool, mouseEvent);
            if (mouseEvent.getButton() != 1) {
                return;
            }
            drawGridCellTool.addBlock();
            drawGridCellTool.hideBlock();
            drawGridCellTool.fireFinish(true);
            drawGridCellTool.showBlock();
            for (int i = 0; i < drawGridCellTool.d_blocksToAdd.size(); ++i) {
                drawGridCellTool.fireRemove(i);
            }
            drawGridCellTool.d_blocksToAdd.clear();
            drawGridCellTool.d_coordsUsed.clear();
            drawGridCellTool.setConsumeEvents(false);
            drawGridCellTool.finish();
            drawGridCellTool.repaintSurface();
        }

        @Override
        public void mouseDragged(DrawGridCellTool drawGridCellTool, MouseEvent mouseEvent) {
            super.mouseDragged(drawGridCellTool, mouseEvent);
            if (!drawGridCellTool.isDragging(1)) {
                return;
            }
            drawGridCellTool.updateBlock();
            drawGridCellTool.addBlock();
            drawGridCellTool.repaintSurface();
        }
    }

    protected class FlipExtrusion
    extends BooleanAction {
        private static final long serialVersionUID = 8125427830882845020L;
        private final Orient d_orient;

        public FlipExtrusion(Orient orient) {
            super(orient.name, DrawGridCellTool.this.d_orient == orient);
            this.d_orient = orient;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawGridCellTool.this.setOrient(this.d_orient);
            }
        }
    }

    private static enum Orient {
        TOWARD_CAMERA(Intl.intl("Extrude toward camera")),
        AWAYFROM_CAMERA(Intl.intl("Extrude away from camera"));

        private final String name;

        private Orient(String string2) {
            this.name = string2;
        }

        public Orient next() {
            switch (this) {
                case TOWARD_CAMERA: {
                    return AWAYFROM_CAMERA;
                }
                case AWAYFROM_CAMERA: {
                    return TOWARD_CAMERA;
                }
            }
            return null;
        }
    }
}

