/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DrawExtrudedPolyTool
extends ADrawTool
implements MouseHistory.IListener,
ValueEditor.IListener {
    private IGeom d_geom;

    public DrawExtrudedPolyTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                DrawExtrudedPolyTool.this.setExtrusion(DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).negate());
            }
        });
    }

    public Class getGeomType() {
        return ExtrudedPoly.class;
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        if (this.canComplete()) {
            menuBuilder.add(new FinishAction());
            menuBuilder.addSeparator();
        }
        menuBuilder.addMutuallyExclusive(new ChangeExtrusion(true), new ChangeExtrusion(false));
        super.addContextMenuActions(menuBuilder);
    }

    protected boolean canComplete() {
        return this.getClickHistory().committedSize() >= 3;
    }

    private void finishIfClosed() {
        Deque<MouseHistory.Point> deque = this.getClickHistory().getHistory();
        if (deque.size() >= 3 && deque.peekFirst().equals(deque.peekLast())) {
            this.finish();
        }
    }

    @Override
    public void finish() {
        this.getClickHistory().finalizePoints();
        this.update(true);
        this.fireFinish(this.d_geom != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_geom = null;
        super.reset();
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        this.update(false);
        if (point.dragged && point.committed && this.d_geom instanceof AABoxGeom) {
            this.finish();
        } else if (point.committed) {
            this.finishIfClosed();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyPressed(keyEvent);
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.finish();
            }
        }
        this.resumeRepaint(true);
    }

    protected void setExtrusion(UnitDouble unitDouble) {
        this.getProps().set(DrawProps.THICKNESS, unitDouble);
        this.update(false);
    }

    private void update(boolean bl) {
        Pair<IGeom, IPropsSrc> pair = this.construct(bl);
        this.d_geom = (IGeom)pair.v1;
        if (this.d_geom != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_geom), (IPropsSrc)pair.v2);
        } else {
            this.fireRemove(0);
        }
        this.updateStatusMessage();
        this.repaintSurface();
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IGeom, IPropsSrc> construct(boolean bl) {
        DrawProps drawProps = this.getProps();
        if (this.getClickHistory().size() <= 1) {
            return new Pair<Object, Object>(null, null);
        }
        Deque<MouseHistory.Point> deque = this.getClickHistory().getHistory();
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(deque.size());
        for (MouseHistory.Point object2 : deque) {
            arrayList.add(object2.p);
        }
        Vector3d vector3d = this.getWorkingPlane().getNormal();
        vector3d.scale(drawProps.get(DrawProps.THICKNESS).getValue(Geometry.LU));
        if (arrayList.size() == 2 && deque.peekLast().dragged) {
            AABox aABox = new AABox();
            aABox.add((Point3d)arrayList.get(0), (Point3d)arrayList.get(1), Util3D.add((Point3d)arrayList.get(0), (Tuple3d)vector3d));
            return new Pair<AABoxGeom, Object>(new AABoxGeom(aABox), null);
        }
        if (arrayList.size() > 1 && !bl) {
            Serializable serializable;
            void var6_11;
            Object var6_8 = null;
            if (arrayList.size() == 2) {
                LineSeg lineSeg = new LineSeg((Point3d)arrayList.get(0), (Point3d)arrayList.get(1));
            } else {
                PolyLine polyLine = new PolyLine(theUtil.toArray(arrayList, Point3d.class));
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(var6_11);
            for (int i = 0; i < var6_11.getNumVerts() - 1; ++i) {
                serializable = var6_11.getVert(i);
                Point3d point3d = var6_11.getVert(i + 1);
                Point3d point3d2 = Util3D.add(serializable, (Tuple3d)vector3d);
                Point3d point3d3 = Util3D.add(point3d, (Tuple3d)vector3d);
                arrayList2.add(new Quad((Point3d)serializable, point3d, point3d3, point3d2));
            }
            PropsBuilder propsBuilder = new PropsBuilder();
            propsBuilder.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
            propsBuilder.add(new IPrimProps.Face(new Color(0, 255, 0, 100), null, 0), arrayList2.size() - 1);
            serializable = new GeomGroup(arrayList2);
            return new Pair<Point3d, IPropsSrc>((Point3d)serializable, propsBuilder.finalizeProps());
        }
        if (arrayList.size() >= 3) {
            if (((Point3d)arrayList.get(arrayList.size() - 1)).equals((Tuple3d)arrayList.get(0))) {
                arrayList.remove(arrayList.size() - 1);
            }
            if (arrayList.size() >= 3) {
                IPolygon iPolygon = PolyUtil.newPoly(theUtil.toArray(arrayList, Point3d.class));
                ExtrudedPoly extrudedPoly = new ExtrudedPoly(iPolygon, vector3d);
                return new Pair<ExtrudedPoly, Object>(extrudedPoly, null);
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    protected class ChangeExtrusion
    extends BooleanAction {
        private static final long serialVersionUID = 8878100424558803667L;
        private boolean d_positive;

        public ChangeExtrusion(boolean bl) {
            super(bl ? Intl.intl("Use positive extrusion") : Intl.intl("Use negative extrusion"), bl == Math.signum(DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).getValueNoUnit()) >= 0.0);
            this.d_positive = bl;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                UnitDouble unitDouble = DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).abs();
                if (!this.d_positive) {
                    unitDouble = unitDouble.negate();
                }
                DrawExtrudedPolyTool.this.setExtrusion(unitDouble);
            }
        }
    }

    protected class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -2300000097007388501L;

        public FinishAction() {
            super(Intl.intl("Close"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawExtrudedPolyTool.this.finish();
        }
    }
}

