/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;

public class DrawAARectangleTool
extends ADrawTool {
    private AARectangle d_rect = null;

    public DrawAARectangleTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S2D);
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return AARectangle.class;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        ValueEditorUtil.configureLocation(valueEditor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(valueEditor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        this.updateRect();
        if (mouseHistory.committedSize() == 2) {
            this.finish();
        }
        this.repaintSurface();
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_rect != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_rect = null;
        super.reset();
    }

    @Override
    protected CursorTool.SnapInfo nextEditorPoint(Point3d point3d) {
        CursorTool.SnapInfo snapInfo = super.nextEditorPoint(point3d);
        return snapInfo;
    }

    private void updateRect() {
        this.d_rect = this.construct();
        if (this.d_rect != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_rect), null);
        } else {
            this.fireRemove(0);
        }
    }

    private AARectangle construct() {
        if (this.getClickHistory().size() < 2) {
            return null;
        }
        Deque<MouseHistory.Point> deque = this.getClickHistory().getHistory();
        MouseHistory.Point point = deque.getFirst();
        MouseHistory.Point point2 = deque.getLast();
        if (this.getView().getCamera() instanceof PerspectiveCamera) {
            Pair<Vector3d, Point3d> pair = this.getDrawingPlane(point, point2);
            Plane3d plane3d = DrawAARectangleTool.alignToAxis((Vector3d)pair.v1, (Point3d)pair.v2);
            Point3d point3d = point.p;
            Point3d point3d2 = plane3d.projectOntoPlane(point2.p);
            return AARectangle.construct(point3d, point3d2, false);
        }
        return AARectangle.construct(point.p, point2.p, false);
    }

    private static Plane3d alignToAxis(Vector3d vector3d, Point3d point3d) {
        switch (Util3D.getClosestAxis(vector3d)) {
            case 0: {
                vector3d = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                vector3d = new Vector3d(0.0, 1.0, 0.0);
                break;
            }
            default: {
                vector3d = new Vector3d(0.0, 0.0, 1.0);
            }
        }
        return new Plane3d(vector3d, point3d);
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Vector3d, Point3d> getDrawingPlane(MouseHistory.Point point, MouseHistory.Point point2) {
        void var15_25;
        Collection<IsectInfo> collection = point.snap.snaps;
        Collection<IsectInfo> collection2 = point2.snap.snaps;
        List<Plane3d> list = this.getFacePlanes(collection);
        List<Plane3d> list2 = this.getFacePlanes(collection2);
        Point3d point3d = point.p;
        Point3d point3d2 = point2.p;
        if (!list.isEmpty() && !list2.isEmpty()) {
            ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>();
            for (Plane3d plane3d : list) {
                for (Plane3d vector3dArray : list2) {
                    if (!plane3d.epsilonEquals(vector3dArray, 1.0E-6) && !plane3d.epsilonEquals(vector3dArray.negate(), 1.0E-6)) continue;
                    arrayList.add(plane3d);
                }
            }
            if (arrayList.size() > 1) {
                double d = 0.0;
                Object object = null;
                Vector3d[] d4 = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
                for (Plane3d plane3d : arrayList) {
                    for (Vector3d vector3d : d4) {
                        double d2 = Math.abs(vector3d.dot(plane3d.getNormal()));
                        if (!(d2 > d)) continue;
                        d = d2;
                        object = plane3d;
                    }
                }
                if (object != null) {
                    return new Pair<Vector3d, Point3d>(((Plane3d)object).getNormal(), point3d);
                }
            }
            if (!arrayList.isEmpty()) {
                Plane3d plane3d = (Plane3d)arrayList.get(0);
                return new Pair<Vector3d, Point3d>(plane3d.getNormal(), point3d);
            }
        }
        double d = Math.abs(point3d.x - point3d2.x);
        double d3 = Math.abs(point3d.y - point3d2.y);
        double d4 = Math.abs(point3d.z - point3d2.z);
        if (d <= d3 && d <= d4) {
            Vector3d vector3d = new Vector3d(1.0, 0.0, 0.0);
        } else if (d3 <= d && d3 <= d4) {
            Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0);
        } else {
            Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        }
        return new Pair<void, Point3d>(var15_25, point3d);
    }

    private List<Plane3d> getFacePlanes(Collection<IsectInfo> collection) {
        ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>();
        IsectInfo isectInfo = null;
        for (IsectInfo isectInfo2 : collection) {
            IPrimitive iPrimitive;
            if (isectInfo2.getPrim == null || !((iPrimitive = isectInfo2.getPrim.get()) instanceof IPolygon)) continue;
            if (isectInfo != null && isectInfo2.prox.compareTo(isectInfo.prox) > 0) break;
            Vector3d vector3d = ((IPolygon)iPrimitive).getNormal(true);
            arrayList.add(new Plane3d(vector3d, isectInfo2.isectPoint));
            isectInfo = isectInfo2;
        }
        return arrayList;
    }
}

