/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.theUtil;

public class DrawAABoxGeomTool
extends ADrawTool {
    private AABoxGeom d_block = null;

    public DrawAABoxGeomTool(IToolController iToolController, DrawProps drawProps) {
        super(iToolController, drawProps, DrawProps.GeomSpace.S3D);
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return AABoxGeom.class;
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        ValueEditorUtil.configureLocation(valueEditor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(valueEditor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    @Override
    public void pointAdded(MouseHistory mouseHistory, MouseHistory.Point point) {
        if (mouseHistory.size() < 2) {
            this.d_block = null;
            this.fireRemove(0);
            return;
        }
        List<Point3d> list = mouseHistory.getAllPoints();
        Point3d point3d = list.get(0);
        Point3d point3d2 = list.get(1);
        AABox aABox = new AABox();
        aABox.add(point3d, point3d2);
        Vector3d vector3d = this.getBoxExtrusion(point3d, point3d2);
        if (vector3d != null) {
            aABox.add(Util3D.add(point3d, (Tuple3d)vector3d));
        }
        this.d_block = new AABoxGeom(aABox.getMin(), aABox.getMax(), 0);
        this.fireUpdate(0, GeomNodeUtil.newNode(this.d_block), null);
        if (point.committed) {
            this.finish();
        }
        this.repaintSurface();
    }

    protected Vector3d getBoxExtrusion(Point3d point3d, Point3d point3d2) {
        double d = this.getProps().get(DrawProps.HEIGHT).getValue(Geometry.LU);
        if (this.getView().getCamera() instanceof OrthoCamera) {
            Vector3d vector3d = new Vector3d(this.getView().getCamera().getViewVector());
            vector3d.normalize();
            vector3d.negate();
            vector3d.scale(d);
            return vector3d;
        }
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        double d2 = vector3d.dot(GeomConstants.VEC3D_ZPOS);
        if (theUtil.eq0(d2, 1.0E-9)) {
            return new Vector3d(0.0, 0.0, d);
        }
        return null;
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_block != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_block = null;
        super.reset();
    }
}

