/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.PyroNativeProps;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.snappers.ModelGridSnapper;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.util.theUtil;

public abstract class ATransformTool
extends APyroTool {
    private final TransformMgr d_xformMgr;
    private final ModelScene d_toolScene;
    private final GeomDisplay d_geomDisp;

    public ATransformTool(ModelView modelView, TransformMgr transformMgr, ModelScene modelScene, DrawProps drawProps) {
        super((IToolController)modelView, drawProps);
        this.d_xformMgr = transformMgr;
        this.d_toolScene = modelScene;
        this.d_geomDisp = new GeomDisplay(new PyroDrawProps(new PyroNativeProps(), () -> null), new GenericGeomSrc("", DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props));
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(){

            @Override
            public boolean acceptPickObject(Object object) {
                if (ATransformTool.this.d_xformMgr.getCopyMode()) {
                    return true;
                }
                if (ATransformTool.this.d_xformMgr.isTransforming()) {
                    if (object instanceof ModelGridSnapper) {
                        object = ((ModelGridSnapper)object).getGrid();
                    }
                    return !ATransformTool.this.d_xformMgr.getDomain().getSelectionModel().isSelected(object);
                }
                return true;
            }
        });
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                ATransformTool.this.d_xformMgr.setCopyMode(!ATransformTool.this.d_xformMgr.getCopyMode());
                ATransformTool.this.repaintSurface();
            }
        });
    }

    public TransformMgr getXformMgr() {
        return this.d_xformMgr;
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    protected void updateToolDisplay(IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        GenericGeomSrc genericGeomSrc = (GenericGeomSrc)this.d_geomDisp.getSource();
        genericGeomSrc.setGeom(iGeomNode.bakeIfRecommended());
        genericGeomSrc.setDisplayProps(iPropsSrc);
        this.d_geomDisp.update();
        this.repaintSurface();
    }

    @Override
    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        menuBuilder.addSeparator();
        menuBuilder.addMutuallyExclusive(new ModeAction(false), new ModeAction(true));
        menuBuilder.addSeparator();
        super.addContextMenuActions(menuBuilder);
    }

    @Override
    public void reset() {
        super.reset();
        this.updateToolDisplay(DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props);
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        super.activate();
        this.d_toolScene.addObjects(this.d_geomDisp);
        this.resumeRepaint(true);
    }

    @Override
    public void deactivate() {
        this.pauseRepaint();
        this.d_toolScene.removeObjects(this.d_geomDisp);
        super.deactivate();
        this.resumeRepaint(true);
    }

    @Override
    public void finish() {
        this.pauseRepaint();
        if (this.d_xformMgr.isTransforming()) {
            this.d_xformMgr.end(true);
        }
        this.reset();
        super.finish();
        this.resumeRepaint();
    }

    @Override
    public void cancel() {
        this.pauseRepaint();
        if (this.d_xformMgr.isTransforming()) {
            this.d_xformMgr.end(false);
        }
        this.reset();
        super.cancel();
        this.resumeRepaint();
    }

    protected Point3d projectToFrustum(Point3d point3d, Vector3d vector3d) {
        View view = this.getView();
        Box3d box3d = view.getFrustum();
        double d = 1.0E20;
        for (int i = 0; i < 6; ++i) {
            double d2 = Inter3D.linePlaneIntersectionT(point3d, vector3d, box3d.getPlanes()[i], 1.0E-6);
            if (Double.isNaN(d2) || theUtil.le0(d2, 1.0E-6) || !(d2 < d)) continue;
            d = d2;
        }
        return Util3D.linePoint(point3d, vector3d, d);
    }

    @Override
    protected String getStatusMessage() {
        return this.getValueEditor().getStatusMessage();
    }

    protected class ModeAction
    extends BooleanAction {
        private static final long serialVersionUID = -2264843991704589282L;
        private final boolean d_copyMode;

        public ModeAction(boolean bl) {
            super(bl ? Intl.intl("Copy Mode") : Intl.intl("Move Mode"), bl == ATransformTool.this.d_xformMgr.getCopyMode());
            this.d_copyMode = bl;
        }

        @Override
        protected void stateChanged() {
            ATransformTool.this.d_xformMgr.setCopyMode(this.d_copyMode);
        }
    }
}

