/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.constraint.WorkingPlaneConstraintGen;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class APyroTool
extends CursorTool
implements IPyroTool,
MouseHistory.IListener {
    private final MouseHistory d_history;
    private DrawProps d_toolProps;
    private ValueEditor d_valueEditor;
    private IPopupMenuBuilder d_menuBuilder;
    private IConstraintGen d_constraintGen;
    private final List<IToggleListener> d_toggleListeners = new ArrayList<IToggleListener>(3);
    private boolean t_modifierConsumed = false;

    public APyroTool(IToolController iToolController, DrawProps drawProps) {
        this(iToolController, drawProps, new ToolFunc());
    }

    public APyroTool(IToolController iToolController, DrawProps drawProps, IToolFunction iToolFunction) {
        super(iToolController, iToolFunction);
        this.d_toolProps = drawProps;
        this.d_constraintGen = WorkingPlaneConstraintGen.INSTANCE;
        this.d_history = new MouseHistory();
        this.d_history.addListener(this);
        this.setCancelOnRightClick(false);
    }

    public MouseHistory getMouseHistory() {
        return this.d_history;
    }

    @Override
    public void addToggleListener(IToggleListener iToggleListener) {
        if (!this.d_toggleListeners.contains(iToggleListener)) {
            this.d_toggleListeners.add(iToggleListener);
        }
    }

    @Override
    public void removeToggleListener(IToggleListener iToggleListener) {
        this.d_toggleListeners.remove(iToggleListener);
    }

    @Override
    public IToggleListener[] getToggleListeners() {
        return theUtil.toArray(this.d_toggleListeners, IToggleListener.class);
    }

    protected void fireToggleEvent() {
        for (IToggleListener iToggleListener : new ArrayList<IToggleListener>(this.d_toggleListeners)) {
            iToggleListener.toolToggled(this);
        }
    }

    @Override
    public void setMenuBuilder(IPopupMenuBuilder iPopupMenuBuilder) {
        this.d_menuBuilder = iPopupMenuBuilder;
    }

    @Override
    public IPopupMenuBuilder getMenuBuilder() {
        return this.d_menuBuilder;
    }

    @Override
    public void setConstraintGen(IConstraintGen iConstraintGen) {
        this.d_constraintGen = iConstraintGen;
    }

    @Override
    public IConstraintGen getConstraintGen() {
        return this.d_constraintGen;
    }

    @Override
    protected boolean isAltMenuAccessEnabled() {
        return false;
    }

    private void initValueEditor() {
        if (this.d_valueEditor != null) {
            return;
        }
        this.d_valueEditor = new ValueEditor(this.getAttachedComponent());
        if (this instanceof ValueEditor.IListener) {
            this.d_valueEditor.addListener((ValueEditor.IListener)((Object)this));
        }
        this.initValueEditor(this.d_valueEditor);
    }

    public ValueEditor getValueEditor() {
        this.initValueEditor();
        return this.d_valueEditor;
    }

    @Override
    public void activate() {
        super.activate();
        this.initValueEditor();
        this.d_valueEditor.attach();
    }

    @Override
    public void deactivate() {
        this.d_valueEditor.detach();
        super.deactivate();
    }

    protected MouseHistory getClickHistory() {
        return this.d_history;
    }

    public void setToolProps(DrawProps drawProps) {
        this.d_toolProps = drawProps;
    }

    @Override
    public DrawProps getProps() {
        return this.d_toolProps;
    }

    @Override
    public void reset() {
        this.d_history.reset();
        this.getValueEditor().clear();
        super.reset();
    }

    protected void showContextMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        MenuBuilder menuBuilder = new MenuBuilder();
        this.addContextMenuActions(menuBuilder);
        menuBuilder.addSeparator();
        menuBuilder.add(new CancelAction());
        Action action = ((ModelView)this.getModelView()).getToolPropsAction();
        if (action.isEnabled()) {
            menuBuilder.addSeparator();
            menuBuilder.add(action);
        }
        if ((jPopupMenu = menuBuilder.buildPopupMenu()) != null) {
            final MouseMotionListener[] mouseMotionListenerArray = (MouseMotionListener[])this.getAttachedComponent().getListeners(MouseMotionListener.class);
            EventListener[] eventListenerArray = mouseMotionListenerArray;
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                MouseMotionListener mouseMotionListener = eventListenerArray[i];
                this.getAttachedComponent().removeMouseMotionListener(mouseMotionListener);
            }
            for (EventListener eventListener : eventListenerArray = (MouseListener[])this.getAttachedComponent().getListeners(MouseListener.class)) {
                this.getAttachedComponent().removeMouseListener((MouseListener)eventListener);
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener((MouseListener[])eventListenerArray){
                final /* synthetic */ MouseListener[] val$mouseListeners;
                {
                    this.val$mouseListeners = mouseListenerArray;
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    for (MouseMotionListener eventListener : mouseMotionListenerArray) {
                        APyroTool.this.getAttachedComponent().addMouseMotionListener(eventListener);
                    }
                    for (EventListener eventListener : this.val$mouseListeners) {
                        APyroTool.this.getAttachedComponent().addMouseListener((MouseListener)eventListener);
                    }
                }
            });
            jPopupMenu.show(this.getAttachedComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void addContextMenuActions(MenuBuilder menuBuilder) {
        if (this.d_menuBuilder != null) {
            this.d_menuBuilder.buildMenu(this, menuBuilder);
        }
    }

    protected Plane3d getWorkingPlane() {
        DrawProps drawProps = this.getProps();
        double d = drawProps.get(DrawProps.LOCATION).getValue(Geometry.LU);
        if (this.getView().getCamera() instanceof PerspectiveCamera) {
            if (this.getSnapToWorkingPlane() && this.getClickHistory().committedSize() > 0) {
                return new Plane3d(new Vector3d(0.0, 0.0, 1.0), this.getClickHistory().getHistory().getFirst().p);
            }
            return null;
        }
        Vector3d vector3d = this.getView().getCamera().getViewVector();
        vector3d.normalize();
        vector3d.negate();
        return new Plane3d(vector3d, new Point3d(d, d, d));
    }

    public ISnapConstraint getSetSnapConstraint() {
        return super.getSnapConstraint();
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        ISnapConstraint iSnapConstraint = super.getSnapConstraint();
        if (iSnapConstraint != null) {
            return iSnapConstraint;
        }
        return this.d_constraintGen != null ? this.d_constraintGen.getConstraint(this) : null;
    }

    @Override
    public ISnapConstraint getDefaultConstraint() {
        double d = this.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
        Plane3d plane3d = new Plane3d(0.0, 0.0, 1.0, -d);
        return new PlanarConstraint(plane3d);
    }

    public void valueEditorChanged(ValueEditor valueEditor, boolean bl) {
        String string = valueEditor.getCurrentValueType();
        if (string.equals("LOCATION")) {
            UnitDouble[] unitDoubleArray = (UnitDouble[])valueEditor.getValue();
            if (unitDoubleArray != null) {
                Point3d point3d = new UnitPoint3D(unitDoubleArray).getPoint3dValue(Geometry.LU);
                this.getClickHistory().addPoint(this.nextEditorPoint(point3d), bl);
            }
        } else if (string.equals("OFFSET")) {
            MouseHistory mouseHistory = this.getClickHistory();
            IOffset iOffset = ValueEditorUtil.getOffset(valueEditor);
            if (iOffset instanceof IOffset.Distance) {
                IOffset.Distance distance = (IOffset.Distance)iOffset;
                if (mouseHistory.committedSize() < mouseHistory.size()) {
                    Point3d point3d;
                    Point3d point3d2 = mouseHistory.getLastCommitted();
                    Vector3d vector3d = Util3D.vector(point3d2, point3d = mouseHistory.getHistory().getLast().p);
                    if (vector3d.lengthSquared() > 0.0) {
                        vector3d.normalize();
                    }
                    vector3d.scale(distance.dist.getValue(Geometry.LU));
                    point3d = Util3D.add(point3d2, (Tuple3d)vector3d);
                    this.getClickHistory().addPoint(this.nextEditorPoint(point3d), bl);
                }
            } else if (iOffset instanceof IOffset.DirOffset) {
                IOffset.DirOffset dirOffset = (IOffset.DirOffset)iOffset;
                Point3d point3d = dirOffset.offset.getPoint3dValue(Geometry.LU);
                if (dirOffset.relative && mouseHistory.committedSize() >= 1) {
                    Point3d point3d3 = mouseHistory.getLastCommitted();
                    Point3d point3d4 = Util3D.add(point3d3, (Tuple3d)point3d);
                    this.getClickHistory().addPoint(this.nextEditorPoint(point3d4), bl);
                } else if (!dirOffset.relative) {
                    this.getClickHistory().addPoint(this.nextEditorPoint(point3d), bl);
                }
            }
        }
        this.updateEditorState(false);
    }

    protected void mouseEventProcessed(MouseEvent mouseEvent) {
        this.updateEditorState(true);
        this.updateStatusMessage();
    }

    protected void updateEditorState(boolean bl) {
        ValueEditor valueEditor = this.getValueEditor();
        MouseHistory mouseHistory = this.getClickHistory();
        if (mouseHistory.committedSize() == 0 && mouseHistory.size() >= 1) {
            valueEditor.setValueType("LOCATION");
            if (bl) {
                Point3d point3d = mouseHistory.getHistory().getLast().p;
                ValueEditorUtil.setLocation(valueEditor, point3d);
            }
        } else if (mouseHistory.committedSize() > 0) {
            Point3d point3d;
            valueEditor.setValueType("OFFSET");
            int n = valueEditor.getCurrentChoiceId();
            if (bl || n != 0) {
                double d = 0.0;
                if (mouseHistory.committedSize() < mouseHistory.size()) {
                    point3d = mouseHistory.getLastCommitted();
                    Point3d point3d2 = mouseHistory.getHistory().getLast().p;
                    d = point3d.distance(point3d2);
                }
                ValueEditorUtil.setOffset(valueEditor, new IOffset.Distance(new UnitDouble(d, Geometry.LU)), false);
            }
            if (bl || n != 1) {
                Point3d point3d3 = new Point3d(0.0, 0.0, 0.0);
                if (mouseHistory.committedSize() < mouseHistory.size()) {
                    Point3d point3d4 = mouseHistory.getLastCommitted();
                    point3d = mouseHistory.getHistory().getLast().p;
                    point3d3 = Util3D.sub(point3d, (Tuple3d)point3d4);
                }
                ValueEditorUtil.setOffset(valueEditor, new IOffset.DirOffset(new UnitPoint3D(point3d3, Geometry.LU), true), false);
            }
            if (bl || n != 2) {
                Point3d point3d5 = mouseHistory.getHistory().getLast().p;
                ValueEditorUtil.setOffset(valueEditor, new IOffset.DirOffset(new UnitPoint3D(point3d5, Geometry.LU), false), false);
            }
        }
    }

    protected CursorTool.SnapInfo nextEditorPoint(Point3d point3d) {
        try {
            point3d = this.constrain(this.getSnapConstraint(), point3d);
        }
        catch (CursorTool.ConstraintException constraintException) {
            return null;
        }
        Point2d point2d = this.toScreen(point3d);
        CursorTool.SnapInfo snapInfo = new CursorTool.SnapInfo(System.currentTimeMillis(), point2d, point3d, (Collection<IsectInfo>)Collections.EMPTY_LIST, point3d);
        return this.snapPoint(snapInfo);
    }

    protected CursorTool.SnapInfo nextMousePoint(CursorTool.SnapInfo snapInfo) {
        if (snapInfo.constrained.isEmpty()) {
            return null;
        }
        return this.snapPoint(snapInfo);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyPressed(keyEvent);
        if (keyEvent.getKeyCode() == 17) {
            this.t_modifierConsumed = false;
        }
        this.resumeRepaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        int n = 0;
        int n2 = 17;
        switch (n2) {
            case 17: {
                n = 128;
                break;
            }
            case 18: {
                n = 512;
                break;
            }
            case 16: {
                n = 64;
                break;
            }
            case 157: {
                n = 256;
            }
        }
        this.t_modifierConsumed |= n != 0 && APyroTool.testBit(keyEvent.getModifiersEx(), n);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.pauseRepaint();
        super.keyReleased(keyEvent);
        if (keyEvent.getKeyCode() == 17 && !this.t_modifierConsumed) {
            this.fireToggleEvent();
        }
        this.resumeRepaint();
    }

    protected CursorTool.SnapInfo snapPoint(CursorTool.SnapInfo snapInfo) {
        return snapInfo;
    }

    protected boolean getSnapToWorkingPlane() {
        return true;
    }

    protected void initValueEditor(ValueEditor valueEditor) {
    }

    public PlanarConstraint getWorkingPlaneConstraint() {
        Plane3d plane3d = this.getWorkingPlane();
        return plane3d != null ? new PlanarConstraint(plane3d) : null;
    }

    protected static class ToolFunc<T extends APyroTool>
    extends AToolFunction<T> {
        protected ToolFunc() {
        }

        @Override
        public Cursor getCursor(T t) {
            return null;
        }

        @Override
        public void mouseMoved(T t, MouseEvent mouseEvent) {
            ((APyroTool)t).getMouseHistory().mouseMoved((CursorTool)t, mouseEvent, ((APyroTool)t).nextMousePoint(((CursorTool)t).getP1()));
            ((APyroTool)t).mouseEventProcessed(mouseEvent);
        }

        @Override
        public void mousePressed(T t, MouseEvent mouseEvent) {
            ((APyroTool)t).getMouseHistory().mousePressed((CursorTool)t, mouseEvent, ((APyroTool)t).nextMousePoint(((CursorTool)t).getP1()));
            ((APyroTool)t).mouseEventProcessed(mouseEvent);
            ((APyroTool)t).showContextMenu(mouseEvent);
        }

        @Override
        public void mouseReleased(T t, MouseEvent mouseEvent) {
            ((APyroTool)t).getMouseHistory().mouseReleased((CursorTool)t, mouseEvent, ((APyroTool)t).nextMousePoint(((CursorTool)t).getP1()));
            ((APyroTool)t).mouseEventProcessed(mouseEvent);
            ((APyroTool)t).showContextMenu(mouseEvent);
        }

        @Override
        public void mouseDragged(T t, MouseEvent mouseEvent) {
            ((APyroTool)t).getMouseHistory().mouseDragged((CursorTool)t, mouseEvent, ((APyroTool)t).nextMousePoint(((CursorTool)t).getP1()));
            ((APyroTool)t).mouseEventProcessed(mouseEvent);
        }
    }

    protected class WorkingPlaneConstraint
    implements ISnapConstraint {
        protected WorkingPlaneConstraint() {
        }

        @Override
        public Point3d snapPoint(Point3d point3d) {
            return null;
        }

        @Override
        public Pair<Point3d, Point3d> snapRay(Point3d point3d, Vector3d vector3d) {
            return null;
        }

        @Override
        public ISnapConstraint transform(Matrix4d matrix4d) {
            return null;
        }

        protected ISnapConstraint getBaseConstraint() {
            Plane3d plane3d = APyroTool.this.getWorkingPlane();
            return plane3d != null ? new PlanarConstraint(plane3d) : null;
        }
    }

    protected class CancelAction
    extends guiAction {
        private static final long serialVersionUID = -8734444625166746831L;

        public CancelAction() {
            super(Intl.intl("&Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            APyroTool.this.cancel();
        }
    }
}

